<?php
/**
 * Init Get My Widget
 *
 * @package AdAce.
 * @subpackage Get My Widget.
 */

// Prevent direct script access.
if ( ! defined( 'ABSPATH' ) ) {
	die( 'No direct script access allowed' );
}

add_action( 'init', 'adace_load_get_my_widget', 0 );
function adace_load_get_my_widget() {
	if ( apply_filters( 'adace_support_get_my_widget', false ) ) {
		// Add Get My Widget defaults.
		add_filter( 'adace_options_defaults', 'adace_options_add_patreon_defaults' );
		// Admin.
		if ( is_admin() ) {
			require_once( trailingslashit( adace_get_plugin_dir() ) . 'includes/get-my-widget/admin/functions.php' );
			require_once( trailingslashit( adace_get_plugin_dir() ) . 'includes/options-page-disclosure.php' );
		}
		// Commons.
		require_once( trailingslashit( adace_get_plugin_dir() ) . 'includes/get-my-widget/common/functions.php' );
		// Front.
		if ( ! is_admin() ) {
			require_once( trailingslashit( adace_get_plugin_dir() ) . 'includes/get-my-widget/front/functions.php' );
		}
	}
}

/**
 * Add Get My Widget Defaults.
 *
 * @param array $option_key Key to get default for.
 * @return mixed Default value or false.
 */
function adace_options_add_get_my_widget_defaults( $defaults ) {
	$defaults = array_merge( $defaults, array(
		'adace_disclosute_text' => esc_html__( 'I use affiliate links', 'adace' ),
	) );
	return $defaults;
}
