<?php
/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woothemes.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 3.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

global $product, $woocommerce_loop;

// Store column count for displaying the grid
if ( empty( $woocommerce_loop['columns'] ) ) {
	$woocommerce_loop['columns'] = apply_filters( 'loop_shop_columns', 4 );
}

// Ensure visibility
if ( ! $product || ! $product->is_visible() ) {
	return;
}

// Extra post classes
$classes = array();

if(!is_product()):
	$grid_column=(12/ $woocommerce_loop['columns']);
	if(bigbazaar_get_option('shop_page_layout','left') =='full_layout'):
		$classes[] = 'col-xs-6 col-sm-4 col-md-' . $grid_column;
	else:
		$classes[] = 'col-xs-6 col-sm-6 col-md-' . $grid_column;
	endif;
endif;

if ( $product->is_on_sale() ) :
	$time_sale = get_post_meta( $product->get_id(), '_sale_price_dates_to', true );
endif;
?>
<li <?php post_class( $classes ); ?>>
	<div class="product-entry">
		<?php
		/**
		 * woocommerce_before_shop_loop_item hook.
		 *
		 * @hooked woocommerce_template_loop_product_link_open - 10
		 */
		do_action( 'woocommerce_before_shop_loop_item' );

		/**
		 * woocommerce_before_shop_loop_item_title hook.
		 *
		 * @hooked woocommerce_show_product_loop_sale_flash - 10
		 * @hooked woocommerce_template_loop_product_thumbnail - 10
		 */?>
		<div class="product-image">
			<a href="<?php the_permalink(); ?>">
			<?php do_action( 'woocommerce_before_shop_loop_item_title' );?>		
			
			<?php if( $product->is_on_sale() && $time_sale ) :?>
			<div class="countdown" data-year="<?php echo date('Y',$time_sale);?>" data-month="<?php echo date('m',$time_sale)-1;?>" data-day="<?php echo date('d',$time_sale);?>" data-hours="<?php echo date('H',$time_sale);?>" data-minutes="<?php echo date('i',$time_sale);?>" data-seconds="<?php echo date('s',$time_sale);?>"></div>
			<?php endif;?>
			
			</a>
		</div>
		<div class="product-content">
		<?php
		
		/**
		 * woocommerce_shop_loop_item_title hook.
		 *
		 * @hooked woocommerce_template_loop_product_title - 10
		 */?>
		<a href="<?php the_permalink(); ?>"><?php 
		do_action( 'woocommerce_shop_loop_item_title' );?>
		</a><?php 
		
		/**
		 * woocommerce_after_shop_loop_item_title hook.
		 *
		 * @hooked woocommerce_template_loop_rating - 5
		 * @hooked woocommerce_template_loop_price - 10
		 */
		do_action( 'woocommerce_after_shop_loop_item_title' );
		?>
		<?php if(bigbazaar_get_option('show_short_description',1)==1):?>
			<div class="short-description">
				<?php echo apply_filters( 'woocommerce_short_description', $post->post_excerpt );?>
			</div>
		<?php endif;?>
		<?php if(bigbazaar_get_option('show_product_buttons',1)==1):?>
			<div class="product-buttons">
			<?php
			/**
			 * woocommerce_after_shop_loop_item hook.
			 *
			 * @hooked woocommerce_template_loop_product_link_close - 5
			 * @hooked woocommerce_template_loop_add_to_cart - 10
			 */
			if(bigbazaar_get_option('show_cart_button',1)==1):?> 
				<div class="product-cart">
					<?php do_action( 'woocommerce_after_shop_loop_item' );?>
				</div>
			<?php endif;
			if(bigbazaar_get_option('show_wishlist_button',1)==1): 
						if( function_exists( 'YITH_WCWL' ) ):
							echo do_shortcode('[yith_wcwl_add_to_wishlist]');
						endif;
					endif;
					
					if(bigbazaar_get_option('show_compare_button',1)==1): 
						if(defined( 'YITH_WOOCOMPARE' )):
							echo do_shortcode('[yith_compare_button]');
						endif;
					endif;
					
					if(bigbazaar_get_option('show_quick_view_button',1)==1): ?>
						<div class="quickview-button">
							<a class="quickview" href="#" data-product_id="<?php echo $post->ID; ?>"><?php _e('Quick View','bigbazaar');?></a>
						</div><?php 
					endif;?>
				</div>
			<?php endif;?>
		</div>
	</div>
</li>
