<?php
/**
 * The portfolio template for displaying content
 *
 * Used for both single and index/archive/search.
 *
 * @package WordPress
 * @subpackage BigBazaar
 * @since BigBazaar 1.0
 */
 
$image_link = wp_get_attachment_url( get_post_thumbnail_id() ); 
$skill_lists = wp_get_object_terms($post->ID, 'portfolio_skills'); 
$item_cats = get_the_terms($post->ID, 'portfolio_cat');
if ($item_cats) {
	foreach ($item_cats as $item_cat) {
		$item_classe =' '. urldecode($item_cat->slug);
	}
}
?>    
<article id="post-<?php the_ID(); ?>" <?php post_class(esc_attr($item_classe.' one-column-portfolio portfolio-item')); ?>>
	<div class="entry-portfolio">
		<div class="col-sm-5">
			<div class="portfolio-thumbnail">
				<?php
					// Post thumbnail.
					bigbazaar_small_post_thumbnail();
				?>							
			</div>					
		</div>
		<div class="col-sm-7">
			<div class="portfolio-content">
				<a href="<?php echo esc_url(get_permalink());?>"><h3><?php the_title();?></h3></a>
				<?php if(!empty($skill_lists)):?>
				<div class="portfolio-skill">
					<strong><?php _e('Skill','bigbazaar');?> :</strong>
					<?php  $i=0; $total = count($skill_lists);
					if(!empty($skill_lists)):
					foreach( $skill_lists as $skill_list):  $i++;?>
					<a href="<?php echo get_tag_link($skill_list->term_id); ?>"><?php echo esc_attr($skill_list->name);?></a><?php if ($i != $total) echo ',';?>
					<?php endforeach; endif;?>
				</div>
				<?php endif;?>
				<?php the_excerpt(); ?>
			</div>
		</div>
	</div>
</article><!-- #post-## -->
		