<?php
/**
 * The portfolio template for displaying content
 *
 * Used for both single and index/archive/search.
 *
 * @package WordPress
 * @subpackage BigBazaar
 * @since BigBazaar 1.0
 */

$image_link = wp_get_attachment_url( get_post_thumbnail_id() ); 
$skill_lists = wp_get_object_terms(get_the_ID(), 'portfolio_skills'); 
?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	
	<div class="entry-portfolio">
		<div class="entry-thumbnail">
			<?php
				// Post thumbnail.
				bigbazaar_post_thumbnail();
			?>
			<div class="image-overlay">
				<div class="entry-action">
					<a href="<?php echo esc_url($image_link);?>" class="zoom-gallery"><i class="fa fa-expand"></i></a>
					<a href="<?php echo esc_url( get_permalink());?>" class="portfolio-detail"><i class="fa fa-link"></i></a>
				</div>
			</div>
		</div>
		<div class="portfolio-content">
			<h3><?php the_title();?></h3>
			<div class="portfolio-skill">
				<ul>
					<?php  $i=0; $total = count($skill_lists);
					if(!empty($skill_lists)):
					foreach( $skill_lists as $skill_list):  $i++;?>
					<li><a href="<?php echo get_tag_link($skill_list->term_id); ?>"><?php echo esc_attr($skill_list->name);?></a><?php if ($i != $total) echo ',';?></li>
					<?php endforeach; endif;?>
				</ul>
			</div>
		</div>
		
	</div>
</article><!-- #post-## -->
  