<?php
/*
 * Template Name: Portfolio
 */

global $postid;

$postid=$post->ID;
$sidebar_position = getSidebarPosition( get_post_meta ( $post->ID, '_bigbazaar_sidebar_position', true ));
$sidebar_widget = getSidebarWidget( get_post_meta ( $post->ID, '_bigbazaar_sidebar_widget', true ));
$show_breadsrumb = getShowBreadsrumb( get_post_meta ( $post->ID, '_bigbazaar_show_breadsrumb', true ) );
$show_title = getShowTitle( get_post_meta ( $post->ID, '_bigbazaar_show_title', true ) );
$portfolio_style = get_post_meta ( $post->ID, '_bigbazaar_portfolio_style', true );
$grid_column = get_post_meta ( $post->ID, '_bigbazaar_portfolio_column', true );
$column_classs=getColumnClass( $sidebar_position ); 
$porftfolio_style=getPortfolioStyle($grid_column);
$GLOBALS['sidebar_position'] = $sidebar_position;
$GLOBALS['sidebar_widget'] = $sidebar_widget;

get_header(); ?>
	<div class="container">
		<?php 
		if( $show_breadsrumb == 'yes' ):
			echo bigbazaar_breadcrumbs();
		endif; ?>
		
		<div class="row">
        	<div class="content-area <?php echo esc_attr($column_classs);?>">
			
				<?php if( $show_title == 'yes' ):?>	
					<header class="entry-header">
						<?php the_title( '<h1 class="page-title">', '</h1>' ); ?>
					</header><!-- .entry-header -->
				<?php endif;?>
				
				<div class="porftfolio-lists <?php echo esc_attr($porftfolio_style);?>">
				<?php
					$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
					$per_page=(isset($page_meta['_bigbazaar_number_portfolio'][0])) ? $page_meta['_bigbazaar_number_portfolio'][0] : 10;
					$args = array('post_type' => 'portfolio', 'posts_per_page' =>$per_page ,'paged' => $paged );
					query_posts( $args );
					if ( have_posts() ) : 
					
						$portfolio_cats = get_categories(array(
							'taxonomy' => 'portfolio_cat'
						));
					
						if (is_array($portfolio_cats) && !empty($portfolio_cats)) :	?>
							<ul class="portfolioFilter">
								<li><a href="#" data-filter="*" class="current"><?php echo __('Show All', 'bigbazaar'); ?></a></li>
								<?php foreach ($portfolio_cats as $portfolio_cats) : ?>
								<li><a href="#" data-filter=".<?php echo esc_attr($portfolio_cats->slug);?>"><?php echo esc_html($portfolio_cats->name);?></a></li>
								<?php endforeach; ?>
							</ul> 
						<?php endif;?>
						<div class="row">
							<div id="portfolio" class="portfolioContainer<?php if(isset($portfolio_style) && $portfolio_style=='masorny_grid'){ echo ' masonry-grid';} ?>">
								<?php /*
								* Include the Custom Portfolio-Format-specific template for the content.
								*/
								
								// Start the loop.
								while ( have_posts() ) : the_post();
								
									get_template_part( 'templates/portfolio/'.$porftfolio_style );
								
								// End the loop.
								endwhile;?>
							</div>
							<?php 
							// Previous/next page navigation.
							bigbazaar_pagination_nav(); ?>
						</div>
						
						<?php 					
					else :
						// If no content, include the "No posts found" template.
						get_template_part( 'content', 'none' );        
					endif;
					wp_reset_query(); ?>
				</div>
			</div>
           	<?php get_sidebar(); ?>
		</div>
	</div><!-- .content-area -->
<?php get_footer(); ?>