<?php
/*
 *	Template Name: Blog
 */

global $postid;
$postid=$post->ID;
$sidebar_position = getSidebarPosition( get_post_meta ( $post->ID, '_bigbazaar_sidebar_position', true ));
$sidebar_widget = getSidebarWidget( get_post_meta ( $post->ID, '_bigbazaar_sidebar_widget', true ));
$show_breadsrumb = getShowBreadsrumb( get_post_meta ( $post->ID, '_bigbazaar_show_breadsrumb', true ) );
$show_title = getShowTitle( get_post_meta ( $post->ID, '_bigbazaar_show_title', true ) );
$blog_style = get_post_meta ( $post->ID, '_bigbazaar_blog_style',true );
$blog_grid_column = get_post_meta ( $post->ID, '_bigbazaar_show_column', true );
$number_post = get_post_meta ( $post->ID, '_bigbazaar_number_post', true );
$column_classs=getColumnClass( $sidebar_position ); 
$blog_grid_style=getBlogStyle( $blog_style, $blog_grid_column);
$GLOBALS['sidebar_position'] = $sidebar_position;
$GLOBALS['sidebar_widget'] = $sidebar_widget;

get_header(); ?>

	<div class="container">
		
		<?php if( $show_breadsrumb == 'yes' ):
			echo bigbazaar_breadcrumbs();
		endif; ?>
		
		<div class="row">
        	<div class="content-area <?php echo esc_attr($column_classs);?>">
			
				<?php if( $show_title == 'yes' ):?>	
					<header class="entry-header">
						<?php the_title( '<h1 class="page-title">', '</h1>' ); ?>
					</header><!-- .entry-header -->
				<?php endif;?>
				
				<div class="blog-posts post_<?php echo esc_attr($blog_grid_style);?>">
					
					<?php $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
					$per_page=(isset($number_post)) ? $number_post : 10;
					$args = array('post_type'=> 'post', 'posts_per_page' =>$per_page ,'paged' => $paged );
					query_posts( $args ); 
					
					if ( have_posts() ) : 
						
						/*
						* Include the Custom Post-Format-specific template for the content.
						*/
						get_template_part( 'templates/blog/'.$blog_grid_style );
					 
						// Previous/next page navigation.
						bigbazaar_pagination_nav(); 
						
					else :
						// If no content, include the "No posts found" template.
						get_template_part( 'content', 'none' );        
					endif;
					
					wp_reset_query();?>
					
				</div>
        	</div>
           	<?php get_sidebar(); ?>
		</div>
	</div><!-- .content-area -->
	
<?php get_footer(); ?>