<?php
/**
 * The template for displaying all single posts and attachments
 *
 * @package WordPress
 * @subpackage BigBazaar
 * @since BigBazaar 1.0
 */
$sidebar_position = getSidebarPosition( get_post_meta ( $post->ID, '_bigbazaar_sidebar_position', true ));
$sidebar_widget = getSidebarWidget( get_post_meta ( $post->ID, '_bigbazaar_sidebar_widget', true ));
$show_breadsrumb = getShowBreadsrumb( get_post_meta ( $post->ID, '_bigbazaar_show_breadsrumb', true ) );
$column_classs=getColumnClass( $sidebar_position );  
$GLOBALS['sidebar_position'] = $sidebar_position;
$GLOBALS['sidebar_widget'] = $sidebar_widget;
$related_posts = getRelatedPosts($post->ID);
get_header(); ?>

	<div class="container">
		<?php 
		if( $show_breadsrumb == 'yes' ):
			echo bigbazaar_breadcrumbs();
		endif;?>
		
		<div class="row">
        	<div class="content-area <?php echo esc_attr($column_classs);?>">

				<?php
				// Start the loop.
				while ( have_posts() ) : the_post();

					/*
					 * Include the post format-specific template for the content. If you want to
					 * use this in a child theme, then include a file called called content-___.php
					 * (where ___ is the post format) and that will be used instead.
					 */
					
					get_template_part( 'content', get_post_format() );
					
					//share social post					
					if(bigbazaar_get_option('show_post_share_link',1)==1):	?>
					<div class="social-share-button">
						<h4><?php _e('Post social share','bigbazaar');?></h4>
						<?php bigbazaar_single_sharing();?>
					</div>
					<?php endif;
					
					// Previous/next post navigation.
					if(bigbazaar_get_option('show_single_post_navigation', 1)==1):
						bigbazaar_post_navigation(array());
					endif;	?>
					
					<?php if(bigbazaar_get_option('show_related_post',1)==1):
						if ( $related_posts->have_posts() ) :
							$id = uniqid();
							global $owlparam;
							$owlparam['productsCarousel']['section-'.$id] = array(
								'item_columns'     => bigbazaar_get_option('blog_per_row',3) ,
								'autoplay'    => bigbazaar_get_option('blog_carousel_auto_play', 0) ? 'true' : 'false',
								'navigation'  => bigbazaar_get_option('blog_carousel_navigation', 0) ? 'false' : 'true',
								'loop'        => bigbazaar_get_option('blog_carousel_loop', 0) ? 'true' : 'false',
							);?>
							<div id="section-<?php echo esc_attr($id);?>" class="product-section blogs_carousel related-posts">
								<h4 class="related-posts-title"><span><?php _e('Related post','bigbazaar');?></span></h4>
								<?php $row=1;?>
								<div class="section-content">
									<div class="product-items row">
										<ul class="products product-carousel owl-carousel">
										<?php function new_excerpt_length($length) {
												return 20;
											}
											add_filter('excerpt_length', 'new_excerpt_length');	?>
										<?php while( $related_posts->have_posts() ): $related_posts->the_post();?>
											
											<?php if($row==1){?>
												<li class="slide-row">
													<ul>
											<?php }?>
												<li class="blog-entry">
													<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
														<?php // Post thumbnail.
															bigbazaar_get_post_thumbnail('medium');
														?>													
														<div class="blog-entry-content">
															<header class="entry-header">
																<?php the_title( sprintf( '<h2 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' );?>
															</header><!-- .entry-header -->
															
															<footer class="entry-footer">
																<?php bigbazaar_entry_meta(); ?>
															</footer><!-- .entry-footer -->
															
															<div class="entry-content">
																<?php the_excerpt(); ?>												
															</div><!-- .entry-content -->
														</div>

													</article><!-- #post-## -->
												</li>
											<?php if($row==1 || $related_posts->current_post+1==$related_posts->post_count){ $row=0;?>
													</ul>
												</li>
											<?php } $row++;?>
										<?php endwhile; // end of the loop. ?>
										</ul>
									</div>
								</div>
							</div>
					<?php endif;wp_reset_postdata();					
					endif;
					
					// If comments are open or we have at least one comment, load up the comment template.
					if ( comments_open() || get_comments_number() ) :
						comments_template();
					endif;

				// End the loop.
				endwhile;
				?>

			</div>
       	<?php get_sidebar(); ?>
		</div>
	</div><!-- .content-area -->

<?php get_footer(); ?>
