<?php
/**
 * The template for displaying all single posts and attachments
 *
 * @package WordPress
 * @subpackage BigBazaar
 * @since BigBazaar 1.0
 */
global $postid;
$postid=$post->ID;
$sidebar_position = getSidebarPosition( get_post_meta ( $post->ID, '_bigbazaar_sidebar_position', true ));
$sidebar_widget = getSidebarWidget( get_post_meta ( $post->ID, '_bigbazaar_sidebar_widget', true ));
$show_breadsrumb = getShowBreadsrumb( get_post_meta ( $post->ID, '_bigbazaar_show_breadsrumb', true ) );
$show_title = getShowTitle( get_post_meta ( $post->ID, '_bigbazaar_show_title', true ) );
$column_classs=getColumnClass( $sidebar_position ); 
$cat_lists = wp_get_object_terms($post->ID, 'portfolio_cat');
$skill_lists = wp_get_object_terms($post->ID, 'portfolio_skills'); 
$related_portfolios = getRelatedPortfolios($post->ID);
$page_meta = get_post_meta ( get_the_ID() );
$GLOBALS['sidebar_position'] = $sidebar_position;
$GLOBALS['sidebar_widget'] = $sidebar_widget;

get_header(); ?>

	<div class="container">
		<?php 
		if( $show_breadsrumb == 'yes' ):
			echo bigbazaar_breadcrumbs();
		endif;?>
		
		<div class="row">
        	<div class="content-area <?php echo esc_attr($column_classs);?>">
            	<?php
				// Start the loop.
				while ( have_posts() ) : the_post();
				?>
                <article id="post-<?php the_ID(); ?>" <?php post_class('portfolio-detail'); ?>>
					<div class="portfolio-title">
					<?php if( $show_title == 'yes' ):?>	
						<header class="entry-header">
							<?php the_title( '<h1 class="page-title">', '</h1>' ); ?>
						</header><!-- .entry-header -->
					<?php endif;
					
						if(bigbazaar_get_option('show_project_navigation', 1)==1):
							//Previous/next portfolio navigation.
							bigbazaar_header_post_navigation(array('archive_post'=>'portfolio'));
						endif;?>
					</div>
                	<div class="portfolio-content row">
                        <div class="col-sm-7 col-md-8">
                            <?php
                                // Post thumbnail.
                                bigbazaar_post_thumbnail();
                            ?>
                        </div>
                        <div class="col-sm-5 col-md-4">
                            <header class="entry-header">
                              <h5 class="project-title"><?php _e('Project Description','bigbazaar');?></h5>
                            </header><!-- .entry-header -->
                       
                            <div class="entry-content">
                                <?php the_content(); ?>
                            </div><!-- .entry-content -->
                            
							<?php if(bigbazaar_get_option('show_project_info', 1)==1):?>
                            <div class="entry-information">
                            	<h5 class="project-title"><?php _e('Project Informations','bigbazaar');?></h5>
								
								<?php if(isset($page_meta['_bigbazaar_portfolio_client_name'])):?>                           
								<div class="project-client">
                                	<h6 class="description-title"><?php _e('Client','bigbazaar');?> :</h6>
									<span><?php echo esc_attr($page_meta['_bigbazaar_portfolio_client_name'][0]);?></span>
                                </div>
								<?php endif;?>
								
								<div class="project-date">
                                	<h5 class="description-title"><?php _e('Date','bigbazaar');?> :</h5>
                                    <span class="project-date"><?php echo get_the_date(); ?></span>
                                </div>
                                <?php if ( !empty( $cat_lists ) ) : ?>
                                    <div class="project-cat">
                                        <h6 class="description-title"><?php _e('Category','bigbazaar');?> :</h6>
                                        <span class="cal-list">
											<?php  $i=0; $total = count($cat_lists);
											foreach( $cat_lists as $cat_list):  $i++;?>
												<a href="<?php echo get_term_link ($cat_list->term_id);?>"><?php echo esc_attr($cat_list->name);?></a><?php if ($i != $total) echo ',';?>
											<?php endforeach; ?>
										</span>									
                                    </div>
                                <?php endif; 
								if (!empty($skill_lists)) : ?>
                                    <div class="project-skills">
                                        <h6 class="description-title"><?php _e('Skills','bigbazaar');?> :</h6>
                                        <span class="skill-list">
											<?php  $i=0; $total = count($skill_lists);
											foreach( $skill_lists as $skill_list):  $i++;?>
											<a href="<?php echo get_tag_link($skill_list->term_id); ?>"><?php echo esc_attr($skill_list->name);?></a> <?php if ($i != $total) echo ',';?>
											<?php endforeach; ?>
										</span>
                                    </div>
                                <?php endif; ?>
								<?php if(isset($page_meta['_bigbazaar_portfolio_project_url'])):?>
                                <div class="project-url">
                                	<a class="button" href="<?php echo esc_url($page_meta['_bigbazaar_portfolio_project_url'][0]);?>" target="_blank">
										<h6><i class="fa fa-hand-o-right fa-lg"></i> <?php _e('Live project','bigbazaar');?></h6>
									</a>
                                </div>
								<?php endif;?>
								
								<?php if(bigbazaar_get_option('show_project_share_link', 1)==1):?>
                                <div class="project-share">
                                	<h5 class="description-title"><?php _e('Share','bigbazaar');?> :</h5>
									<?php bigbazaar_single_sharing();?>
                                </div>
								<?php endif;?>
                               
                            </div><!-- .entry-detail -->
							<?php endif;?>
                        </div>
                    </div>
                </article><!-- #post-## -->		
				
                <?php 			
				$id = uniqid();
				$owlparam['productsCarousel']['section-'.$id] = array(
					'item_columns' => bigbazaar_get_option('related_upsell_products_per_row', 3),
					'autoplay'     => bigbazaar_get_option('related_upsell_auto_play', 0) ? 'true' : 'false',
					'navigation'   => bigbazaar_get_option('related_upsell_navigation', 1) ? 'true' : 'false',
				);
				?>
				
				<?php if(bigbazaar_get_option('show_related_projects', 1)==1):?>
					<?php if ( $related_portfolios->have_posts() ) :?>
						<div class="related-portfolios">
							<h4 class="related-portfolio-title"><span><?php _e('Related projects','bigbazaar');?></span></h4>
							<div id="section-<?php echo esc_attr($id);?>" class="row">
								<div id="portfolio" class="product-carousel owl-carousel">
									<?php while ($related_portfolios->have_posts()) {
										$related_portfolios->the_post();?>
										<div class="item">
										<?php get_template_part('templates/portfolio/portfolio_content'); ?>
										 </div>
									<?php }	?>                       
								</div>
							</div>
						</div>
					<?php endif;?>
				<?php endif;?>
                <?php 				
                // End the loop.
                endwhile;
                ?>
		</div>
       	<?php get_sidebar(); ?>
		</div>
	</div><!-- .content-area -->

<?php get_footer(); ?>
