<?php
/**
 * The template for displaying search results pages.
 *
 * @package WordPress
 * @subpackage BigBazaar
 * @since BigBazaar 1.0
 */

get_header(); ?>

	<div class="container">
		<?php	
			echo bigbazaar_breadcrumbs();		
		?>
		<div class="row">
        	<div class="content-area col-sm-8 col-md-9">
			
				<?php if(isset($page_meta['_bigbazaar_show_title']) && $page_meta['_bigbazaar_show_title'][0]=='no'):
	
				else:?>	
					<header class="entry-header">
						<h1 class="page-title"><?php printf( __( 'Search Results for: %s', 'bigbazaar' ), get_search_query() ); ?></h1>
					</header><!-- .entry-header -->
					
				<?php endif;?>
				
				<div class="blog-posts">
				<?php if ( have_posts() ) : 
					
					// Start the loop.
					while ( have_posts() ) : the_post(); ?>

						<?php
						/*
						 * Run the loop for the search to output the results.
						 * If you want to overload this in a child theme then include a file
						 * called content-search.php and that will be used instead.
						 */
						get_template_part( 'content', 'search' );

					// End the loop.
					endwhile;
				 
					// Previous/next page navigation.
					bigbazaar_pagination_nav(); 
					
                else :
					// If no content, include the "No posts found" template.
                    get_template_part( 'content', 'none' );        
                endif;
				
				wp_reset_query(); ?>
				
				</div>
        	</div>
           	<?php get_sidebar(); ?>
		</div>
	</div><!-- .content-area -->
<?php get_footer(); ?>