<?php
/**
 * The template for displaying pages
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages and that
 * other "pages" on your WordPress site will use a different template.
 *
 * @package WordPress
 * @subpackage BigBazaar
 * @since BigBazaar 1.0
 */

$sidebar_position = getSidebarPosition( get_post_meta ( get_the_ID(), '_bigbazaar_sidebar_position', true ));
$sidebar_widget = getSidebarWidget( get_post_meta ( get_the_ID(), '_bigbazaar_sidebar_widget', true ));
$show_breadsrumb = getShowBreadsrumb( get_post_meta ( $post->ID, '_bigbazaar_show_breadsrumb', true ) );
$column_classs = getColumnClass( $sidebar_position ); 
$GLOBALS['sidebar_position'] = $sidebar_position;
$GLOBALS['sidebar_widget'] = $sidebar_widget;

get_header(); ?>
	
	<div class="container">
		
		<?php 
		if( $show_breadsrumb == 'yes' ):	
			echo bigbazaar_breadcrumbs();
		endif;
		?>
		
		<div class="row">
        	<div class="content-area <?php echo esc_attr($column_classs);?>">

				<?php
                // Start the loop.
                while ( have_posts() ) : the_post();
        
                    // Include the page content template.
                    get_template_part( 'content', 'page' );
        
                    // If comments are open or we have at least one comment, load up the comment template.
                    if ( comments_open() || get_comments_number() ) :
                        comments_template();
                    endif;
        
                // End the loop.
                endwhile;
                ?>

			</div>
        
			<?php 
            // Get sidebar
            get_sidebar(); 
            ?>
		</div>
	</div><!-- .content-area -->

<?php get_footer(); ?>
