/*
 * Theme functions file.
 *
 * Contains handlers for navigation and widget area.
 */

var $ = jQuery.noConflict();
var bigbazaarOwlArg 	= bigbazaarOwlArg || {},
	bigbazaar_options 	= bigbazaar_options || {};

;(function($) {
	
	'use strict';
	
	var bigbazaar = bigbazaar || {},
		bigbazaarQuickview = false,
		lmp_update_state;
	
	bigbazaar.init = function() {
		bigbazaar.$body = $(document.body),
		bigbazaar.$window = $(window),
		bigbazaar.$windowWidth = $(window).width(),
		bigbazaar.$windowHeight = $(window).height(),
		bigbazaar.$angle_left,bigbazaar.$angle_right,
		bigbazaar.$chevron_left,bigbazaar.$chevron_right,
		bigbazaar.$style = jQuery('head style').first();
		
		this.isCheckRTL();
		this.backToTop();
		this.newsletterPopup();
		this.loginPopup();
		this.stickyHeaderMenu();
		this.isotopePortfolio();
		this.ImagesLightbox();
		this.productLiveSearch();
		this.productQuickview();
		this.addToCartPopup();
		this.gridListView();
		this.widgetToggle();
		this.widgetMenuToggle();
		this.widgetMaxLimitItem();
		this.productCountdown();
		this.infiniteAjaxPagination();
		this.productSectionColor();
		this.productsCarousels();
		this.productBannerCarousel();
		this.productBrandsCarousel();
		this.productBrandsVerticalCarousel();
		this.variationsImageChange();
		this.productImageZoom();
		this.initProductThumbnailSlick();
		this.postGalleryCarousel();
		this.testimonialCarousel();
		this.categoryMenuToggle();
		this.megamenuWindowsPosition();
		this.mobileMenu();
		this.mobileToggle();
		this.stickySidebar();
		
		/*
		* Responsive Mobile menu 
		*/
		selectnav('main-navigation', {
			label: '--- Navigation ---',
			indent: '-'
		});
		
		/*
		* Init Masonry grid
		*/
		$( '.masonry-grid' ).masonry( {} );
		
		/*
		* Change number of products to be viewed on shop page
		*/
		$( '.show-products-number' ).change( function() {
			$( this ).closest( 'form' ).submit();
		} );
		
		/*
		* Change number of products to be viewed on shop page
		*/
		$( '.show-products-number' ).on( 'change', 'select.showpagers', function() {
			$( this ).closest( 'form' ).submit();
		});			
	};
	
	bigbazaar.isCheckRTL = function(){
		/*
		* If check is site RTL
		*/		
		$('html[dir="rtl"] body').addClass('rtl');
		var bigbazaar_rtl = false;
		bigbazaar.$angle_left ="<i class='fa fa-angle-left'></i>";
		bigbazaar.$angle_right ="<i class='fa fa-angle-right'></i>";
		bigbazaar.$chevron_left="<i class='fa fa-chevron-left'></i>";
		bigbazaar.$chevron_right="<i class='fa fa-chevron-right'></i>";
		if($('body,html').hasClass('rtl')){ 
			bigbazaar_rtl =  true;
			bigbazaar.$angle_left="<i class='fa fa-angle-right'></i>";
			bigbazaar.$angle_right="<i class='fa fa-angle-left'></i>";
			bigbazaar.$chevron_left="<i class='fa fa-chevron-right'></i>";
			bigbazaar.$chevron_right="<i class='fa fa-chevron-left'></i>";
		}		
		return bigbazaar_rtl;
	};
	
	bigbazaar.backToTop = function(){
		/*
		* Back to top button 
		*/
		bigbazaar.$window.on('scroll',function(){				
			var button = $('#back-to-top');
			
			if( bigbazaar.$window.scrollTop() > 150  && bigbazaar.$windowWidth > 767 ){
				button.fadeIn(400);	
			}else{
				button.fadeOut(400);	
			}		
		});
		
		$('#back-to-top').click(function() {
				$('html,body').animate({scrollTop:0}, 600);	
				return false;
		});	
		
	};
	
	bigbazaar.newsletterPopup =  function(){
		/*
		* Newsletter Popup.
		*/
		var obj = {
		  init: function() {
			try
			{
			  if ($.cookie('popupNewsletter') !== 'disable') { 
				this.checkboxEvent();
				setTimeout(function() {
				  $('#newsletterPopup').modal('show');
				  var date = new Date();
				  var minutes = 1;
				  date.setTime(date.getTime() + (minutes * 60 * 1000));
				  $.cookie('popupNewsletter', 'disable', {expires:date, path:'/'});
				}, 1500);
			  }
			}
			catch (err) {} // ignore errors reading cookies
		  },
		  checkboxEvent: function() {
			$('input[id^="checkBox"]').change(function(){
			  if ($(this).is(':checked')) {
				$.cookie('popupNewsletter', 'disable', {expires:1, path:'/'});
			  } else {
				$.cookie('popupNewsletter', null, { path: '/' });
			  }
			});
		  }
		};
		
		$(document).ready(function() {
		  obj.init();
		});
	};
	
	bigbazaar.loginPopup = function(){		
		/*
		* User's login popup 
		*/
		bigbazaar.$body.on('click', '.user-login.enable', function (e) {
			e.preventDefault();
			$('#login-popup').modal('show');
		});
	};
	
	bigbazaar.stickyHeaderMenu = function(){
		/*
		* Sticky header menu 
		*/		
		var getHeaderHeight = $('.header-middle').outerHeight();
		var borderAmount = 2;
		var shadowAmount = 30;
		var lastScrollPosition = 0;

		// set negative top position to create the animated header effect
		$('.header-middle').css('top', '-' + (getHeaderHeight + shadowAmount + borderAmount) + 'px');

		if(bigbazaar_options.enable_sticky_navigation){
			bigbazaar.$window.on('scroll',function(){
				var currentScrollPosition = bigbazaar.$window.scrollTop();
				 
				if (bigbazaar.$window.scrollTop() > 2 * (getHeaderHeight + shadowAmount + borderAmount) ) {

					$('body').addClass('scrollActive').css('padding-top', getHeaderHeight);
					$('.header-middle').css('top', 0);
					
					if(bigbazaar.$windowWidth > 991){
						$('#header-navigation .category-menu').find('.categories-list').hide();
					}

					if (currentScrollPosition < lastScrollPosition) {
						$('.header-middle').css('top', '-' + (getHeaderHeight + shadowAmount + borderAmount) + 'px');
					}
					lastScrollPosition = currentScrollPosition;

				} else {
					$('body').removeClass('scrollActive').css('padding-top', 0);
					//$('.home .category-menu').find('.categories-list').show();
				}
			});
		}
	};
	
	bigbazaar.isotopePortfolio = function(){
		/*
		* Init isotope portfolio
		*/
		var $container = $('.portfolioContainer');
		var $filter = $('.portfolioFilter');
		$(window).load(function () {
			// Initialize Isotope
			
			if(bigbazaar.isCheckRTL()){			
				$container.isotope({
					itemSelector: '.portfolio-item',
					isOriginLeft: false,
				});
			}
			else{
				$container.isotope({
					itemSelector: '.portfolio-item',
				});
			}
			$('.portfolioFilter a').click(function () {
				var selector = $(this).attr('data-filter');
				$container.isotope({ filter: selector });
				return false;
			});
			$filter.find('a').click(function () {
				var selector = $(this).attr('data-filter');
				$filter.find('a').removeClass('current');
				$(this).addClass('current');
			});
		});
	};
	
	bigbazaar.ImagesLightbox = function(){
		/*
		* Image Lightbox 
		*/
		
		$('a.zoom-gallery').magnificPopup({
			type: 'image',					
			mainClass: 'mfp-with-zoom mfp-img-mobile',
			gallery		: {
				enabled: true
			}
		});
	};
	
	bigbazaar.productLiveSearch = function(){
		/*
		* Product live search
		*/
		if( bigbazaar_options.enable_live_search === '1' ) {
			$('.woocommerce-product-search').each(function(){
				 var append = $(this).find('.live-search-results');
				 var search_categories = $(this).find('.product_cat');
				 var serviceUrl = bigbazaar_options.ajax_url + '?action=products_live_search';
				 //var product_cat = '';

				if (search_categories.length && search_categories.val() !== '') {
					serviceUrl += '&product_cat=' + search_categories.val();
				}

				 $(this).find('.search-field').devbridgeAutocomplete({
					minChars        : 3,
					appendTo        : append,
					triggerSelectOnValidInput: false,
					serviceUrl      : serviceUrl,
					onSearchStart   : function () {
					  $('.search-btn').removeClass('loading');
					  $('.search-btn').addClass('loading');
					},
					onSelect        : function (suggestion) {
						if (suggestion.id !== -1) {
							window.location.href = suggestion.url;
						}
					},
					onSearchComplete: function () {
						$('.search-btn').removeClass('loading');
					},
					beforeRender: function (container) {
						$(container).removeAttr('style');
					},
					formatResult: function (suggestion, currentValue) {
							var pattern = '(' + $.Autocomplete.utils.escapeRegExChars(currentValue) + ')';
							var html = '';					
							if(suggestion.img) {
								html += '<div class="search-product-image"><img src="'+suggestion.img+'"></div>';
							}
							html += '<div class="search-product-title"><a href="'+suggestion.url+'">'+suggestion.value.replace(new RegExp(pattern, 'gi'), '<strong>$1<\/strong>')+'</a></div>';
							if(suggestion.price) {
								html += '<span class="search-product-price">'+suggestion.price+'</span>';
							}

							return html;
						}
				});

				if( search_categories.length ){
					var searchForm = $(this).find('.search-field').devbridgeAutocomplete();

					search_categories.on( 'change', function( ){
						if( search_categories.val() !== '' ) {
							searchForm.setOptions({
								serviceUrl:  bigbazaar_options.ajax_url + '?action=products_live_search&product_cat=' + search_categories.val()
							});
						} else{
							searchForm.setOptions({
								serviceUrl:  bigbazaar_options.ajax_url + '?action=products_live_search'
							});
						}
						// update suggestions
						searchForm.hide();
						searchForm.onValueChange();
					});
				}
			});
		}
	};
	
	bigbazaar.productQuickview = function(){
		/*
		* Product quickview
		*/		
		$( 'body' ).on( 'click', '.quickview', function(e) {
			e.preventDefault();
			var _this = $( this ),
				pid   = _this.attr( 'data-product_id' ),
				data  = { action: 'bigbazaar_product_quickview', pid: pid };
			
			$( 'body .wrapper' ).after( '<div class="qv loading"><div class="pl-loading"></div></div>' );
			
			$.post( myAjax.ajaxurl, data, function( response ) {
				$.magnificPopup.open({
					items: {
						src: response,
						type: 'inline'
					},
					mainClass: 'mfp-fade',
					removalDelay: 500,
				});			
				
				setTimeout(function() {
					if ( $( '.product-quickview form' ).hasClass( 'variations_form' ) ) {
						$( '.product-quickview .variations_form' ).wc_variation_form();
						$( '.product-quickview select' ).trigger( 'change' );
					}
				}, 100);
				
				$( '.qv.loading' ).remove();				
				bigbazaar.initProductThumbnailSlick();
				
				if ( typeof $.PLT !== 'undefined'){
					$.PLT.main_product_variation_select();
					$.PLT.main_product_variation_load_default();
					$.PLT.product_bundle_variation_select();
				}
				
				$( '.images' ).imagesLoaded( function() {
					var imgHeight = $( '.product-quickview .images' ).outerHeight();
					$( '.product-quickview .single-product-entry > div' ).css({
						'height': imgHeight
					});
				});
			});
			bigbazaarQuickview=true;
		});		
	};
	
	bigbazaar.addToCartPopup = function(){
		/*
		* Add to cart Popoup
		*/
		
		if (!bigbazaar_options.add_to_cart_popup) return;
		
		jQuery('body').append('<div class="bigbazaar-notice-wrapper"><div class="bigbazaar-notice"></div><div class="close"><i class="fa fa-times-circle"></i></div></div>');
			
		jQuery('.bigbazaar-notice-wrapper .close').on('click', function(){
			jQuery('.bigbazaar-notice-wrapper').fadeOut();
			jQuery('.bigbazaar-notice').html('');
		});
		jQuery('body').on( 'adding_to_cart', function(event, button, data) {
			var ajaxPId = button.attr('data-product_id');
			var ajaxPQty = button.attr('data-quantity');
			
			//get product info by ajax
			jQuery.post(
				myAjax.ajaxurl, 
				{
					'action': 'get_productinfo',
					'data':   {'pid': ajaxPId,'quantity': ajaxPQty}
				},
				function(response){
					jQuery('.bigbazaar-notice').html(response);
				}
			);
		});
		jQuery('body').on( 'added_to_cart', function(event, fragments, cart_hash) {
			//show product info after added
			jQuery('.bigbazaar-notice-wrapper').fadeIn();
		});
	}
	
	bigbazaar.gridListView = function(){
		/*
		* List/Grid view toggle
		*/
		jQuery('.grid').click(function() {
			jQuery('.grid').addClass('active');
			jQuery('.list').removeClass('active');
			jQuery.cookie('gridcookie','grid', { path: '/' });
			jQuery('ul.products.is_shop').fadeOut(300, function() {
				jQuery(this).addClass('grid').removeClass('list').fadeIn(300);
			});
			return false;
		});

		jQuery('.list').click(function() {
			jQuery('.list').addClass('active');
			jQuery('.grid').removeClass('active');
			jQuery.cookie('gridcookie','list', { path: '/' });
			jQuery('ul.products.is_shop').fadeOut(300, function() {
				jQuery(this).removeClass('grid').addClass('list').fadeIn(300);
			});
			return false;
		});

		if (jQuery.cookie('gridcookie')) {
			jQuery('ul.products.is_shop').addClass(jQuery.cookie('gridcookie'));
		} else {
			jQuery('.gridlist-toggle .grid').addClass('active');
			jQuery('ul.products.is_shop').addClass('grid');
		}

		if (jQuery.cookie('gridcookie') == 'grid') {
			jQuery('.gridlist-toggle .grid').addClass('active');
			jQuery('.gridlist-toggle .list').removeClass('active');
		}

		if (jQuery.cookie('gridcookie') == 'list') {
			jQuery('.gridlist-toggle .list').addClass('active');
			jQuery('.gridlist-toggle .grid').removeClass('active');
		}

		jQuery('.gridlist-toggle a').click(function(event) {
			event.preventDefault();
		});	
	};
	
	bigbazaar.widgetMenuToggle = function(){
		//*******************************************************************
		//* Widget Menu Toggle
		//*******************************************************************/
		
		if( bigbazaar_options.widget_menu_toggle) {
			$('.widget ul.children').parent().addClass('parent-item');
			$('.widget ul.sub-menu').parent().addClass('parent-item');
			$('.widget ul > li.parent-item > ul').hide();
			$('.widget ul > li.parent-item.current-cat-parent > ul').show().parent().addClass('open-item');
			$('.widget ul > li.parent-item.current-cat.cat-parent > ul').show().parent().addClass('open-item');
			
			$('.widget ul > li.parent-item').click(function() {
				if ($(this).hasClass('current-cat-parent') || $(this).hasClass('current-cat.cat-parent')) {
					var li = $(this).closest('li');
					li.find(' > ul').slideToggle('fast');
					$(this).toggleClass('close-cat');
				} else {
					var li = $(this).closest('li');
					li.find(' > ul').slideToggle('fast');
					$(this).toggleClass('open-item');
				}
			});
			
			$('.widget ul.children li, .widget ul.sub-menu li, .widget ul.sub-menu li > a, ul.children li > a').click(function(e){
				e.stopPropagation();
			});
		}		
	};
	
	bigbazaar.widgetToggle = function(){
		//*******************************************************************
		//* Widget Menu Toggle
		//*******************************************************************/
		
		if( bigbazaar_options.widget_toggle) {
			
			$('.widget-area .widget').addClass('widget-toggle');
			$('.widget-area .widget .widget-title, .dokan-widget-area .widget .widget-title').click(function(e) {
				e.stopPropagation();
				if ($(this).next().is(':visible')){
                    $(this).parent().addClass('closed');
                } else {
                    $(this).parent().removeClass('closed');
                }
                $(this).next().stop().slideToggle(200);
			});			
		}
	};
	
	bigbazaar.widgetMaxLimitItem = function(){
		//*******************************************************************
		//* Widget Hide Max Limit Item
		//*******************************************************************/
		if( bigbazaar_options.widget_hide_max_limit_item) {
			var js_translate_text = bigbazaar_options.js_translate_text;
			$('.widget .widget-title + ul').hideMaxListItems({
				'max': bigbazaar_options.number_of_show_widget_items,
				'speed': 500,
				'moreText': js_translate_text.show_more,
				'lessText': js_translate_text.Show_less
			});
		}
	};
	
	bigbazaar.productCountdown = function(){
		/*
		* Product sale countdown
		*/		
		$('.countdown').each(function(){
			var js_translate_text = bigbazaar_options.js_translate_text;
			var $this = $(this),
				endDate = $this.data(),
				until = new Date(
					endDate.year,
					endDate.month || 0,
					endDate.day || 1,
					endDate.hours || 0,
					endDate.minutes || 0,
					endDate.seconds || 0
				);
			// initialize
			$this.countdown({
				until : until,
				format : 'dHMS',
				labels : ['years', 'month', 'weeks', js_translate_text.days_text, js_translate_text.hours_text, js_translate_text.mins_text, js_translate_text.secs_text]
			});
		});
	};
	
	bigbazaar.infiniteAjaxPagination = function(){
		/*
		* Infinite Ajax Pagination
		*/
		
		if ( bigbazaar_options.load_more_products =="default_pagination" || pagination_settings.length === 0 ) {
			return;
		}
		
		var lmp_is_loading = false,
			lmp_loading_style;
		if ( $( pagination_settings.products ).length > 0 ) {
			$( pagination_settings.products ).after( $( pagination_settings.load_more ) );
			current_style();
			$(window).resize( function () {
				current_style();
			});
			$(window).scroll ( function () {
				if ( lmp_loading_style == 'infinity_scroll' ) {
					var products_bottom = $( pagination_settings.products ).offset().top + $( pagination_settings.products ).height() - pagination_settings.buffer;
					var bottom_position = $(window).scrollTop() + $(window).height();
					if ( products_bottom < bottom_position && ! lmp_is_loading ) {
						load_next_page();
					}
				}
			});
			$(document).on( 'click', '.lmp_button', function (event) {
				event.preventDefault();
				$( '.lmp_load_more_button' ).hide();
				load_next_page();
			});
			if ( ! pagination_settings.is_AAPF ) {
				$(document).on( 'click', pagination_settings.pagination+' a', function (event) {
					event.preventDefault();
					load_next_page( true, $(this).attr('href') );
				});
			}
		}
		function load_next_page( replace, user_next_page ) {
			if ( typeof( replace ) == 'undefined' ) {
				user_next_page = false;
			}
			if ( typeof( user_next_page ) == 'undefined' ) {
				user_next_page = false;
			}
			var $next_page = $( pagination_settings.next_page );
			if ( $next_page.length > 0 || user_next_page !== false ) {
				start_ajax_loading()
				var next_page;
				if( user_next_page !== false ) {
					next_page = user_next_page;
				} else {
					next_page = $next_page.attr('href');
				}
				$.get( next_page, function( data ) {
					var $data = $(data);
					if( ( pagination_settings.lazy_load_m && $(window).width() <= pagination_settings.mobile_width ) || ( pagination_settings.lazy_load && $(window).width() > pagination_settings.mobile_width ) ) {
						$data.find(pagination_settings.item+', .berocket_lgv_additional_data').find( 'img' ).each( function ( i, o ) {
							$(o).attr( 'data-src', $(o).attr( 'src' ) ).removeAttr( 'src' );
						});
						$data.find(pagination_settings.item+', .berocket_lgv_additional_data').addClass('lazy');
					}
					var $products = $data.find( pagination_settings.products ).html();
					if ( replace ) {
						$( pagination_settings.products ).html( $products );
					} else {
						$( pagination_settings.products ).append( $products );
					}
					if( (pagination_settings.lazy_load_m && $(window).width() <= pagination_settings.mobile_width ) || (pagination_settings.lazy_load && $(window).width() > pagination_settings.mobile_width ) ) {
						$( pagination_settings.products+' .lazy' ).find( 'img' ).lazyLoadXT();
						$( pagination_settings.products ).find('.lazy').on( 'lazyshow', function () {
							$(this).removeClass('lazy').addClass('animated').addClass(pagination_settings.LLanimation);
							if( ! $(this).is('.berocket_lgv_additional_data') ) {
								$(this).next( '.berocket_lgv_additional_data' ).removeClass('lazy').addClass('animated').addClass(pagination_settings.LLanimation);
							}
						});
					}
					var $pagination = $data.find( pagination_settings.pagination );
					$( pagination_settings.pagination ).html( $pagination.html() );
					current_style();
					end_ajax_loading();
				});
			}
		}
		function start_ajax_loading() {
			lmp_is_loading = true;
			//lmp_execute_func( pagination_settings.javascript.before_update );
			$( pagination_settings.products ).append( $( pagination_settings.load_image ) );
		}
		function end_ajax_loading() {
			$( pagination_settings.load_img_class ).remove();
			//lmp_execute_func( pagination_settings.javascript.after_update );
			lmp_is_loading = false;
			var $next_page = $( pagination_settings.next_page );
			if( ( lmp_loading_style == 'infinity_scroll' || lmp_loading_style == 'more_button' ) && $next_page.length <= 0 ) {
				$( pagination_settings.products ).append( $( pagination_settings.end_text ) );
			}
		}
		function current_style() {
			if ( pagination_settings.use_mobile && $(window).width() <= pagination_settings.mobile_width ) {
				set_style( pagination_settings.mobile_type );
			} else {
				set_style( pagination_settings.type );
			}
		}
		function set_style( style ) {
			var $next_page = $( pagination_settings.next_page );
			$( pagination_settings.pagination ).hide();
			$( '.lmp_load_more_button' ).hide();
			if ( style == 'more_button' ) {
				if ( $next_page.length > 0 ) {
					$( '.lmp_load_more_button' ).show();
				} else {
					setTimeout( test_next_page, 4000 );
				}
			} else if ( style == 'pagination' ) {
				$( pagination_settings.pagination ).show();
			}
			lmp_loading_style = style;
		}
		function test_next_page() {
			var $next_page = $( pagination_settings.next_page );
			if ( $next_page.length > 0 ) {
				current_style();
			} else {
				setTimeout( test_next_page, 4000 );
			}
		}
		lmp_update_state = function() {
			current_style();
		}
	};
	
	bigbazaar.productSectionColor = function(){
		/*
		* section color of products
		*/
		if ( bigbazaarOwlArg.length === 0 || typeof bigbazaarOwlArg.sectionColor === 'undefined' ) {
			return;
		}
		$.each( bigbazaarOwlArg.sectionColor, function ( id, sectionColor ) {
			var $section_color =sectionColor.color_code;
			var $section_id=id;
			
			bigbazaar.$style.append('#'+$section_id+'.product-section.categories_and_products .section-title > a h3,  #'+$section_id+' .woocommerce  ul.products .product-content .product-buttons .product-cart a:hover, #'+$section_id+' .woocommerce  ul.products .product-content .product-buttons .compare:hover, #'+$section_id+' .woocommerce  ul.products .product-content .product-buttons .add_to_wishlist:hover, #'+$section_id+' .woocommerce  ul.products .product-content .product-buttons .quickview:hover{background-color:'+$section_color+';}');
			
			bigbazaar.$style.append('#'+$section_id+'.product-section.categories_and_products .section-tab .nav-tabs li a:hover, #'+$section_id+'.product-section.categories_and_products .section-tab .nav-tabs li.active a, #'+$section_id+'.categories_and_products .section-categories ul.sub-categories li:hover a{color:'+$section_color+';}');
			
			bigbazaar.$style.append('#'+$section_id+'.product-section.categories_and_products .section-inner{ border-top-color:'+$section_color+';}');

		} );
	};
	
	bigbazaar.productsCarousels = function(){
		/*
		* owl carousel slider of products
		*/		
		if ( bigbazaarOwlArg.length === 0 || typeof bigbazaarOwlArg.productsCarousel === 'undefined' ) {
			return;
		}
		$.each( bigbazaarOwlArg.productsCarousel, function ( id, productsCarousel ) {
			var autoplay = ( productsCarousel.autoplay === 'true' ) ? true : false,
				navigation = ( productsCarousel.navigation === 'true' ) ? true : false,
				loop = ( productsCarousel.loop === 'true' ) ? true : false,
				item_mobile = bigbazaar_options.products_per_row_mobile,
				touch_slider = ( bigbazaar_options.touch_slider_mobile === 'true' ) ? true : false;

			if( productsCarousel.item_columns > 0 ) {
				var items = productsCarousel.item_columns;
			}

			$( document.getElementById( id ) ).find( '.product-carousel').owlCarousel({
				autoplay: 		autoplay,
				loop: 			loop,
				nav: 			navigation,
				dots:			false,
				navText: 		[bigbazaar.$chevron_left,bigbazaar.$chevron_right],
				touchDrag: 		( bigbazaar.$windowWidth <  768 && !touch_slider) ? false : true,
				smartSpeed: 	850,
				rtl : 			(bigbazaar.isCheckRTL()) ? true : false,
				responsive:{
					0:{
						items: item_mobile,
					},
					621:{
						items: 2,
					},
					1023:{
						items : 3,
					},
					1199:{
						items : items,
					}
				},
			});
		});
		$( '.owl-carousel').addClass('owl-theme');
	};
	
	bigbazaar.productBannerCarousel = function(){
		/*
		* owl carousel slider of product banner
		*/
		$('.banner-carousel').owlCarousel({
			autoplay:true,
			rewindSpeed:1000,
			items:1,
			rtl : (bigbazaar.isCheckRTL()) ? true : false,
		});
	};
	
	bigbazaar.productBrandsCarousel = function(){
		/*
		* owl carousel slider of products brands
		*/		
		if ( bigbazaarOwlArg.length === 0 || typeof bigbazaarOwlArg.productsBrands === 'undefined' ) {
			return;
		}//console.log(bigbazaarOwlArg);
		$.each( bigbazaarOwlArg.productsBrands, function ( id, productsBrands ) {
			var autoplay = ( productsBrands.autoplay === 'true' ) ? true : false,
				navigation = ( productsBrands.navigation === 'true' ) ? true : false,
				loop = ( productsBrands.loop === 'true' ) ? true : false;

			if( productsBrands.item_columns > 1 ) {
				var items = productsBrands.item_columns;
			}

			$( document.getElementById( id ) ).find( '.brands-carousel').owlCarousel({
				autoplay: autoplay,
				loop : loop,
				nav: navigation,
				dots: false,
				navText: [bigbazaar.$chevron_left,bigbazaar.$chevron_right],
				smartSpeed: 750,
				responsive:{
					0:{
						items:3,
					},
					480:{
						items:4,
					},
					768:{
						items:6,
					},
					1024:{
						items : items,
					},
				},
			});

		} );
	};
	
	bigbazaar.productBrandsVerticalCarousel = function(){
		/*
		* product brands vertical
		*/
		$('.brands-vertical-carousel').not( '.slick-initialized' ).slick();
	};
	
	bigbazaar.variationsImageChange = function(){
		/**
		 * Sets product images for the chosen variation
		 */
		$.fn.wc_variations_image_update = function( variation ) {
			var $form             = this,
				$product          = $form.closest( '.product' ),
				$product_gallery  = $product.find( '.images' ),
				$gallery_img      = $product.find( '.product-thumbnails .slick-slide[data-slick-index="0"] img' ),
				$product_img_wrap = $product_gallery.find( '.woocommerce-product-gallery__image, .woocommerce-product-gallery__image--placeholder' ).eq( 0 ),
				$product_img      = $product_img_wrap.find( '.wp-post-image' ),
				$product_link     = $product_img_wrap.find( 'a' ).eq( 0 );

			if ( variation && variation.image && variation.image.src && variation.image.src.length > 1 ) {
				$product_img.wc_set_variation_attr( 'src', variation.image.src );
				$product_img.wc_set_variation_attr( 'height', variation.image.src_h );
				$product_img.wc_set_variation_attr( 'width', variation.image.src_w );
				$product_img.wc_set_variation_attr( 'srcset', variation.image.srcset );
				$product_img.wc_set_variation_attr( 'sizes', variation.image.sizes );
				$product_img.wc_set_variation_attr( 'title', variation.image.title );
				$product_img.wc_set_variation_attr( 'alt', variation.image.alt );
				$product_img.wc_set_variation_attr( 'data-src', variation.image.full_src );
				$product_img.wc_set_variation_attr( 'data-large_image', variation.image.full_src );
				$product_img.wc_set_variation_attr( 'data-large_image_width', variation.image.full_src_w );
				$product_img.wc_set_variation_attr( 'data-large_image_height', variation.image.full_src_h );
				$product_img_wrap.wc_set_variation_attr( 'data-thumb', variation.image.src );
				$gallery_img.wc_set_variation_attr( 'src', variation.image.thumb_src );
				$product_link.wc_set_variation_attr( 'href', variation.image.full_src );
			} else {
				$product_img.wc_reset_variation_attr( 'src' );
				$product_img.wc_reset_variation_attr( 'width' );
				$product_img.wc_reset_variation_attr( 'height' );
				$product_img.wc_reset_variation_attr( 'srcset' );
				$product_img.wc_reset_variation_attr( 'sizes' );
				$product_img.wc_reset_variation_attr( 'title' );
				$product_img.wc_reset_variation_attr( 'alt' );
				$product_img.wc_reset_variation_attr( 'data-src' );
				$product_img.wc_reset_variation_attr( 'data-large_image' );
				$product_img.wc_reset_variation_attr( 'data-large_image_width' );
				$product_img.wc_reset_variation_attr( 'data-large_image_height' );
				$product_img_wrap.wc_reset_variation_attr( 'data-thumb' );
				$gallery_img.wc_reset_variation_attr( 'src' );
				$product_link.wc_reset_variation_attr( 'href' );
			}

			window.setTimeout( function() {
				$product_gallery.trigger( 'woocommerce_gallery_init_zoom' );
				$form.wc_maybe_trigger_slide_position_reset( variation );
				$( window ).trigger( 'resize' );
			}, 20 );
		};
	};
	
	bigbazaar.productImageZoom = function(){
		//*******************************************************************
		//* Single Product image zoom style
		//******************************************************************
		
		if (!bigbazaar_options.enable_product_image_zoom) return; 
		
		if ( $( '#product-image .woocommerce-product-gallery__image' ).length > 0 ) {
			var img = $( '#product-image .woocommerce-product-gallery__image' );
			img.zoom({
				touch: false
			});
		}
	};
	
	bigbazaar.initProductThumbnailSlick = function(){
		//*******************************************************************
		//* Product detail image and thumbnails slider
		//*******************************************************************/		
		
		$( '.bigbazaar-slick-carousel' ).not( '.slick-initialized' ).slick();
		
		$( '#product-image.bigbazaar-slick-carousel' ).on('afterChange', function(event, slick, currentSlide, nextSlide){
			$('.slick-slide').removeClass('flex-active-slide');
			$('.slick-current').addClass('flex-active-slide');
		});
			
		// Reset the index of image on product variation
		$(document).on( 'found_variation', '.variations_form', function( es, variation ) {		
			if ( variation && variation.image && variation.image.src && variation.image.src.length > 1 ) {
				$( '.bigbazaar-slick-carousel' ).slick( 'slickGoTo', 0 );
			}
		}).on('reset_image', function () {
			$('.bigbazaar-slick-carousel').slick( 'slickGoTo', 0 );
		});
	};
	
	bigbazaar.postGalleryCarousel = function(){
		/*
		* post gallery carousel
		*/
		$('.post-slider').owlCarousel({			
			autoplay : 	true,
			rtl : 		(bigbazaar.isCheckRTL()) ? true : false,
			rewind: 	true,
			smartSpeed: 850,
			nav : 		true,
			navText: 	[bigbazaar.$chevron_left,bigbazaar.$chevron_right],
			dots: 		true,		
			items: 		1
		});
		$( '.post-slider').addClass('owl-theme');
	};
	
	bigbazaar.testimonialCarousel = function(){
		/*
		* Testimonial carousel
		*/
		$('.testimonial-carousel').owlCarousel({
			autoplay:			false,
			rtl : 				(bigbazaar.isCheckRTL()) ? true : false,
			nav: 				true,
			navText:		 	[bigbazaar.$chevron_left,bigbazaar.$chevron_right],
			dots: 				false,
			smartSpeed:			750,
			margin:				15,
			items:				1
		});
	};
	
	bigbazaar.categoryMenuToggle = function(){
		/*
		* Category menu toggle
		*/
		$('.home #header-navigation .category-menu').find('.categories-list').hide();	
		$(document).on('click','.category-menu .down-up',function(){
			var width = $(window).width();		
			$(this).closest('#header-navigation .category-menu').find('.categories-list').slideToggle();
			return false;
		});
	};
	
	bigbazaar.megamenuWindowsPosition = function(){
		/*
		* Megamenu windows exist
		*/
		
		// position mega menu correctly
		jQuery.fn.bigbazaar_position_megamenu = function( variables ) {		

			// top header headnling
			var reference_elem = '';		
			reference_elem = jQuery( this ).parent( '.bigbazaar-main-menu' );		

			if( jQuery( this ).parent( '.bigbazaar-main-menu' ).length ) {

				var main_nav_container = reference_elem,
					main_nav_container_position = main_nav_container.offset(),
					main_nav_container_width = main_nav_container.width(),
					main_nav_container_left_edge = main_nav_container_position.left,
					main_nav_container_right_edge = main_nav_container_left_edge + main_nav_container_width;

				if( ! jQuery( 'body.rtl' ).length ) {
					return this.each( function() {

						jQuery( this ).children( 'li' ).each( function() {
							var li_item = jQuery( this ),
								li_item_position = li_item.offset(),
								megamenu_wrapper = li_item.find( '.bigbazaar-megamenu-wrapper' ),
								megamenu_wrapper_width = megamenu_wrapper.outerWidth(),
								megamenu_wrapper_position = 0;

							// check if there is a megamenu
							if( megamenu_wrapper.length ) {
								megamenu_wrapper.removeAttr( 'style' );

								// set megamenu max width
								var reference_bigbazaar_row;

								if( jQuery( '.bigbazaar-secondary-main-menu' ).length ) {
									reference_bigbazaar_row = jQuery( '.bigbazaar-header-wrapper .bigbazaar-secondary-main-menu .bigbazaar-row' );
								} else {
									reference_bigbazaar_row = jQuery( '.bigbazaar-header-wrapper .bigbazaar-row' );
								}

								if( megamenu_wrapper.hasClass( 'col-span-12' ) && ( reference_bigbazaar_row.width() < megamenu_wrapper.data( 'maxwidth' ) ) ) {
									megamenu_wrapper.css( 'width', reference_bigbazaar_row.width() );
								} else {
									megamenu_wrapper.removeAttr( 'style' );
								}

								// reset the megmenu width after resizing the menu
								megamenu_wrapper_width = megamenu_wrapper.outerWidth();

								if( li_item_position.left + megamenu_wrapper_width > main_nav_container_right_edge ) {
									megamenu_wrapper_position = -1 * ( li_item_position.left - ( main_nav_container_right_edge - megamenu_wrapper_width ) );

									megamenu_wrapper.css( 'left', megamenu_wrapper_position );
								}
							}
						});
					});

				} else {
					return this.each( function() {
						jQuery( this ).children( 'li' ).each( function() {
							var li_item = jQuery( this ),
								li_item_position = li_item.offset(),
								li_item_right_edge = li_item_position.left + li_item.outerWidth(),
								megamenu_wrapper = li_item.find( '.bigbazaar-megamenu-wrapper' ),
								megamenu_wrapper_width = megamenu_wrapper.outerWidth(),
								megamenu_wrapper_position = 0;

							// check if there is a megamenu
							if( megamenu_wrapper.length ) {
								megamenu_wrapper.removeAttr( 'style' );

								// set megamenu max width
								var reference_bigbazaar_row;

								if( jQuery( '.bigbazaar-secondary-main-menu' ).length ) {
									reference_bigbazaar_row = jQuery( '.bigbazaar-header-wrapper .bigbazaar-secondary-main-menu .bigbazaar-row' );
								} else {
									reference_bigbazaar_row = jQuery( '.bigbazaar-header-wrapper .bigbazaar-row' );
								}

								if( megamenu_wrapper.hasClass( 'col-span-12' ) && ( reference_bigbazaar_row.width() < megamenu_wrapper.data( 'maxwidth' ) ) ) {
									megamenu_wrapper.css( 'width', reference_bigbazaar_row.width() );
								} else {
									megamenu_wrapper.removeAttr( 'style' );
								}

								if( li_item_right_edge - megamenu_wrapper_width < main_nav_container_left_edge ) {

									megamenu_wrapper_position = -1 * ( megamenu_wrapper_width - ( li_item_right_edge - main_nav_container_left_edge ) );

									megamenu_wrapper.css( 'right', megamenu_wrapper_position );
								}
							}
						});
					});
				}
			}
		};
		
		// Calculate megamenu position
		if( jQuery.fn.bigbazaar_position_megamenu ) {
			jQuery( '.bigbazaar-main-menu > ul' ).bigbazaar_position_megamenu();

			jQuery( '.bigbazaar-main-menu .bigbazaar-megamenu-menu' ).mouseenter( function() {
				jQuery( this ).parent().bigbazaar_position_megamenu();
			});

			jQuery(window).resize(function() {
				jQuery( '.bigbazaar-main-menu > ul' ).bigbazaar_position_megamenu();
			});
		}
		
		// position dropdown menu correctly
		jQuery.fn.bigbazaar_position_menu_dropdown = function( variables ) {

			return 	jQuery( this ).children( '.sub-menu' ).each( function() {

				// reset attributes
				jQuery( this ).removeAttr( 'style' );
				jQuery( this ).show();
				jQuery( this ).removeData( 'shifted' );

				var submenu = jQuery( this );

				if( submenu.length ) {
					var submenu_position = submenu.offset(),
						submenu_left = submenu_position.left,
						submenu_top = submenu_position.top,
						submenu_height = submenu.height(),
						submenu_width = submenu.outerWidth(),
						submenu_bottom_edge = submenu_top + submenu_height,
						submenu_right_edge = submenu_left + submenu_width,
						browser_bottom_edge = jQuery( window ).height(),
						browser_right_edge = jQuery( window ).width();

					if(	jQuery( '#wpadminbar' ).length ) {
						var admin_bar_height = jQuery( '#wpadminbar' ).height();
					} else {
						var admin_bar_height = 0;
					}

					if( jQuery( '#side-header' ).length ) {
						var side_header_top = jQuery( '#side-header' ).offset().top - admin_bar_height;
					}

					// current submenu goes beyond browser's right edge
					if( submenu_right_edge > browser_right_edge ) {

						//if there are 2 or more submenu parents position this submenu below last one
						if( submenu.parent().parent( '.sub-menu' ).parent().parent( '.sub-menu' ).length ) {
							submenu.css({
								'left': '0',
								'top': submenu.parent().parent( '.sub-menu' ).height()
							});

						// first or second level submenu
						} else {
							// first level submenu
							if( ! submenu.parent().parent( '.sub-menu' ).length ) {
								submenu.css( 'left', ( -1 ) * submenu_width + submenu.parent().width() );

							// second level submenu
							} else {
								submenu.css({
									'left': ( -1 ) * submenu_width
								});
							}
						}

						submenu.data( 'shifted', 1 );
					// parent submenu had to be shifted
					} else if( submenu.parent().parent( '.sub-menu' ).length ) {
						if( submenu.parent().parent( '.sub-menu' ).data( 'shifted' ) ) {
							submenu.css( 'left', ( -1 ) * submenu_width );
							submenu.data( 'shifted', 1 );
						}
					}

				}
			});
				
		};

		// Recursive function for positioning menu items correctly on load
		jQuery.fn.walk_through_menu_items = function() {
			jQuery( this ).bigbazaar_position_menu_dropdown();

			if( jQuery( this ).find( '.sub-menu' ).length ) {
				jQuery( this ).find( '.sub-menu li' ).walk_through_menu_items();
			} else {
				return;
			}
		};
		
		// Calculate main menu dropdown submenu position
		if( jQuery.fn.bigbazaar_position_menu_dropdown ) {
			jQuery( '.bigbazaar-dropdown-menu, .bigbazaar-dropdown-menu li' ).mouseenter( function() {
				jQuery( this ).bigbazaar_position_menu_dropdown();
			});

			jQuery( '.bigbazaar-dropdown-menu > ul > li' ).each( function() {
				jQuery( this ).walk_through_menu_items();
			});

			jQuery( window ).on( 'resize', function() {
				jQuery( '.bigbazaar-dropdown-menu > ul > li' ).each( function() {
					jQuery( this ).walk_through_menu_items();
				});
			});
		}
	};	
	
	bigbazaar.mobileMenu = function(){
		//*******************************************************************
		//*  Mobile menu display
		//*******************************************************************/		
		
		//Menu wrapper
		$(".mobile-nav-tabs li").click(function(){
			if(!$(this).hasClass("active")){
				var cn=$(this).data("menu");
				$(this).parent().find(".active").removeClass("active");
				$(this).addClass("active");
				$(".mobile-nav-content").removeClass("active").fadeOut(300);
				$(".mobile-"+cn+"-menu").addClass("active").fadeIn(300);
			}
		});
		
		//Menu
		var $mobileMenu = $('#mobile-menu-wrapper');
		bigbazaar.$body.on('click', '.navbar-toggle', function (e) {
			e.preventDefault();
			$mobileMenu.toggleClass('open');
			bigbazaar.$body.toggleClass('mobile-menu-opened');
		});

		$( '.mobile-main-menu li.menu-item-has-children' ).append( '<span class="menu-toggle"></span>' );
		
		$mobileMenu.on('click', '.menu-item-has-children > .menu-toggle', function (e) {
			e.preventDefault();

			$(this).closest('li').siblings().find('ul').slideUp();
			$(this).closest('li').siblings().removeClass('active');
			$(this).closest('li').siblings().find('li').removeClass('active');

			$(this).closest('li').children('ul').slideToggle();
			$(this).closest('li').toggleClass('active');

		});

		bigbazaar.$body.on('click', '.panel-overlay, #mobile-nav-close', function (e) {
			e.preventDefault();
			$mobileMenu.removeClass('open');
			bigbazaar.$body.removeClass('mobile-menu-opened');
		});

		bigbazaar.$window.on('resize', function () {
			if (bigbazaar.$window.width() > 991) {
				if ($mobileMenu.hasClass('open')) {
					$mobileMenu.removeClass('open');
					bigbazaar.$body.removeClass('mobile-menu-opened');
				}
			}
		});
	};
	
	bigbazaar.mobileToggle = function(){
		//*******************************************************************
		//*  Mobile Toggle.
		//*******************************************************************/
		$( '.mobile-topbar-wrapper span > ul > li > a' ).on( 'click', function ( e ) {
			e.preventDefault();
			$(this).closest('li').children('ul').slideToggle('active');
		} );
	};
	
	bigbazaar.stickySidebar = function(){
		//*******************************************************************
		//*  Sticky Sidebar.
		//*******************************************************************/
		$(document).ready(function(){
			if (bigbazaar_options.sticky_sidebar){
				jQuery('#sidebar').theiaStickySidebar({
					// Settings
					additionalMarginTop: 30
				});
			}
		});
	};
	
	/**
	 * Document ready
	 */ 
	$(document).ready(function(){
		bigbazaar.init();
    });	
})(jQuery);