<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * e.g., it puts together the home page when no home.php file exists.
 *
 * Learn more: {@link https://codex.wordpress.org/Template_Hierarchy}
 *
 * @package WordPress
 * @subpackage BigBazaar
 * @since BigBazaar 1.0
 */

$sidebar_position=bigbazaar_get_option('blog_page_layout', 'right');
$blog_style=bigbazaar_get_option('blog_page_style', 'large_image');
$column_grid=bigbazaar_get_option('blog_page_show_column', 'two');
$sidebar_widget=bigbazaar_get_option('blog_page_sidebar_widget', 'sidebar-1');
$blog_grid_style=getBlogStyle($blog_style, $column_grid);
$column_classs=getColumnClass( $sidebar_position );
$GLOBALS['sidebar_position'] = $sidebar_position;
$GLOBALS['sidebar_widget'] = $sidebar_widget;

get_header(); ?>

	<div class="container">
	
		<?php if(bigbazaar_get_option('show_blog_page_breadsrumb', 1)==1):
			echo bigbazaar_breadcrumbs();
		endif;?>
		
		<div class="row">
        	<div class="content-area <?php echo esc_attr($column_classs);?>">
			
				<?php if(bigbazaar_get_option('show_blog_page_title', 1)==1):?>
					<?php if ( is_home() && ! is_front_page() ) : ?>
                        <header>
                            <h1 class="page-title"><?php single_post_title(); ?></h1>
                        </header>
                    <?php endif; ?><!-- .entry-header -->
				<?php endif;?>
				
				<div class="blog-posts post_<?php echo esc_attr($blog_grid_style);?>">
				<?php if ( have_posts() ) : ?>
                    
                    <?php                   
					 /*
					 * Include the Post-Format-specific template for the content.
					 * If you want to override this in a child theme, then include a file
					 * called content-___.php (where ___ is the Post Format name) and that will be used instead.
					 */
					get_template_part( 'templates/blog/'.$blog_grid_style );                       
					
                    // Previous/next page navigation.
                    bigbazaar_pagination_nav();   
					
                // If no content, include the "No posts found" template.
                else :
                    get_template_part( 'content', 'none' );        
                endif;
				wp_reset_postdata(); ?>
				</div>
        	</div>
           	<?php get_sidebar(); ?>
		</div>
	</div><!-- .content-area -->

<?php get_footer(); ?>
