<?php
/*
*
*	Meta Box Functions
*	------------------------------------------------
*	BigBazaar Framework
*
*/
global $meta_boxes;

/********************* META BOX REGISTERING ***********************/

/**
 * Register meta boxes
 *
 * @return void
 */
function bigbazaar_register_meta_boxes(){
	
	/**
	* Check Theme Activation
	*/
	if (! bigbazaar_is_activated()) return;
	
	global $meta_boxes;
	$prefix = 'bb_';

// POST FORMAT: Image
//--------------------------------------------------
	$meta_boxes[] = array(
		'title' 		=> esc_html__('Post Format: Image', 'bigbazaar'),
		'id' 			=> $prefix .'meta_box_post_format_image',
		'post_types' 	=> array('post'),
		'priority' 		=> 'high',
		'fields' 		=> array(
								array(
									'name' => esc_html__('Image', 'bigbazaar'),
									'id' => $prefix . 'post_format_image',
									'type' => 'image_advanced',
									'max_file_uploads' => 1,
									'desc' => esc_html__('Select a image for post','bigbazaar')
								),
						),
	);

// POST FORMAT: Gallery
//--------------------------------------------------
	$meta_boxes[] = array(
		'title' 		=> esc_html__('Post Format: Gallery', 'bigbazaar'),
		'id' 			=> $prefix . 'meta_box_post_format_gallery',
		'post_types' 	=> array('post'),
		'priority' 		=> 'high',
		'fields' 		=> array(
								array(
									'name' => esc_html__('Images', 'bigbazaar'),
									'id' => $prefix . 'post_format_gallery',
									'type' => 'image_advanced',
									'desc' => esc_html__('Select images gallery for post','bigbazaar')
								),
						),
	);

// POST FORMAT: Video
//--------------------------------------------------
	$meta_boxes[] = array(
		'title' 		=> esc_html__('Post Format: Video', 'bigbazaar'),
		'id' 			=> $prefix . 'meta_box_post_format_video',
		'post_types'	=> array('post'),
		'priority' 		=> 'high',
		'fields' 		=> array(
								array(
									'name' => esc_html__( 'Video URL or Embeded Code', 'bigbazaar' ),
									'id'   => $prefix . 'post_format_video',
									'type' => 'textarea',
									'desc' => esc_html__('Enter the URL or embed code of Vimeo.com or YouTube.com streaming services.<br>To get the code, go to the external video page, click "share" button and copy the Embed code.','bigbazaar')
								),
						),
	);

// POST FORMAT: Audio
//--------------------------------------------------
	$meta_boxes[] = array(
		'title' 		=> esc_html__('Post Format: Audio', 'bigbazaar'),
		'id' 			=> $prefix . 'meta_box_post_format_audio',
		'post_types' 	=> array('post'),
		'fields' 		=> array(
								array(
									'name' => esc_html__( 'Audio URL or Embeded Code', 'bigbazaar' ),
									'id'   => $prefix . 'post_format_audio',
									'type' => 'textarea',
									'desc' => esc_html__('Please enter the URL or Embeded code of the audio.','bigbazaar')
								),
						),
	);

// POST FORMAT: QUOTE
//--------------------------------------------------
    $meta_boxes[] = array(
        'title' => esc_html__('Post Format: Quote', 'bigbazaar'),
        'id' 	=> $prefix . 'meta_box_post_format_quote',
        'post_types' => array('post'),
		'priority' 	=> 'high',
        'fields' 	=> array(
							array(
								'name' => esc_html__( 'Quote', 'bigbazaar' ),
								'id'   => $prefix . 'post_format_quote',
								'type' => 'textarea',
								'desc' => esc_html__('Add a quote.','bigbazaar')
							),
							array(
								'name' => esc_html__( 'Author', 'bigbazaar' ),
								'id'   => $prefix . 'post_format_quote_author',
								'type' => 'text',
								'desc' => esc_html__('Add the quote author.','bigbazaar')
							),
							array(
								'name' => esc_html__( 'Author Url', 'bigbazaar' ),
								'id'   => $prefix . 'post_format_quote_author_url',
								'type' => 'url',
								'desc' => esc_html__('Add the quote author URL.','bigbazaar')
							),
					),
    );
    
// POST FORMAT: LINK
//--------------------------------------------------
$meta_boxes[] = array(
	'title' => esc_html__('Post Format: Link', 'bigbazaar'),
	'id' 	=> $prefix . 'meta_box_post_format_link',
	'post_types' => array('post'),
	'priority' 	=> 'high',
	'fields' 	=> array(
						array(
							'name' => esc_html__( 'Url', 'bigbazaar' ),
							'id'   => $prefix . 'post_format_link_url',
							'type' => 'url',
							'desc' => esc_html__('Add an URL link.','bigbazaar')
						),
						array(
							'name' => esc_html__( 'Text', 'bigbazaar' ),
							'id'   => $prefix . 'post_format_link_text',
							'type' => 'text',
							'desc' => esc_html__('Add text for the URL link.','bigbazaar')
						),
				),
);

// PORTFOLIO METABOX
//--------------------------------------------------
$meta_boxes[] = array(
	'title' => esc_html__('Portfolio Informations', 'bigbazaar'),
	'id' 	=> 'portfolio_informations',
	'post_types' => array('portfolio'),
	'priority' 	=> 'default',
	'fields' 	=> array(
						array(
							'name' => esc_html__( 'Enter Client Name', 'bigbazaar' ),
							'id'   => '_bigbazaar_portfolio_client_name',
							'type' => 'text',
							'desc' => esc_html__('Enter your project client name.','bigbazaar')
						),
						array(
							'name' => esc_html__( 'Enter Live Project URL', 'bigbazaar' ),
							'id'   => '_bigbazaar_portfolio_project_url',
							'type' => 'text',
							'desc' => esc_html__('Enter your live project url.','bigbazaar')
						),
				),
);

// SERVICES METABOX
//--------------------------------------------------
$meta_boxes[] = array(
	'title' => esc_html__('Service Options', 'bigbazaar'),
	'id' 	=> $prefix .'service_options',
	'post_types' => array('service'),
	'priority' 	=> 'high',
	'fields' 	=> array(
						array(
							'name' => esc_html__('Enter Service Icon','bigbazaar'),
							'id' => 'service_icon',
							'type' => 'text',
							'desc' => esc_html__('Enter font awesome icon for service. ex. fa-code','bigbazaar'),
						),
				),
);

// Testimonial METABOX
//--------------------------------------------------
$meta_boxes[] = array(
	'id' 			=> 'testimonial_options',
	'title' 		=> __('Testimonial Options','bigbazaar'),
	'post_types' 	=> array('testimonial'),
	'priority' 		=> 'high',
	'fields' 		=> array(
							array(
								'name' => __('Enter Designation','bigbazaar'),
								'id' => 'client_designation',
								'type' => 'text',
								'desc' => __('Enter client designation.','bigbazaar'),
							),
							array(
								'name' => __('Enter Company Name','bigbazaar'),
								'id' => 'client_company',
								'type' => 'text',
								'desc' => __('Enter client company name.','bigbazaar'),
							),
					)
);

// PAGE, POST, PORTFOLIO PAGE OPTIONS 
//--------------------------------------------------
$meta_boxes[] = array(
	'title' => esc_html__('Page Layout Options', 'bigbazaar'),
	'id' 	=> 'page_options',
	'post_types' => array('page', 'post','portfolio'),
	'priority' 	=> 'high',
	'fields' => array(
					array(
						'name' 	=> esc_html__( 'Show Title', 'bigbazaar' ),
						'id'   	=> '_bigbazaar_show_title',
						'type' 	=> 'select_advanced',
						'desc' 	=> esc_html__('Show title of the page.','bigbazaar'),
						'options' => array(
										'yes'		=> esc_html__( 'Yes', 'bigbazaar' ),
										'no'		=> esc_html__( 'No', 'bigbazaar' ),
									),
						'std' 	=> 'yes',
					),
					array(
						'name' 	=> esc_html__( 'Show Breadcrumb', 'bigbazaar' ),
						'id'   	=> '_bigbazaar_show_breadsrumb',
						'type' 	=> 'select_advanced',
						'desc' 	=> esc_html__('Show breadcrumb of the page.','bigbazaar'),
						'options' => array(
										'yes'		=> esc_html__( 'Yes', 'bigbazaar' ),
										'no'		=> esc_html__( 'No', 'bigbazaar' ),
									),
						'std' => 'yes',
					),
					
					//Post options
					array(
						'name' 	=> esc_html__('Show Posts Per Page','bigbazaar'),
						'id' 	=> '_bigbazaar_number_post',
						'type' 	=> 'number',
						'desc' 	=> esc_html__('Show posts per page.','bigbazaar'),
						'std' 	=> '10'
					),
					array(
						'name' 	=> esc_html__('Blog Style','bigbazaar'),
						'id' 	=> '_bigbazaar_blog_style',
						'type' 	=> 'select_advanced',
						'desc' 	=> esc_html__('Choose blog style.','bigbazaar'),
						'options' => array(
										'large_image'		=> esc_html__( 'Large Image', 'bigbazaar' ),
										'small_image'		=> esc_html__( 'Small Image', 'bigbazaar' ),
										'masonry_grid'		=> esc_html__( 'Masonry Grid', 'bigbazaar' ),
										//'timeline'		=> esc_html__( 'Timeline', 'bigbazaar' ),
									),
						'std' => 'large_image'
					),
					array(
						'name' 	=> esc_html__('Show Post Columns','bigbazaar'),
						'id' 	=> '_bigbazaar_show_column',
						'type' 	=> 'select_advanced',
						'desc' 	=> esc_html__('Show post column of the post/blog page. Column option apply only on above masorny grid option.','bigbazaar'),
						'options' => array(
										'two'		=> esc_html__( '2 Columns', 'bigbazaar' ),
										'three'		=> esc_html__( '3 Columns', 'bigbazaar' ),
										'four'		=> esc_html__( '4 Columns', 'bigbazaar' ),
									),
						'std' 	=> 'two'
					),
					
					//Portfolio options
					array(
						'name' => esc_html__('Show Portfolio Per Page','bigbazaar'),
						'id' 	=> '_bigbazaar_number_portfolio',
						'type' 	=> 'number',
						'desc' 	=> esc_html__('Show number of portfolio per page.','bigbazaar'),
						'std' 	=> '10'
					),
					array(
						'name' 	=> esc_html__('Select Portfolio style','bigbazaar'),
						'id' 	=> '_bigbazaar_portfolio_style',
						'type' 	=> 'select_advanced',
						'desc' 	=> esc_html__('Choose portfolio grid style.','bigbazaar'),
						'options' => array(
										'normal_grid'		=> esc_html__( 'Normal Grid', 'bigbazaar' ),
										'masonry_grid'		=> esc_html__( 'Masonry Grid', 'bigbazaar' ),
									),
						'std' 	=> 'normal_grid'
					),
					array(
						'name' 	=> esc_html__('Show Portfolio Columns','bigbazaar'),
						'id' 	=> '_bigbazaar_portfolio_column',
						'type' 	=> 'select_advanced',
						'desc' 	=> esc_html__('Show portfolio columns of the page.','bigbazaar'),
						'options' 	=> array(
											'one'		=> esc_html__( '1 Columns', 'bigbazaar' ),
											'two'		=> esc_html__( '2 Columns', 'bigbazaar' ),
											'three'		=> esc_html__( '3 Columns', 'bigbazaar' ),
											'four'		=> esc_html__( '4 Columns', 'bigbazaar' ),
										),
						'std' 	=> 'two'
					),
					array(
						'name'  => esc_html__( 'Page Sidebar', 'bigbazaar' ),
						'id'    => '_bigbazaar_sidebar_position',
						'type'  => 'image_set',
						'allowClear' => true,
						'options' 	=> array(
											'none'	  => BIGBAZAAR_URI.'/images/sidebar-none.png',
											'left'	  => BIGBAZAAR_URI.'/images/sidebar-left.png',
											'right'	  => BIGBAZAAR_URI.'/images/sidebar-right.png',
											//'both'	  => BIGBAZAAR_URI.'/images/sidebar-both.png'
										),
						'std'	=> 'right',
						'multiple' 	=> false,
						'required' 	=> true,

					),
					array (
						'name' 	=> esc_html__('Sidebar Widget', 'bigbazaar'),
						'id' 	=> '_bigbazaar_sidebar_widget',
						'type' 	=> 'sidebars',
						'placeholder' => esc_html__('Select Sidebar','bigbazaar'),
						'std' 	=> 'sidebar-1',
						'required' 	=> true,
						//'required-field' => array($prefix . 'top_drawer_type','<>','none'),
						'required-field' => array('_bigbazaar_sidebar_position','=',array('','left','right')),
					),
			),
);

/* PRODUCT PAGE OPTIONS 
 * BIGBAZAAR 2.0
 *--------------------------------------------------*/
$meta_boxes[] = array(
	'title' 		=> esc_html__('Product Page Layout Options', 'bigbazaar'),
	'id' 			=> 'bigbazaar_product_page_options',
	'post_types' 	=> 'product',
	'context'   	=> 'normal',
	'priority'  	=> 'high',
	'fields' 		=> array(
					
					array(
						'name'  		=> esc_html__( 'Product Page Layout', 'bigbazaar' ),
						'id'    		=> '_bigbazaar_product_layout',
						'type'  		=> 'image_set',
						'allowClear' 	=> true,
						'options' 		=> array(
												'none-left'	  	=> BIGBAZAAR_ADMIN_IMAGES.'/thumbnail/none_left.png',
												'none-right'	=> BIGBAZAAR_ADMIN_IMAGES.'/thumbnail/none_right.png',
												'full-layout'	=> BIGBAZAAR_ADMIN_IMAGES.'/thumbnail/none.png',
												'right'	  		=> BIGBAZAAR_ADMIN_IMAGES.'/thumbnail/right.png',
												'left'	  		=> BIGBAZAAR_ADMIN_IMAGES.'/thumbnail/left.png'	
											),
						//'std'			=> 'right',
						'multiple' 		=> false,
						//'required' 	=> true,
						'desc' 			=> sprintf( __( 'Choose product page layout for only this product. You can choose  global for all product page layout at <a target="_blank" href="%1$s">here</a> (WooCommerce > Single Product section).', 'bigbazaar' ), esc_url( admin_url( 'themes.php?page=optionsframework' ) ) ),

					),					
					array (
						'name' 			=> esc_html__('Sidebar Widget', 'bigbazaar'),
						'id' 			=> '_bigbazaar_product_sidebar_widget',
						'type' 			=> 'sidebars',
						'placeholder' 	=> esc_html__('Select Sidebar','bigbazaar'),
						//'std' 		=> 'sidebar-1',
						//'required' 	=> true,
						'required-field'=> array('_bigbazaar_product_layout','=',array('','left','right')),
					),
					array(
						'name' 			=> esc_html__('Product Size Guide Image', 'bigbazaar'),
						'id' 			=> '_bigbazaar_product_size_guide',
						'type' 			=> 'image_upload',
						'max_file_uploads' => 1,
						'desc' 			=> sprintf( __( 'Upload product size guide image for only this product. You can use image size guide for all product at <a target="_blank" href="%1$s">here</a> (WooCommerce > Single Product section).', 'bigbazaar' ), esc_url( admin_url( 'themes.php?page=optionsframework' ) ) )
					),
			),
);

	
	// Make sure there's no errors when the plugin is deactivated or during upgrade
	if (class_exists('RW_Meta_Box')) {
		foreach ($meta_boxes as $meta_box) {
			new RW_Meta_Box($meta_box);
		}
	}
}

// Hook to 'admin_init' to make sure the meta box class is loaded before
// (in case using the meta box class in another plugin)
// This is also helpful for some conditionals like checking page template, categories, etc.
add_action('admin_init', 'bigbazaar_register_meta_boxes');
