<?php
/**
 * Customize theme style functionality for BigBazaar
 *
 * @package WordPress
 * @subpackage BigBazaar
 * @since BigBazaar 1.0
 */

 /**
 * Styles the theme body.
 *
 * @since BigBazaar 1.0
 *
 */
add_action( 'wp_enqueue_scripts', 'bigbazaar_theme_style', 11 );
if ( ! function_exists( 'bigbazaar_theme_style' ) ) :
function bigbazaar_theme_style() {
	global $bigbazaar_options;
	
	// Add custom user CSS
	$theme_css = trim( bigbazaar_get_option('custom_css',''));	
	
	$pre_page_width	= (bigbazaar_get_option('use_predefined_page_width',1)== 1) ? bigbazaar_get_option('predefined_page_width','1170') : bigbazaar_get_option('custom_page_width','1170');
	
	$body_background_color 		= bigbazaar_get_option('body_background_color','#ffffff');
	$body_background 			= "url('')";
	$topbar_background_color 	= bigbazaar_get_option('topbar_background_color','#353d41');
	$topbar_background			= "url('')";
	$header_background_color 	= bigbazaar_get_option('header_background_color','#ffffff');
	$header_background			= "url('')";
	$footer_background_color 	= bigbazaar_get_option('footer_background_color','#363636');
	$footer_background			= "url('')";
	
	//body background
	$body_image = bigbazaar_get_option('body_background_image');
	$body_image_none= pathinfo($body_image);
	if(isset($body_image) && $body_image_none['filename']!='none'):
		$body_background="url(".$body_image.")";
	elseif(bigbazaar_get_option('choose_body_background_pattern') !=1):
			$body_background="url(".bigbazaar_get_option('custom_body_background_pattern').")";
	endif;
	
	
	//topbar background
	$topbar_image = bigbazaar_get_option('topbar_background_image');
	$topbar_image_none= pathinfo($topbar_image);
	if(isset($topbar_image) && $topbar_image_none['filename']!='none'):
		$topbar_background = "url(".$topbar_image.")";		
	elseif(bigbazaar_get_option('choose_topbar_background_pattern') !=1):			
		$topbar_background ="url(".bigbazaar_get_option('custom_topbar_background_pattern').")";
	endif;
	
	//header background
	$header_image = bigbazaar_get_option('header_background_image');
	$header_image_none= pathinfo($header_image);
	if(isset($header_image) && $header_image_none['filename']!='none'):
		$header_background ="url(".$header_image.")";
	elseif(bigbazaar_get_option('choose_header_background_pattern') !=1):
			$header_background ="url(".bigbazaar_get_option('custom_header_background_pattern').")";
	endif;
	
	//footer background
	$footer_image = bigbazaar_get_option('footer_background_image');
	$footer_image_none= pathinfo($footer_image);
	if(isset($footer_image) && $footer_image_none['filename']!='none'):
		$footer_background ="url(".$footer_image.")";		
	elseif( bigbazaar_get_option('choose_footer_background_pattern') !=1):			
		$footer_background ="url(".bigbazaar_get_option('custom_footer_background_pattern').")";
	endif;	
	
		
	$theme_css.="
	/* 
	* page width
	*/
	body{
		background-color:{$body_background_color};
		background-image:{$body_background};
	}
	.wrapper.boxed-layout, .wrapper .container{
		width:{$pre_page_width}px;
	}	
	.header-topbar, .wcaccount-topbar .wcaccount-dropdown,.header-topbar .wpml-ls-statics-shortcode_actions .wpml-ls-sub-menu, .header-topbar .currency-topbar .wcml-cs-submenu, .header-topbar .demo-dropdown .demo-dropdown-sub-menu{
		background-color:{$topbar_background_color};
		background-image:{$topbar_background};
	}	
	#header .header-middle{
		background-color:{$header_background_color};
		background-image:{$header_background};
	}
	#footer .footer-top, #footer .footer-middle, #footer .footer-bottom{
		background-color:{$footer_background_color};
		background-image:{$footer_background};
	}";

	$colors = wp_parse_args( $bigbazaar_options, array(
		'theme_color'    			=> '#e62e04',
		'body_text_color'     		=> '#333333',
		'body_link_color'     		=> '#333333',
		'body_hover_color'     		=> '#ff6600',
		'theme_border'				=> array("width" => "1","style" => "solid","color" => "#e9e9e9"),
				
		'topbar_text_color'     	=> '#93999d',
		'topbar_link_color'     	=> '#93999d',
		'topbar_hover_color'     	=> '#ffffff',
		'topbar_background_image'   => '',
		'topbar_border'				=> array("width" => "1","style" => "solid","color" => "#454d50"),
		
		'header_background_color'   => '#ffffff',
		'header_text_color'     	=> '#333333',
		'header_link_color'     	=> '#333333',
		'header_link_hover_color' 	=> '#ff6600',
		'header_hover_color'    	=> '#ffffff',
		'header_border'				=> array("width" => "1","style" => "solid","color" => "#e9e9e9"),
		
		'navigation_background_color' => '#fcfcfc',
		'navigation_text_color'     => '#333333',
		'navigation_link_color'     => '#333333',
		'navigation_link_hover_color' => '#ff6600',
		'navigation_hover_color'    => '#ffffff',
		'navigation_bar_border'		=> array("width" => "1","style" => "solid","color" => "#e9e9e9"),
		
		'menu_background_color'		=> '#ffffff',
		'menu_text_color'			=> '#333333',
		'menu_link_color'			=> '#333333',
		'menu_link_hover_color'		=> '#ff6600',
		'menu_hover_color'			=> '#ffffff',
		'menu_border'				=> array("width" => "1","style" => "solid","color" => "#e9e9e9"),
		
		'footer_text_color'			=> '#999999',
		'footer_link_color' 		=> '#999999',
		'footer_header_color'		=> '#ffffff',
		'footer_hover_color'		=> '#FF6600',
		'footer_border'				=> array("width" => "1","style" => "solid","color" => "#434343"),
		
		'copyright_background_color'=> '#212121',
		'copyright_text_color'		=> '#999999',
		'copyright_link_color' 		=> '#999999',
		'copyright_hover_color'		=> '#FF6600',
		
		'newsletter_background'		=> '#e62e04',
		'newsletter_color'			=> '#ffffff',
		'newsletter_button_color' 	=> '#FF6600',
		
		'out_stock_opacity'			=> '7',
	) );
	
	$theme_css.=<<<CSS
	/* 
	* Body color Scheme 
	*/
	body{
		color:{$colors['body_text_color']};
	}
	a, .bigbazaar-main-menu > ul.bigbazaar-vertical-menu > li > a, #header-navigation .category-menu a, #header .header-cart-content .cart-item-detail a, #header .search-control-group .search-categories a{
		color:{$colors['body_link_color']};
	}
	a:hover, .bigbazaar-main-menu > ul.bigbazaar-vertical-menu > li:hover > a, #header-navigation .category-menu a:hover{
		color:{$colors['body_hover_color']};
	}
	.header-cart-content .cart_list.product_list_widget .cart-box-title, .header-cart-content .cart_list.product_list_widget .empty, .header-cart-content .total, #header-navigation li{
		color:{$colors['body_text_color']};
	}
	.product_list_widget .cart-item-detail .quantity, .woocommerce.widget_shopping_cart .total .amount, .header-cart-content .cart-product-list p.total .amount, .woocommerce ul.products .product-entry .product-content .price, .widget .product-price, .widget .product-categories li.current-cat-parent > a, .widget .product-categories li.current-cat-parent > span, .widget .product-categories li.current-cat > a, .widget .product-categories li.current-cat > span, .woocommerce .single-product-entry .product-price .price, .woocommerce .single-product-entry .single_variation .price, .single-product-entry .entry-summary .product-title-price .amount, .single-product-entry .entry-summary .product-title-price del, .single-product-entry .entry-summary .product-title-price ins, .single-product-entry .entry-summary .product_meta .posted_in a, .single-product-entry .entry-summary .product_meta .tagged_as a, .woocommerce .single-product-entry .entry-summary .yith-wcwl-add-to-wishlist a:before, .woocommerce .single-product-entry .entry-summary .compare:before, .entry-content .more-link, .portfolio-content .more-link, .services ul.services .service-item i, .woocommerce  ul.products .product-content .product-buttons .add_to_cart_button.loading:after, article .entry-action a, .header-middle .customer-support{
		color:{$colors['theme_color']};
	}
	a:hover, a:focus, .single-product-entry .entry-summary .product_meta .posted_in a:hover, .single-product-entry .entry-summary .product_meta .tagged_as a:hover, .woocommerce .single-product-entry .entry-summary .yith-wcwl-add-to-wishlist a:hover:before, .woocommerce .single-product-entry .entry-summary .compare:hover:before, #header .header-cart-content .cart-item-detail a:hover, .product-section .section-tab .nav-tabs li a:hover, .product-section .section-tab .nav-tabs li.active a, .category-entry:hover .category-content a, .entry-media .post-link:hover a{
		color:{$colors['body_hover_color']};
	}
	.topbar-notification .news-title, button, .button, input[type='button'], input[type='reset'], input[type='submit'], .woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt, .header-cart-content .heading-cart:before,#back-to-top,.category-menu .category-menu-title, .product-toolbar .gridlist-toggle .grid.active, .product-toolbar .gridlist-toggle .grid:hover, .product-toolbar .gridlist-toggle .list.active, .product-toolbar .gridlist-toggle .list:hover,.woocommerce .woocommerce-pagination ul.page-numbers span.current, .woocommerce .woocommerce-pagination ul.page-numbers a:hover, #footer .widget .tagcloud a:hover, .single-product-entry .entry-summary .product-navbar, .woocommerce-product-gallery__trigger::before, .owl-carousel .owl-nav .owl-prev:hover, .owl-carousel .owl-nav .owl-next:hover, .woocommerce div.product .woocommerce-tabs ul.tabs li.active, .woocommerce  ul.products .product-content .product-buttons .product-cart a.added_to_cart, .woocommerce  ul.products .product-content .yith-wcwl-wishlistaddedbrowse a, .woocommerce  ul.products .product-content .yith-wcwl-wishlistexistsbrowse a, #yith-wcwl-popup-message, .entry-portfolio:hover .portfolio-content, article .entry-action a:hover, .porftfolio-lists .portfolioFilter a.current, .woocommerce .widget_price_filter .ui-slider .ui-slider-range, .pagination .page-numbers.current, .lmp_load_more_button .lmp_button, .cwallowcookies.button, .entry-content .more-link:hover, .entry-summary .more-link:hover, .portfolio-content .more-link:hover, .header-post-navigation .nav-links li a:hover, .entry-media blockquote, .entry-media .post-link, .woocommerce-MyAccount-navigation > ul li a, .mobile-nav-tabs li.active{
		background-color:{$colors['theme_color']};
	}
	.woocommerce .selectBox-options li.selectBox-selected a{
		background-color:{$colors['theme_color']} !important;
	}
	button:hover, .button:hover, input[type='button']:hover, input[type='reset']:hover, input[type='submit']:hover, button:focus, .button:focus, input[type='button']:focus, input[type='reset']:focus, input[type='submit']:focus, .woocommerce #respond input#submit.alt:hover, .woocommerce a.button.alt:hover, .woocommerce button.button.alt:hover, .woocommerce input.button.alt:hover, .single-product-entry .entry-summary .product-prev:hover .product-navbar, .single-product-entry .entry-summary .product-next:hover .product-navbar,.slick-slider .slick-arrow:before, .woocommerce  ul.products .product-content .product-buttons .product-cart a:hover, .woocommerce  ul.products .product-content .product-buttons .compare:hover, .woocommerce  ul.products .product-content .product-buttons .add_to_wishlist:hover, .woocommerce  ul.products .product-content .product-buttons .quickview:hover,.live-search-results .autocomplete-suggestion:hover, .live-search-results .autocomplete-suggestion.autocomplete-selected, .woocommerce .widget_price_filter .ui-slider .ui-slider-handle, .lmp_load_more_button .lmp_button:hover, .cwallowcookies.button:hover, .cwcookiesmoreinfo.button:hover,.woocommerce-MyAccount-navigation > ul li:hover a {
		background-color:{$colors['body_hover_color']};
	}
	.woocommerce .selectBox-options li.selectBox-hover a{
		background-color:{$colors['body_hover_color']} !important;
	}
	.product-section .section-header .section-title h3:before, .newsletter-section .section-header .section-title h3:before, .testimonials-section .section-header .section-title h3:before, .woocommerce .woocommerce-pagination ul.page-numbers span.current, .woocommerce .woocommerce-pagination ul.page-numbers a:hover, #footer .widget .tagcloud a:hover, .woocommerce div.product .woocommerce-tabs ul.tabs li.active, .woocommerce div.product div.products h2 span:before, .cart-collaterals .cross-sells h2 span:before, #yith-wcwl-popup-message, .related-portfolios .related-portfolio-title span:before, .porftfolio-lists .portfolioFilter a.current, .pagination .page-numbers.current, .entry-content .more-link:hover, .entry-summary .more-link:hover, .portfolio-content .more-link:hover, .related-posts .related-posts-title span:before{
		border-color:{$colors['theme_color']};
	}
	.single-product-entry  .entry-summary .product-next .product-next-popup:before, .single-product-entry  .entry-summary .product-prev:hover .product-prev-popup:before, .woocommerce div.product .woocommerce-tabs ul.tabs:before, .product-section.products_carousel .section-tab, .post-navigation .nav-next .post-nav-thumb, .header-post-navigation .nav-next .post-nav-thumb, .post-navigation .nav-previous .post-nav-thumb, .header-post-navigation .nav-previous .post-nav-thumb, .header-cart-content .cart-product-list:before{
		border-bottom-color:{$colors['theme_color']} !important;
	}
	.widget li a::before, .topbar-notification .news-title::before{
		border-left-color:{$colors['theme_color']};
	}
	.loading .pl-loading:after{
		border-left-color:{$colors['theme_color']} !important;
	}
	.widget-area .widget, .header-cart-content .cart-product-list, .single-product-entry  .entry-summary .product-next .product-next-popup, .single-product-entry  .entry-summary .product-prev .product-prev-popup, .post-navigation .nav-next .post-nav-thumb:before, .header-post-navigation .nav-next .post-nav-thumb:before, .post-navigation .nav-previous .post-nav-thumb:before, .header-post-navigation .nav-previous .post-nav-thumb:before, .bigbazaar-main-menu .sub-menu, .bigbazaar-main-menu .bigbazaar-megamenu-wrapper {
		border-top-color:{$colors['theme_color']};
	}
	
	table, th, td,.bigbazaar-main-menu .bigbazaar-vertical-menu, .post-navigation, .widget, .secondary .widget > select,.widget .tagcloud a, .widget.yith-woocompare-widget .clear-all, .blog-posts .hentry, .comment-area-wrap, .comment-avatar img, .comment-respond, .porftfolio-lists .portfolioFilter a, .product-toolbar, .product-toolbar .gridlist-toggle > a, .woocommerce .woocommerce-pagination ul.page-numbers span,.woocommerce .woocommerce-pagination ul.page-numbers a, .product-items .product-entry, .product-items .product-category a, .single-product-entry .images #product-image, .single-product-entry .flex-viewport, .product-thumbnails .slick-slide, .woocommerce .single-product-entry .entry-summary .quantity .qty, .woocommerce-tabs .panel, .product-section .section-inner, .product-section.categories_carousel .product-items .category-entry, .product-section.products_brands .brands-carousel .slide-row li, .product-section.blogs_carousel .product-carousel .slide-row li, .testimonials-section .quote-content p, .testimonials-section .quote-meta  .client-image, .woocommerce .col2-set .col-1, .woocommerce-page .col2-set .col-1, .woocommerce .col2-set .col-2,.woocommerce-page .col2-set .col-2{
		border-width:{$colors['theme_border']['width']}px;
		border-style:{$colors['theme_border']['style']};
		border-color:{$colors['theme_border']['color']};
	}
	.bigbazaar-main-menu > ul.bigbazaar-vertical-menu > li > a, .bigbazaar-main-menu ul.bigbazaar-vertical-menu .sub-menu li, .widget-title,.widget_rss li, .widget ul.post-list-widget li, .widget ul.product_list_widget li, .portfolio_one_column .entry-portfolio .portfolio-skill, .related-portfolios .related-portfolio-title,.related-posts .related-posts-title, .woocommerce .single-product-entry .entry-summary .cart, .woocommerce div.product div.products > h2, .cart-collaterals .cross-sells > h2, .product-section.categories_and_products .section-title > a h3, .product-section .section-tab .nav-tabs, .product-section .section-tab .nav-tabs li a, .product-section .section-header .section-title, .newsletter-section .section-header .section-title, .testimonials-section .section-header .section-title, .services ul.services .service-item, .woocommerce ul.cart_list li, .woocommerce ul.product_list_widget li{
		border-bottom-width:{$colors['theme_border']['width']}px;
		border-bottom-style:{$colors['theme_border']['style']};
		border-bottom-color:{$colors['theme_border']['color']};
	}
	.portfolio_one_column .entry-portfolio .portfolio-skill, .portfolio-detail .entry-information > div, .countdown:not(.simple) .countdown-period, .woocommerce .single-product-entry .entry-summary .cart, .services ul.services, .product-items .category-entry{
		border-top-width:{$colors['theme_border']['width']}px;
		border-top-style:{$colors['theme_border']['style']};
		border-top-color:{$colors['theme_border']['color']};
	}
	.countdown:not(.simple) .countdown-section:not(:last-child), .services ul.services, .product-items .category-entry{
		border-right-width:{$colors['theme_border']['width']}px;
		border-right-style:{$colors['theme_border']['style']};
		border-right-color:{$colors['theme_border']['color']};
	}
	.product-section.categories_and_products .section-tab, .categories_and_products.brands-products .section-content, .categories_and_products.only-categories .section-content, .categories_and_products.brands-categories .section-content, .product-section .section-brands .brands-vertical-carousel, .services ul.services .service-item, .search-control-group .search-categories{
		border-left-width:{$colors['theme_border']['width']}px;
		border-left-style:{$colors['theme_border']['style']};
		border-left-color:{$colors['theme_border']['color']};
	}
	
	
	/*
	* topbar color scheme
	*/
	.header-topbar, .wcaccount-topbar .wcaccount-dropdown{		
		color:{$colors['topbar_text_color']};
	}
	.header-topbar a{
		color:{$colors['topbar_link_color']};
	}
	.header-topbar a:hover{
		color:{$colors['topbar_hover_color']};
	}
	.topbar-right > span, .topbar-right .nav li, .header-topbar .social-link ul li:first-child a{
		border-left-width:{$colors['topbar_border']['width']}px;
		border-left-style:{$colors['topbar_border']['style']};
		border-left-color:{$colors['topbar_border']['color']};
	}
	.topbar-right > span:last-child, .topbar-right .nav li:last-child{
		border-right-width:{$colors['topbar_border']['width']}px;
		border-right-style:{$colors['topbar_border']['style']};
		border-right-color:{$colors['topbar_border']['color']};
	}
	.header-topbar, .wcaccount-topbar .wcaccount-dropdown > li{
		border-bottom-width:{$colors['topbar_border']['width']}px;
		border-bottom-style:{$colors['topbar_border']['style']};
		border-bottom-color:{$colors['topbar_border']['color']};
	}
	@media screen and (max-width: 620px) {
		.header-topbar .topbar{
			border-top-width:{$colors['topbar_border']['width']}px;
			border-top-style:{$colors['topbar_border']['style']};
			border-top-color:{$colors['topbar_border']['color']};
		}
	}
	
	/*
	* header color scheme
	*/
	#header .header-middle, .header-middle .bigbazaar-main-menu > ul > li > a{
		color:{$colors['header_text_color']};
	}
	.header-middle a, .header-middle .search-area .live-search-results{
		color:{$colors['header_link_color']};
	}
	.header-middle a:hover, .header-middle .header-cart-content:hover .heading-cart a, .header-middle .bigbazaar-main-menu > ul > li:hover > a, .header-middle .bigbazaar-main-menu > ul > li.menu-item-has-children:hover > a, .header-middle .bigbazaar-main-menu > ul > li.current-page-ancestor > a, .header-middle .bigbazaar-main-menu > ul > li.current-menu-ancestor > a, .header-middle .bigbazaar-main-menu > ul > li.current-menu-item > a, .header-middle .bigbazaar-main-menu > ul > li.current_page_item > a{
		color:{$colors['header_link_hover_color']};
	}
	.navbar-toggle .icon-bar{
		background-color:{$colors['header_text_color']};
	}
	.header-middle .search-area{
		border-width:{$colors['header_border']['width']}px;
		border-style:{$colors['header_border']['style']};
		border-color:{$colors['header_border']['color']};
	}
	
	/*
	* navigation bar color scheme
	*/
	#header-navigation{
		background-color:{$colors['navigation_background_color']};
		color:{$colors['navigation_text_color']};
	}
	#header-navigation .heading-cart a, #header-navigation .header-cart-content .heading-cart span, #header-navigation .main-navigation .bigbazaar-main-menu > ul > li > a{
		color:{$colors['navigation_text_color']};
	}
	#header-navigation a, #header-navigation .search-area .live-search-results{
		color:{$colors['navigation_link_color']};
	}
	#header-navigation a:hover, #header-navigation .main-navigation .bigbazaar-main-menu > ul > li:hover > a, #header-navigation .main-navigation .bigbazaar-main-menu > ul > li.menu-item-has-children:hover > a, #header-navigation .main-navigation .bigbazaar-main-menu > ul > li.current-page-ancestor > a, #header-navigation .main-navigation .bigbazaar-main-menu > ul > li.current-menu-ancestor > a, #header-navigation .main-navigation .bigbazaar-main-menu > ul > li.current-menu-item > a, #header-navigation .main-navigation .bigbazaar-main-menu > ul > li.current_page_item > a{
		color:{$colors['navigation_link_hover_color']};
	}
	#header-navigation{
		border-top-width:{$colors['navigation_bar_border']['width']}px;
		border-top-style:{$colors['navigation_bar_border']['style']};
		border-top-color:{$colors['navigation_bar_border']['color']};
	}
	#header-navigation .main-navigation .bigbazaar-main-menu > ul > li{
		border-left-width:{$colors['navigation_bar_border']['width']}px;
		border-left-style:{$colors['navigation_bar_border']['style']};
		border-left-color:{$colors['navigation_bar_border']['color']};
	}
	#header-navigation .main-navigation .bigbazaar-main-menu > ul > li:last-child{
		border-right-width:{$colors['navigation_bar_border']['width']}px;
		border-right-style:{$colors['navigation_bar_border']['style']};
		border-right-color:{$colors['navigation_bar_border']['color']};
	}
	#header-navigation .category-menu .category-menu-title, #header-navigation .header-cart-content{
		background-color:{$colors['navigation_hover_color']};
	}
	
	/*
	* Menu color scheme
	*/
	.main-navigation .bigbazaar-main-menu .sub-menu, .main-navigation .bigbazaar-main-menu .bigbazaar-megamenu-wrapper{
		background-color:{$colors['menu_background_color']};
		color:{$colors['menu_text_color']};
	}
	.main-navigation .sub-menu li a, .main-navigation .bigbazaar-megamenu-wrapper li a{
		color:{$colors['menu_link_color']};
	}
	#header-navigation .main-navigation .bigbazaar-main-menu li.menu-item-has-children > .sub-menu > li:hover > a, .header-middle .main-navigation .bigbazaar-main-menu li.menu-item-has-children > .sub-menu > li:hover > a, .main-navigation .bigbazaar-main-menu .bigbazaar-megamenu-wrapper li a:hover, #header-navigation .main-navigation ul.sub-menu li.current-page-ancestor > a, #header-navigation .main-navigation ul.sub-menu li.current-menu-ancestor > a, #header-navigation .main-navigation ul.sub-menu li.current-menu-item > a, #header-navigation .main-navigation ul.sub-menu li.current_page_item > a, .header-middle .main-navigation ul.sub-menu li.current-page-ancestor > a, .header-middle .main-navigation ul.sub-menu li.current-menu-ancestor > a, .header-middle .main-navigation ul.sub-menu li.current-menu-item > a, .header-middle .main-navigation ul.sub-menu li.current_page_item > a{
		color:{$colors['menu_link_hover_color']};
		background-color:{$colors['menu_hover_color']};
	}
	.main-navigation .bigbazaar-main-menu .sub-menu li{
		border-bottom-width:{$colors['menu_border']['width']}px;
		border-bottom-style:{$colors['menu_border']['style']};
		border-bottom-color:{$colors['menu_border']['color']};
	}
	
	/*
	* footer color scheme
	*/
	.footer h2.widget-title, .footer-bottom .categories-list li.cate_title{
		color:{$colors['footer_header_color']};
	}
	.footer .footer-top, .footer .footer-middle, .footer .footer-bottom, .footer .widget .product-price{
		color:{$colors['footer_text_color']};
	}
	.footer, .footer a{
		color:{$colors['footer_link_color']};
	}
    .footer a:hover{
		color:{$colors['footer_hover_color']};
	}
	.footer .widget li a:before{
		border-left-color:{$colors['footer_link_color']};
	}
	.footer .widget li a:hover:before{
		border-left-color:{$colors['footer_hover_color']};
	}
	.footer .footer-top .container, .footer .widget ul.post-list-widget li, .footer .widget ul.product_list_widget li{
		border-bottom-width:{$colors['footer_border']['width']}px;
		border-bottom-style:{$colors['footer_border']['style']};
		border-bottom-color:{$colors['footer_border']['color']};
	}
	.footer .footer-bottom .container, .footer-copyright{
		border-top-width:{$colors['footer_border']['width']}px;
		border-top-style:{$colors['footer_border']['style']};
		border-top-color:{$colors['footer_border']['color']};
	}
	
	/*
	* Copyright color scheme
	*/
	.footer-copyright{
		background-color:{$colors['copyright_background_color']};
		color:{$colors['copyright_text_color']};
	}
	.footer-copyright a{
		color:{$colors['copyright_link_color']};
	}
	.footer-copyright a:hover{
		color:{$colors['copyright_hover_color']};
	}
	
	/*
	* Newsletter Color
	*/
	.newsletter-content.modal-content{
		background-color:{$colors['newsletter_background']};
		color:{$colors['newsletter_color']};
	}
	.newsletter-content .close, .newsletter-content .newsletter-text > h1{
		color:{$colors['newsletter_color']};
	}
	.newsletter-content .mc4wp-form-fields input[type='submit']{
		background-color:{$colors['newsletter_button_color']};
	}
	
	/*
	* General
	*/
	.product-items ul.products li.outofstock .product-entry{
		opacity:.{$colors['out_stock_opacity']};
	}
	
CSS;

	/*Theme RTL CSS*/
	$theme_css_rtl=<<<CSS
	
	/*
	* topbar color scheme
	*/	
	.topbar-right > span, .topbar-right .nav li, .header-topbar .social-link ul li:first-child a{
		border-right-width:{$colors['topbar_border']['width']}px;
		border-right-style:{$colors['topbar_border']['style']};
		border-right-color:{$colors['topbar_border']['color']};
	}
	.topbar-right > span:last-child, .topbar-right .nav li:last-child{
		border-left-width:{$colors['topbar_border']['width']}px;
		border-left-style:{$colors['topbar_border']['style']};
		border-left-color:{$colors['topbar_border']['color']};
	}
	
	/*
	* header color scheme
	*/
	.header-middle .search-control-group .search-categories{
		border-right-width:{$colors['header_border']['width']}px;
		border-right-style:{$colors['header_border']['style']};
		border-right-color:{$colors['header_border']['color']};
	}
	
	/*
	* navigation bar color scheme
	*/
	#header-navigation .search-control-group .search-categories{
		border-right-width:{$colors['navigation_bar_border']['width']}px;
		border-right-style:{$colors['navigation_bar_border']['style']};
		border-right-color:{$colors['navigation_bar_border']['color']};
	}
	
CSS;

	/*Custom Options*/
	if(bigbazaar_get_option('products_per_row_mobile', 1 )==1){
		$theme_css.='
		@media only screen and (max-width : 480px) {
			.product-items .products.grid-view li.type-product, .product-items .products.no-owl li.type-product{
				width:100%;
			}
		}';
	}
	
	if(is_rtl()){
		$theme_css.=$theme_css_rtl;
	}
	
	wp_add_inline_style( 'bigbazaar-style', $theme_css );
}
endif; // bigbazaar_theme_style 

function hook_javascript() {
	
	$output="<script>
		jQuery(document).ready(function($){";
	
		$output.=trim( bigbazaar_get_option('custom_js', '') );
	
	$output.="}); 
		</script>";	
	
	echo $output;
}
add_action('wp_footer','hook_javascript');  