<?php
/**
 * BigBazaar Include Customizer Function
 *
 * @package WordPress
 * @subpackage BigBazaar
 * @since BigBazaar 1.0
 */
 
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * Extras Functions
 */
require_once ( apply_filters('bigbazaar_file_url', BIGBAZAAR_INC . '/extras.php') );

/**
 * Theme options
 *
 * @since BigBazaar 1.0
 */
if ( bigbazaar_is_activated()) {
	require BIGBAZAAR_DIR . '/admin/index.php'; 
}

if ( is_admin() ) {
	/*
	* Check Verity Purchase Theme
	* ******************************************************************* */
	require_once( apply_filters('bigbazaar_file_url', BIGBAZAAR_LIB . '/verity-purchase.php') );
}

/**
 * Include mega menu
 *
 * @since BigBazaar 1.0
 */
require BIGBAZAAR_LIB . '/megamenu/mega-menus.php';

/**
 * Breadcrumbs
 *
 * @since BigBazaar 1.0
 */
require BIGBAZAAR_INC . '/breadcrumbs.php';

/**
 * Add metabox	
 *
 * @since BigBazaar 1.0
 */
require_once BIGBAZAAR_INC . '/meta-boxes.php';
require_once BIGBAZAAR_LIB . '/meta-box/meta-box.php';

/**
 * 
 Add admin custom sidebar widget area	
 *
 * @since BigBazaar 1.0
 */
require BIGBAZAAR_LIB . '/sidebar-generator.class.php';
new BIGBAZZAR_SIDEBAR();

require BIGBAZAAR_INC . '/plugin_activetion_class.php';

/**
 * WooCommerce Customizer
 *
 * @since BigBazaar 1.0
 */
require BIGBAZAAR_LIB . '/woocommerce.php';

/**
 * Enqueue scripts and styles.
 *
 * @since BigBazaar 1.0
 */
function bigbazaar_scripts() {
	
	// Add custom fonts, used in the main stylesheet.
	wp_enqueue_style( 'bigbazaar-fonts', bigbazaar_fonts_url(), array(), null );
	
	wp_enqueue_style( 'bigbazaar-plugins', BIGBAZAAR_CSS . '/plugins.css', array(), BIGBAZAAR_VERSION );
	
	/* if (is_rtl()) {
		wp_enqueue_style( 'bigbazaar-rtl', BIGBAZAAR_URI . '/rtl.css', array('bigbazaar-style'), BIGBAZAAR_VERSION );
	} */
	
	// Load our main stylesheet.
	wp_enqueue_style( 'bigbazaar-style', get_stylesheet_uri());
	
	// Load the Internet Explorer specific stylesheet.
	wp_enqueue_style( 'bigbazaar-ie', BIGBAZAAR_CSS . '/ie.css', array( 'bigbazaar-style' ), '' );
	wp_style_add_data( 'bigbazaar-ie', 'conditional', 'lt IE 9' );

	// Load the Internet Explorer 7 specific stylesheet.
	wp_enqueue_style( 'bigbazaar-ie7', BIGBAZAAR_CSS . '/ie7.css', array( 'bigbazaar-style' ), '' );
	wp_style_add_data( 'bigbazaar-ie7', 'conditional', 'lt IE 8' );
	
	//theme js load
	wp_enqueue_script( 'bigbazaar-plugins', BIGBAZAAR_JS . '/plugins.js', array( 'jquery' ), BIGBAZAAR_VERSION, true );
	
	wp_enqueue_script('masonry');
	
	$enable_live_search = ( bigbazaar_get_option('live_search','1') ==1) ? true : false;	
	if($enable_live_search){
		wp_enqueue_script( 'bigbazaar-autocomplete', BIGBAZAAR_JS . '/jquery.autocomplete.min.js', array( 'jquery' ), '', true );
	}
	
	if ( class_exists( 'WooCommerce' ) ) {
		wp_enqueue_script( 'wc-add-to-cart-variation' );
	}	
	wp_enqueue_script( 'bigbazaar-script', BIGBAZAAR_JS . '/functions.js', array( 'jquery' ), BIGBAZAAR_VERSION, true );
			
	$bigbazaar_settings = apply_filters( 'bigbazaar_localize_script_data', array(
		'rtl' 							=> is_rtl() ? true : false,
		'ajax_url' 						=> admin_url( 'admin-ajax.php' ),
		'enable_live_search'			=> $enable_live_search,
		'js_translate_text'				=> apply_filters( 'BIGBAZAAR_JS_text', array(
				'days_text'					=> esc_html__( 'Days', 'bigbazaar' ),
				'hours_text'				=> esc_html__( 'Hours', 'bigbazaar' ),
				'mins_text'					=> esc_html__( 'Mins', 'bigbazaar' ),
				'secs_text'					=> esc_html__( 'Secs', 'bigbazaar' ),
				'show_more'					=> esc_html__( '+ Show more', 'bigbazaar' ),
				'Show_less'					=> esc_html__( '- Show less', 'bigbazaar' ),
			) ),
		'add_to_cart_popup'				=> (bigbazaar_get_option('add_to_cart_popup', 1)) ? true : false,
		'enable_sticky_navigation' 		=> ( bigbazaar_get_option('sticky_navigation', 1) ) ? true : false,
		'enable_product_image_zoom'		=> (bigbazaar_get_option('enable_product_image_zoom', 1)) ? true : false,
		'widget_toggle'					=> (bigbazaar_get_option('enable_widget_toggle', 1)) ? true : false,
		'widget_menu_toggle'			=> (bigbazaar_get_option('enable_widget_menu_toggle', 1)) ? true : false,
		'widget_hide_max_limit_item' 	=> (bigbazaar_get_option('widget_items_hide_max_limit', 1)) ? true : false,
		'number_of_show_widget_items'	=> bigbazaar_get_option('number_of_show_widget_items', 8),
		'load_more_products' 			=> bigbazaar_get_option('load_more_products','default_pagination'),
		'products_per_row_mobile' 		=> bigbazaar_get_option('products_per_row_mobile',1),
		'touch_slider_mobile' 			=> bigbazaar_get_option('touch_slider_mobile',0),
		'sticky_sidebar' 				=> bigbazaar_get_option('sticky_sidebar',1),
	));
	wp_localize_script( 'bigbazaar-script', 'bigbazaar_options', $bigbazaar_settings );	
	
	//general ajax
	wp_localize_script( 'bigbazaar-script', 'myAjax', array( 'ajaxurl' => admin_url( 'admin-ajax.php' ) ) );
	
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'bigbazaar_scripts' );


if ( ! function_exists( 'bigbazaar_admin_scripts' ) ) {
	function bigbazaar_admin_scripts() {		
		//Admin css
		wp_enqueue_style('bigbazaar_admin_css',BIGBAZAAR_CSS .'/bigbazaar_admin.css');
		wp_enqueue_style( 'Font-Awesome', BIGBAZAAR_CSS . '/font-awesome.min.css', array(), '3.2' );
		
		//Admin js
		wp_enqueue_script( 'bigbazaar_admin_js' , BIGBAZAAR_JS . '/admin.js', array( 'jquery' ), '', true );
	}
}
add_action('admin_enqueue_scripts', 'bigbazaar_admin_scripts');

/**
 * Load custom js in footer
 * @since 1.0.0
 * @return void
 */
function bigbazaar_owl_footer() {
	global $owlparam;
	wp_localize_script( 'bigbazaar-script', 'bigbazaarOwlArg', $owlparam );
}
add_action( 'wp_footer', 'bigbazaar_owl_footer' );

/*
* custome theme fucntion 
*/


/* 	Topbar Customer support
/* --------------------------------------------------------------------- */
if ( ! function_exists( 'bigbazaar_customer_support' ) ):
	function bigbazaar_customer_support()
	{
		if(bigbazaar_get_option('show_topbar_email', 1) ==1 || bigbazaar_get_option('show_topbar_number', 1) ==1):?>
			<div class="customer-support">
				<?php if(bigbazaar_get_option('show_topbar_email', 1) ==1):?>
				<div class="customer-support-email"><i class="fa fa-envelope"></i><span><?php echo esc_attr(bigbazaar_get_option('topbar_email','info@company.com'));?></span></div>
				<?php endif;
				if(bigbazaar_get_option('show_topbar_number', 1) ==1):?>
				<div class="customer-support-call"><i class="fa fa-phone"></i><span><?php echo esc_attr(bigbazaar_get_option('topbar_number','+81 59832452528'));?></span></div>
				<?php endif;?>
			</div>
		<?php endif;?>
	<?php }
endif;

/* 	Topbar notification
/* --------------------------------------------------------------------- */
if ( ! function_exists( 'bigbazaar_topbar_notification' ) ):
	function bigbazaar_topbar_notification(){
		
		if(!bigbazaar_get_option('show_topbar_news', 1)) return;?>
		
			<div class="topbar-notification">
				<div class="news-title">
					<i class="fa fa-rss"></i>
					<span><?php esc_html_e('News','bigbazaar');?></span>
				</div>
				<div class="news-text">
					<marquee behavior="scroll" direction="left"><span class="break-new"><?php echo bigbazaar_get_option("topbar_news","<a href='#'>Super Sale 50%</a><a href='#'>Big Promotion on Valentine days</a><a href='#'>Gift 15 Voucher for</a>");?> </span></marquee>
				</div>
			</div>
	<?php }
endif;

/* 	Topbar Social link
/* --------------------------------------------------------------------- */
if ( ! function_exists( 'bigbazaar_social_link' ) ):
	function bigbazaar_social_link(){
		
		if(!bigbazaar_get_option('show_topbar_social_link', 1)) return;?>		
		<ul class="social-link">
			<?php if(bigbazaar_get_option('facebook_link') !=''):?>
				<li class="icon-facebook"><a href="<?php echo esc_url(bigbazaar_get_option('facebook_link'));?>"><i class="fa fa-facebook"></i></a></li>
			<?php endif;?>
			<?php if(bigbazaar_get_option('twitter_link') !=''):?>
				<li class="icon-twitter"><a href="<?php echo esc_url(bigbazaar_get_option('twitter_link'));?>"><i class="fa fa-twitter"></i></a></li>
			<?php endif;?>
			<?php if(bigbazaar_get_option('linkedin_link') !=''):?>
				<li class="icon-linkedin"><a href="<?php echo esc_url(bigbazaar_get_option('linkedin_link'));?>"><i class="fa fa-linkedin"></i></a></li>
			<?php endif;?>
			<?php if(bigbazaar_get_option('instagram_link') !=''):?>
				<li class="icon-instagram"><a href="<?php echo esc_url(bigbazaar_get_option('instagram_link'));?>"><i class="fa fa-instagram"></i></a></li>
			<?php endif;?>
			<?php if(bigbazaar_get_option('flickr_link') !=''):?>
				<li class="icon-google-plus"><a href="<?php echo esc_url(bigbazaar_get_option('flickr_link'));?>"><i class="fa fa-google-plus"></i></a></li>
			<?php endif;?>
			<?php if(bigbazaar_get_option('google_plus_link') !=''):?>
				<li class="icon-flickr"><a href="<?php echo esc_url(bigbazaar_get_option('google_plus_link'));?>"><i class="fa fa-flickr"></i></a></li>
			<?php endif;?>
			<?php if(bigbazaar_get_option('rss_link') !=''):?>
				<li class="icon-rss"><a href="<?php echo esc_url(bigbazaar_get_option('rss_link'));?>"><i class="fa fa-rss"></i></a></li>
			<?php endif;?>
			<?php if(bigbazaar_get_option('pinterest_link') !=''):?>
				<li class="icon-pinterest"><a href="<?php echo esc_url(bigbazaar_get_option('pinterest_link'));?>"><i class="fa fa-pinterest"></i></a></li>
			<?php endif;?>
		</ul>
	<?php }
endif;

/* 	Topbar Welcome Message
/* --------------------------------------------------------------------- */
if ( ! function_exists( 'bigbazaar_welcome_message' ) ):
	function bigbazaar_welcome_message(){
		
		if(!bigbazaar_get_option('show_topbar_welcome_message', 0)) return;?>
		
		<span class="topbar-welcome-message">
			<span class="welcome-message-text"><?php echo bigbazaar_get_option("topbar_welcome_message","Welcome to my Shop");?> </span>
		</span>
	<?php }
endif;

/* 	Topbar user login
/* --------------------------------------------------------------------- */
if ( ! function_exists( 'bigbazaar_login_topbar' ) ):
	function bigbazaar_login_topbar(){
		$myaccount_url = get_permalink(get_option( 'woocommerce_myaccount_page_id' ));	?>
		<span class="user-login <?php echo (bigbazaar_get_option('show_login_register_popup',1) && !is_user_logged_in()) ? 'enable' : '';?>">
			<?php
			if(!is_user_logged_in()):?>
				<a href="<?php echo esc_url($myaccount_url);?>"><i class="fa fa-lock"></i><span><?php esc_html_e('Login/Register','bigbazaar');?></span></a>
			<?php else:?>
				<a href="<?php echo esc_url(wp_logout_url(get_permalink()));?>"><i class="fa fa-unlock"></i><span><?php esc_html_e('Logout','bigbazaar');?></span></a>
			<?php endif;?>
		</span>
	<?php }
endif;

/* 	Topbar woocommerce myaccount
/* --------------------------------------------------------------------- */
if ( ! function_exists( 'bigbazaar_wcaccount_topbar' ) ):
	function bigbazaar_wcaccount_topbar()	{
		
		if(!is_woocommerce_activated()) return false;
		
		global $woocommerce;
		$myaccount_page_url = get_permalink( get_option('woocommerce_myaccount_page_id') );
		$cart_url = wc_get_cart_url();
		$checkout_url = wc_get_checkout_url();	?>
		<span class="wcaccount-topbar">			
			<a href="<?php echo get_permalink(wc_get_page_id( 'myaccount' ));?>"><i class="fa fa-user"></i><span><?php esc_html_e('My Account','bigbazaar');?> </span><i class="fa fa-caret-down"></i></a>			
			<ul class="wcaccount-dropdown">
				<li><a href="<?php echo esc_url($checkout_url);?>"><i class="fa fa-check-square-o"></i><span><?php esc_html_e('Checkout','bigbazaar');?></span></a></li>
				<li><a href="<?php echo esc_url($cart_url);?>"><i class="fa fa-shopping-cart"></i><span><?php esc_html_e('Cart','bigbazaar');?></span></a></li>				
				<?php if( function_exists( 'YITH_WCWL' ) ):
					$wishlist_url = YITH_WCWL()->get_wishlist_url(); ?>
					<li class=""><a href="<?php echo esc_url($wishlist_url);?>"><i class="fa fa-heart"></i><span><?php esc_html_e('My Wishlist','bigbazaar');?></span></a></li>
				<?php endif; ?>				
				<?php if(defined( 'YITH_WOOCOMPARE' )): 
					global $yith_woocompare; 
					$product_count = count($yith_woocompare->obj->products_list); ?>
					<li><a href="#" class="yith-woocompare-open"><i class="fa fa-refresh"></i><span><?php esc_html_e( "Compare", 'bigbazaar') ?></span></a></li>
				<?php endif; ?>
				<?php if(is_user_logged_in()):?>
					<li><a href="<?php echo esc_url(wp_logout_url(get_permalink()));?>"><i class="fa fa-unlock"></i><span><?php esc_html_e('sign Out','bigbazaar');?></span></a></li>
				<?php endif;?>
			</ul>
		</span>
	<?php }
endif;

/* 	Header Middle myaccount
/* --------------------------------------------------------------------- */
if ( ! function_exists( 'bigbazaar_wcaccount_header_middle' ) ):

	function bigbazaar_wcaccount_header_middle(){
		
		if(!is_woocommerce_activated()) return false;
		
		$checkout_url = wc_get_checkout_url();	?>
		<div class="header-middle-wcaccount">			
			<ul class="wcaccount">
				<li><a href="<?php echo get_permalink(wc_get_page_id( 'myaccount' ));?>"><i class="fa fa-user"></i><span><?php _e('My Account','bigbazaar');?></span></a></li>			
				<li><a href="<?php echo esc_url($checkout_url);?>"><i class="fa fa-check-square-o"></i><span><?php _e('Checkout','bigbazaar');?></span></a></li>			
			</ul>			
		</div>		
	<?php }
endif;

/* 	Topbar currency
/* --------------------------------------------------------------------- */
if ( ! function_exists( 'bigbazaar_currency_topbar' ) ):
	function bigbazaar_currency_topbar(){
		
		if(!bigbazaar_get_option('show_currency_switcher',1)) return;
		
		if (class_exists('woocommerce_wpml')) { ?>
			<div class="currency-topbar">
				<?php echo(do_shortcode('[currency_switcher]')); ?>
			</div>
		<?php }
	}
endif;

/* 	Topbar language
/* --------------------------------------------------------------------- */
if ( ! function_exists( 'bigbazaar_language_topbar' ) ):
	function bigbazaar_language_topbar(){
		
		if(!bigbazaar_get_option('show_language_switcher',1)) return;
		
		if (class_exists('SitePress')) {?>
			<div class="language-topbar">
				<?php do_action('wpml_add_language_selector'); ?>
			</div>
		<?php }
	}
endif;

/* 	Header Services
/* --------------------------------------------------------------------- */
if ( ! function_exists( 'bigbazaar_header_services' ) ):
	function bigbazaar_header_services(){?>
	
		<div class="header-services">
			<div class="box-service">
				<span class="icon-service">
					<i class="fa <?php echo bigbazaar_get_option('service_icon1', 'fa-phone'); ?>"> </i>
				</span>
				<div class="content-service">
					<h6><?php echo bigbazaar_get_option('service_title1', '08 143 456 753');?></h6>
					<span><?php echo bigbazaar_get_option('service_des1', 'lorem ipsum dolor.');?></span>
				</div>
			</div>
			<div class="box-service">
				<span class="icon-service">
					<i class="fa <?php echo bigbazaar_get_option('service_icon2', 'fa-truck');?> "> </i>
				</span>
				<div class="content-service">
					<h6><?php echo bigbazaar_get_option('service_title2', esc_html__('Free Shipping','bigbazaar'));?></h6>
					<span><?php echo bigbazaar_get_option('service_des2', esc_html__('all order over $100.','bigbazaar'));?></span>
				</div>
			</div>
			<div class="box-service">
				<span class="icon-service">
					<i class="fa <?php echo bigbazaar_get_option('service_icon3', 'fa-refresh'); ?>"> </i>
				</span>
				<div class="content-service">
					<h6><?php echo bigbazaar_get_option('service_title3', esc_html__('Free Shipping','bigbazaar'));?></h6>
					<span><?php echo bigbazaar_get_option('service_des3', esc_html__('Return & Exchange','bigbazaar'));?></span>
				</div>
			</div>
		</div>
	<?php }
endif;

/* 	Header logo
/* --------------------------------------------------------------------- */
if ( ! function_exists( 'bigbazaar_header_logo' ) ):
	function bigbazaar_header_logo(){?>
		<div class="header-logo">			
			<a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"> <img src="<?php echo esc_url(bigbazaar_get_option('header_logo', BIGBAZAAR_IMAGES.'/logo.png'));?>" alt="logo"></a>			
		</div>
	<?php }
endif;

/* 	Header cart
/* --------------------------------------------------------------------- */
if ( ! function_exists( 'bigbazaar_header_cart' ) ):
	function bigbazaar_header_cart(){
		
		if ( !class_exists( 'WooCommerce' ) || !bigbazaar_get_option('show_header_cart',1)) return;
		
		global $woocommerce;
		$myaccount_page_url = get_permalink( get_option('woocommerce_myaccount_page_id') );
		$cart_url = wc_get_cart_url();
		$checkout_url = wc_get_checkout_url();?>
		<div class="header-cart-content">
			<div class="heading-cart">
				<a class="cart-contents" href="<?php echo esc_url($cart_url); ?>">
					<h6><?php _e('Shopping Cart','bigbazaar');?></h6>
					<span><?php echo sprintf(_n('%d item', '%d item(s)', $woocommerce->cart->cart_contents_count, 'woocommerce'), $woocommerce->cart->cart_contents_count);?> - <?php echo $woocommerce->cart->get_cart_total(); ?></span>
				</a>
			</div>			
			<div class="cart-product-list woocommerce">
				<?php woocommerce_mini_cart();?>
			</div>
		</div>
	<?php 
	}
endif;

/* 	Header My Account
/* --------------------------------------------------------------------- */
if ( ! function_exists( 'bigbazaar_header_myaccount' ) ):
	function bigbazaar_header_myaccount(){
		if(!is_woocommerce_activated()):
			return false;
		endif;
		
		echo '<span class="header-myaccount"> <a href="'.get_permalink(wc_get_page_id( 'myaccount' )) .'">' . '<i class="fa fa-user"></i>' . '<span class="header-myaccount-text">' . esc_html__( 'My Account', 'bigbazaar' ) . '</span></a> </span>';
	}
endif;

/* 	Header Wishlist
/* --------------------------------------------------------------------- */
if ( ! function_exists( 'bigbazaar_header_wishlist' ) ):
	function bigbazaar_header_wishlist(){
		
		if(!bigbazaar_get_option('show_header_wishlist', 1)) return; 
		
		if( function_exists( 'YITH_WCWL' ) ):
			$wishlist_url = YITH_WCWL()->get_wishlist_url(); ?>
			<span class="header-wishlist">
				<a href="<?php echo esc_url($wishlist_url);?>">
					<i class="fa fa-heart"></i>
					<span class="header-wishlist-text"><?php esc_html_e('Wishlist','bigbazaar');?></span>
				</a>
			</span>
		<?php endif;
	}
endif;

/* 	BigBazaar Campare
/* --------------------------------------------------------------------- */
if ( ! function_exists( 'bigbazaar_header_campare' ) ){
	function bigbazaar_header_campare(){
		
		if(!bigbazaar_get_option('show_header_campare', 1)) return;
				
		if(defined( 'YITH_WOOCOMPARE' )): 
			global $yith_woocompare; 
			$product_count = count($yith_woocompare->obj->products_list); ?>
			<span class="header-compare">
				<a href="#" class="yith-woocompare-open">
					<i class="fa fa-refresh"></i>
					<span class="header-compare-text"><?php esc_html_e( "Compare", 'bigbazaar') ?></span>
				</a>
			</span>
		<?php endif;
	}
}

/* 	BigBazaar Checkout
/* --------------------------------------------------------------------- */
if ( ! function_exists( 'bigbazaar_header_checkout' ) ):
	function bigbazaar_header_checkout(){
		
		if(!is_woocommerce_activated()) return false;
		
		$checkout_url = wc_get_checkout_url();?>
		<span class="header-checkout">
			<a href="<?php echo esc_url($checkout_url);?>">
				<i class="fa fa-check-square-o"></i>
				<span class="header-checkout-text"><?php esc_html_e('Checkout','bigbazaar');?></span>
			</a>
		</span><?php
	}
endif;

/* 	Header menu
/* --------------------------------------------------------------------- */
if ( ! function_exists( 'bigbazaar_header_menu' ) ):
	function bigbazaar_header_menu(){?>
		<div class="main-navigation" role="navigation">
			<?php wp_nav_menu( array( 'theme_location' 	=> 'primary',
									'menu_id' 			=> 'main-navigation',
									'menu_class'      	=> 'bigbazaar-horizontal-menu',
									'container_class'	=> 'bigbazaar-main-menu',
									'fallback_cb' 		=> 'BigBazaarFrontendWalker::fallback',
									'walker' 			=> new BigBazaarFrontendWalker(),
							  ) ); ?>
		</div>
	<?php }
endif;

/* 	Header Mobile menu
 *
 * @since BigBazaar 2.0
/* --------------------------------------------------------------------- */
if ( ! function_exists( 'bigbazaar_header_mobile_menu' ) ):
	function bigbazaar_header_mobile_menu(){
		
		if( function_exists( 'bigbazaar_products_live_search_form' ) ) {
			bigbazaar_products_live_search_form( $arg="product_cat2" );
		}?>
		
		<div class="mobile-nav-tabs">
			<ul>
				<?php if ( has_nav_menu( 'primary' ) ) {?>
					<li class="primary-menu active" data-menu="primary"><span><?php esc_html_e('Menu','bigbazaar');?></span></li>
				<?php }?>
				<?php if ( bigbazaar_get_option('show-categories-menu', 1) && has_nav_menu( 'vertical_menu' ) ) {?>
					<li class=" categories-menu" data-menu="vertical"><span><?php esc_html_e('Categories','bigbazaar');?></span></li>
				<?php }?>
			</ul>
		</div>
		
		<?php if ( has_nav_menu( 'primary' ) ) {					
			wp_nav_menu( array( 'theme_location' 	=> 'primary',
				'menu_class'      	=> 'mobile-main-menu',
				'container_class'	=> 'mobile-primary-menu mobile-nav-content active',
			) ); 			
		}
	
		if ( bigbazaar_get_option('show-categories-menu', 1) && has_nav_menu( 'vertical_menu' ) ) {
			wp_nav_menu( array( 'theme_location' 	=> 'vertical_menu',
				'menu_class'      	=> 'mobile-main-menu',
				'container_class'	=> 'mobile-vertical-menu mobile-nav-content',
			) );
		}?>	
		
		<div class="mobile-topbar-wrapper">
			<?php if( function_exists( 'bigbazaar_header_myaccount' ) ) {
				bigbazaar_header_myaccount();
			}
			if( function_exists( 'bigbazaar_header_checkout' ) ) {
				bigbazaar_header_checkout();
			}
			if( function_exists( 'bigbazaar_header_wishlist' ) ) {
				bigbazaar_header_wishlist();
			}
			if( function_exists( 'bigbazaar_header_campare' ) ) {
				bigbazaar_header_campare();
			}				
			if( function_exists( 'bigbazaar_login_topbar' ) ) {
				bigbazaar_login_topbar();
			}			
			if( function_exists( 'bigbazaar_currency_topbar' ) ) {
				bigbazaar_currency_topbar();
			}
			if( function_exists( 'bigbazaar_language_topbar' ) ) {
				bigbazaar_language_topbar();
			}?>
		</div>
		<div class="mobile-topbar-social">
			<?php if( function_exists( 'bigbazaar_social_link' ) ) {
				bigbazaar_social_link();
			}?>
		</div>
		
	<?php }
endif;

/* 	Header Mobile Toggle Bar Icon
 *
 * @since BigBazaar 2.0
/* --------------------------------------------------------------------- */
if ( ! function_exists( 'bigbazaar_header_mobile_toggle' ) ):
	function bigbazaar_header_mobile_toggle(){?>
		<div class="navbar-toggle">
			<span class="sr-only"><?php esc_html_e('Menu', 'bigbazaar'); ?></span>
			<span class="icon-bar"></span>
			<span class="icon-bar"></span>
			<span class="icon-bar"></span>
		</div>
	<?php }
endif;

/* 	Header Category/Vertical menu
/* --------------------------------------------------------------------- */
if ( ! function_exists( 'bigbazaar_category_menu' ) ):
	function bigbazaar_category_menu($title=null){ ?>
		<?php if ( has_nav_menu( 'vertical_menu' ) ) {?>
			<div class="category-menu">
				<div class="category-menu-title">
					<h4><?php echo ($title !=null) ? esc_attr($title) : bigbazaar_get_option('shopping_categories_text','Shopping Categories');?></h4>
					<span class="down-up"><i class="fa fa-list"></i></span>
				</div>
				<div class="categories-list">
				<?php wp_nav_menu( array( 'theme_location' 	=> 'vertical_menu',
										'menu_class'      	=> 'bigbazaar-vertical-menu',
										'container_class'	=> 'bigbazaar-main-menu',
										'fallback_cb' 		=> 'BigBazaarFrontendWalker::fallback',
										'walker' 			=> new BigBazaarFrontendWalker(),
								  ) ); ?>
				</div>
			</div>
		<?php }?>
	<?php }
endif;

/* 	Sub Categories
/* --------------------------------------------------------------------- */
if ( ! function_exists( 'bigbazaar_sub_category' ) ):
	function bigbazaar_sub_category()
	{
		$categories = get_categories( array( 'parent' => $parent_arg , 'hide_empty' => 1, 'taxonomy' => 'product_cat' ) ); 
	}
endif;

/* 	Page / Post colunm class
/* --------------------------------------------------------------------- */
if ( !function_exists('getColumnClass')) {
	function getColumnClass($sidebar_position)
	{
		if(isset($sidebar_position) && $sidebar_position == 'none'):
			$column_classs="col-md-12";
		elseif(isset($sidebar_position) && $sidebar_position=='left'):
			if(is_rtl()){
				$column_classs="col-xs-12 col-sm-8 col-md-9 col-md-pull-3";
			}else{
					$column_classs="col-xs-12 col-sm-8 col-md-9 col-md-push-3";
			}
		else:
			$column_classs="col-xs-12 col-sm-8 col-md-9";
		endif;
		
		return $column_classs;
	}
}

/* 	Blog style of custom template
/* --------------------------------------------------------------------- */
if ( !function_exists('getBlogStyle')) {
	function getBlogStyle($blog_style, $blog_grid_column)
	{
		if(isset($blog_style) && $blog_style=="masonry_grid" && isset($blog_grid_column))
		{
			$blog_style='grid_'.$blog_grid_column.'_column';
		}
		return (isset($blog_style)) ? $blog_style : "large_image";
	}
}

/* 	Sidebar position
/* --------------------------------------------------------------------- */
if ( !function_exists('getSidebarPosition')) {
	function getSidebarPosition($sidebar_position)
	{
		return (isset($sidebar_position) && $sidebar_position !='') ? $sidebar_position : "right";
	}
}

/* 	Sidebar Widget
/* --------------------------------------------------------------------- */
if ( !function_exists('getSidebarWidget')) {
	function getSidebarWidget($sidebar_widget)
	{
		return (isset($sidebar_widget) && $sidebar_widget !='') ? $sidebar_widget : "sidebar-1";
	}
}

/* 	Show Breadcrumb
/* --------------------------------------------------------------------- */
if ( !function_exists('getShowBreadsrumb')) {
	function getShowBreadsrumb($show_breadsrumb)
	{
		return (isset($show_breadsrumb) && $show_breadsrumb !='') ? $show_breadsrumb : "yes";
	}
}

/* 	Sidebar Widget
/* --------------------------------------------------------------------- */
if ( !function_exists('getShowTitle')) {
	function getShowTitle($show_title)
	{
		return (isset($show_title) && $show_title !='') ? $show_title : "yes";
	}
}

/* 	Portfolio style of custom template
/* --------------------------------------------------------------------- */

if ( !function_exists('getPortfolioStyle')) {
	function getPortfolioStyle($grid_column)
	{		
		if(isset($grid_column)):
			$grid_column='portfolio_'.$grid_column.'_column';	
		else:
			$grid_column='portfolio_two_column';
		endif;
		return $grid_column;
	}
}

/* 	Get post thumbnail
/* --------------------------------------------------------------------- */
if ( !function_exists('bigbazaar_get_post_thumbnail')) {
	function bigbazaar_get_post_thumbnail($image_size){
		$prefix = 'bb_';
		switch(get_post_format()) {
			
			case 'image' :
					$attachment_id=get_post_meta ( get_the_ID(), $prefix .'post_format_image', true )  ;
					if ( is_singular() ) : ?>
						<div class="post-thumbnail">
							<?php if(wp_get_attachment_url( $attachment_id )) :
								 //the_post_thumbnail('blog-large');
								 echo wp_get_attachment_image( $attachment_id, 'large' );
							else:?>
								<img src="<?php echo esc_url(BIGBAZAAR_URI.'/images/blog-placeholder.jpg');?>"/>
							<?php endif;?>
						</div><!-- .post-thumbnail -->

						<?php else : ?>
						
						<div class="entry-thumbnail">
							<a class="post-thumbnail" href="<?php the_permalink(); ?>" aria-hidden="true">
								<?php if(wp_get_attachment_url( $attachment_id )) :
									echo wp_get_attachment_image( $attachment_id, $image_size );
								else:?>
									<img src="<?php echo esc_url(BIGBAZAAR_URI.'/images/blog-placeholder.jpg');?>"/>
								<?php endif;?>
							</a>							
						</div>
					<?php endif; // End is_singular()
					break;			
			case 'gallery' :
					$attachment_ids=get_post_meta ( get_the_ID(), $prefix .'post_format_gallery' )  ;
					$output = '';
					if (!empty($attachment_ids) && is_array($attachment_ids)) {
						$output .= "<div class='post-slider entry-media owl-carousel'>";
						foreach ($attachment_ids as $attachment_id) {
							if (is_single()) {
								$output .= "<div class='item'>";
									$output.= wp_get_attachment_image( $attachment_id, 'large' );
							$output .= "</div>";
							} else {
								$output .= "<div class='item'>";
								$output .= '<a data-group="entry-'. esc_attr(get_the_ID()) .'" class="single-image" href="'. get_permalink(get_the_ID()) .'">';
									$output.= wp_get_attachment_image( $attachment_id,  $image_size );
								$output .= '</a>';
							$output .= "</div>";
							}				
						}
						$output .= "</div>";
						echo $output;
					}
					break;
			case 'video' :
						$video_url_embed=get_post_meta ( get_the_ID(), $prefix .'post_format_video', true ) ;
						$video_url_embed = preg_replace( '|^\s*(https?://[^\s"]+)\s*$|im', "[embed]$1[/embed]", strip_tags($video_url_embed));
						preg_match("!\[embed.+?\]|\[video.+?\]!", $video_url_embed, $match_video);
						$output = '';
						if (!empty($match_video)) {
							global $wp_embed;

							$image_size = get_image_size($image_size);
							$video = $match_video[0];
							$video = str_replace('[embed]', '[embed width="'. $image_size['width'] .'" height="'. $image_size['height'] .'"]', $video);

							$output = "<div class='entry-media'>";
								$output .= do_shortcode($wp_embed->run_shortcode($video));
							$output .= "</div>";
						}
						echo $output;
					break;
					
			case 'audio' :
					$audio_url_embed=get_post_meta ( get_the_ID(), $prefix .'post_format_audio', true ) ;
					$output = '';					
					$audio_url_embed = preg_replace( '|^\s*(http?://[^\s"]+)\s*$|im', "[audio src='$1']", strip_tags($audio_url_embed ) );
					preg_match("!\[audio.+?\]!", $audio_url_embed, $match_audio);
					preg_match("!\[embed.+?\]!", $audio_url_embed, $match_embed);

					if (!empty($match_embed) && strpos($match_embed[0], 'soundcloud.com') !== false) {
						global $wp_embed;
						$image_size = get_image_size($image_size);
						$embed = $match_embed[0];
						$embed = str_replace('[embed]', '[embed width="'. $image_size['width'] .'" height="250"]', $embed);

						$output = "<div class='entry-media'>";
							$output .= $wp_embed->run_shortcode($embed);
						$output .= "</div>";
						
					} else if (!empty($match_audio)) {
						$output = "<div class='entry-media'>";
							$output .= do_shortcode($match_audio[0]);
						$output .= "</div>";
					}
					echo $output;
		
					break;
					
			case 'link' :
					$link_url=get_post_meta ( get_the_ID(), $prefix .'post_format_link_url', true ) ;
					$link_text=get_post_meta ( get_the_ID(), $prefix .'post_format_link_text', true ) ;
					$output = '';
					if(isset($link_url) && $link_url != ''):
						$output = '<div class="entry-media">';
							$output .= '<div class="post-link">';
								$output .= '<a href="'.$link_url.'" alt="'.$link_text.'">'.$link_text.'</a>';
							$output .= '</div>';
						$output .= '</div>';
					endif;
					echo $output;
					break;
					
			case 'quote' :	
					$quote=get_post_meta ( get_the_ID(), $prefix .'post_format_quote', true ) ;
					$quote_author=get_post_meta ( get_the_ID(), $prefix .'post_format_quote_author', true ) ;
					$quote_author_url=get_post_meta ( get_the_ID(), $prefix .'post_format_quote_author_url', true ) ;
					$output = '';
					if(isset($quote) && $quote !=''):
						$output = '<div class="entry-media">';
							$output .= '<blockquote>';
								$output .= $quote;
								$output .='<br><a href="'.$quote_author_url.'" alt="'.$quote_author.'">'.$quote_author.'</a>';
							$output .= '</blockquote>';
						$output .= '</div>';
					endif;
					echo $output;					
					break;
			default:
				if( $image_size== 'medium' ):
					bigbazaar_small_post_thumbnail();
				else:
					bigbazaar_post_thumbnail();
				 endif;
				 
				 break;				 
		}		
	}
}

// Add SoundCloud oEmbed
function add_oembed_soundcloud(){
	wp_oembed_add_provider( 'http://soundcloud.com/*', 'http://soundcloud.com/oembed' );
}
add_action('init','add_oembed_soundcloud');

/* 	Get related post
/* --------------------------------------------------------------------- */
if ( !function_exists('getRelatedPosts')) {
	function getRelatedPosts($post_id) {
	
		$args = '';
	
		$item_cats = get_the_terms($post_id, 'category');
		if ($item_cats) :
			foreach($item_cats as $item_cat) {
				$item_array[] = $item_cat->term_id;
			}
		endif;
		
		if(empty($item_array)){
			$item_array[]=0;
		}
		
		$args = wp_parse_args($args, array(
			'showposts' => '10',
			'post__not_in' => array($post_id),
			'ignore_sticky_posts' => 0,
			'post_type' => 'post',
			'tax_query' => array(
				array(
					'taxonomy' => 'category',
					'field' => 'id',
					'terms' => $item_array
				)
			),
			'orderby' => 'DESC'
		));
	
		$query = new WP_Query($args);
		
		return $query;
	}
}

/* 	Get related portfolio
/* --------------------------------------------------------------------- */
if ( !function_exists('getRelatedPortfolios')) {
	function getRelatedPortfolios($post_id) {
	
		$args = '';
	
		$item_cats = get_the_terms($post_id, 'portfolio_cat');
		if ($item_cats) :
			foreach($item_cats as $item_cat) {
				$item_array[] = $item_cat->term_id;
			}
		endif;
		
		if(empty($item_array)){
			$item_array[]=0;
		}
		
		$args = wp_parse_args($args, array(
			'showposts' => '10',
			'post__not_in' => array($post_id),
			'ignore_sticky_posts' => 0,
			'post_type' => 'portfolio',
			'tax_query' => array(
				array(
					'taxonomy' => 'portfolio_cat',
					'field' => 'id',
					'terms' => $item_array
				)
			),
			'orderby' => 'DESC'
		));
	
		$query = new WP_Query($args);

		return $query;
	}
}

// Remove that filter again
add_filter( 'max_srcset_image_width', create_function( '', 'return 1;' ) );

/* 	get post image size
/* ---------------------------------------------------------------------- */
if (!function_exists('get_image_size')) {

	function get_image_size( $image_type ) {
		
		if($image_type=='medium'){
			$image_size=array('width'=>'463', 'height'=>'348', 'image_type'=>$image_type);
		}elseif($image_type=='large'){
			$image_size=array('width'=>'870', 'height'=>'510', 'image_type'=>$image_type);
		}
		return $image_size;
	}
}

/* 	Post Comment structure
/* --------------------------------------------------------------------- */
if ( !function_exists('bigbazaar_comment')) {
	function bigbazaar_comment($comment, $args, $depth) {
		$GLOBALS['comment'] = $comment; ?>

		<li <?php comment_class(); ?> id="comment-<?php comment_ID(); ?>">
            <article id="div-comment-<?php comment_ID(); ?>" class="comment-body clearfix">
				<div class="comment-avatar"><?php echo get_avatar($comment, 70); ?></div>
                <div class="comment-area-wrap">
                    <div class="comment-meta">
                        <b class="comment-author"><?php echo get_comment_author_link() ?></b>
                        <span class="comment-date"> <?php printf(__('%1$s', 'bigbazaar'), get_comment_date()) ?></span>
                        <?php echo get_comment_reply_link(array_merge(
                            array('reply_text' => __('Reply', 'bigbazaar')),
                            array('depth' => $depth, 'max_depth' => $args['max_depth'])
                        ));
                        ?>
                    </div><!--/ .comment-meta-->
                    <div class="comment-content"><?php comment_text(); ?></div>
                </div>
			</article><!--/ .comment-wrap-->
		</li>
	<?php
	}
}

/* 	Post navigation
/* --------------------------------------------------------------------- */
if ( !function_exists('bigbazaar_post_navigation')) {
	function bigbazaar_post_navigation($atts, $content = null){
		$next_post = get_next_post();
		$prev_post = get_previous_post();
			if(!empty($prev_post) || !empty($next_post)):
		?>
			<div class="navigation" role="navigation">
				<h4><?php _e('Post navigation','bigbazaar');?></h4>
				<div class="post-navigation">
					<div class="nav-links">
					<?php if(!empty($prev_post)) : ?>
						<div class="nav-previous">
							<a href="<?php echo get_permalink($prev_post->ID); ?>" ><span class="meta-nav">&laquo; <?php echo get_the_title($prev_post->ID); ?></span></a>
							<div class="post-nav-thumb">
								<?php echo get_the_post_thumbnail( $prev_post->ID, 'thumbnail'); ?>
							</div>
						</div>
					<?php endif; ?>
					<?php if(!empty($next_post)) : ?>
						<div class="nav-next">
							<a href="<?php echo get_permalink($next_post->ID); ?>"><span class="meta-nav"><?php echo get_the_title($next_post->ID); ?>  &raquo;</span></a>
							<div class="post-nav-thumb">
								<?php echo get_the_post_thumbnail( $next_post->ID,'thumbnail' ); ?>
							</div>
						</div>
					<?php endif; ?>
					</div>
				</div>
			</div>
		<?php
		endif;
	}
}

/* 	header post navigation
/* --------------------------------------------------------------------- */
if ( !function_exists('bigbazaar_header_post_navigation')) {
	function bigbazaar_header_post_navigation($atts, $content = null){
		$next_post = get_next_post();
		$prev_post = get_previous_post();
			if(!empty($prev_post) || !empty($next_post)):
		?>
			<div class="header-post-navigation hidden-xs" role="navigation">
				<div class="navigation">
					<ul class="nav-links">
					<?php if(!empty($prev_post)) : ?>
						<li class="nav-previous">
							<a href="<?php echo get_permalink($prev_post->ID); ?>" ><?php echo get_the_title($prev_post->ID); ?></a>
							<div class="post-nav-thumb">
								<?php echo get_the_post_thumbnail( $prev_post->ID, 'thumbnail'); ?>
							</div>
						</li>
					<?php endif; ?>
						<li class="archive-page">
							<a href="<?php echo get_post_type_archive_link($atts['archive_post']) ?>"></a>
						</li>
					<?php if(!empty($next_post)) : ?>
						<li class="nav-next">
							<a href="<?php echo get_permalink($next_post->ID); ?>"> <?php echo get_the_title($next_post->ID); ?> </a>
							<div class="post-nav-thumb">
								<?php echo get_the_post_thumbnail( $next_post->ID,'thumbnail' ); ?>
							</div>
						</li>
					<?php endif; ?>
					</ul>
				</div>
			</div>
		<?php
		endif;
	}
}

/* 	Regex
/* ---------------------------------------------------------------------- */
if (!function_exists('bigbazaar_regex')) {

	/*
	*	Regex for url: http://mathiasbynens.be/demo/url-regex
	*/
	function bigbazaar_regex($string, $pattern = false, $start = "^", $end = "") {
		if (!$pattern) return false;

		if ($pattern == "url") {
			$pattern = "!$start((https?|ftp)://(-\.)?([^\s/?\.#-]+\.?)+(/[^\s]*)?)$end!";
		} else if ($pattern == "mail") {
			$pattern = "!$start\w[\w|\.|\-]+@\w[\w|\.|\-]+\.[a-zA-Z]{2,4}$end!";
		} else if ($pattern == "image") {
			$pattern = "!$start(https?(?://([^/?#]*))?([^?#]*?\.(?:jpg|gif|png)))$end!";
		} else if ($pattern == "mp4") {
			$pattern = "!$start(https?(?://([^/?#]*))?([^?#]*?\.(?:mp4)))$end!";
		} else if (strpos($pattern,"<") === 0) {
			$pattern = str_replace('<',"",$pattern);
			$pattern = str_replace('>',"",$pattern);

			if (strpos($pattern,"/") !== 0) { $close = "\/>"; $pattern = str_replace('/',"",$pattern); }
			$pattern = trim($pattern);
			if (!isset($close)) $close = "<\/".$pattern.">";

			$pattern = "!$start\<$pattern.+?$close!";
		}

		preg_match($pattern, $string, $result);

		if (empty($result[0])) {
			return false;
		} else {
			return $result;
		}
	}
}
 
/*  QR Code generation
/* --------------------------------------------------------------------- */ 
if(!function_exists('generate_qr_code')) {
    function generate_qr_code($text='QR Code', $title = 'QR Code', $size = 128, $class = '', $self_link = false, $lightbox = false ) {
        if($self_link) {
            global $wp;
            $text = @(isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] == 'on') ? 'https://' : 'http://';
            if ( $_SERVER['SERVER_PORT'] != '80' )
                $text .= $_SERVER['SERVER_NAME'] . ':' . $_SERVER['SERVER_PORT'] . $_SERVER['REQUEST_URI'];
            else 
                $text .= $_SERVER['SERVER_NAME'] . $_SERVER['REQUEST_URI'];
        }
        $image = 'https://chart.googleapis.com/chart?chs=' . $size . 'x' . $size . '&cht=qr&chld=H|1&chl=' . $text;

        if($lightbox) {
            $class .= 'zoom-gallery';
            $output = '<a href="'.$image.'" class="'.$class.'">'.$title.'</a>';
        } else{
            $class .= ' qr-code-image';
            $output = '<img src="'.$image.'"  class="'.$class.'" />';
        }
        return $output;
    }
}

/* 	Setup item data for theme 
/* --------------------------------------------------------------------- */
add_action( 'admin_init', 'bigbazaar_set_item' );
if ( ! function_exists( 'bigbazaar_set_item' ) ) :
    function bigbazaar_set_item(){
        if ( ! bigbazaar_is_activated() ) return;
        $item_data = get_option( 'bigbazaar_activated_data' );
        if ( ! empty( $item_data['item'] ) ) return;

        if( isset( $item_data['purchase'] ) && ! empty( $item_data['purchase'] ) ) {
            $code = trim( $item_data['purchase'] );

            if( empty( $code ) ) return;

            $theme_id = 15572515;
            $api = ETHEME_API;

            $response = wp_remote_get( $api . 'activate/' . $code . '?envato_id='. $theme_id );
            $response_code = wp_remote_retrieve_response_code( $response );

            if( $response_code != '200' ) return;
            
            $data = json_decode( wp_remote_retrieve_body($response), true );

            if( isset( $data['error'] ) ) return;
            if( ! $data['verified'] ) return;

            foreach ( $data as $key => $value ) {
               $item_data['item'][$key] = $value;
            }

            update_option( 'bigbazaar_activated_data', maybe_unserialize( $item_data ) );
        }
        return;
    }
endif;

/*  Activation notice
/* --------------------------------------------------------------------- */
if( !function_exists('bigbazaar_activation_bar')) {
    add_action('init', 'bigbazaar_activation_bar' );
    function bigbazaar_activation_bar() {  
        if( ! bigbazaar_is_activated() ) { 
            add_action( 'bb_after_body', 'bigbazaar_activation_bar_out', 100 );
        }
    }
}

if( ! function_exists('bigbazaar_activation_bar_out')) {
    function bigbazaar_activation_bar_out() { ?>
            <div class="bigbazaar-activation-bar">Important Note: You need to activate<a style="color:red;" href="<?php echo admin_url( 'admin.php?page=bigbazaar_activation_page' ); ?>"> BigBazaar Theme</a> using your purchased code to continue working.</div>
        <?php
    }
}

/*  Add google analytics code
/* --------------------------------------------------------------------- */ 
add_action('init', 'bigbazaar_google_analytics');
if(!function_exists('bigbazaar_google_analytics')) {
	function bigbazaar_google_analytics() {
		$googleCode = bigbazaar_get_option('google_analytics','');

		if(empty($googleCode)) return;

		if(strpos($googleCode,'UA-') === 0) {

			$googleCode = "

			<script type='text/javascript'>

			var _gaq = _gaq || [];
			_gaq.push(['_setAccount', '".$googleCode."']);
			_gaq.push(['_trackPageview']);

			(function() {
			var ga = document.createElement('script'); ga.type = 'text/javascript'; ga.async = true;
			ga.src = ('https:' == document.location.protocol ? 'https://ssl' : 'http://www') + '.google-analytics.com/ga.js';
			var s = document.getElementsByTagName('script')[0]; s.parentNode.insertBefore(ga, s);
			})();

			</script>";
		}

		add_action('wp_head', 'bigbazaar_print_google_code');
	}

	function bigbazaar_print_google_code() {
		$googleCode = bigbazaar_get_option('google_analytics','');

		if(!empty($googleCode)) {
			echo $googleCode;
		}
	}

}

/* 	Get Social share
/* --------------------------------------------------------------------- */
if( ! function_exists( 'bigbazaar_single_sharing' ) ) {
	function bigbazaar_single_sharing() {
		
		if( !bigbazaar_get_option('show_social_sharing', 1) ) return; 
		
		global $post;		
		$post_link	= esc_url( get_permalink() );
		$post_title = wp_strip_all_tags( get_the_title() );
		$src = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), false, '' );?>
		
		<div class="social-share <?php echo (bigbazaar_get_option('social_sharing_style', 1)) ? 'style-1' : 'style-2'; ?>">	
			<?php $post_title = htmlspecialchars(urlencode(html_entity_decode( $post_title, ENT_COMPAT, 'UTF-8')), ENT_COMPAT, 'UTF-8'); ?>
			<ul class="social-link">	
				<?php if( bigbazaar_get_option( 'social_share_fb', 1 ) ): ?>
					<li class="icon-facebook"><a title="<?php echo esc_html__( 'Share on Facebook', 'bigbazaar' ); ?>" href="//www.facebook.com/sharer.php?u=<?php echo $post_link; ?>" onclick="window.open(this.href,this.title,'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,width=500,height=500,top=300px,left=300px');  return false;">
						<i class="fa fa-facebook"></i>
					</a></li>
				<?php endif; ?>	
				<?php if( bigbazaar_get_option( 'social_share_tw', 1 ) ): ?>
					<li class="icon-twitter"><a title="<?php echo esc_html__( 'Share on Twitter', 'bigbazaar' ); ?>" href="//twitter.com/share?url=<?php echo $post_link; ?>" onclick="window.open(this.href,this.title,'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,width=500,height=500,top=300px,left=300px');  return false;">
						<i class="fa fa-twitter"></i>
					</a></li>
				<?php endif; ?>
				<?php if( bigbazaar_get_option( 'social_share_in', 1 ) ): ?>
					<li  class="icon-linkedin"><a title="<?php echo esc_html__( 'Share on LinkedIn', 'bigbazaar' ); ?>" href="//www.linkedin.com/shareArticle?mini=true&url=<?php echo $post_link; ?>&title=<?php echo $post_title; ?>" onclick="window.open(this.href,this.title,'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,width=500,height=500,top=300px,left=300px');  return false;">
						<i class="fa fa-linkedin"></i>
					</a></li>
				<?php endif; ?>
				<?php if( bigbazaar_get_option( 'social_share_gp', 1 ) ): ?>
					<li  class="icon-google-plus"><a title="<?php echo esc_html__( 'Share on Google Plus', 'bigbazaar' ); ?>" href="//plus.google.com/share?url=<?php echo $post_link; ?>" onclick="window.open(this.href,this.title,'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,width=500,height=500,top=300px,left=300px');  return false;">
						<i class="fa fa-google-plus"></i>
					</a></li>
				<?php endif; ?>			
				<?php if( bigbazaar_get_option( 'social_share_sl', 1 ) ): ?>
					<li  class="icon-submit"><a title="<?php echo esc_html__( 'Share on Stumbleupon', 'bigbazaar' ); ?>" href="//www.stumbleupon.com/submit?url=<?php echo $post_link; ?>&title=<?php echo $post_title; ?>" onclick="window.open(this.href,this.title,'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,width=500,height=500,top=300px,left=300px');  return false;">
						<i class="fa fa-stumbleupon"></i>
					</a></li>
				<?php endif; ?>
				<?php if( bigbazaar_get_option( 'social_share_pr', 1 ) ): ?>
					<li  class="icon-pinterest"><a title="<?php echo esc_html__( 'Share on Pinterest', 'bigbazaar' ); ?>" href="//pinterest.com/pin/create/button/?url=<?php echo $post_link; ?>&media=<?php echo esc_url( $src[0] ); ?>&description=<?php echo $post_title; ?>" onclick="window.open(this.href,this.title,'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,width=500,height=500,top=300px,left=300px');  return false;">
						<i class="fa fa-pinterest"></i>
					</a></li>
				<?php endif; ?>
				<?php if( bigbazaar_get_option( 'social_share_tl', 1 ) ): ?>
					<li  class="icon-tumblr"><a title="<?php echo esc_html__( 'Share on Tumblr', 'bigbazaar' ); ?>" href="//tumblr.com/widgets/share/tool?canonicalUrl=<?php echo $post_link; ?>" onclick="window.open(this.href,this.title,'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,width=500,height=500,top=300px,left=300px');  return false;">
						<i class="fa fa-tumblr"></i>
					</a>
				<?php endif; ?>
				
			</ul>
		</div>
		<div class="clear"></div> 
	<?php }
}

if( !function_exists('bigbazaar_newsletter_popup')){
	function bigbazaar_newsletter_popup(){
	
		if(!bigbazaar_get_option('newsletter_enable', 0)) return;?>
		
		<div id="newsletterPopup" class="modal fade newsletterPopup popup-modal">
			<div class="modal-dialog">
				<div class="newsletter-content modal-content modal-md">
					<button type="button" class="close" data-dismiss="modal">&times;</button>
					<div class="newsletter-logo">
						<?php $newsletter_logo=bigbazaar_get_option('newsletter_logo',BIGBAZAAR_IMAGES.'/logo.png');
						if( !empty( $newsletter_logo)):?>
							<img src="<?php echo esc_url($newsletter_logo);?>" alt="logo">
						<?php endif;?>
					</div>
					<div class="newsletter-text">
						<h1><?php echo bigbazaar_get_option('newsletter_title', 'Join Us Now!')?></h1>
						<p class="tag-line"><?php echo bigbazaar_get_option('newsletter_tag_line', 'Signup today for free and be the first to hear of special promotions, new arrivals and designer news.')?></p>
					</div>
					<div class="newsletter-form">
						<?php if( function_exists( 'mc4wp_show_form' ) ) {
							mc4wp_show_form();
						}?>
						<div class="checkbox-group form-group-top clearfix">
						  <input type="checkbox" id="checkBox1">
						  <label for="checkBox1"> 
							<span class="check"></span>
							<span class="box"></span>
							<?php echo bigbazaar_get_option('newsletter_dont_show', 'Don\'t show this popup again')?>
						  </label>
						</div>
					</div>
				</div>
			</div>
		</div>
	<?php }
}
add_action( 'bigbazaar_after_footer', 'bigbazaar_newsletter_popup', 5 );


/* Font-Awesome Icon
/* --------------------------------------------------------------------- */ 
function font_awesome_icon(){
	return array('fa-glass','fa-music','fa-search','fa-envelope-o','fa-heart','fa-star','fa-star-o','fa-user','fa-film','fa-th-large','fa-th','fa-th-list','fa-check','fa-remove','fa-close','fa-times','fa-search-plus','fa-search-minus','fa-power-off','fa-signal','fa-gear','fa-cog','fa-trash-o','fa-home','fa-file-o','fa-clock-o','fa-road','fa-download','fa-arrow-circle-o-down','fa-arrow-circle-o-up','fa-inbox','fa-play-circle-o','fa-rotate-right','fa-repeat','fa-refresh','fa-list-alt','fa-lock','fa-flag','fa-headphones','fa-volume-off','fa-volume-down','fa-volume-up','fa-qrcode','fa-barcode','fa-tag','fa-tags','fa-book','fa-bookmark','fa-print','fa-camera','fa-font','fa-bold','fa-italic','fa-text-height','fa-text-width','fa-align-left','fa-align-center','fa-align-right','fa-align-justify','fa-list','fa-dedent','fa-outdent','fa-indent','fa-video-camera','fa-photo','fa-image','fa-picture-o','fa-pencil','fa-map-marker','fa-adjust','fa-tint','fa-edit','fa-pencil-square-o','fa-share-square-o','fa-check-square-o','fa-arrows','fa-step-backward','fa-fast-backward','fa-backward','fa-play','fa-pause','fa-stop','fa-forward','fa-fast-forward','fa-step-forward','fa-eject','fa-chevron-left','fa-chevron-right','fa-plus-circle','fa-minus-circle','fa-times-circle','fa-check-circle','fa-question-circle','fa-info-circle','fa-crosshairs','fa-times-circle-o','fa-check-circle-o','fa-ban','fa-arrow-left','fa-arrow-right','fa-arrow-up','fa-arrow-down','fa-mail-forward','fa-share','fa-expand','fa-compress','fa-plus','fa-minus','fa-asterisk','fa-exclamation-circle','fa-gift','fa-leaf','fa-fire','fa-eye','fa-eye-slash','fa-warning','fa-exclamation-triangle','fa-plane','fa-calendar','fa-random','fa-comment','fa-magnet','fa-chevron-up','fa-chevron-down','fa-retweet','fa-shopping-cart','fa-folder','fa-folder-open','fa-arrows-v','fa-arrows-h','fa-bar-chart-o','fa-bar-chart','fa-twitter-square','fa-facebook-square','fa-camera-retro','fa-key','fa-gears','fa-cogs','fa-comments','fa-thumbs-o-up','fa-thumbs-o-down','fa-star-half','fa-heart-o','fa-sign-out','fa-linkedin-square','fa-thumb-tack','fa-external-link','fa-sign-in','fa-trophy','fa-github-square','fa-upload','fa-lemon-o','fa-phone','fa-square-o','fa-bookmark-o','fa-phone-square','fa-twitter','fa-facebook-f','fa-facebook','fa-github','fa-unlock','fa-credit-card','fa-rss','fa-hdd-o','fa-bullhorn','fa-bell','fa-certificate','fa-hand-o-right','fa-hand-o-left','fa-hand-o-up','fa-hand-o-down','fa-arrow-circle-left','fa-arrow-circle-right','fa-arrow-circle-up','fa-arrow-circle-down','fa-globe','fa-wrench','fa-tasks','fa-filter','fa-briefcase','fa-arrows-alt','fa-group','fa-users','fa-chain','fa-link','fa-cloud','fa-flask','fa-cut','fa-scissors','fa-copy','fa-files-o','fa-paperclip','fa-save','fa-floppy-o','fa-square','fa-navicon','fa-reorder','fa-bars','fa-list-ul','fa-list-ol','fa-strikethrough','fa-underline','fa-table','fa-magic','fa-truck','fa-pinterest','fa-pinterest-square','fa-google-plus-square','fa-google-plus','fa-money','fa-caret-down','fa-caret-up','fa-caret-left','fa-caret-right','fa-columns','fa-unsorted','fa-sort','fa-sort-down','fa-sort-desc','fa-sort-up','fa-sort-asc','fa-envelope','fa-linkedin','fa-rotate-left','fa-undo','fa-legal','fa-gavel','fa-dashboard','fa-tachometer','fa-comment-o','fa-comments-o','fa-flash','fa-bolt','fa-sitemap','fa-umbrella','fa-paste','fa-clipboard','fa-lightbulb-o','fa-exchange','fa-cloud-download','fa-cloud-upload','fa-user-md','fa-stethoscope','fa-suitcase','fa-bell-o','fa-coffee','fa-cutlery','fa-file-text-o','fa-building-o','fa-hospital-o','fa-ambulance','fa-medkit','fa-fighter-jet','fa-beer','fa-h-square','fa-plus-square','fa-angle-double-left','fa-angle-double-right','fa-angle-double-up','fa-angle-double-down','fa-angle-left','fa-angle-right','fa-angle-up','fa-angle-down','fa-desktop','fa-laptop','fa-tablet','fa-mobile-phone','fa-mobile','fa-circle-o','fa-quote-left','fa-quote-right','fa-spinner','fa-circle','fa-mail-reply','fa-reply','fa-github-alt','fa-folder-o','fa-folder-open-o','fa-smile-o','fa-frown-o','fa-meh-o','fa-gamepad','fa-keyboard-o','fa-flag-o','fa-flag-checkered','fa-terminal','fa-code','fa-mail-reply-all','fa-reply-all','fa-star-half-empty','fa-star-half-full','fa-star-half-o','fa-location-arrow','fa-crop','fa-code-fork','fa-unlink','fa-chain-broken','fa-question','fa-info','fa-exclamation','fa-superscript','fa-subscript','fa-eraser','fa-puzzle-piece','fa-microphone','fa-microphone-slash','fa-shield','fa-calendar-o','fa-fire-extinguisher','fa-rocket','fa-maxcdn','fa-chevron-circle-left','fa-chevron-circle-right','fa-chevron-circle-up','fa-chevron-circle-down','fa-html5','fa-css3','fa-anchor','fa-unlock-alt','fa-bullseye','fa-ellipsis-h','fa-ellipsis-v','fa-rss-square','fa-play-circle','fa-ticket','fa-minus-square','fa-minus-square-o','fa-level-up','fa-level-down','fa-check-square','fa-pencil-square','fa-external-link-square','fa-share-square','fa-compass','fa-toggle-down','fa-caret-square-o-down','fa-toggle-up','fa-caret-square-o-up','fa-toggle-right','fa-caret-square-o-right','fa-euro','fa-eur','fa-gbp','fa-dollar','fa-usd','fa-rupee','fa-inr','fa-cny','fa-rmb','fa-yen','fa-jpy','fa-ruble','fa-rouble','fa-rub','fa-won','fa-krw','fa-bitcoin','fa-btc','fa-file','fa-file-text','fa-sort-alpha-asc','fa-sort-alpha-desc','fa-sort-amount-asc','fa-sort-amount-desc','fa-sort-numeric-asc','fa-sort-numeric-desc','fa-thumbs-up','fa-thumbs-down','fa-youtube-square','fa-youtube','fa-xing','fa-xing-square','fa-youtube-play','fa-dropbox','fa-stack-overflow','fa-instagram','fa-flickr','fa-adn','fa-bitbucket','fa-bitbucket-square','fa-tumblr','fa-tumblr-square','fa-long-arrow-down','fa-long-arrow-up','fa-long-arrow-left','fa-long-arrow-right','fa-apple','fa-windows','fa-android','fa-linux','fa-dribbble','fa-skype','fa-foursquare','fa-trello','fa-female','fa-male','fa-gittip','fa-gratipay','fa-sun-o','fa-moon-o','fa-archive','fa-bug','fa-vk','fa-weibo','fa-renren','fa-pagelines','fa-stack-exchange','fa-arrow-circle-o-right','fa-arrow-circle-o-left','fa-toggle-left','fa-caret-square-o-left','fa-dot-circle-o','fa-wheelchair','fa-vimeo-square','fa-turkish-lira','fa-try','fa-plus-square-o','fa-space-shuttle','fa-slack','fa-envelope-square','fa-wordpress','fa-openid','fa-institution','fa-bank','fa-university','fa-mortar-board','fa-graduation-cap','fa-yahoo','fa-google','fa-reddit','fa-reddit-square','fa-stumbleupon-circle','fa-stumbleupon','fa-delicious','fa-digg','fa-pied-piper','fa-pied-piper-alt','fa-drupal','fa-joomla','fa-language','fa-fax','fa-building','fa-child','fa-paw','fa-spoon','fa-cube','fa-cubes','fa-behance','fa-behance-square','fa-steam','fa-steam-square','fa-recycle','fa-automobile','fa-car','fa-cab','fa-taxi','fa-tree','fa-spotify','fa-deviantart','fa-soundcloud','fa-database','fa-file-pdf-o','fa-file-word-o','fa-file-excel-o','fa-file-powerpoint-o','fa-file-photo-o','fa-file-picture-o','fa-file-image-o','fa-file-zip-o','fa-file-archive-o','fa-file-sound-o','fa-file-audio-o','fa-file-movie-o','fa-file-video-o','fa-file-code-o','fa-vine','fa-codepen','fa-jsfiddle','fa-life-bouy','fa-life-buoy','fa-life-saver','fa-support','fa-life-ring','fa-circle-o-notch','fa-ra','fa-rebel','fa-ge','fa-empire','fa-git-square','fa-git','fa-hacker-news','fa-tencent-weibo','fa-qq','fa-wechat','fa-weixin','fa-send','fa-paper-plane','fa-send-o','fa-paper-plane-o','fa-history','fa-genderless','fa-circle-thin','fa-header','fa-paragraph','fa-sliders','fa-share-alt','fa-share-alt-square','fa-bomb','fa-soccer-ball-o','fa-futbol-o','fa-tty','fa-binoculars','fa-plug','fa-slideshare','fa-twitch','fa-yelp','fa-newspaper-o','fa-wifi','fa-calculator','fa-paypal','fa-google-wallet','fa-cc-visa','fa-cc-mastercard','fa-cc-discover','fa-cc-amex','fa-cc-paypal','fa-cc-stripe','fa-bell-slash','fa-bell-slash-o','fa-trash','fa-copyright','fa-at','fa-eyedropper','fa-paint-brush','fa-birthday-cake','fa-area-chart','fa-pie-chart','fa-line-chart','fa-lastfm','fa-lastfm-square','fa-toggle-off','fa-toggle-on','fa-bicycle','fa-bus','fa-ioxhost','fa-angellist','fa-cc','fa-shekel','fa-sheqel','fa-ils','fa-meanpath','fa-buysellads','fa-connectdevelop','fa-dashcube','fa-forumbee','fa-leanpub','fa-sellsy','fa-shirtsinbulk','fa-simplybuilt','fa-skyatlas','fa-cart-plus','fa-cart-arrow-down','fa-diamond','fa-ship','fa-user-secret','fa-motorcycle','fa-street-view','fa-heartbeat','fa-venus','fa-mars','fa-mercury','fa-transgender','fa-transgender-alt','fa-venus-double','fa-mars-double','fa-venus-mars','fa-mars-stroke','fa-mars-stroke-v','fa-mars-stroke-h','fa-neuter','fa-facebook-official','fa-pinterest-p','fa-whatsapp','fa-server','fa-user-plus','fa-user-times','fa-hotel','fa-bed','fa-viacoin','fa-train','fa-subway','fa-medium');
}