<?php
/**
 * The default template for displaying content
 *
 * Used for both single and index/archive/search.
 *
 * @package WordPress
 * @subpackage BigBazaar
 * @since BigBazaar 1.0
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	
	<?php // Post thumbnail.
		bigbazaar_get_post_thumbnail('large');
	?>

	<header class="entry-header">
		<?php
			if ( is_single() ) :
				the_title( '<h1 class="page-title">', '</h1>' );
			else :
				the_title( sprintf( '<h2 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' );
			endif;
		?>
	</header><!-- .entry-header -->
	
	<?php if(bigbazaar_get_option('show_postmeta', 1)==1):?>
		<footer class="entry-footer">
			<?php bigbazaar_entry_meta(); ?>
			<?php edit_post_link( __( 'Edit', 'bigbazaar' ), '<span class="edit-link">', '</span>' ); ?>
		</footer><!-- .entry-footer -->
	<?php endif;?>
	
	<div class="entry-content">
		
		<?php if( ! is_single() && (bigbazaar_get_option('show_blog_excerpt', 0)==1)):
				the_excerpt();
			else:
				/* translators: %s: Name of current post */
				the_content( sprintf(
					__( 'Read more %s', 'bigbazaar' ),
					the_title( '<span class="screen-reader-text">', '</span>', false )
				) );
			endif;					

			wp_link_pages( array(
				'before'      => '<div class="page-links"><span class="page-links-title">' . __( 'Pages:', 'bigbazaar' ) . '</span>',
				'after'       => '</div>',
				'link_before' => '<span>',
				'link_after'  => '</span>',
				'pagelink'    => '<span class="screen-reader-text">' . __( 'Page', 'bigbazaar' ) . ' </span>%',
				'separator'   => '<span class="screen-reader-text">, </span>',
			) );
		?>
	</div><!-- .entry-content -->

	<?php
		// Author bio.
		if ( is_single() && get_the_author_meta( 'description' ) ) :
			get_template_part( 'author-bio' );
		endif;
	?>

</article><!-- #post-## -->
