<?php

add_action("init","of_options");

if (!function_exists("of_options"))
{
	function of_options()
	{
		global $of_sidebars;
		//Access the WordPress Categories via an Array
		$of_categories 		= array();  
		$of_categories_obj 	= get_categories("hide_empty=1");
		foreach ($of_categories_obj as $of_cat) {
		    $of_categories[$of_cat->cat_ID] = $of_cat->cat_name;}
		$categories_tmp 	= array_unshift($of_categories, "Select a category:");    
		
		//Access the product Categories via an Array
		$of_product_categories 		= array();  
		if(is_woocommerce_activated()):
			$of_product_categories_obj 	= get_categories(array("hide_empty" =>1,"parent" =>0, "taxonomy" => "product_cat"));
			foreach ($of_product_categories_obj as $of_pro_cat) {
				$of_product_categories[$of_pro_cat->cat_ID] = $of_pro_cat->cat_name;}
			//$pro_categories_tmp 	= array_unshift($of_product_categories, "Select a category:");    
		endif;
	       
		//Access the WordPress Pages via an Array
		$of_pages 			= array();
		$of_pages_obj 		= get_pages("sort_column=post_parent,menu_order");    
		foreach ($of_pages_obj as $of_page) {
		    $of_pages[$of_page->ID] = $of_page->post_name; }
		$of_pages_tmp 		= array_unshift($of_pages, "Select a page:");   

		//Sidebars
        $of_sidebars = array();
        foreach ($GLOBALS["wp_registered_sidebars"] as $sidebar){
            $of_sidebars[ $sidebar["id"] ] =  $sidebar["id"];
        }
		
		//Stylesheets Reader
		$alt_stylesheet_path = LAYOUT_PATH;
		$alt_stylesheets = array();
		
		if ( is_dir($alt_stylesheet_path) ) 
		{
		    if ($alt_stylesheet_dir = opendir($alt_stylesheet_path) ) 
		    { 
		        while ( ($alt_stylesheet_file = readdir($alt_stylesheet_dir)) !== false ) 
		        {
		            if(stristr($alt_stylesheet_file, ".css") !== false)
		            {
		                $alt_stylesheets[] = $alt_stylesheet_file;
		            }
		        }    
		    }
		}


		//Background Images Reader
		$bg_images_path = BIGBAZAAR_DIR. "/images/patterns/"; // change this to where you store your bg images
		$bg_images_url = BIGBAZAAR_IMAGES."/patterns/"; // change this to where you store your bg images
		$bg_images = array();
		
		if ( is_dir($bg_images_path) ) {
		    if ($bg_images_dir = opendir($bg_images_path) ) { 
		        while ( ($bg_images_file = readdir($bg_images_dir)) !== false ) {
		            if(stristr($bg_images_file, ".png") !== false || stristr($bg_images_file, ".jpg") !== false) {
		            	natsort($bg_images); //Sorts the array into a natural order
		                $bg_images[] = $bg_images_url . $bg_images_file;
		            }
		        }    
		    }
		}
		
/*-----------------------------------------------------------------------------------*/
/* The Options Array */
/*-----------------------------------------------------------------------------------*/

// Set the Options Array
global $of_options;
$of_options = array();

$of_options[] = array( 	"name" 		=> "General Settings",
						"type" 		=> "heading"
				);
					
$url =  ADMIN_DIR . "assets/images/";
$of_options[] = array( 	"name" 		=> esc_html__("Theme Layout","bigbazaar"),
						"desc" 		=> esc_html__("Choose theme wide or boxed layout.","bigbazaar"),
						"id" 		=> "theme_layout",
						"std" 		=> "full_layout",
						"type" 		=> "images",
						"options" 	=> array(
							"full_layout" 	=> $url . "full-width.png",
							"boxed_layout" 	=> $url . "sidebar-both.png"
						)
				);

$of_options[] = array( 	"name" 		=> esc_html__("Page Container Width","bigbazaar"),
						"desc" 		=> esc_html__("Choose one of the pre-defined widths or enter custom one.","bigbazaar"),
						"id" 		=> "use_predefined_page_width",
						"std" 		=> 1,
						"on"    	=> esc_html__( "Predefined", "bigbazaar" ),
                        "off"   	=> esc_html__( "Custom", "bigbazaar" ),
						"folds"		=> 0,
						"type" 		=> "switch"
				);

$of_options[] = array(  "name"      => "",
						"desc"      => "",
						"id"        => "predefined_page_width",
						"std"       => "1170",
						"type"      => "radio",
						"fold"      => "use_predefined_page_width",
						"options"   => array(
							"1170"  => esc_html__( "Wide Screen", "bigbazaar" ) . " (1170px)",
							"960"   => esc_html__( "NoteBook", "bigbazaar" ) . " (960px)",
						)
				);

$of_options[] = array(  "name"  	=> "",
						"desc"  	=> "px",
						"id"    	=> "custom_page_width",
						"std"   	=> "1170",
						"fold"  	=> "off_" . "use_predefined_page_width",
						"type"  	=> "text"
				);
		
$of_options[] = array( 	"name" 		=> esc_html__("Header Logo","bigbazaar"),
						"desc" 		=> esc_html__("Upload header logo.","bigbazaar"),
						"id" 		=> "header_logo",
						"std" 		=> BIGBAZAAR_IMAGES."/logo.png",
						//"mod"		=> "min",
						"type" 		=> "media"
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Favicon Icon","bigbazaar"),
						"desc" 		=> esc_html__("Upload site favicon icon.","bigbazaar"),
						"id" 		=> "favicon_icon",
						"std" 		=> BIGBAZAAR_IMAGES."/favicon.ico",
						"type" 		=> "media"
				);

$of_options[] = array( 	"name" 		=> esc_html__("Sticky Navigation","bigbazaar"),
						"desc" 		=> esc_html__("Sticky header navigation.","bigbazaar"),
						"id" 		=> "sticky_navigation",
						"on"        => esc_html__("Enable","bigbazaar"),
						"off"       => esc_html__("Disable","bigbazaar"),
						"std" 		=> 1,
						"type" 		=> "switch"
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Show Back To Top","bigbazaar"),
						"desc" 		=> esc_html__("Show back to top button.","bigbazaar"),
						"id" 		=> "back_to_top",
						"std" 		=> 1,
						"type" 		=> "switch"
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Tracking Code","bigbazaar"),
						"desc" 		=> esc_html__("Paste your Google Analytics (or other) tracking code here. This will be added into the footer template of your theme.","bigbazaar"),
						"id" 		=> "google_analytics",
						"std" 		=> "",
						"type" 		=> "textarea"

				);

/*
* Styling Options
*/
$of_options[] = array( 	"name" 		=> "Theme Styling",
						"type" 		=> "heading"
				);

$of_options[] = array( 	"name" 		=> esc_html__("Body Style","bigbazaar"),
						"desc" 		=> "",
						"id" 		=> "body_styling",
						"std" 		=> "<h3 style=\"margin: 0;\">".esc_html__('Body Styling','bigbazaar')."</h3>",
						"icon" 		=> true,
						"type" 		=> "info"
				);

$of_options[] = array( 	"name" 		=> esc_html__("Color","bigbazaar"),
						"desc" 		=> esc_html__("Theme color","bigbazaar"),
						"id" 		=> "theme_color",
						"std" 		=> "#e62e04",
						"type" 		=> "color"
				);
				
$of_options[] = array( 	"name" 		=> "",
						"desc" 		=> esc_html__("Background Color","bigbazaar"),
						"id" 		=> "body_background_color",
						"std" 		=> "#ffffff",
						"type" 		=> "color"
				);	
				
$of_options[] = array( 	"name" 		=> "",
						"desc" 		=> esc_html__("Text Color","bigbazaar"),
						"id" 		=> "body_text_color",
						"std" 		=> "#333333",
						"type" 		=> "color"
				);

$of_options[] = array( 	"name" 		=> "",
						"desc" 		=> esc_html__("Link Color","bigbazaar"),
						"id" 		=> "body_link_color",
						"std" 		=> "#333333",
						"type" 		=> "color"
				);

$of_options[] = array( 	"name" 		=> "",
						"desc" 		=> esc_html__("Hover Color","bigbazaar"),
						"id" 		=> "body_hover_color",
						"std" 		=> "#ff6600",
						"type" 		=> "color"
				);

$of_options[] = array( 	"name" 		=> esc_html__("Border","bigbazaar"),
						"desc" 		=> esc_html__("General border of theme.","bigbazaar"),
						"id" 		=> "theme_border",
						"std" 		=> array(
											"width" => "1",
											"style" => "solid",
											"color" => "#e9e9e9"
										),
						"type" 		=> "border"
				);
$of_options[] = array( 	"name" 		=> esc_html__("Background Pattern Image","bigbazaar"),
						"desc" 		=> esc_html__("Choose pattern pre-defined or upload custom.","bigbazaar"),
						"id" 		=> "choose_body_background_pattern",
						"std" 		=> 1,
						"on"    	=> esc_html__( "Predefined", "bigbazaar" ),
                        "off"   	=> esc_html__( "Custom", "bigbazaar" ),
						"folds"		=> 0,
						"type" 		=> "switch"
				);
				
$of_options[] = array( 	"name" 		=> "",
						"desc" 		=> esc_html__("Select a background pattern.","bigbazaar"),
						"id" 		=> "body_background_image",
						"std" 		=> $bg_images_url."none.png",
						"fold"  	=> "choose_body_background_pattern",
						"type" 		=> "tiles",
						"options" 	=> $bg_images,
				);						
		
$of_options[] = array( 	"name" 		=> esc_html__("Upload Custom Pattern","bigbazaar"),
						"desc" 		=> esc_html__("Upload custom pattern.","bigbazaar"),
						"id" 		=> "custom_body_background_pattern",
						"std" 		=> BIGBAZAAR_IMAGES."/patterns/pattern.jpg",
						"fold"  	=> "off_" . "choose_body_background_pattern",
						"type" 		=> "media"
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Topbar Style","bigbazaar"),
						"desc" 		=> "",
						"id" 		=> "topbar_styling",
						"std" 		=> "<h3 style=\"margin: 0;\">".esc_html__('Topbar Styling','bigbazaar')."</h3>",
						"icon" 		=> true,
						"type" 		=> "info"
				);

$of_options[] = array( 	"name" 		=> esc_html__("Color","bigbazaar"),
						"desc" 		=> esc_html__("Background color","bigbazaar"),
						"id" 		=> "topbar_background_color",
						"std" 		=> "#353d41",
						"type" 		=> "color"
				);	
				
$of_options[] = array( 	"name" 		=> "",
						"desc" 		=> esc_html__("Text Color","bigbazaar"),
						"id" 		=> "topbar_text_color",
						"std" 		=> "#93999d",
						"type" 		=> "color"
				);

$of_options[] = array( 	"name" 		=> "",
						"desc" 		=> esc_html__("Link Color","bigbazaar"),
						"id" 		=> "topbar_link_color",
						"std" 		=> "#93999d",
						"type" 		=> "color"
				);

$of_options[] = array( 	"name" 		=> "",
						"desc" 		=> esc_html__("Hover Color","bigbazaar"),
						"id" 		=> "topbar_hover_color",
						"std" 		=> "#ffffff",
						"type" 		=> "color"
				);

$of_options[] = array( 	"name" 		=> esc_html__("Border","bigbazaar"),
						"desc" 		=> esc_html__("Set topbar border.","bigbazaar"),
						"id" 		=> "topbar_border",
						"std" 		=> array(
											"width" => "1",
											"style" => "solid",
											"color" => "#454d50"
										),
						"type" 		=> "border"
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Background Pattern Image","bigbazaar"),
						"desc" 		=> esc_html__("Choose pattern pre-defined or upload custom.","bigbazaar"),
						"id" 		=> "choose_topbar_background_pattern",
						"std" 		=> 1,
						"on"    	=> esc_html__( "Predefined", "bigbazaar" ),
                        "off"   	=> esc_html__( "Custom", "bigbazaar" ),
						"folds"		=> 0,
						"type" 		=> "switch"
				);
				
$of_options[] = array( 	"name" 		=> "",
						"desc" 		=> esc_html__("Select a background pattern.","bigbazaar"),
						"id" 		=> "topbar_background_image",
						"std" 		=> $bg_images_url."none.png",
						"fold"  	=> "choose_topbar_background_pattern",
						"type" 		=> "tiles",
						"options" 	=> $bg_images,
				);						
		
$of_options[] = array( 	"name" 		=> esc_html__("Upload Custom Pattern","bigbazaar"),
						"desc" 		=> esc_html__("Upload custom pattern.","bigbazaar"),
						"id" 		=> "custom_topbar_background_pattern",
						"std" 		=> BIGBAZAAR_IMAGES."/patterns/pattern.jpg",
						"fold"  	=> "off_" . "choose_topbar_background_pattern",
						"type" 		=> "media"
				);

$of_options[] = array( 	"name" 		=> esc_html__("Header Style","bigbazaar"),
						"desc" 		=> "",
						"id" 		=> "header_styling",
						"std" 		=> "<h3 style=\"margin: 0;\">".esc_html__('Header Styling','bigbazaar')."</h3>",
						"icon" 		=> true,
						"type" 		=> "info"
				);

$of_options[] = array( 	"name" 		=> esc_html__("Color","bigbazaar"),
						"desc" 		=> esc_html__("Background color","bigbazaar"),
						"id" 		=> "header_background_color",
						"std" 		=> "#ffffff",
						"type" 		=> "color"
				);	
				
$of_options[] = array( 	"name" 		=> "",
						"desc" 		=> esc_html__("Text color","bigbazaar"),
						"id" 		=> "header_text_color",
						"std" 		=> "#333333",
						"type" 		=> "color"
				);

$of_options[] = array( 	"name" 		=> "",
						"desc" 		=> esc_html__("Link color","bigbazaar"),
						"id" 		=> "header_link_color",
						"std" 		=> "#333333",
						"type" 		=> "color"
				);
			
$of_options[] = array( 	"name" 		=> "",
						"desc" 		=> esc_html__("Link hover color","bigbazaar"),
						"id" 		=> "header_link_hover_color",
						"std" 		=> "#ff6600",
						"type" 		=> "color"
				);

$of_options[] = array( 	"name" 		=> "",
						"desc" 		=> esc_html__("Hover color","bigbazaar"),
						"id" 		=> "header_hover_color",
						"std" 		=> "#ffffff",
						"type" 		=> "color"
				);

$of_options[] = array( 	"name" 		=> esc_html__("Border","bigbazaar"),
						"desc" 		=> esc_html__("Set header border.","bigbazaar"),
						"id" 		=> "header_border",
						"std" 		=> array(
											"width" => "1",
											"style" => "solid",
											"color" => "#e9e9e9"
										),
						"type" 		=> "border"
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Background Pattern Image","bigbazaar"),
						"desc" 		=> esc_html__("Choose pattern pre-defined or upload custom.","bigbazaar"),
						"id" 		=> "choose_header_background_pattern",
						"std" 		=> 1,
						"on"    	=> esc_html__( "Predefined", "bigbazaar" ),
                        "off"   	=> esc_html__( "Custom", "bigbazaar" ),
						"folds"		=> 0,
						"type" 		=> "switch"
				);
				
$of_options[] = array( 	"name" 		=> "",
						"desc" 		=> esc_html__("Select a background pattern.","bigbazaar"),
						"id" 		=> "header_background_image",
						"std" 		=> $bg_images_url."none.png",
						"fold"  	=> "choose_header_background_pattern",
						"type" 		=> "tiles",
						"options" 	=> $bg_images,
				);						
		
$of_options[] = array( 	"name" 		=> esc_html__("Upload Custom Pattern","bigbazaar"),
						"desc" 		=> esc_html__("Upload custom pattern.","bigbazaar"),
						"id" 		=> "custom_header_background_pattern",
						"std" 		=> BIGBAZAAR_IMAGES."/patterns/pattern.jpg",
						"fold"  	=> "off_" . "choose_header_background_pattern",
						"type" 		=> "media"
				);

$of_options[] = array( 	"name" 		=> esc_html__("Navigation Bar Style","bigbazaar"),
						"desc" 		=> "",
						"id" 		=> "navigation_styling",
						"std" 		=> "<h3 style=\"margin: 0;\">".esc_html__('Navigation Bar Styling','bigbazaar')."</h3>",
						"icon" 		=> true,
						"type" 		=> "info"
				);

$of_options[] = array( 	"name" 		=> esc_html__("Color","bigbazaar"),
						"desc" 		=> "Background color",
						"id" 		=> "navigation_background_color",
						"std" 		=> "#fcfcfc",
						"type" 		=> "color"
				);	
				
$of_options[] = array( 	"name" 		=> "",
						"desc" 		=> esc_html__("Text color","bigbazaar"),
						"id" 		=> "navigation_text_color",
						"std" 		=> "#333333",
						"type" 		=> "color"
				);

$of_options[] = array( 	"name" 		=> "",
						"desc" 		=> esc_html__("Link color","bigbazaar"),
						"id" 		=> "navigation_link_color",
						"std" 		=> "#333333",
						"type" 		=> "color"
				);
				
$of_options[] = array( 	"name" 		=> "",
						"desc" 		=> esc_html__("Link hover color","bigbazaar"),
						"id" 		=> "navigation_link_hover_color",
						"std" 		=> "#ff6600",
						"type" 		=> "color"
				);

$of_options[] = array( 	"name" 		=> "",
						"desc" 		=> esc_html__("Secondry Background Color","bigbazaar"),
						"id" 		=> "navigation_hover_color",
						"std" 		=> "#e62e04",
						"type" 		=> "color"
				);

$of_options[] = array( 	"name" 		=> esc_html__("Border","bigbazaar"),
						"desc" 		=> esc_html__("Set navigation bar border.","bigbazaar"),
						"id" 		=> "navigation_bar_border",
						"std" 		=> array(
											"width" => "1",
											"style" => "solid",
											"color" => "#e9e9e9"
										),
						"type" 		=> "border"
				);				

$of_options[] = array( 	"name" 		=> esc_html__("Menu Style","bigbazaar"),
						"desc" 		=> "",
						"id" 		=> "menu_styling",
						"std" 		=> "<h3 style=\"margin: 0;\">".esc_html__('Menu Styling','bigbazaar')."</h3>",
						"icon" 		=> true,
						"type" 		=> "info"
				);

$of_options[] = array( 	"name" 		=> esc_html__("Color","bigbazaar"),
						"desc" 		=> esc_html__("Background color","bigbazaar"),
						"id" 		=> "menu_background_color",
						"std" 		=> "#ffffff",
						"type" 		=> "color"
				);	
				
$of_options[] = array( 	"name" 		=> "",
						"desc" 		=> esc_html__("Text Color","bigbazaar"),
						"id" 		=> "menu_text_color",
						"std" 		=> "#333333",
						"type" 		=> "color"
				);

$of_options[] = array( 	"name" 		=> "",
						"desc" 		=> esc_html__("Link Color","bigbazaar"),
						"id" 		=> "menu_link_color",
						"std" 		=> "#333333",
						"type" 		=> "color"
				);
				
$of_options[] = array( 	"name" 		=> "",
						"desc" 		=> esc_html__("Link hover color","bigbazaar"),
						"id" 		=> "menu_link_hover_color",
						"std" 		=> "#ff6600",
						"type" 		=> "color"
				);

$of_options[] = array( 	"name" 		=> "",
						"desc" 		=> esc_html__("Hover Color","bigbazaar"),
						"id" 		=> "menu_hover_color",
						"std" 		=> "#ffffff",
						"type" 		=> "color"
				);	

$of_options[] = array( 	"name" 		=> esc_html__("Border","bigbazaar"),
						"desc" 		=> "Set menu bar border.",
						"id" 		=> "menu_border",
						"std" 		=> array(
											"width" => "1",
											"style" => "solid",
											"color" => "#e9e9e9"
										),
						"type" 		=> "border"
				);				
				
$of_options[] = array( 	"name" 		=> esc_html__("Footer Style","bigbazaar"),
						"desc" 		=> "",
						"id" 		=> "footer_styling",
						"std" 		=> "<h3 style=\"margin: 0;\">".esc_html__('Footer Styling','bigbazaar')."</h3>",
						"icon" 		=> true,
						"type" 		=> "info"
				);

$of_options[] = array( 	"name" 		=> esc_html__("Color","bigbazaar"),
						"desc" 		=> esc_html__("Background Color","bigbazaar"),
						"id" 		=> "footer_background_color",
						"std" 		=> "#363636",
						"type" 		=> "color"
				);	

$of_options[] = array( 	"name" 		=> "",
						"desc" 		=> esc_html__("Heading Color","bigbazaar"),
						"id" 		=> "footer_header_color",
						"std" 		=> "#ffffff",
						"type" 		=> "color"
				);
				
$of_options[] = array( 	"name" 		=> "",
						"desc" 		=> esc_html__("Text Color","bigbazaar"),
						"id" 		=> "footer_text_color",
						"std" 		=> "#999999",
						"type" 		=> "color"
				);

$of_options[] = array( 	"name" 		=> "",
						"desc" 		=> esc_html__("Link Color","bigbazaar"),
						"id" 		=> "footer_link_color",
						"std" 		=> "#999999",
						"type" 		=> "color"
				);

$of_options[] = array( 	"name" 		=> "",
						"desc" 		=> esc_html__("Hover Color","bigbazaar"),
						"id" 		=> "footer_hover_color",
						"std" 		=> "#ffffff",
						"type" 		=> "color"
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Border","bigbazaar"),
						"desc" 		=> esc_html__("Set menu bar border.","bigbazaar"),
						"id" 		=> "footer_border",
						"std" 		=> array(
											"width" => "1",
											"style" => "solid",
											"color" => "#434343"
										),
						"type" 		=> "border"
				);	

$of_options[] = array( 	"name" 		=> esc_html__("Background Pattern Image","bigbazaar"),
						"desc" 		=> esc_html__("Choose pattern pre-defined or upload custom.","bigbazaar"),
						"id" 		=> "choose_footer_background_pattern",
						"std" 		=> 1,
						"on"    	=> esc_html__( "Predefined", "bigbazaar" ),
                        "off"   	=> esc_html__( "Custom", "bigbazaar" ),
						"folds"		=> 0,
						"type" 		=> "switch"
				);
				
$of_options[] = array( 	"name" 		=> "",
						"desc" 		=> esc_html__("Select a background pattern.","bigbazaar"),
						"id" 		=> "footer_background_image",
						"std" 		=> $bg_images_url."none.png",
						"fold"  	=> "choose_footer_background_pattern",
						"type" 		=> "tiles",
						"options" 	=> $bg_images,
				);						
		
$of_options[] = array( 	"name" 		=> esc_html__("Upload Custom Pattern","bigbazaar"),
						"desc" 		=> esc_html__("Upload custom pattern.","bigbazaar"),
						"id" 		=> "custom_footer_background_pattern",
						"std" 		=> BIGBAZAAR_IMAGES."/patterns/pattern.jpg",
						"fold"  	=> "off_" . "choose_footer_background_pattern",
						"type" 		=> "media"
				);

$of_options[] = array( 	"name" 		=> esc_html__("Copyright Style","bigbazaar"),
						"desc" 		=> "",
						"id" 		=> "copyright_styling",
						"std" 		=> "<h3 style=\"margin: 0;\">".esc_html__('Copyright Styling','bigbazaar')."</h3>",
						"icon" 		=> true,
						"type" 		=> "info"
				);

$of_options[] = array( 	"name" 		=> esc_html__("Color","bigbazaar"),
						"desc" 		=> esc_html__("Background Color","bigbazaar"),
						"id" 		=> "copyright_background_color",
						"std" 		=> "#2B2B2B",
						"type" 		=> "color"
				);	
				
$of_options[] = array( 	"name" 		=> "",
						"desc" 		=> esc_html__("Text Color","bigbazaar"),
						"id" 		=> "copyright_text_color",
						"std" 		=> "#999999",
						"type" 		=> "color"
				);

$of_options[] = array( 	"name" 		=> "",
						"desc" 		=> esc_html__("Link Color","bigbazaar"),
						"id" 		=> "copyright_link_color",
						"std" 		=> "#999999",
						"type" 		=> "color"
				);

$of_options[] = array( 	"name" 		=> "",
						"desc" 		=> esc_html__("Hover Color","bigbazaar"),
						"id" 		=> "copyright_hover_color",
						"std" 		=> "#ffffff",
						"type" 		=> "color"
				);				
			
				
/*
* Header
*/
$of_options[] = array( 	"name" 		=> esc_html__("Header","bigbazaar"),
						"type" 		=> "heading"
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Header Layout","bigbazaar"),
						"id" 		=> "header_layout",
						"std" 		=> "header-1",
						"type" 		=> "full_images",
						"options" 	=> array(
							"header-1" 	=> $url . "header/header-1.png",
							"header-2" 	=> $url . "header/header-2.png",
							"header-3" 	=> $url . "header/header-3.png",
							"header-4" 	=> $url . "header/header-4.png",
							"header-5" 	=> $url . "header/header-5.png",
							"header-6" 	=> $url . "header/header-6.png",
							"header-7" 	=> $url . "header/header-7.png",
							"header-8" 	=> $url . "header/header-8.png",
							"header-9" 	=> $url . "header/header-9.png",
							),
				);

$of_options[] = array( 	"name" 		=> esc_html__("Sticky Header","bigbazaar"),
						"id" 		=> "sticky_navigation",
						"std" 		=> 1,
						"on"        => esc_html__("Enable","bigbazaar"),
						"off"       => esc_html__("disable","bigbazaar"),
						"folds"		=> 1,
						"type" 		=> "switch",
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Header Topbar","bigbazaar"),
						"desc" 		=> esc_html__("Show header topbar on header.","bigbazaar"),
						"id" 		=> "show_topbar",
						"std" 		=> 1,
						"on"        => esc_html__("Show","bigbazaar"),
						"off"       => esc_html__("Hide","bigbazaar"),
						"folds"		=> 1,
						"type" 		=> "switch"
				);

$of_options[] = array( 	"name" 		=> esc_html__("Language Switcher","bigbazaar"),
						"desc" 		=> esc_html__("Show language switcher on topbar.","bigbazaar"),
						"id" 		=> "show_language_switcher",
						"std" 		=> 1,
						"on"        => esc_html__("Show","bigbazaar"),
						"off"       => esc_html__("Hide","bigbazaar"),
						"type" 		=> "switch"
				);

$of_options[] = array( 	"name" 		=> esc_html__("Currency Switcher","bigbazaar"),
						"desc" 		=> esc_html__("Show currency switcher on topbar.","bigbazaar"),
						"id" 		=> "show_currency_switcher",
						"std" 		=> 1,
						"on"        => esc_html__("Show","bigbazaar"),
						"off"       => esc_html__("Hide","bigbazaar"),
						"type" 		=> "switch",
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Topbar Email","bigbazaar"),
						"id" 		=> "show_topbar_email",
						"std" 		=> 1,
						"on"        => esc_html__("Show","bigbazaar"),
						"off"       => esc_html__("Hide","bigbazaar"),
						"folds"		=> 1,
						"type" 		=> "switch",
				);	
				
$of_options[] = array( 	"name" 		=> esc_html__("Enter Topbar Email","bigbazaar"),
						"id" 		=> "topbar_email",
						"std" 		=> "info@company.com",
						"fold" 		=> "show_topbar_email",
						"type" 		=> "text"
				);

$of_options[] = array( 	"name" 		=> esc_html__("Topbar Number","bigbazaar"),
						"id" 		=> "show_topbar_number",
						"std" 		=> 1,
						"on"        => esc_html__("Show","bigbazaar"),
						"off"       => esc_html__("Hide","bigbazaar"),
						"folds"		=> 1,
						"type" 		=> "switch",
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Enter Topbar Number","bigbazaar"),
						"desc" 		=> esc_html__("Enter topbar mobile number.","bigbazaar"),
						"id" 		=> "topbar_number",
						"std" 		=> "+81 59832452528",
						"fold" 		=> "show_topbar_number",
						"type" 		=> "text"
				);

$of_options[] = array( 	"name" 		=> esc_html__("Topbar News","bigbazaar"),
						"id" 		=> "show_topbar_news",
						"std" 		=> 1,
						"on"        => esc_html__("Show","bigbazaar"),
						"off"       => esc_html__("Hide","bigbazaar"),
						"folds"		=> 1,
						"type" 		=> "switch",
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Enter Topbar News","bigbazaar"),
						"desc" 		=> esc_html__("Enter topbar news in 'a' tab.","bigbazaar"),
						"id" 		=> "topbar_news",
						"std" 		=> "<a href='#'>Super Sale 50%</a><a href='#'>Big Promotion on Valentine days</a><a href='#'>Gift 15 Voucher for</a>",
						"fold" 		=> "show_topbar_news",
						"type" 		=> "textarea"
				);

$of_options[] = array( 	"name" 		=> esc_html__("Topbar Social Link","bigbazaar"),
						"id" 		=> "show_topbar_social_link",
						"std" 		=> 1,
						"on"        => esc_html__("Show","bigbazaar"),
						"off"       => esc_html__("Hide","bigbazaar"),
						"folds"		=> 1,
						"type" 		=> "switch",
				);
			
$of_options[] = array( 	"name" 		=> esc_html__("Topbar Welcome Message","bigbazaar"),
						"id" 		=> "show_topbar_welcome_message",
						"std" 		=> 0,
						"on"        => esc_html__("Show","bigbazaar"),
						"off"       => esc_html__("Hide","bigbazaar"),
						"folds"		=> 1,
						"type" 		=> "switch",
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Enter Topbar Welcome Message","bigbazaar"),
						"id" 		=> "topbar_welcome_message",
						"std" 		=> "Welcome to my Shop",
						"fold" 		=> "show_topbar_welcome_message",
						"type" 		=> "text"
				);
			
$of_options[] = array( 	"name" 		=> esc_html__("Login Register Popup","bigbazaar"),
						"id" 		=> "show_login_register_popup",
						"std" 		=> 1,
						"on"        => esc_html__("Show","bigbazaar"),
						"off"       => esc_html__("Hide","bigbazaar"),
						"folds"		=> 1,
						"type" 		=> "switch",
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Product Live Search","bigbazaar"),
						"desc" 		=> esc_html__("Live product search or not on header.","bigbazaar"),
						"id" 		=> "live_search",
						"on"        => esc_html__("Enable","bigbazaar"),
						"off"       => esc_html__("Disable","bigbazaar"),
						"std" 		=> 1,
						"type" 		=> "switch"
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Categories Dropdown","bigbazaar"),
						"desc" 		=> esc_html__("Show categories dropdow or not.","bigbazaar"),
						"id" 		=> "show_categories_dropdown",
						"std" 		=> 1,
						"on"        => esc_html__("Show","bigbazaar"),
						"off"       => esc_html__("Hide","bigbazaar"),
						"folds"		=> 1,
						"type" 		=> "switch",
				);	
				
$of_options[] = array( 	"name" 		=> esc_html__("Search Categories Dropdown","bigbazaar"),
						"desc" 		=> esc_html__("Display categories in search categories dropdow.","bigbazaar"),
						"id" 		=> "search_categories",
						"std" 		=> "all",
						"type" 		=> "radio",
						"fold" 		=> "show_categories_dropdown",
						"options" 	=> array("all" => esc_html__("Show All Categories","bigbazaar"),"parent" => esc_html__("Only Parent(top level) Categories","bigbazaar"))
				);

$of_options[] = array( 	"name" 		=> esc_html__("Categories Hierarchical","bigbazaar"),
						"desc" 		=> esc_html__("Show categories in hierarchical (Must be need to select above option Show All Categories).","bigbazaar"),
						"id" 		=> "categories_hierarchical",
						"std" 		=> 1,
						"fold" 		=> "show_categories_dropdown",
						"on"        => esc_html__("Show","bigbazaar"),
						"off"       => esc_html__("Hide","bigbazaar"),
						"type" 		=> "switch"
				);

$of_options[] = array( 	"name" 		=> esc_html__("Live Search By Product SKU","bigbazaar"),
						"desc" 		=> esc_html__("Live search by product sku or not.","bigbazaar"),
						"id" 		=> "enable_search_by_sku",
						"std" 		=> 0,
						"on"        => esc_html__("Yes","bigbazaar"),
						"off"       => esc_html__("No","bigbazaar"),
						"type" 		=> "switch",
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Search Palceholder Text","bigbazaar"),
						"desc" 		=> esc_html__("Enter search palceholder text","bigbazaar"),
						"id" 		=> "search_placeholder_text",
						"std" 		=> "I\'m shopping for...",
						"type" 		=> "text"
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Shopping Categories Title","bigbazaar"),
						"desc" 		=> esc_html__("Enter shopping categories title on header","bigbazaar"),
						"id" 		=> "shopping_categories_text",
						"std" 		=> "Shopping Categories",
						"type" 		=> "text"
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Header Cart","bigbazaar"),
						"id" 		=> "show_header_cart",
						"std" 		=> 1,
						"on"        => esc_html__("Show","bigbazaar"),
						"off"       => esc_html__("Hide","bigbazaar"),
						"folds"		=> 1,
						"type" 		=> "switch",
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Header Services 1","bigbazaar"),
						"desc" 		=> esc_html__("Enter font awesome service icon code.","bigbazaar")." ex. fa-truck",
						"id" 		=> "service_icon1",
						"std" 		=> "fa-phone",
						"type" 		=> "text"
				);
				
$of_options[] = array( 	"name" 		=> "",
						"desc" 		=> esc_html__("Enter service title.","bigbazaar"),
						"id" 		=> "service_title1",
						"std" 		=> "08 143 456 753",
						"type" 		=> "text"
				);
				
$of_options[] = array( 	"name" 		=> "",
						"desc" 		=> esc_html__("Enter service description.","bigbazaar"),
						"id" 		=> "service_des1",
						"std" 		=> "lorem ipsum dolor",
						"type" 		=> "text"
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Header Services 2","bigbazaar"),
						"desc" 		=> esc_html__("Enter font awesome service icon code.","bigbazaar")." ex. fa-truck",
						"id" 		=> "service_icon2",
						"std" 		=> "fa-truck",
						"type" 		=> "text"
				);
				
$of_options[] = array( 	"name" 		=> "",
						"desc" 		=> esc_html__("Enter service title.","bigbazaar"),
						"id" 		=> "service_title2",
						"std" 		=> "Free Shipping",
						"type" 		=> "text"
				);
				
$of_options[] = array( 	"name" 		=> "",
						"desc" 		=> esc_html__("Enter service description.","bigbazaar"),
						"id" 		=> "service_des2",
						"std" 		=> "all order over $100",
						"type" 		=> "text"
				);				
				
$of_options[] = array( 	"name" 		=> esc_html__("Header Services 3","bigbazaar"),
						"desc" 		=> esc_html__("Enter font awesome service icon code.","bigbazaar")." ex. fa-truck",
						"id" 		=> "service_icon3",
						"std" 		=> "fa-refresh",
						"type" 		=> "text"
				);
				
$of_options[] = array( 	"name" 		=> "",
						"desc" 		=> esc_html__("Enter service title.","bigbazaar"),
						"id" 		=> "service_title3",
						"std" 		=> "Return & Exchange",
						"type" 		=> "text"
				);
				
$of_options[] = array( 	"name" 		=> "",
						"desc" 		=> esc_html__("Enter service description.","bigbazaar"),
						"id" 		=> "service_des3",
						"std" 		=> "in 5 working days",
						"type" 		=> "text"
				);				
				
/*
* Footer
*/
$of_options[] = array( 	"name" 		=> esc_html__("Footer","bigbazaar"),
						"type" 		=> "heading"
				);

$of_options[] = array( 	"name" 		=> esc_html__("Footer Layout","bigbazaar"),
						"id" 		=> "footer_layout",
						"std" 		=> "footer-1",
						"type" 		=> "full_images",
						"options" 	=> array(
							"footer-1" 	=> $url . "footer/footer-1.png",
							"footer-2" 	=> $url . "footer/footer-2.png",
							"footer-3" 	=> $url . "footer/footer-3.png",
						)
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Select a Categories","bigbazaar"),
						"desc" 		=> esc_html__("Select multiple parent categories and show sub categories of all parent categories on footer.","bigbazaar"),
						"id" 		=> "product_categories",
						"type" 		=> "multiple_select",
						"options" 	=> $of_product_categories
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Copyright","bigbazaar"),
						"desc" 		=> esc_html__("Enter copyright text.","bigbazaar"),
						"id" 		=> "copyright_text",
						"std" 		=> "&copy; 2016 presslayouts.com. All Rights Reserved.",
						"type" 		=> "textarea"
				);

				
$of_options[] = array( 	"name" 		=> esc_html__("Payment method","bigbazaar"),
						"desc" 		=> esc_html__("Show payment method or hide.","bigbazaar"),
						"id" 		=> "show_payment_method",
						"std" 		=> 1,
						"folds"		=> 1,
						"on"        => esc_html__("Show","bigbazaar"),
						"off"       => esc_html__("Hide","bigbazaar"),
						"type" 		=> "switch"
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Payments Logo Image","bigbazaar"),
						"desc" 		=> esc_html__("Upload payments logo image.","bigbazaar"),
						"id" 		=> "payments_logo",
						"fold"		=> "show_payment_method",
						"std" 		=> BIGBAZAAR_IMAGES."/payments-method.png",
						"type" 		=> "media"
				);
				
/*
* Shop/Products page options
*/				
$of_options[] = array(  "name" 		=> esc_html__("Shop Page","bigbazaar"),
                        "type" 		=> "heading"
					);

$of_options[] = array( 	"name" 		=> esc_html__("Shop Page Layout","bigbazaar"),
						"desc" 		=> esc_html__("Select shop page layout with sidebar postion.","bigbazaar"),
						"id" 		=> "shop_page_layout",
						"std" 		=> "left",
						"folds"		=> 1,
						"type" 		=> "images",
						"options" 	=> array(
							"full_layout" 	=> $url . "full-width.png",
							"left" 	=> $url . "sidebar-left.png",
							"right" 	=> $url . "sidebar-right.png"
						)
				);

$of_options[] = array( 	"name" 		=> "Choose Sidebar Widget Area",
						"desc" 		=> esc_html__("Choose widget display in sidebar on shop page.","bigbazaar"),
						"id" 		=> "shop_page_sidebar_widget",
						"std" 		=> "shop-page",
						"fold"		=> "shop_page_layout",
						"type" 		=> "select",
						"options" 	=> $of_sidebars
				);

$of_options[] = array( 	"name" 		=> esc_html__("Products Per Row","bigbazaar"),
						"desc" 		=> esc_html__("Choose products per row on shop page.","bigbazaar"),
						"id" 		=> "products_per_row",
						"std" 		=> "3",
						"type" 		=> "select",
						"mod" 		=> "mini",
						"options" 	=> array("3"=>"3","4"=>"4","6"=>"6")
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Products Per Row In Mobile","bigbazaar"),
						"id" 		=> "products_per_row_mobile",
						"std" 		=> "1",
						"type" 		=> "select",
						"mod" 		=> "mini",
						"options" 	=> array("1"=>"1","2"=>"2")
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Number Of Products Show Per Page","bigbazaar"),
						"desc" 		=> esc_html__("Number of products show per page on shop page.","bigbazaar"),
						"id" 		=> "products_show_per_page",
						"std" 		=> "12",
						"type" 		=> "select",
						"mod" 		=> "mini",
						"options" 	=> array("6"=>"6","8"=>"8","10"=>"10","12"=>"12","15"=>"15","16"=>"16","18"=>"18","20"=>"20","24"=>"24","27"=>"27","28"=>"28","30"=>"30","32"=>"32","33"=>"33","36"=>"36","40"=>"40")
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Show Grid/List View Button","bigbazaar"),
						"desc" 		=> esc_html__("Show grid view list view button on shop page.","bigbazaar"),
						"id" 		=> "show_grid_list_button",
						"std" 		=> 1,
						"on"        => esc_html__("Show","bigbazaar"),
						"off"       => esc_html__("Hide","bigbazaar"),
						"type" 		=> "switch"
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Switch Product Image On Hover","bigbazaar"),
						"desc" 		=> esc_html__("Switch product image after mouse hover on image.","bigbazaar"),
						"id" 		=> "product_image_switch",
						"std" 		=> 1,
						"type" 		=> "switch"
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Load More Products Type","bigbazaar"),
						"desc" 		=> esc_html__("Choose styles pagination/load more products on shop page.","bigbazaar"),
						"id" 		=> "load_more_products",
						"std" 		=> "default_pagination",
						"type" 		=> "select",
						"options" 	=> array("default_pagination"=>esc_html__("Default Pagination","bigbazaar"),"infinity_scroll"=>esc_html__("Infinity Scroll","bigbazaar"),"more_button"=>esc_html__("Load More Button","bigbazaar"),"pagination"=>esc_html__("AJAX Pagination","bigbazaar"))
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Load More Button Text","bigbazaar"),
						"desc" 		=> esc_html__("Load more button text.","bigbazaar"),
						"id" 		=> "load_more_button_text",
						"std" 		=> "Load More",
						"type" 		=> "text"
				);

$of_options[] = array( 	"name" 		=> esc_html__("Enable Lazy Load","bigbazaar"),
						"desc" 		=> esc_html__("Enable lazy load product image.","bigbazaar"),
						"id" 		=> "enable_lazy_load",
						"std" 		=> 0,
						"on"        => esc_html__("Enable","bigbazaar"),
						"off"       => esc_html__("Disable","bigbazaar"),
						"folds"		=> 1,
						"type" 		=> "switch"
				);			

$of_options[] = array( 	"name" 		=> esc_html__("Lazy Load Animation Style","bigbazaar"),
						"desc" 		=> esc_html__("Different styles of lazy load animation.","bigbazaar"),
						"id" 		=> "load_animation_style",
						"std" 		=> "fadeInUp",
						"fold" 		=> "enable_lazy_load",
						"type" 		=> "select",
						"options" 	=>  array('bounce' => 'bounce', 'flash' => 'flash', 'pulse' => 'pulse', 'rubberBand' => 'rubberBand', 'shake' => 'shake', 'swing' => 'swing', 'tada' => 'tada', 'bounceIn' => 'bounceIn', 'bounceInDown' => 'bounceInDown', 'bounceInLeft' => 'bounceInLeft' , 'bounceInRight' => 'bounceInRight', 'bounceInUp' => 'bounceInUp', 'fadeIn' => 'fadeIn'    , 'fadeInDown' => 'fadeInDown', 'fadeInDownBig' => 'fadeInDownBig', 'fadeInLeft' => 'fadeInLeft' , 'fadeInLeftBig' => 'fadeInLeftBig', 'fadeInRight' => 'fadeInRight', 'fadeInRightBig' => 'fadeInRightBig', 'fadeInUp' => 'fadeInUp', 'fadeInUpBig' => 'fadeInUpBig', 'zoomIn' => 'zoomIn', 'zoomInDown' => 'zoomInDown', 'zoomInLeft' => 'zoomInLeft', 'zoomInRight' => 'zoomInRight', 'zoomInUp' => 'zoomInUp')
				);					

$of_options[] = array( 	"name" 		=> esc_html__("Products Per Page Option","bigbazaar"),
						"desc" 		=> esc_html__("Show products per page option on shop page.","bigbazaar"),
						"id" 		=> "show_products_per_page",
						"std" 		=> 1,
						"on"        => esc_html__("Show","bigbazaar"),
						"off"       => esc_html__("Hide","bigbazaar"),
						"type" 		=> "switch"
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Product Price","bigbazaar"),
						"desc" 		=> esc_html__("Show product price on products listing.","bigbazaar"),
						"id" 		=> "show_product_price",
						"std" 		=> 1,
						"on"        => esc_html__("Show","bigbazaar"),
						"off"       => esc_html__("Hide","bigbazaar"),
						"type" 		=> "switch"
				);

$of_options[] = array( 	"name" 		=> esc_html__("Product Rating","bigbazaar"),
						"desc" 		=> esc_html__("Show product rating on products listing.","bigbazaar"),
						"id" 		=> "show_product_rating",
						"std" 		=> 1,
						"on"        => esc_html__("Show","bigbazaar"),
						"off"       => esc_html__("Hide","bigbazaar"),
						"type" 		=> "switch"
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Product Buttons","bigbazaar"),
						"desc" 		=> esc_html__("Show product buttons in product listing.","bigbazaar"),
						"id" 		=> "show_product_buttons",
						"std" 		=> 1,
						"on"        => esc_html__("Show","bigbazaar"),
						"off"       => esc_html__("Hide","bigbazaar"),
						"folds"		=> 1,
						"type" 		=> "switch"
				);

$of_options[] = array( 	"name" 		=> esc_html__("Cart Button","bigbazaar"),
						"desc" 		=> esc_html__("Show cart button in products listing. ","bigbazaar"),
						"id" 		=> "show_cart_button",
						"std" 		=> 1,
						"on"        => esc_html__("Show","bigbazaar"),
						"off"       => esc_html__("Hide","bigbazaar"),
						"fold" 		=> "show_product_buttons",
						"type" 		=> "switch"
				);

$of_options[] = array( 	"name" 		=> esc_html__("Wishlist Button","bigbazaar"),
						"desc" 		=> esc_html__("Show wishlist button in products listing.","bigbazaar"),
						"id" 		=> "show_wishlist_button",
						"std" 		=> 1,
						"on"        => esc_html__("Show","bigbazaar"),
						"off"       => esc_html__("Hide","bigbazaar"),
						"fold" 		=> "show_product_buttons",
						"type" 		=> "switch"
				);

$of_options[] = array( 	"name" 		=> esc_html__("Compare Button","bigbazaar"),
						"desc" 		=> esc_html__("Show compare button in products listing.","bigbazaar"),
						"id" 		=> "show_compare_button",
						"std" 		=> 1,
						"on"        => esc_html__("Show","bigbazaar"),
						"off"       => esc_html__("Hide","bigbazaar"),
						"fold" 		=> "show_product_buttons",
						"type" 		=> "switch"
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Quick View Button","bigbazaar"),
						"desc" 		=> esc_html__("Show quick view button in products listing.","bigbazaar"),
						"id" 		=> "show_quick_view_button",
						"std" 		=> 1,
						"on"        => esc_html__("Show","bigbazaar"),
						"off"       => esc_html__("Hide","bigbazaar"),
						"fold" 		=> "show_product_buttons",
						"type" 		=> "switch"
				);

$of_options[] = array( 	"name" 		=> esc_html__("short Description","bigbazaar"),
						"desc" 		=> esc_html__("Show short description in list view on shop page.","bigbazaar"),
						"id" 		=> "show_short_description",
						"std" 		=> 1,
						"type" 		=> "switch"
				);

$of_options[] = array( 	"name" 		=> esc_html__("Product Highlight Labels","bigbazaar"),
						"desc" 		=> esc_html__("Show product highlight labels sale, hot and out of stock on product.","bigbazaar"),
						"id" 		=> "show_product_highlight_labels",
						"std" 		=> 1,
						"on"        => esc_html__("Show","bigbazaar"),
						"off"       => esc_html__("Hide","bigbazaar"),
						"folds"		=> 1,
						"type" 		=> "switch"
				);

$of_options[] = array( 	"name" 		=> esc_html__("Product Highlight Label Sale","bigbazaar"),
						"desc" 		=> esc_html__("Show product highlight label sale on product.","bigbazaar"),
						"id" 		=> "show_product_highlight_label_sale",
						"std" 		=> 1,
						"on"        => esc_html__("Show","bigbazaar"),
						"off"       => esc_html__("Hide","bigbazaar"),
						"fold" 		=> "show_product_highlight_labels",
						"type" 		=> "switch"
				);

$of_options[] = array( 	"name" 		=> esc_html__("Product Highlight Label Hot","bigbazaar"),
						"desc" 		=> esc_html__("Show product highlight label hot on product.","bigbazaar"),
						"id" 		=> "show_product_highlight_label_hot",
						"std" 		=> 1,
						"on"        => esc_html__("Show","bigbazaar"),
						"off"       => esc_html__("Hide","bigbazaar"),
						"fold" 		=> "show_product_highlight_labels",
						"type" 		=> "switch"
				);

$of_options[] = array( 	"name" 		=> esc_html__("Product Highlight Label Out Of Stock","bigbazaar"),
						"desc" 		=> esc_html__("Show product highlight label out of stock on product.","bigbazaar"),
						"id" 		=> "show_product_highlight_label_outofstock",
						"std" 		=> 1,
						"on"        => esc_html__("Show","bigbazaar"),
						"off"       => esc_html__("Hide","bigbazaar"),
						"fold" 		=> "show_product_highlight_labels",
						"type" 		=> "switch"
				);

$of_options[] = array( 	"name" 		=> esc_html__("Out Of Stock Product Opacity.","bigbazaar"),
						"desc" 		=> esc_html__("Apply opacity of out of stock product.","bigbazaar"),
						"id" 		=> "out_stock_opacity",
						"std" 		=> "6",
						"min" 		=> "0",
						"step"		=> "1",
						"max" 		=> "10",
						"type" 		=> "sliderui" 
				);
				
/*
* Single product page options
*/				
$of_options[] = array(  "name" 		=> esc_html__("Product Page","bigbazaar"),
                        "type" 		=> "heading"
					);

$of_options[] = array( 	"name" 		=> esc_html__("Single Product Page Layout","bigbazaar"),
						"desc" 		=> esc_html__("Select product page layout with sidebar postion.","bigbazaar"),
						"id" 		=> "single_product_page_layout",
						"std" 		=> "none-left",
						"folds"		=> 1,
						"type" 		=> "images",
						"options" 	=> array(
							"none-left" 	=> $url . "thumbnail/none_left.png",
							"none-right" 	=> $url . "thumbnail/none_right.png",
							"full-layout" 	=> $url . "thumbnail/none.png",
							"right" 		=> $url . "thumbnail/right.png",
							"left" 			=> $url . "thumbnail/left.png",
						)
				);

$of_options[] = array( 	"name" 		=> "Choose Sidebar Widget Area",
						"desc" 		=> esc_html__("Choose widget display in sidebar on single product page.","bigbazaar"),
						"id" 		=> "single_product_page_sidebar_widget",
						"std" 		=> "single-product",
						"type" 		=> "select",
						"options" 	=> $of_sidebars
				);

$of_options[] = array( 	"name" 		=> esc_html__("Product Image Zoom","bigbazaar"),
						"id" 		=> "enable_product_image_zoom",
						"std" 		=> 1,
						"on"        => esc_html__("Enable","bigbazaar"),
						"off"       => esc_html__("Disable","bigbazaar"),
						"type" 		=> "switch"
				);				
				
$of_options[] = array( 	"name" 		=> esc_html__("Product Highlight Labels","bigbazaar"),
						"desc" 		=> esc_html__("Show product highlight labels sale, hot and out of stock on product.","bigbazaar"),
						"id" 		=> "show_single_product_highlight_labels",
						"std" 		=> 1,
						"on"        => esc_html__("Show","bigbazaar"),
						"off"       => esc_html__("Hide","bigbazaar"),
						"folds"		=> 1,
						"type" 		=> "switch"
				);

$of_options[] = array( 	"name" 		=> esc_html__("Product Highlight Label Sale","bigbazaar"),
						"desc" 		=> esc_html__("Show product highlight label sale on product.","bigbazaar"),
						"id" 		=> "show_single_product_highlight_label_sale",
						"std" 		=> 1,
						"on"        => esc_html__("Show","bigbazaar"),
						"off"       => esc_html__("Hide","bigbazaar"),
						"fold" 		=> "show_single_product_highlight_labels",
						"type" 		=> "switch"
				);

$of_options[] = array( 	"name" 		=> esc_html__("Product Highlight Label Hot","bigbazaar"),
						"desc" 		=> esc_html__("Show product highlight label hot on product.","bigbazaar"),
						"id" 		=> "show_single_product_highlight_label_hot",
						"std" 		=> 1,
						"on"        => esc_html__("Show","bigbazaar"),
						"off"       => esc_html__("Hide","bigbazaar"),
						"fold" 		=> "show_single_product_highlight_labels",
						"type" 		=> "switch"
				);

$of_options[] = array( 	"name" 		=> esc_html__("Product Highlight Label Out Of Stock","bigbazaar"),
						"desc" 		=> esc_html__("Show product highlight label out of stock on product.","bigbazaar"),
						"id" 		=> "show_single_product_highlight_label_outofstock",
						"std" 		=> 1,
						"on"        => esc_html__("Show","bigbazaar"),
						"off"       => esc_html__("Hide","bigbazaar"),
						"fold" 		=> "show_single_product_highlight_labels",
						"type" 		=> "switch"
				);				

$of_options[] = array( 	"name" 		=> esc_html__("Product Next/Previous Navigation","bigbazaar"),
						"desc" 		=> esc_html__("Show product next previous navigation.","bigbazaar"),
						"id" 		=> "show_product_navigation",
						"std" 		=> 1,
						"on"        => esc_html__("Show","bigbazaar"),
						"off"       => esc_html__("Hide","bigbazaar"),
						"type" 		=> "switch"
				);				
$of_options[] = array( 	"name" 		=> esc_html__("Product Price","bigbazaar"),
						"id" 		=> "single_product_price",
						"std" 		=> 1,
						"on"        => esc_html__("Show","bigbazaar"),
						"off"       => esc_html__("Hide","bigbazaar"),
						"type" 		=> "switch"
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Product Rating","bigbazaar"),
						"desc" 		=> esc_html__("Show product rating.","bigbazaar"),
						"id" 		=> "show_single_product_rating",
						"std" 		=> 1,
						"on"        => esc_html__("Show","bigbazaar"),
						"off"       => esc_html__("Hide","bigbazaar"),
						"type" 		=> "switch"
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Product Meta","bigbazaar"),
						"desc" 		=> esc_html__("Show or hide product brand, category, tag, etc...","bigbazaar"),
						"id" 		=> "single_product_meta",
						"std" 		=> 1,
						"on"        => esc_html__("Show","bigbazaar"),
						"off"       => esc_html__("Hide","bigbazaar"),
						"type" 		=> "switch"
				);

$of_options[] = array( 	"name" 		=> esc_html__("Product Sharing buttons","bigbazaar"),
						"desc" 		=> esc_html__("Show product sharing buttons.","bigbazaar"),
						"id" 		=> "show_single_product_sharing",
						"std" 		=> 1,
						"on"        => esc_html__("Show","bigbazaar"),
						"off"       => esc_html__("Hide","bigbazaar"),
						"folds"		=> 1,
						"type" 		=> "switch"
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Size Guide","bigbazaar"),
						"desc" 		=> esc_html__("Show size guide.","bigbazaar"),
						"id" 		=> "enable_size_guide",
						"std" 		=> 0,
						"on"        => esc_html__("Show","bigbazaar"),
						"off"       => esc_html__("Hide","bigbazaar"),
						"folds"		=> 0,
						"type" 		=> "switch"
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Choose Size Guide Image","bigbazaar"),
						"desc" 		=> esc_html__("You use global image size guide for all products.","bigbazaar"),
						"id" 		=> "size_guide_image",
						"std" 		=> BIGBAZAAR_IMAGES."/sizeguide.png",
						"fold" 		=> "enable_size_guide",
						"type" 		=> "media"
				);				
				
$of_options[] = array( 	"name" 		=> esc_html__("Related Products","bigbazaar"),
						"desc" 		=> esc_html__("Show related products.","bigbazaar"),
						"id" 		=> "show_related_products",
						"std" 		=> 1,
						"on"        => esc_html__("Show","bigbazaar"),
						"off"       => esc_html__("Hide","bigbazaar"),
						"type" 		=> "switch"
				);

$of_options[] = array( 	"name" 		=> esc_html__("Up Sell Products","bigbazaar"),
						"desc" 		=> esc_html__("Show up sell/you may also like products.","bigbazaar"),
						"id" 		=> "show_upsell_products",
						"std" 		=> 1,
						"on"        => esc_html__("Show","bigbazaar"),
						"off"       => esc_html__("Hide","bigbazaar"),
						"type" 		=> "switch"
				);	

$of_options[] = array( 	"name" 		=> esc_html__("Related/Up Sell Products Show Per Row","bigbazaar"),
						"desc" 		=> esc_html__("Select related/up sell products per row.","bigbazaar"),
						"id" 		=> "related_upsell_products_per_row",
						"std" 		=> "3",
						"type" 		=> "select",
						"mod" 		=> "mini",
						"options" 	=> array("3"=>"3","4"=>"4","6"=>"6")
				);

$of_options[] = array( 	"name" 		=> esc_html__("Carousel Autoplay Mode","bigbazaar"),
						"desc" 		=> esc_html__("Enables related/up sell products carousel autoplay.","bigbazaar"),
						"id" 		=> "related_upsell_auto_play",
						"std" 		=> 0,
						"on"        => esc_html__("Enable","bigbazaar"),
						"off"       => esc_html__("Disable","bigbazaar"),
						"type" 		=> "switch"
				);	

$of_options[] = array( 	"name" 		=> esc_html__("Carousel Navigation","bigbazaar"),
						"desc" 		=> esc_html__("Show related/up sell/you may also like products carousel navigation.","bigbazaar"),
						"id" 		=> "related_upsell_navigation",
						"std" 		=> 1,
						"on"        => esc_html__("Show","bigbazaar"),
						"off"       => esc_html__("Hide","bigbazaar"),
						"type" 		=> "switch"
				);				

/*
* Blog options
*/					
$of_options[] = array( 	"name" 		=> esc_html__("Blog","bigbazaar"),
						"type" 		=> "heading"
				);			

$of_options[] = array( 	"name" 		=> esc_html__("Select Blog Page Layout","bigbazaar"),
						"desc" 		=> esc_html__("Select blog/post page layout with sidebar postion.","bigbazaar"),
						"id" 		=> "blog_page_layout",
						"std" 		=> "right",
						"type" 		=> "images",
						"options" 	=> array(
							"none" 	=> $url . "full-width.png",
							"left" 	=> $url . "sidebar-left.png",
							"right" 	=> $url . "sidebar-right.png"
						)
				);

$of_options[] = array( 	"name" 		=> "Choose Sidebar Widget Area",
						"desc" 		=> esc_html__("Choose widget display in sidebar on blog page.","bigbazaar"),
						"id" 		=> "blog_page_sidebar_widget",
						"std" 		=> "sidebar-1",
						"type" 		=> "select",
						"options" 	=> $of_sidebars
				);

$of_options[] = array( 	"name" 		=> esc_html__("Choose Blog Style","bigbazaar"),
						"desc" 		=> esc_html__("Choose blog style.","bigbazaar"),
						"id" 		=> "blog_page_style",
						"std" 		=> "large_image",
						"type" 		=> "select",
						"options" 	=> array("large_image"=>esc_html__("Large Image","bigbazaar"),"small_image"=>esc_html__("Small Image","bigbazaar"),"masonry_grid"=>esc_html__("Masonry Grid","bigbazaar"))						
				);

$of_options[] = array( 	"name" 		=> esc_html__("Choose Blog Columns","bigbazaar"),
						"desc" 		=> esc_html__("Show post column of the post/blog page. Column option apply only on above masorny grid option.","bigbazaar"),
						"id" 		=> "blog_page_show_column",
						"std" 		=> "two",
						"type" 		=> "select",
						"options" 	=> array("two"=>esc_html__("2 Columns","bigbazaar"),"three"=>esc_html__("3 Columns","bigbazaar"),"four"=>esc_html__("4 Columns","bigbazaar"))						
				);

$of_options[] = array( 	"name" 		=> esc_html__("Blog Page Breadsrumb","bigbazaar"),
						"desc" 		=> esc_html__("Show breadsrumb on blog page or not.","bigbazaar"),
						"id" 		=> "show_blog_page_breadsrumb",
						"std" 		=> 1,
						"on"        => esc_html__("Show","bigbazaar"),
						"off"       => esc_html__("Hide","bigbazaar"),
						"type" 		=> "switch"
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Blog Page Title","bigbazaar"),
						"desc" 		=> esc_html__("Show title on blog page or not.","bigbazaar"),
						"id" 		=> "show_blog_page_title",
						"std" 		=> 1,
						"on"        => esc_html__("Show","bigbazaar"),
						"off"       => esc_html__("Hide","bigbazaar"),
						"type" 		=> "switch"
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Show Excerpt","bigbazaar"),
						"desc" 		=> esc_html__("Show excerpt.","bigbazaar"),
						"id" 		=> "show_blog_excerpt",
						"std" 		=> 0,
						"on"        => esc_html__("Show","bigbazaar"),
						"off"       => esc_html__("Hide","bigbazaar"),
						"folds"		=> 1,
						"type" 		=> "switch"
				);

$of_options[] = array( 	"name" 		=> esc_html__("Excerpt Length (words)","bigbazaar"),
						"desc" 		=> esc_html__("Show blogs listing content length (words).","bigbazaar"),
						"id" 		=> "blog_excerpt_length",
						"std" 		=> 75,
						"fold"		=> "show_blog_excerpt",
						"type" 		=> "text"
				);

$of_options[] = array( 	"name" 		=> esc_html__("Read More Button","bigbazaar"),
						"desc" 		=> esc_html__("Show read more button.","bigbazaar"),
						"id" 		=> "show_readmore",
						"std" 		=> 1,
						"on"        => esc_html__("Show","bigbazaar"),
						"off"       => esc_html__("Hide","bigbazaar"),
						"type" 		=> "switch"
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Post Meta","bigbazaar"),
						"desc" 		=> esc_html__("Show post meta or not on blog/post page.","bigbazaar"),
						"id" 		=> "show_postmeta",
						"std" 		=> 1,
						"on"        => esc_html__("Show","bigbazaar"),
						"off"       => esc_html__("Hide","bigbazaar"),
						"type" 		=> "switch"
				);
			
$of_options[] = array( 	"name" 		=> esc_html__("Social Share Links","bigbazaar"),
						"desc" 		=> esc_html__("Show post social share link on post page.","bigbazaar"),
						"id" 		=> "show_post_share_link",
						"std" 		=> 1,
						"on"        => esc_html__("Show","bigbazaar"),
						"off"       => esc_html__("Hide","bigbazaar"),
						"type" 		=> "switch"
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Post Navigation","bigbazaar"),
						"desc" 		=> esc_html__("Show next previous post on single post navigation.","bigbazaar"),
						"id" 		=> "show_single_post_navigation",
						"std" 		=> 1,
						"on"        => esc_html__("Show","bigbazaar"),
						"off"       => esc_html__("Hide","bigbazaar"),
						"type" 		=> "switch"
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Related Post","bigbazaar"),
						"desc" 		=> esc_html__("Show related post.","bigbazaar"),
						"id" 		=> "show_related_post",
						"std" 		=> 1,
						"on"        => esc_html__("Show","bigbazaar"),
						"off"       => esc_html__("Hide","bigbazaar"),
						"folds"		=> 1,
						"type" 		=> "switch"
				);

$of_options[] = array( 	"name" 		=> esc_html__("Blog Show Per Row","bigbazaar"),
						"desc" 		=> esc_html__("show number of blog per row.","bigbazaar"),
						"id" 		=> "blog_per_row",
						"std" 		=> "3",
						"fold"		=> 'show_related_post',
						"type" 		=> "select",
						"mod" 		=> "mini",
						"options" 	=> array("2"=>"2","3"=>"3","4"=>"4","6"=>"6")
				);

$of_options[] = array( 	"name" 		=> esc_html__("Carousel Autoplay Mode","bigbazaar"),
						"desc" 		=> esc_html__("Enables blog carousel autoplay.","bigbazaar"),
						"id" 		=> "blog_carousel_auto_play",
						"std" 		=> 0,
						"on"        => esc_html__("Enable","bigbazaar"),
						"off"       => esc_html__("Disable","bigbazaar"),
						"fold"		=> 'show_related_post',
						"type" 		=> "switch"
				);

$of_options[] = array( 	"name" 		=> esc_html__("Hide Carousel Navigation","bigbazaar"),
						"desc" 		=> esc_html__("Show blog carousel navigation.","bigbazaar"),
						"id" 		=> "blog_carousel_navigation",
						"std" 		=> 0,
						"on"        => esc_html__("Show","bigbazaar"),
						"off"       => esc_html__("Hide","bigbazaar"),
						"fold"		=> 'show_related_post',
						"type" 		=> "switch"
				);

$of_options[] = array( 	"name" 		=> esc_html__("Enable Carousel loop","bigbazaar"),
						"desc" 		=> esc_html__("Enable blog carousel continue loop.","bigbazaar"),
						"id" 		=> "blog_carousel_loop",
						"std" 		=> 0,
						"on"        => esc_html__("Enable","bigbazaar"),
						"off"       => esc_html__("Disable","bigbazaar"),
						"fold"		=> 'show_related_post',
						"type" 		=> "switch"
				);				
				
				
/*
* Portfolio options
*/					
$of_options[] = array( 	"name" 		=> esc_html__("Portfolio","bigbazaar"),
						"type" 		=> "heading"
				);			

$of_options[] = array( 	"name" 		=> esc_html__("Portfolio Archive Page","bigbazaar"),
		"desc" 		=> "",
		"id" 		=> "portfolio_archive",
		"std" 		=> "<h3 style=\"margin: 0;\">Portfolio Archive Page Settings</h3>",
		"icon" 		=> true,
		"type" 		=> "info"
);

$of_options[] = array( 	"name" 		=> esc_html__("Select Archive Page Layout","bigbazaar"),
						"desc" 		=> esc_html__("Select portfolio archive page layout with sidebar postion.","bigbazaar"),
						"id" 		=> "portfolio_archive_page_layout",
						"std" 		=> "right",
						"type" 		=> "images",
						"options" 	=> array(
							"none" 	=> $url . "full-width.png",
							"left" 	=> $url . "sidebar-left.png",
							"right" 	=> $url . "sidebar-right.png"
						)
				);

$of_options[] = array( 	"name" 		=> "Choose Sidebar Widget Area",
						"desc" 		=> esc_html__("Choose widget display in sidebar on portfolio archive page.","bigbazaar"),
						"id" 		=> "portfolio_archive_page_sidebar_widget",
						"std" 		=> "sidebar-1",
						"type" 		=> "select",
						"options" 	=> $of_sidebars
				);

$of_options[] = array( 	"name" 		=> esc_html__("Choose Portfolio Style","bigbazaar"),
						"desc" 		=> esc_html__("Choose portfolio style.","bigbazaar"),
						"id" 		=> "portfolio_archive_page_style",
						"std" 		=> "normal_grid",
						"type" 		=> "select",
						"options" 	=> array("normal_grid"=>esc_html__("Normal Grid","bigbazaar"),"masonry_grid"=>esc_html__("Masonry Grid","bigbazaar"),"timeline"=>esc_html__("Timeline","bigbazaar"))						
				);

$of_options[] = array( 	"name" 		=> esc_html__("Choose Portfolio Columns","bigbazaar"),
						"desc" 		=> esc_html__("Choose portfolio column of the portfolio page.","bigbazaar"),
						"id" 		=> "portfolio_archive_page_show_column",
						"std" 		=> "two",
						"type" 		=> "select",
						"options" 	=> array("one"=>esc_html__("1 Columns","bigbazaar"),"two"=>esc_html__("2 Columns","bigbazaar"),"three"=>esc_html__("3 Columns","bigbazaar"),"four"=>esc_html__("4 Columns","bigbazaar"))						
				);

$of_options[] = array( 	"name" 		=> esc_html__("Archive Page Breadsrumb","bigbazaar"),
						"desc" 		=> esc_html__("Show breadsrumb on archive page or not.","bigbazaar"),
						"id" 		=> "show_portfolio_archive_page_breadsrumb",
						"std" 		=> 1,
						"on"        => esc_html__("Show","bigbazaar"),
						"off"       => esc_html__("Hide","bigbazaar"),
						"type" 		=> "switch"
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Archive Page Title","bigbazaar"),
						"desc" 		=> esc_html__("Show title on archive page or not.","bigbazaar"),
						"id" 		=> "show_portfolio_archive_page_title",
						"std" 		=> 1,
						"on"        => esc_html__("Show","bigbazaar"),
						"off"       => esc_html__("Hide","bigbazaar"),
						"type" 		=> "switch"
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Single Portfolio Page Settings","bigbazaar"),
		"desc" 		=> "",
		"id" 		=> "single_portfolio",
		"std" 		=> "<h3 style=\"margin: 0;\">Single Portfolio Page Settings</h3>",
		"icon" 		=> true,
		"type" 		=> "info"
);
				
$of_options[] = array( 	"name" 		=> esc_html__("Project Informations","bigbazaar"),
						"desc" 		=> esc_html__("Show porject informations on project page.","bigbazaar"),
						"id" 		=> "show_project_info",
						"std" 		=> 1,
						"on"        => esc_html__("Show","bigbazaar"),
						"off"       => esc_html__("Hide","bigbazaar"),
						"type" 		=> "switch"
				);
	
$of_options[] = array( 	"name" 		=> esc_html__("Social Share Links","bigbazaar"),
						"desc" 		=> esc_html__("Show porject social share link on project page.","bigbazaar"),
						"id" 		=> "show_project_share_link",
						"std" 		=> 1,
						"on"        => esc_html__("Show","bigbazaar"),
						"off"       => esc_html__("Hide","bigbazaar"),
						"type" 		=> "switch"
				);
	
$of_options[] = array( 	"name" 		=> esc_html__("Project Navigation","bigbazaar"),
						"desc" 		=> esc_html__("Show porject navigation on project page.","bigbazaar"),
						"id" 		=> "show_project_navigation",
						"std" 		=> 1,
						"on"        => esc_html__("Show","bigbazaar"),
						"off"       => esc_html__("Hide","bigbazaar"),
						"type" 		=> "switch"
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Related Projects","bigbazaar"),
						"desc" 		=> esc_html__("Show related projects on project page.","bigbazaar"),
						"id" 		=> "show_related_projects",
						"std" 		=> 1,
						"on"        => esc_html__("Show","bigbazaar"),
						"off"       => esc_html__("Hide","bigbazaar"),
						"type" 		=> "switch"
				);

/*
* Testimonial options
*/					
$of_options[] = array( 	"name" 		=> esc_html__("Testimonial","bigbazaar"),
						"type" 		=> "heading"
				);			

$of_options[] = array( 	"name" 		=> esc_html__("Testimonial Archive Page","bigbazaar"),
		"desc" 		=> "",
		"id" 		=> "testimonial_archive",
		"std" 		=> "<h3 style=\"margin: 0;\">Testimonial Archive Page Settings</h3>",
		"icon" 		=> true,
		"type" 		=> "info"
);

$of_options[] = array( 	"name" 		=> esc_html__("Select Archive Page Layout","bigbazaar"),
						"desc" 		=> esc_html__("Select archive page layout with sidebar postion.","bigbazaar"),
						"id" 		=> "testimonialt_archive_page_layout",
						"std" 		=> "right",
						"type" 		=> "images",
						"options" 	=> array(
							"none" 	=> $url . "full-width.png",
							"left" 	=> $url . "sidebar-left.png",
							"right" 	=> $url . "sidebar-right.png"
						)
				);

$of_options[] = array( 	"name" 		=> "Choose Sidebar Widget Area",
						"desc" 		=> esc_html__("Choose widget display in sidebar on archive page.","bigbazaar"),
						"id" 		=> "testimonialt_archive_page_sidebar_widget",
						"std" 		=> "sidebar-1",
						"type" 		=> "select",
						"options" 	=> $of_sidebars
				);

$of_options[] = array( 	"name" 		=> esc_html__("Choose Testimonial Columns","bigbazaar"),
						"desc" 		=> esc_html__("Show testimonial column of the testimonial archive page.","bigbazaar"),
						"id" 		=> "testimonialt_archive_page_show_column",
						"std" 		=> "three",
						"type" 		=> "select",
						"options" 	=> array("two"=>esc_html__("2 Columns","bigbazaar"),"three"=>esc_html__("3 Columns","bigbazaar"),"four"=>esc_html__("4 Columns","bigbazaar"))						
				);

$of_options[] = array( 	"name" 		=> esc_html__("Archive Page Breadsrumb","bigbazaar"),
						"desc" 		=> esc_html__("Show breadsrumb on archive page or not.","bigbazaar"),
						"id" 		=> "show_testimonialt_archive_page_breadsrumb",
						"std" 		=> 1,
						"on"        => esc_html__("Show","bigbazaar"),
						"off"       => esc_html__("Hide","bigbazaar"),
						"type" 		=> "switch"
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Archive Page Title","bigbazaar"),
						"desc" 		=> esc_html__("Show title on archive page or not.","bigbazaar"),
						"id" 		=> "show_testimonialt_archive_page_title",
						"std" 		=> 1,
						"on"        => esc_html__("Show","bigbazaar"),
						"off"       => esc_html__("Hide","bigbazaar"),
						"type" 		=> "switch"
				);

$of_options[] = array( 	"name" 		=> esc_html__("Testimonial Page","bigbazaar"),
		"desc" 		=> "",
		"id" 		=> "testimonial_page",
		"std" 		=> "<h3 style=\"margin: 0;\">Single Testimonial Page Settings</h3>",
		"icon" 		=> true,
		"type" 		=> "info"
);

$of_options[] = array( 	"name" 		=> esc_html__("Select Testimonial Page Layout","bigbazaar"),
						"desc" 		=> esc_html__("Select testimonial page layout with sidebar postion.","bigbazaar"),
						"id" 		=> "testimonialt_page_layout",
						"std" 		=> "right",
						"type" 		=> "images",
						"options" 	=> array(
							"none" 	=> $url . "full-width.png",
							"left" 	=> $url . "sidebar-left.png",
							"right" 	=> $url . "sidebar-right.png"
						)
				);

$of_options[] = array( 	"name" 		=> "Choose Sidebar Widget Area",
						"desc" 		=> esc_html__("Choose widget display in sidebar on testimonial page.","bigbazaar"),
						"id" 		=> "testimonialt_page_sidebar_widget",
						"std" 		=> "sidebar-1",
						"type" 		=> "select",
						"options" 	=> $of_sidebars
				);

$of_options[] = array( 	"name" 		=> esc_html__("Testimonial Page Breadsrumb","bigbazaar"),
						"desc" 		=> esc_html__("Show breadsrumb on testimonial page or not.","bigbazaar"),
						"id" 		=> "show_testimonialt_page_breadsrumb",
						"std" 		=> 1,
						"on"        => esc_html__("Show","bigbazaar"),
						"off"       => esc_html__("Hide","bigbazaar"),
						"type" 		=> "switch"
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Testimonial Page Title","bigbazaar"),
						"desc" 		=> esc_html__("Show title on testimonial page or not.","bigbazaar"),
						"id" 		=> "show_testimonialt_page_title",
						"std" 		=> 1,
						"on"        => esc_html__("Show","bigbazaar"),
						"off"       => esc_html__("Hide","bigbazaar"),
						"type" 		=> "switch"
				);

/*
* Sidebar options
*/					
$of_options[] = array( 	"name" 		=> esc_html__("Sidebar","bigbazaar"),
						"type" 		=> "heading"
				);	

$of_options[] = array( 	"name" 		=> esc_html__("Widget Toggle","bigbazaar"),
						"desc" 		=> esc_html__("Enable page widget toggle or not.","bigbazaar"),
						"id" 		=> "enable_widget_toggle",
						"std" 		=> 1,
						"on"        => esc_html__("Enable","bigbazaar"),
						"off"       => esc_html__("Disable","bigbazaar"),
						"type" 		=> "switch"
				);

$of_options[] = array( 	"name" 		=> esc_html__("Widget Menu Toggle","bigbazaar"),
						"desc" 		=> esc_html__("Enable page widget menu toggle or not.","bigbazaar"),
						"id" 		=> "enable_widget_menu_toggle",
						"std" 		=> 1,
						"on"        => esc_html__("Enable","bigbazaar"),
						"off"       => esc_html__("Disable","bigbazaar"),
						"type" 		=> "switch"
				);

$of_options[] = array( 	"name" 		=> esc_html__("Widget Items Hide","bigbazaar"),
						"desc" 		=> esc_html__("Enable widget items hide max limit.","bigbazaar"),
						"id" 		=> "enable_widget_toggle",
						"std" 		=> 1,
						"on"        => esc_html__("Enable","bigbazaar"),
						"off"       => esc_html__("Disable","bigbazaar"),
						"folds"		=> 1,
						"type" 		=> "switch"
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Show Number Of Widget Items","bigbazaar"),
						"id" 		=> "number_of_show_widget_items",
						"std" 		=> "8",
						"min" 		=> "5",
						"step"		=> "1",
						"max" 		=> "15",
						"fold"		=> "enable_widget_toggle",
						"type" 		=> "sliderui" 
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Sticky Sidebar","bigbazaar"),
						"desc" 		=> esc_html__("Enable sticky page sidebar","bigbazaar"),
						"id" 		=> "sticky_sidebar",
						"std" 		=> 1,
						"on"        => esc_html__("Enable","bigbazaar"),
						"off"       => esc_html__("Disable","bigbazaar"),
						"type" 		=> "switch"
				);
				
/*
* Social Share
*/					
$of_options[] = array( 	"name" 		=> esc_html__("Social Share","bigbazaar"),
						"type" 		=> "heading"
				);

$of_options[] = array( 	"name" 		=> esc_html__("Show or Hide Social link Icon on Header And Footer","bigbazaar"),
						"desc" 		=> "",
						"id" 		=> "show_hide_social_icon",
						"std" 		=> "<h3 style=\"margin: 0;\">".esc_html__('Show or Hide Social link Icon on Header And Footer','bigbazaar')."</h3>",
						"icon" 		=> true,
						"type" 		=> "info"
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Facebook","bigbazaar"),
						"desc" 		=> esc_html__("Enter your custom link to show the facebook icon. Leave blank to hide icon.","bigbazaar"),
						"id" 		=> "facebook_link",
						"std" 		=> "https://www.facebook.com/",
						"type" 		=> "text"
				);

$of_options[] = array( 	"name" 		=> esc_html__("Twitter","bigbazaar"),
						"desc" 		=> esc_html__("Enter your custom link to show the twitter icon. Leave blank to hide icon.","bigbazaar"),
						"id" 		=> "twitter_link",
						"std" 		=> "http://twitter.com/",
						"type" 		=> "text"
				);

$of_options[] = array( 	"name" 		=> esc_html__("Linkedin","bigbazaar"),
						"desc" 		=> esc_html__("Enter your custom link to show the linkedin icon. Leave blank to hide icon.","bigbazaar"),
						"id" 		=> "linkedin_link",
						"std" 		=> "https://linkedin.com/",
						"type" 		=> "text"
				);
			
$of_options[] = array( 	"name" 		=> esc_html__("Instagram","bigbazaar"),
						"desc" 		=> esc_html__("Enter your custom link to show the instagram icon. Leave blank to hide icon.","bigbazaar"),
						"id" 		=> "instagram_link",
						"std" 		=> "https://www.instagram.com/",
						"type" 		=> "text"
				);

$of_options[] = array( 	"name" 		=> esc_html__("Flickr","bigbazaar"),
						"desc" 		=> esc_html__("Enter your custom link to show the flickr icon. Leave blank to hide icon.","bigbazaar"),
						"id" 		=> "flickr_link",
						"std" 		=> "https://www.flickr.com/",
						"type" 		=> "text"
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Google Plus","bigbazaar"),
						"desc" 		=> esc_html__("Enter your custom link to show the google plus icon. Leave blank to hide icon.","bigbazaar"),
						"id" 		=> "google_plus_link",
						"std" 		=> "https://plus.google.com/",
						"type" 		=> "text"
				);

$of_options[] = array( 	"name" 		=> esc_html__("RSS","bigbazaar"),
						"desc" 		=> esc_html__("Enter your custom link to show the rss icon. Leave blank to hide icon.","bigbazaar"),
						"id" 		=> "rss_link",
						"std" 		=> "https://www.rss.com/",
						"type" 		=> "text"
				);	

$of_options[] = array( 	"name" 		=> esc_html__("Pinterest","bigbazaar"),
						"desc" 		=> esc_html__("Enter your custom link to show the pinterest icon. Leave blank to hide icon.","bigbazaar"),
						"id" 		=> "pinterest_link",
						"std" 		=> "",
						"type" 		=> "text"
				);

$of_options[] = array( 	"name" 		=> esc_html__("Show or Hide Social Sharing Icon on Product, Post and Portfolio","bigbazaar"),
						"desc" 		=> "",
						"id" 		=> "show_hide_social_sharing_icon",
						"std" 		=> "<h3 style=\"margin: 0;\">".esc_html__('Show or Hide Social Sharing Icon on Product, Post and Portfolio','bigbazaar')."</h3>",
						"icon" 		=> true,
						"type" 		=> "info"
				);

$of_options[] = array( 	"name" 		=> esc_html__("Show Social Share Links","bigbazaar"),
						"id" 		=> "show_social_sharing",
						"std" 		=> 1,
						"on"        => esc_html__("Show","bigbazaar"),
						"off"       => esc_html__("Hide","bigbazaar"),
						"folds"		=> 1,
						"type" 		=> "switch"
				);

$of_options[] = array( 	"name" 		=> esc_html__("Social Sharing Style","bigbazaar"),
						"desc" 		=> esc_html__("Choose social sharing style.","bigbazaar"),
						"id" 		=> "social_sharing_style",
						"std" 		=> 1,
						"on"    	=> esc_html__( "Style 1", "bigbazaar" ),
                        "off"   	=> esc_html__( "Style 2", "bigbazaar" ),
						"type" 		=> "switch"
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Show Facebook Share","bigbazaar"),
						"id" 		=> "social_share_fb",
						"std" 		=> 1,
						"on"        => esc_html__("Show","bigbazaar"),
						"off"       => esc_html__("Hide","bigbazaar"),
						"fold" 		=> "show_social_sharing",
						"type" 		=> "switch"
				);

$of_options[] = array( 	"name" 		=> esc_html__("Show Twitter Share","bigbazaar"),
						"id" 		=> "social_share_tw",
						"std" 		=> 1,
						"on"        => esc_html__("Show","bigbazaar"),
						"off"       => esc_html__("Hide","bigbazaar"),
						"fold" 		=> "show_social_sharing",
						"type" 		=> "switch"
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Show Linkedin Share","bigbazaar"),
						"id" 		=> "social_share_in",
						"std" 		=> 1,
						"on"        => esc_html__("Show","bigbazaar"),
						"off"       => esc_html__("Hide","bigbazaar"),
						"fold" 		=> "show_social_sharing",
						"type" 		=> "switch"
				);

$of_options[] = array( 	"name" 		=> esc_html__("Show Google Plus Share","bigbazaar"),
						"id" 		=> "social_share_gp",
						"std" 		=> 1,
						"on"        => esc_html__("Show","bigbazaar"),
						"off"       => esc_html__("Hide","bigbazaar"),
						"fold" 		=> "show_social_sharing",
						"type" 		=> "switch"
				);

$of_options[] = array( 	"name" 		=> esc_html__("Show StumbleUpon Share","bigbazaar"),
						"id" 		=> "social_share_sl",
						"std" 		=> 1,
						"on"        => esc_html__("Show","bigbazaar"),
						"off"       => esc_html__("Hide","bigbazaar"),
						"fold" 		=> "show_social_sharing",
						"type" 		=> "switch"
				);

$of_options[] = array( 	"name" 		=> esc_html__("Show Pinterest Share","bigbazaar"),
						"id" 		=> "social_share_pr",
						"std" 		=> 1,
						"on"        => esc_html__("Show","bigbazaar"),
						"off"       => esc_html__("Hide","bigbazaar"),
						"fold" 		=> "show_social_sharing",
						"type" 		=> "switch"
				);

$of_options[] = array( 	"name" 		=> esc_html__("Show Tumblr Share","bigbazaar"),
						"id" 		=> "social_share_tl",
						"std" 		=> 1,
						"on"        => esc_html__("Show","bigbazaar"),
						"off"       => esc_html__("Hide","bigbazaar"),
						"fold" 		=> "show_social_sharing",
						"type" 		=> "switch"
				);				

/*
* Cookie Options
*/					
$of_options[] = array( 	"name" 		=> esc_html__("Cookie Notice","bigbazaar"),
						"type" 		=> "heading"
				);	

$of_options[] = array( 	"name" 		=> esc_html__("Cookie Enable or Disable.","bigbazaar"),
						"desc" 		=> esc_html__("Cookie notice enable or disable in your site.","bigbazaar"),
						"id" 		=> "cookie_enable",
						"std" 		=> 0,
						"on"        => esc_html__("Enable","bigbazaar"),
						"off"       => esc_html__("Disable","bigbazaar"),
						"type" 		=> "switch"
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Cookie Title","bigbazaar"),
						"desc" 		=> esc_html__("Enter the cookie title/name.","bigbazaar"),
						"id" 		=> "cookie_title",
						"std" 		=> esc_html__("Cookies Notice","bigbazaar"),
						"type" 		=> "text"
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Message","bigbazaar"),
						"desc" 		=> esc_html__("Enter the cookie notice message.","bigbazaar"),
						"id" 		=> "cookie_message_text",
						"std" 		=> esc_html__("We use cookies to ensure that we give you the best experience on our website. If you continue to use this site we will assume that you are happy with it.","bigbazaar"),
						"type" 		=> "textarea"
				);

$of_options[] = array( 	"name" 		=> esc_html__("Button text","bigbazaar"),
						"desc" 		=> esc_html__("The text of the option to accept the usage of the cookies and make the notification disappear.","bigbazaar"),
						"id" 		=> "cookie_accept_text",
						"std" 		=> esc_html__("Yes, I\'m Accept","bigbazaar"),
						"type" 		=> "text"
				);
				
$of_options[] = array( 	"name" 		=> esc_html__('More info link','bigbazaar'),
						"desc" 		=> esc_html__("Enable Read more link.","bigbazaar"),
						"id" 		=> "cookie_see_more_opt",
						"std" 		=> 0,
						"on"        => esc_html__("Enable","bigbazaar"),
						"off"       => esc_html__("Disable","bigbazaar"),
						"folds"		=> 0,
						"type" 		=> "switch"
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Read More Button Text.","bigbazaar"),
						"desc" 		=> esc_html__("The text of the more info button.","bigbazaar"),
						"id" 		=> "cookie_see_more_text",
						"std" 		=> esc_html__("Read more","bigbazaar"),
						"fold"		=> "cookie_see_more_opt",
						"type" 		=> "text"
				);
				
$of_options[] = array(  "name"      => esc_html__("Redirect Page Link","bigbazaar"),
						"desc"      => esc_html__("Select where to redirect user for more information about cookies.","bigbazaar"),
						"id"        => "cookie_see_more_link_type",
						"std"       => "custom",
						"type"      => "radio",
						"fold"      => "cookie_see_more_opt",
						"options"   => array(
								"custom" 	=> esc_html__("Custom link","bigbazaar"),
								"page" 		=> esc_html__("Page link","bigbazaar"),
						),
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Enter Custom Link URL","bigbazaar"),
						"desc" 		=> esc_html__("Enter the full URL starting with http://","bigbazaar"),
						"id" 		=> "cookie_see_more_link_custom",
						"std" 		=> "http://empty",
						"fold"      => "cookie_see_more_opt",
						"type" 		=> "text"
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Select Existing Page","bigbazaar"),
						"desc" 		=> esc_html__("Select from one of your site\'s pages","bigbazaar"),
						"id" 		=> "cookie_see_more_link_pages",
						"fold"		=> "cookie_see_more_opt",
						"std" 		=> "",
						"type" 		=> "select",
						"options" 	=> $of_pages,
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Link target","bigbazaar"),
						"desc" 		=> esc_html__("Select the link target for more info page.","bigbazaar"),
						"id" 		=> "cookie_see_more_link_target",
						"std" 		=> "_blank",
						"type" 		=> "select",
						"options"  => array(
								"_blank" => "_blank",
								"_self" => "_self",
						),
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Refuse button","bigbazaar"),
						"desc" 		=> esc_html__("Give to the user the possibility to refuse third party non functional cookies.","bigbazaar"),
						"id" 		=> "cookie_refuse_opt",
						"std" 		=> 0,
						"on"        => esc_html__("Enable","bigbazaar"),
						"off"       => esc_html__("Disable","bigbazaar"),
						"folds"		=> 0,
						"type" 		=> "switch"
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Enter Cookie Refuse Text","bigbazaar"),
						"desc" 		=> esc_html__("The text of the option to refuse the usage of the cookies. To get the cookie notice status use bigbazaar_cn_cookies_accepted() function.","bigbazaar"),
						"id" 		=> "cookie_refuse_text",
						"std" 		=> "No",
						"fold"      => "cookie_refuse_opt",
						"type" 		=> "text"
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Enter Refuse Code","bigbazaar"),
						"desc" 		=> esc_html__("Enter non functional cookies Javascript code here (for e.g. Google Analitycs). It will be used after cookies are accepted.","bigbazaar"),
						"id" 		=> "cookie_refuse_code",
						"fold"      => "cookie_refuse_opt",
						"type" 		=> "textarea"
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("On scroll","bigbazaar"),
						"desc" 		=> esc_html__("Enable cookie notice acceptance when users scroll.","bigbazaar"),
						"id" 		=> "cookie_on_scroll",
						"std" 		=> 0,
						"on"        => esc_html__("Enable","bigbazaar"),
						"off"       => esc_html__("Disable","bigbazaar"),
						"fold"      => 0,
						"type" 		=> "switch"
				);

$of_options[] = array( 	"name" 		=> esc_html__("Cookie On Scroll Offset","bigbazaar"),
						"desc" 		=> esc_html__("Number of pixels user has to scroll to accept the usage of the cookies and make the notification disappear.","bigbazaar"),
						"id" 		=> "cookie_on_scroll_offset",
						"std" 		=> 100,
						"fold"      => "cookie_on_scroll",
						"type" 		=> "text"
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Cookie expiry","bigbazaar"),
						"desc" 		=> esc_html__("Select the link target for more info page.","bigbazaar"),
						"id" 		=> "cookie_expiry_times",
						"std" 		=> "2592000",
						"type" 		=> "select",
						"options"  => array(
								"86400"	 	=> esc_html__( "1 day", "bigbazaar" ),
								"604800"	=> esc_html__( "1 week", "bigbazaar" ),
								"2592000"	=> esc_html__( "1 month", "bigbazaar" ),
								"7862400"	=> esc_html__( "3 months", "bigbazaar" ),
								"15811200"	=> esc_html__( "6 months", "bigbazaar" ),
								"31536000"	=> esc_html__( "1 year", "bigbazaar" ),
								"31337313373" => esc_html__( "infinity", "bigbazaar" ),
						),
				);
				
$of_options[] = array(  "name"      => esc_html__("Position","bigbazaar"),
						"desc"      => esc_html__("Select location for your cookie notice.","bigbazaar"),
						"id"        => "cookie_positions",
						"std"       => "bottom",
						"type"      => "radio",
						"options"   => array(
								"top" 	=> esc_html__("Top","bigbazaar"),
								"bottom" 		=> esc_html__("Bottom","bigbazaar"),
						),
				);
				
$of_options[] = array(  "name"      => esc_html__("Cookie Style","bigbazaar"),
						"desc"      => esc_html__("Select style of cookie notice on bottom.","bigbazaar"),
						"id"        => "cookie_style",
						"std"       => "box",
						"type"      => "radio",
						"options"   => array(
								"bar" 	=> esc_html__("Bar","bigbazaar"),
								"box" 		=> esc_html__("Box","bigbazaar"),
						),
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Text Color","bigbazaar"),
						"id" 		=> "cookie_text_color",
						"std" 		=> "#212121",
						"type" 		=> "color"
				);	
				
$of_options[] = array( 	"name" 		=> esc_html__("Bar Background Color","bigbazaar"),
						"id" 		=> "cookie_background_color",
						"std" 		=> "#fcfcfc",
						"type" 		=> "color"
				);	

/*
* Newsletter Options
*/					
$of_options[] = array( 	"name" 		=> esc_html__("Newsletter","bigbazaar"),
						"type" 		=> "heading"
				);

$of_options[] = array( 	"name" 		=> esc_html__("Newsletter Enable or Disable.","bigbazaar"),
						"desc" 		=> esc_html__("Newsletter popup enable or disable in your site.","bigbazaar"),
						"id" 		=> "newsletter_enable",
						"on"        => esc_html__("Enable","bigbazaar"),
						"off"       => esc_html__("Disable","bigbazaar"),
						"std" 		=> 0,
						"folds" 	=> 0,
						"type" 		=> "switch"
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Newsletter Logo","bigbazaar"),
						"desc" 		=> esc_html__("Upload newsletter logo.","bigbazaar"),
						"id" 		=> "newsletter_logo",
						"std" 		=> BIGBAZAAR_IMAGES."/logo2.png",
						//"mod"		=> "min",
						"fold"   	=> "newsletter_enable",
						"type" 		=> "media"
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Newsletter Title","bigbazaar"),
						"id" 		=> "newsletter_title",
						"std" 		=> "Join Us Now!",
						"fold"      => "newsletter_enable",
						"type" 		=> "text"
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Newsletter Tag Line","bigbazaar"),
						"id" 		=> "newsletter_tag_line",
						"std" 		=> "Signup today for free and be the first to hear of special promotions, new arrivals and designer news.",
						"fold"      => "newsletter_enable",
						"type" 		=> "text"
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Newsletter Don\'t Show Msg","bigbazaar"),
						"id" 		=> "newsletter_dont_show",
						"std" 		=> "Don\'t show this popup again",
						"fold"      => "newsletter_enable",
						"type" 		=> "text"
				);

$of_options[] = array( 	"name" 		=> esc_html__("Background Color","bigbazaar"),
						"desc" 		=> esc_html__("Newsletter background color.","bigbazaar"),
						"id" 		=> "newsletter_background",
						"std" 		=> "#e62e04",
						"fold"      => "newsletter_enable",
						"type" 		=> "color"
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Newsletter Text Color","bigbazaar"),
						"desc" 		=> "",
						"id" 		=> "newsletter_color",
						"std" 		=> "#ffffff",
						"fold"      => "newsletter_enable",
						"type" 		=> "color"
				);	
				
$of_options[] = array( 	"name" 		=> esc_html__("Newsletter Button Color","bigbazaar"),
						"desc" 		=> "",
						"id" 		=> "newsletter_button_color",
						"std" 		=> "#FF6600",
						"fold"      => "newsletter_enable",
						"type" 		=> "color"
				);	
				
/*
* Custom CSS/JS
*/					
$of_options[] = array( 	"name" 		=> esc_html__("Custom Code","bigbazaar"),
						"type" 		=> "heading"
				);	
				
$of_options[] = array( 	"name" 		=> esc_html__("Custom CSS","bigbazaar"),
						"desc" 		=> esc_html__("Quickly add some CSS to your theme.","bigbazaar"),
						"id" 		=> "custom_css",
						"std" 		=> "",
						"type" 		=> "textarea"
				);

$of_options[] = array( 	"name" 		=> esc_html__("Custom JS","bigbazaar"),
						"desc" 		=> esc_html__("Quickly add some JS to your theme.","bigbazaar"),
						"id" 		=> "custom_js",
						"std" 		=> "",
						"type" 		=> "textarea"
				);			
				

/*
* Advanced
*/					
$of_options[] = array( 	"name" 		=> esc_html__("Advanced","bigbazaar"),
						"type" 		=> "heading"
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Show Product In Popup After Added Cart","bigbazaar"),
						"desc" 		=> esc_html__("Show product in popup after product added in cart.","bigbazaar"),
						"id" 		=> "show_cart_popup",
						"on"        => esc_html__("Show","bigbazaar"),
						"off"       => esc_html__("Hide","bigbazaar"),
						"std" 		=> 1,
						"type" 		=> "switch"
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Touch Slider In Mobile","bigbazaar"),
						"desc" 		=> esc_html__("Enable or disable products touch sliders in mobile devices.","bigbazaar"),
						"id" 		=> "touch_slider_mobile",
						"on"        => esc_html__("Enable","bigbazaar"),
						"off"       => esc_html__("Disable","bigbazaar"),
						"std" 		=> 0,
						"type" 		=> "switch"
				);
				
// Backup Options
$of_options[] = array( 	"name" 		=> esc_html__("Backup Options","bigbazaar"),
						"type" 		=> "heading",
						"icon"		=> ADMIN_IMAGES . "icon-database_go.png"
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Backup and Restore Options","bigbazaar"),
						"id" 		=> "of_backup",
						"std" 		=> "",
						"type" 		=> "backup",
						"desc" 		=> esc_html__("You can use the two buttons below to backup your current options, and then restore it back at a later time. This is useful if you want to experiment on the options but would like to keep the old settings in case you need it back.","bigbazaar"),
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Transfer Theme Options Data","bigbazaar"),
						"id" 		=> "of_transfer",
						"std" 		=> "",
						"type" 		=> "transfer",
						"desc" 		=> esc_html__("You can tranfer the saved options data between different installs by copying the text inside the text box. To import data from another install, replace the data in the text box with the one from another install and click 'Import Options'.","bigbazaar"),
				);
				
$of_options[] = array( 	"name" 		=> esc_html__("Import Demo Data","bigbazaar"),
						"type" 		=> "heading",
						"icon"		=> ADMIN_IMAGES . "icon-drive_go.png"
				);

$of_options[] = array( 	"name" 		=> esc_html__("Import Demo Data","bigbazaar"),
						"desc" 		=> "",
						"id" 		=> "introduction_2",
						"std" 		=> __("<h3 style=\"margin: 0 0 10px;\">Warning:</h3>
						Importing demo content will copy sliders, widget, theme options, products data, posts, pages and portfolio posts, this will replicate the live demo. The Demo Importer will not import the images we have used in our live demos, due to copyright / license reasons. Choose any one preset layout and click on it thumb image. It can also take a minute to complete.","bigbazaar"),
						"icon" 		=> true,
						"type" 		=> "info"
				);				
				
$of_options[] = array( 	"name" 		=> "",
						"id" 		=> "import_preset",
						"std" 		=> "",
						"type" 		=> "import_preset",
						"options" 	=> array(
							"general" 		=> $url . "preset/general.jpg",
							"automotive" 	=> $url . "preset/automative.jpg",
							"beauty" 		=> $url . "preset/beauty.jpg",
							"electronic" 	=> $url . "preset/electronic.jpg",
							"furnitur" 		=> $url . "preset/furnitur.jpg",
							"jewelry" 		=> $url . "preset/jewelry.jpg",
							"kids" 			=> $url . "preset/kids.jpg",
							"mobile" 		=> $url . "preset/mobile.jpg",
							"vegetable" 	=> $url . "preset/vegetable.jpg",
							"womenware" 	=> $url . "preset/womenware.jpg",
						)
				);
				
	}//End function: of_options()
}//End chack if function exists: of_options()
?>
