<?php
/**
 * Single Product Sale Flash
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     1.6.4
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

global $post, $product;

?>
<?php if(bigbazaar_get_option('show_single_product_highlight_labels',1)==1):

	if(is_product()){ //BigBazaar 2.0
		$page_layout = get_post_meta ( get_the_ID(), '_bigbazaar_product_layout', true ); 
		if(isset($page_layout) && $page_layout!="")
			$page_layout=$page_layout;
		else
			$page_layout=bigbazaar_get_option('single_product_page_layout','none-left');
	}?>
	<div class="product-highlight <?php echo esc_attr($page_layout);?>">
	<?php if ( bigbazaar_get_option('show_single_product_highlight_label_sale',1)==1 && $product->is_on_sale() ) : ?>

		<?php echo apply_filters( 'woocommerce_sale_flash', '<span class="onsale">' . __( 'Sale!', 'woocommerce' ) . '</span>', $post, $product ); ?>

	<?php endif; ?>

	<?php if ( bigbazaar_get_option('show_single_product_highlight_label_hot',1)==1 && $product->is_featured() ) :

		echo apply_filters( 'woocommerce_sale_flash','<span class="featured">' . __( 'Hot', 'woocommerce' ) . '</span>',$post, $product );
		
	endif;?>

	<?php if ( bigbazaar_get_option('show_single_product_highlight_label_outofstock',1)==1 ) :
		$availability = $product->get_availability();
		if ( $availability['availability'] == 'Out of stock') :
			echo apply_filters( 'woocommerce_stock_html', '<span class="' . esc_attr( $availability['class'] ) . '">' . esc_html( $availability['availability'] ) . '</span>', $availability['availability'] );
		endif;
	endif;
	?>
	</div>
<?php endif;?>