<?php
/**
 * Related Products
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/related.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $owlparam;

if ( $related_products ) : ?>
	
	<?php $id = uniqid();
	$owlparam['productsCarousel']['section-'.$id] = array(
		'item_columns' => bigbazaar_get_option('related_upsell_products_per_row',3),
		'autoplay'     => bigbazaar_get_option('related_upsell_auto_play',0) ? 'true' : 'false',
		'navigation'   => bigbazaar_get_option('related_upsell_navigation',1) ? 'true' : 'false',
	);?>
	
	<div class="related products">

		<h2><span><?php esc_html_e( 'Related products', 'woocommerce' ); ?></span></h2>

		<?php //woocommerce_product_loop_start(); ?>
		<div id="section-<?php echo esc_attr($id);?>" class="product-items row">
			<ul class="products product-carousel owl-carousel">
				<?php foreach ( $related_products as $related_product ) : ?>

					<?php
						$post_object = get_post( $related_product->get_id() );

						setup_postdata( $GLOBALS['post'] =& $post_object );

						wc_get_template_part( 'content', 'product' ); ?>

				<?php endforeach; ?>
			</ul>
		</div>
		<?php //woocommerce_product_loop_end(); ?>

	</div>

<?php endif;

wp_reset_postdata();
