<?php
/**
 * Product loop sale flash
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     1.6.4
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

global $post, $product;

?>
<?php if(bigbazaar_get_option('show_product_highlight_labels',1)==1):?>
	<div class="product-highlight">
	<?php if ( bigbazaar_get_option('show_product_highlight_label_sale',1)==1 && $product->is_on_sale() ) : ?>

		<?php echo apply_filters( 'woocommerce_sale_flash', '<span class="onsale">' . __( 'Sale!', 'woocommerce' ) . '</span>', $post, $product ); ?>

	<?php endif; ?>

	<?php if ( bigbazaar_get_option('show_product_highlight_label_hot',1)==1 && $product->is_featured() ) :

		echo apply_filters( 'woocommerce_sale_flash','<span class="featured">' . __( 'Hot', 'woocommerce' ) . '</span>',$post, $product );
		
	endif;?>

	<?php if ( bigbazaar_get_option('show_product_highlight_label_outofstock',1)==1 ) :
		$availability = $product->get_availability();
		if ( $availability['availability'] == 'Out of stock') :
			echo apply_filters( 'woocommerce_stock_html', '<span class="' . esc_attr( $availability['class'] ) . '">' . esc_html( $availability['availability'] ) . '</span>', $availability['availability'] );
		endif;
	endif;?>
	</div>
<?php endif;?>