<?php
/**
 * Cross-sells
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/cart/cross-sells.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $owlparam;

if ( $cross_sells ) : ?>
	
	<?php $id = uniqid();
	$owlparam['productsCarousel']['section-'.$id] = array(
		'item_columns' => 4,
		'autoplay'     => 'false',
		'navigation'   => 'true',
	);?>
	
	<div class="cross-sells">

		<h2><span><?php _e( 'You may be interested in&hellip;', 'woocommerce' ) ?></span></h2>

		<?php //woocommerce_product_loop_start(); ?>
		<div id="section-<?php echo esc_attr($id);?>" class="product-items row">
			<ul class="products product-carousel owl-carousel">

				<?php foreach ( $cross_sells as $cross_sell ) : ?>

					<?php
						$post_object = get_post( $cross_sell->get_id() );

						setup_postdata( $GLOBALS['post'] =& $post_object );

						wc_get_template_part( 'content', 'product' ); ?>

				<?php endforeach; ?>
			</ul>
		</div>
		<?php //woocommerce_product_loop_end(); ?>

	</div>

<?php endif;

wp_reset_postdata();
