<?php
/**
 * The template for displaying the footer
 *
 * @package WordPress
 * @subpackage BigBazaar
 * @since BigBazaar 1.0
 */
?>
<footer id="footer" class="footer">
	
	<div class="footer-middle">
		<div class="container">
			<div class="row">
				<div class="col-sm-6 col-md-3">					
					<?php dynamic_sidebar('footer-widget-area-1');?>
				</div>
				<div class="col-sm-6 col-md-3">
					<?php dynamic_sidebar('footer-widget-area-2');?>
				</div>
				<div class="col-sm-6 col-md-3">
					<?php dynamic_sidebar('footer-widget-area-3');?>
				</div>
				<div class="col-sm-6 col-md-3">
					<?php dynamic_sidebar('footer-widget-area-4');?>					
				</div>
			</div>
		</div>
	</div>
	<div class="footer-bottom">
		<div class="container">
			<div class="row">
				<div class="col-sm-12 col-md-12">
					<?php if(!empty(bigbazaar_get_option('product_categories'))):?>
						<?php foreach(bigbazaar_get_option('product_categories') as $cat_ID):
								$args=array('child_of' =>$cat_ID , 'taxonomy'=> 'product_cat','number' => 10, 'title_li'=>''); ?>
								
								<ul class="categories-list">
								<li class="cate_title"><?php echo get_the_category_by_ID( $cat_ID );?>: </li>
								<?php wp_list_categories( $args ); ?>
								</ul>
						<?php endforeach; ?>
					<?php endif;?>
				</div>				
			</div>
		</div>
	</div>
	<div class="footer-copyright">
		<div class="container">
			<div class="row">
				<div class="col-sm-6">
					<p><?php echo force_balance_tags(bigbazaar_get_option('copyright_text',esc_html__('&copy; 2018 presslayouts.com. All Rights Reserved.','bigbazaar')));?></p>
				</div>
				<div class="col-sm-6 text-right">
					<?php if(bigbazaar_get_option('show_payment_method',1) ==1):?>
						<div class="payments-method">							
							<img src="<?php echo esc_url(bigbazaar_get_option('payments_logo', BIGBAZAAR_IMAGES."/payments-method.png"));?>" alt="Payments">
						</div>
					<?php endif;?>
				</div>
			</div>
		</div>
	</div>
</footer><!-- .site-footer -->