<?php
/**
 * The template for displaying the footer
 *
 * @package WordPress
 * @subpackage BigBazaar
 * @since BigBazaar 1.0
 */
?>
<footer id="footer"  class="footer">
	<div class="footer-top">
		<div class="container">
			<div class="row">
				<div class="col-sm-7 col-md-7 news-letter">
					<h2 class="widget-title"><?php _e('Newsletter','bigbazaar');?></h2> 
					<?php if( function_exists( 'mc4wp_show_form' ) ) { 
						mc4wp_show_form();
					}?>
				</div>
				<div class="col-sm-5 col-md-5 social-media">
					<h2 class="widget-title"><?php _e('Stay Connected','bigbazaar');?></h2>
					<?php bigbazaar_social_link();?>
				</div>
			</div>
		</div>
	</div>
	<div class="footer-middle">
		<div class="container">
			<div class="row">
				<div class="col-sm-6 col-md-3">					
					<?php dynamic_sidebar('footer-widget-area-1');?>
				</div>
				<div class="col-sm-6 col-md-3">
					<?php dynamic_sidebar('footer-widget-area-2');?>
				</div>
				<div class="col-sm-6 col-md-3">
					<?php dynamic_sidebar('footer-widget-area-3');?>
				</div>
				<div class="col-sm-6 col-md-3">
					<?php dynamic_sidebar('footer-widget-area-4');?>					
				</div>
			</div>
		</div>
	</div>
	<div class="footer-copyright">
		<div class="container">
			<div class="row">
				<div class="col-xs-12 col-sm-6">
					<p><?php echo force_balance_tags(bigbazaar_get_option('copyright_text',esc_html__('&copy; 2018 presslayouts.com. All Rights Reserved.','bigbazaar')));?></p>
				</div>
				<div class="col-xs-12 col-sm-6 text-right">
					<?php if(bigbazaar_get_option('show_payment_method',1) ==1):?>
						<div class="payments-method">							
							<img src="<?php echo esc_url(bigbazaar_get_option('payments_logo', BIGBAZAAR_IMAGES."/payments-method.png"));?>" alt="Payments">
						</div>
					<?php endif;?>
				</div>
			</div>
		</div>
	</div>
</footer><!-- .site-footer -->