<?php
/**
 * The default template for displaying content
 *
 * Used for both single and index/archive/search.
 *
 * @package WordPress
 * @subpackage BigBazaar
 * @since BigBazaar 1.0
 */
 
?>
<div class="row masonry-grid">
	<?php
    // Start the loop.
    while ( have_posts() ) : the_post();?>
	
    <div class="col-xs-12 col-sm-6 col-md-4">
        <article id="post-<?php the_ID(); ?>" <?php post_class('post-item'); ?>>
           
		   <?php // Post thumbnail.
				bigbazaar_get_post_thumbnail('medium');
			?>
        
            <header class="entry-header">
                <?php
                    the_title( sprintf( '<h2 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' );
                ?>
            </header><!-- .entry-header -->
			
            <?php if(bigbazaar_get_option('show_postmeta',1)==1):?>
				<footer class="entry-footer">
					<?php bigbazaar_entry_meta(); ?>
					<?php edit_post_link( __( 'Edit', 'bigbazaar' ), '<span class="edit-link">', '</span>' ); ?>
				</footer><!-- .entry-footer -->
			<?php endif;?>
            
            <div class="entry-content">
		
				<?php if( bigbazaar_get_option('show_blog_excerpt', 0) ==1 ):
					the_excerpt();
				else:
					/* translators: %s: Name of current post */
					the_content( sprintf(
						__( 'Read more %s', 'bigbazaar' ),
						the_title( '<span class="screen-reader-text">', '</span>', false )
					) );
				endif;?>
				
			</div><!-- .entry-content -->
			
        </article><!-- #post-## -->
    </div>
    <?php
    // End the loop.
    endwhile;
    ?>
</div>