<?php
/**
 * The template for displaying portfolio category archive pages.
 *
 * @package WordPress
 * @subpackage BigBazaar
 * @since BigBazaar 1.0
 *
 */

$sidebar_position=bigbazaar_get_option('portfolio_archive_page_layout', 'right');
$porftfolio_style=bigbazaar_get_option('portfolio_archive_page_style', 'normal_grid');
$column_grid=bigbazaar_get_option('portfolio_archive_page_show_column', 'two');
$sidebar_widget=bigbazaar_get_option('portfolio_archive_page_sidebar_widget', 'sidebar-1');
$porftfolio_grid_layout=getPortfolioStyle($column_grid);
$column_classs=getColumnClass( $sidebar_position );
$GLOBALS['sidebar_position'] = $sidebar_position;
$GLOBALS['sidebar_widget'] = $sidebar_widget;

get_header();?>

	<div class="container">
		
		<?php if(bigbazaar_get_option('show_portfolio_archive_page_breadsrumb',1)==1):
			echo bigbazaar_breadcrumbs();
		endif;?>
		
		<div class="row">
        	<div class="content-area <?php echo esc_attr($column_classs);?>">
				
				<?php if(bigbazaar_get_option('show_portfolio_archive_page_title',1)==1):?>
					<header class="entry-header">
						<?php the_archive_title( '<h1 class="page-title">', '</h1>' ); ?>
					</header><!-- .entry-header -->
				<?php endif;?>
				
				<div class="porftfolio-lists <?php echo esc_attr($porftfolio_grid_layout);?>">
					<?php 
					if(have_posts()) : 
						
						$portfolio_cats = get_categories(array(
							'taxonomy' => 'portfolio_cat'
						));
					
						if (is_array($portfolio_cats) && !empty($portfolio_cats)) :	?>
							<ul class="portfolioFilter">
								<li><a href="#" data-filter="*" class="current"><?php echo __('Show All', 'bigbazaar'); ?></a></li>
								<?php foreach ($portfolio_cats as $portfolio_cats) : ?>
								<li><a href="#" data-filter=".<?php echo esc_attr($portfolio_cats->slug);?>"><?php echo esc_html($portfolio_cats->name);?></a></li>
								<?php endforeach; ?>
							</ul> 
						<?php endif;?>
						<div class="row">
							<div id="portfolio" class="portfolioContainer<?php if(isset($porftfolio_style) && $porftfolio_style=='masonry_grid'){ echo ' masonry-grid';} ?>" style="margin-right: -1px;">
							
							<?php /*
							* Include the Custom Portfolio-Format-specific template for the content.
							*/
							
							// Start the loop.
							while ( have_posts() ) : the_post();
							
								get_template_part( 'templates/portfolio/'.$porftfolio_grid_layout );
							
							// End the loop.
							endwhile; ?>
							
							</div>
							<?php 
							// Previous/next page navigation.
							bigbazaar_pagination_nav(); ?>
						</div>
					<?php else :
						// If no content, include the "No posts found" template.
						get_template_part( 'content', 'none' ); 
					endif;?>
				</div>
			</div>
           	<?php get_sidebar(); ?>
		</div>
	</div><!-- .content-area -->

<?php 
get_footer();?>