<?php
/**
 * The template for displaying all single testimonial and attachments
 *
 * @package WordPress
 * @subpackage BigBazaar
 * @since BigBazaar 1.0
 */

$sidebar_position=bigbazaar_get_option('testimonialt_page_layout', 'right');
$sidebar_widget=bigbazaar_get_option('testimonialt_page_sidebar_widget','sidebar-1');
$column_classs=getColumnClass( $sidebar_position );
$GLOBALS['sidebar_position'] = $sidebar_position;
$GLOBALS['sidebar_widget'] = $sidebar_widget;

$testimonial_meta = get_post_meta( get_the_ID());
get_header();?>

	<div class="container">
		
		<?php if(bigbazaar_get_option('show_testimonialt_page_breadsrumb',1)==1):
			echo bigbazaar_breadcrumbs();
		endif;?>
		
		<div class="row">
        	<div class="content-area <?php echo esc_attr($column_classs);?> single-testimonial">				
				
				<div class="testimonial-title">
					<?php if(bigbazaar_get_option('show_testimonialt_page_title',1)==1):?>	
						<header class="entry-header">
							<?php the_title( '<h1 class="page-title">', '</h1>' ); ?>
							<div class="designation">
								<?php if( !empty( $testimonial_meta['client_designation'] ) ):
									echo esc_attr($testimonial_meta['client_designation'][0]);
								endif;?>
							</div>	
						</header><!-- .entry-header -->
					<?php endif;					
						
					//Previous/next testimonial navigation.
					bigbazaar_header_post_navigation(array('archive_post'=>'testimonial'));?>
					</div>
					
				<div class="entry-testimonials">
					<?php 
					if(have_posts()) : ?>
					
						<div class="row">
							<ul class="testimonials-list">
								<?php /*
								* Include the Custom Testimonial-Format-specific template for the content.
								*/								
								// Start the loop.
								while ( have_posts() ) : the_post();?>
									<li class="blockquote">
										<div class="quote-meta col-xs-3 col-md-2">
											<div class="client-image">
												<?php echo get_the_post_thumbnail( get_the_ID(), 'thumbnail' ); ?>
											</div>																
										</div>
										<div class="quote-content col-xs-9 col-md-10">
											<?php the_content();?>
										</div>										
									</li>
								
								<?php 
								// End the loop.
								endwhile; ?>
							</ul>					
						</div>
						
					<?php else :
						// If no content, include the "No posts found" template.
						get_template_part( 'content', 'none' ); 
					endif;?>
				</div>
			</div>
           	<?php get_sidebar(); ?>
		</div>
	</div><!-- .content-area -->

<?php 
get_footer();?>