<?php
/**
 * The sidebar containing the shop widget area
 *
 * @package WordPress
 * @subpackage BigBazaar
 * @since BigBazaar 1.0
 */

if(is_single()):
	$page_layout = get_post_meta ( get_the_ID(), '_bigbazaar_product_layout', true );
	if(isset($page_layout) && $page_layout!="")
		$sidebar_position=bigbazaar_get_woo_page_sidebar_position($page_layout);
	else
		$sidebar_position=bigbazaar_get_woo_page_sidebar_position(bigbazaar_get_option('single_product_page_layout','none-left'));
else:
	$sidebar_position=bigbazaar_get_woo_page_sidebar_position(bigbazaar_get_option('shop_page_layout','left'));
endif;

if(is_single()):
	$widgetId = get_post_meta ( get_the_ID(), '_bigbazaar_product_sidebar_widget', true );
	if(isset($widgetId) && $widgetId!="")
		$shop_page_sidebar=$widgetId;
	else
		$shop_page_sidebar=bigbazaar_get_option('single_product_page_sidebar_widget', 'single-product');
elseif(!is_single()):
	$shop_page_sidebar=bigbazaar_get_option('shop_page_sidebar_widget','shop-page');
else:
	$shop_page_sidebar="woocommerce-widget";
endif;?>

<?php if($sidebar_position !=''):?>
	<div id="sidebar" class="sidebar <?php echo esc_attr($sidebar_position);?>">
		<div id="secondary" class="secondary">

			<?php if ( is_active_sidebar( $shop_page_sidebar ) ) : ?>
				<div id="widget-area" class="widget-area" role="complementary">
					<?php dynamic_sidebar( $shop_page_sidebar ); ?>
				</div><!-- .widget-area -->
			<?php endif; ?>

		</div><!-- .secondary -->
	</div>
<?php endif;?>
