<?php
/**
 * The template for displaying the header
 *
 * Displays all of the head element and everything up until the "site-content" div.
 *
 * @package WordPress
 * @subpackage BigBazaar
 * @since BigBazaar 1.0
 */
?><!DOCTYPE html>
<?php
$pre_page_width=(bigbazaar_get_option('use_predefined_page_width',1)==1)? bigbazaar_get_option('predefined_page_width','1170') : bigbazaar_get_option('custom_page_width','1170');
$body_class='';

if($pre_page_width < 1024){
	$body_class='custom_content_width';
}?>

<html <?php language_attributes(); ?> class="no-js">
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	<?php if(!empty(bigbazaar_get_option('favicon_icon'))) :?>
		<link rel="icon" type="image/x-icon" href="<?php echo esc_url(bigbazaar_get_option('favicon_icon'));?>">
	<?php endif;?>
	<!--[if lt IE 9]>
	<script src="<?php echo esc_url( get_template_directory_uri() ); ?>/js/html5.js"></script>
	<![endif]-->
	<?php wp_head(); ?>
</head>

<body <?php body_class($body_class); ?>>
<?php do_action( 'bb_after_body' ); //BigBazaar 2.0 ?> 
<div class="panel-overlay"></div>
<div class="wrapper<?php echo (bigbazaar_get_option('theme_layout','full_layout')=='boxed_layout') ? ' boxed-layout' : '';?>">
	
	<div id="mobile-menu-wrapper" class="mobile-menu-wrapper">
		<a href="#" id="mobile-nav-close" class=""><i class="fa fa-close"></i></a>
		<div class="navbar-collapse">			
			<?php bigbazaar_header_mobile_menu(); ?>				
		</div><!-- /.navbar-collapse -->		
	</div>
	
	<header id="header" class="<?php echo esc_attr(bigbazaar_get_option('header_layout','header-1'));?>">
	
		<?php get_template_part( 'templates/header/'.bigbazaar_get_option('header_layout','header-1')); ?>
		
	</header>
	<div id="content" class="site-content">