<?php 
/**
 * BigBazaar Woocommerce Customizer Function
 *
 * @package PressLayouts
 * @subpackage BigBazaar
 * @since BigBazaar 1.0
 */

 if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/*
 * add theme support
 *-----------------------------------------------------------------------*/
add_theme_support( 'woocommerce' );

/*Disable woocommerce css
/* --------------------------------------------------------------------- */
add_filter( 'woocommerce_enqueue_styles', '__return_false' );
//define( 'WOOCOMMERCE_USE_CSS', false );


/* 	woocommerce hook, fucntion and customize
/* --------------------------------------------------------------------- */

remove_action( 'woocommerce_before_shop_loop', 'woocommerce_result_count', 20 );
remove_action( 'woocommerce_before_shop_loop', 'woocommerce_catalog_ordering',	30 );
remove_action( 'woocommerce_after_shop_loop', 'woocommerce_pagination',	10 );
remove_action( 'woocommerce_before_shop_loop_item', 'woocommerce_template_loop_product_link_open',	10 );
remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_product_link_close',	5 );


if(bigbazaar_get_option('show_product_price', 1) ==0 ):
	remove_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_price',	10 );
endif;
if(bigbazaar_get_option('show_product_rating', 1) ==0 ):
	remove_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating',	5 );
endif;
if(bigbazaar_get_option('show_single_product_rating', 1) ==0 ):
	remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_rating',	10 );
endif;
if(bigbazaar_get_option('single_product_price', 1) ==0 ):
	remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_price', 10 );
endif;
if(bigbazaar_get_option('single_product_meta', 1) ==0 ):
	remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_meta', 40 );
endif;
if(bigbazaar_get_option('show_related_products', 1) ==0 ):
	remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_related_products',	20 );
endif;
if(bigbazaar_get_option('show_upsell_products', 1) ==0 ):
	remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_upsell_display',	15 );
endif;

add_action( 'woocommerce_before_shop_loop',	'bigbazaar_product_toolbar', 10 );
add_action( 'woocommerce_after_shop_loop', 'bigbazaar_product_toolbar',	10 );
if(bigbazaar_get_option('show_grid_list_button',1) ==1 ):
	add_action( 'bigbazaar_product_toolbar', 'bigbazaar_grid_list_view', 10 );
endif;
add_action( 'bigbazaar_product_toolbar', 'woocommerce_catalog_ordering', 20 );
if(bigbazaar_get_option('show_products_per_page',1) ==1 ):
	add_action( 'bigbazaar_product_toolbar', 'bigbazaar_product_show_pager', 22 );
endif;
add_action( 'bigbazaar_product_toolbar', 'woocommerce_pagination', 25 );
if(bigbazaar_get_option('show_product_navigation',1) ==1 ):
	add_action( 'woocommerce_single_product_summary', 'addProductNextPrev', 6);
endif;
add_action( 'woocommerce_single_product_summary', 'bigbazaar_single_product_sizeguide', 30 );
if(bigbazaar_get_option('show_single_product_sharing',1) ==1 ):
	add_action( 'woocommerce_single_product_summary', 'bigbazaar_single_sharing', 55);
endif;

remove_action( 'woocommerce_before_main_content', 'woocommerce_output_content_wrapper', 10 );
remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20 );
//remove_action( 'woocommerce_after_main_content', 'woocommerce_output_content_wrapper_end', 10 );
add_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 10 );
add_action( 'woocommerce_before_main_content', 'woocommerce_output_content_wrapper', 20 );


/* User's Login/Register Popup
 *
 * @since BigBazaar 2.0
/* --------------------------------------------------------------------- */
if( ! function_exists( 'bigbazaar_login_popup' ) ) {
	function bigbazaar_login_popup() {
		if ( ! shortcode_exists( 'woocommerce_my_account' ) || is_user_logged_in() ) {
			return;
		}?>
		<div id="login-popup" class="modal fade loginPopup popup-modal">
			<div class="modal-dialog">
				<div class="login-content modal-content modal-md">
					 <button type="button" class="close" data-dismiss="modal">&times;</button>
					<?php echo do_shortcode( '[woocommerce_my_account]' ) ?>
				</div>
			</div>		
		</div>
	<?php }
}
add_action( 'wp_footer', 'bigbazaar_login_popup', 5 );


if( ! function_exists( 'bigbazaar_product_toolbar' ) ):
	function bigbazaar_product_toolbar(){ ?>
		<div class="product-toolbar"><?php
			/**
			 * @hooked bigbazaar_grid_list_view - 10
			 * @hooked woocommerce_catalog_ordering - 20
			 * @hooked woocommerce_pagination - 25
			 */
			do_action( 'bigbazaar_product_toolbar' );?>
			
		</div><?php
	}
endif;

/* 	Add second thumbnail in products list page
/* --------------------------------------------------------------------- */
function bigbazaar_loop_product_thumbnail(){
	global $post;
	$id = get_the_ID();
	$gallery = get_post_meta($id, '_product_image_gallery', true);
	$size = 'shop_catalog';
	
	$attachment_image = '';
    if (!empty($gallery) && (bigbazaar_get_option('product_image_switch', 1)==1)) {
        $gallery = explode(',', $gallery);
        $first_image_id = $gallery[0];
        $attachment_image = wp_get_attachment_image($first_image_id , $size, false, array('class' => 'back-image'));
    }
	
	$thumb_image = get_the_post_thumbnail($id , $size, array('class' => 'front-image'));
	if(!wp_get_attachment_url( get_post_thumbnail_id() )){
		$thumb_image ="<img src='".BIGBAZAAR_URI."/images/product-listing-placeholder.jpg' />";
    }elseif(!$thumb_image) {
        if ( wc_placeholder_img_src() ) {
            $thumb_image = wc_placeholder_img( $size );
        }
    }
	
	echo $thumb_image;
    echo $attachment_image;
}
add_action( 'woocommerce_before_shop_loop_item_title', 'bigbazaar_loop_product_thumbnail', 10 );
remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_thumbnail', 10 );

/* 	Grid / List view toggle
/* --------------------------------------------------------------------- */
function bigbazaar_grid_list_view() {
	?>		
	<div class="gridlist-toggle">
		<!--<span><?php _e( 'View', 'bigbazaar' ) ?>:</span>-->
		<a href="#" class="grid" title="<?php _e('View as Grid', 'bigbazaar'); ?>"><i class="fa fa-th"></i></a>
		<a href="#" class="list" title="<?php _e('View as List', 'bigbazaar'); ?>"><i class="fa fa-th-list"></i></a>
	</div>
	<?php
}

/* 	Change number of products to be displayed 
/* --------------------------------------------------------------------- */
function pre_get_products() {
	
	$default_products=bigbazaar_get_option('products_show_per_page', 12);	
	
	return $number = isset( $_GET['showproducts'] ) ? absint( $_GET['showproducts'] ) : $default_products;
}
add_filter('loop_shop_per_page', 'pre_get_products');
	
/* 	Product show per page 
/* --------------------------------------------------------------------- */
function bigbazaar_product_show_pager() {
		
	$numbers = array( 6, 8, 9, 10, 12, 14, 15, 16, 18, 20, 21, 22, 24, 26, 27, 28, 30, 32, 33, 34, 36, 38, 40 );

	$options   = array();
	$showproducts = get_query_var( 'posts_per_page' );
	foreach ( $numbers as $number ):
		$options[] = sprintf(
			'<option value="%s" %s>%s %s</option>',
			esc_attr( $number ),
			selected( $number, $showproducts, false ),
			$number,'','');
	endforeach;
	?>		
	<form class="show-products-number" method="get">
		<!--<span><?php _e( 'Show', 'bigbazaar' ) ?>:</span>-->
		<select name="showproducts" class="selectBox">
			<?php echo implode( '', $options ); ?>
		</select>
		<?php
		foreach( $_GET as $name => $value ) {
			if ( 'showproducts' != $name ) {
				printf( '<input type="hidden" name="%s" value="%s">', esc_attr( $name ), esc_attr( $value ) );
			}
		}
		?>
	</form>
	<?php
}

/*  Change variation price 
/* --------------------------------------------------------------------- */
if( ! function_exists( 'wc_wc20_variation_price_format' ) ):
	function wc_wc20_variation_price_format( $price, $product ) {
		// Main Price
		$prices = array( $product->get_variation_price( 'min', true ), $product->get_variation_price( 'max', true ) );
		$price = $prices[0] !== $prices[1] ?  wc_price( $prices[0] ) : wc_price( $prices[0] );
		// Sale Price
		$prices = array( $product->get_variation_regular_price( 'min', true ), $product->get_variation_regular_price( 'max', true ) );
		sort( $prices );
		//$saleprice = $prices[0] !== $prices[1] ? sprintf( __( 'From','%1$s', 'woocommerce' ), wc_price( $prices[0] ) ) : wc_price( $prices[0] );
		$saleprice = $prices[0] !== $prices[1] ?  wc_price( $prices[0] ) : wc_price( $prices[0] );
		if ( $price !== $saleprice ) {
		$price = '<del>' . $saleprice . '</del> <ins>' . $price . '</ins>';
		}
		return $price;
	}
endif;
add_filter( 'woocommerce_variable_sale_price_html', 'wc_wc20_variation_price_format', 10, 2 );
add_filter( 'woocommerce_variable_price_html', 'wc_wc20_variation_price_format', 10, 2 );

if( ! function_exists( 'bigbazaar_products_live_search_form' ) ) :
	function bigbazaar_products_live_search_form( $arg="" ) {
		if(!is_woocommerce_activated()):
			return false;
		endif;?>
	<div class="search-area">
		<form method="get" class="search-header-form woocommerce-product-search" action="<?php echo esc_url( home_url( '/'  ) ); ?>">
			<div class="search-control-group">				
				<input type="search" class="search-field"  name="s" value="<?php echo get_search_query(); ?>" placeholder="<?php echo bigbazaar_get_option('search_placeholder_text', 'I\'m shopping for...'); ?>"/>
				<div class="search-categories">
				<?php
					$selected_cat = isset($_GET['product_cat']) ? $_GET['product_cat'] : '';     
					
					$args = array(
					  'name'         => 'product_cat',
					  'value_field'  =>'slug',
					  'class'        => 'categories-filter selectBox product_cat',
					  'id'        	 => $arg,
					  'show_option_none' => esc_html__( 'All Categories','bigbazaar' ),
					  'option_none_value' => '',
					  'hide_empty'   => 1,
					  'orderby'      => 'name',
					  'order'        => 'asc',
					  'echo'         => 0,
					  'taxonomy'     => 'product_cat',
					);
					
					if($selected_cat !=''):
						$args['selected'] = $selected_cat;
					else:
						$args['selected'] = 0;
					endif;
					
					if(bigbazaar_get_option('search_categories', 'all')=='parent'):
						$args['depth'] = 1;
					endif;
					
					if(bigbazaar_get_option('categories_hierarchical', 1)==1):
						$args['hierarchical'] = true;
					endif;
					
					$show_categories_dropdown=bigbazaar_get_option('show_categories_dropdown',1);
					if($show_categories_dropdown==1):
						echo wp_dropdown_categories( $args );
					endif;?>
					
				</div>
				<div class="input-search-btn">
					<button type="submit" class="search-btn"></button>
					<input type="hidden" name="post_type" value="product" />
				</div>
			</div>
			<div class="live-search-results"></div>
		</form>
	</div><?php
	}
endif;

/* 	Prodcut live search
 *
 * @ since BigBazaar 2.0
/* --------------------------------------------------------------------- */
if( ! function_exists( 'bigbazaar_products_live_search' ) ) :
	function bigbazaar_products_live_search() {
		
		$products = array();
		$sku_products = array();	
		
		$products = bigbazaar_ajax_search_products();
		$sku_products = bigbazaar_get_option('enable_search_by_sku', 0)
		  ? bigbazaar_ajax_search_products_by_sku()
		  : array();			

		$results = array_merge( $products, $sku_products );

		$suggestions = array();

		foreach ( $results as $key => $post ) { 
			$product 		= wc_get_product( $post );
			$product_image 	= wp_get_attachment_image_src( get_post_thumbnail_id( $product->get_id() ) );

			$suggestions[] = array(
						'id' 	=> $product->get_id(),
						'value' => $product->get_title(),
						'url' 	=> $product->get_permalink(),
						'img' 	=> $product_image[0],
						'price' => $product->get_price_html(),
					);
			
		}

		if ( empty( $results ) ) {			
			$no_results 	= esc_html__( 'No products found.', 'bigbazaar' );
			$suggestions[] 	= array(
						'id' 	=> - 1,
						'value' => $no_results,
						'url' 	=> '',
					);
		}

		echo json_encode( array( 'suggestions' => $suggestions ) );
		die();
	}
endif;
add_action( 'wp_ajax_nopriv_products_live_search', 'bigbazaar_products_live_search' );
add_action( 'wp_ajax_products_live_search', 'bigbazaar_products_live_search' );

/* 	Search for products.
 *
 * @ since BigBazaar 2.0
/* --------------------------------------------------------------------- */
if( ! function_exists( 'bigbazaar_ajax_search_products' ) ) {
	function bigbazaar_ajax_search_products ( ) {
		global $woocommerce;
		$ordering_args = $woocommerce->query->get_catalog_ordering_args( 'title', 'asc' );
		
		// Add products to the results.
		$args = array(
			's'					=> $_REQUEST['query'],
			'post_status' 		=> 'publish',
			'post_type' 		=> 'product',
			'posts_per_page' 	=> -1,
			'ignore_sticky_posts'=> 1,
			'orderby' 			=> $ordering_args['orderby'],
			'order' 			=> $ordering_args['order'],
			'tax_query' 		=> WC()->query->get_tax_query(),
			'meta_query'	 	=> WC()->query->get_meta_query(),
		);

		if ( isset( $_REQUEST['product_cat'] ) ) {
			$args['tax_query'][] = array(
			'relation' => 'AND',
			array(
				'taxonomy' => 'product_cat',
				'field' => 'slug',
				'terms' => esc_attr( $_REQUEST['product_cat'] )
			)
			);
		}

		$search_query 	= http_build_query( $args );		
		$query_results 	= new WP_Query( $search_query );
		
		return $query_results->get_posts();	
	}
}

/* 	Search for products.
 *
 * @ since BigBazaar 2.0
/* --------------------------------------------------------------------- */
if( ! function_exists( 'bigbazaar_ajax_search_products_by_sku' ) ) {
	function bigbazaar_ajax_search_products_by_sku () {
	  $query = apply_filters( 'bigbazaar_ajax_search_products_by_sku_search_query', esc_attr( $_REQUEST['query'] ) );
	  
	  $query_args = array(
		'post_status' => 'publish',
		'post_type' => 'product',
		'meta_query' => array(
		  array(
			'key' => '_sku',
			'value' => $query,
		  )
		),
		'tax_query' => array(
			'relation' => 'AND',
		),
	  );

	  $query_args = bigbazaar_ajax_search_catalog_visibility( $query_args );
	  $query_results = new WP_Query($query_args);

	  return $query_results->get_posts();
	}
}

if( ! function_exists( 'products_live_search' ) ) {
	function bigbazaar_ajax_search_catalog_visibility( $query_args ) {
		$product_visibility_term_ids = wc_get_product_visibility_term_ids();

		$query_args['tax_query'][] = array(
			'taxonomy' => 'product_visibility',
			'field' => 'term_taxonomy_id',
			'terms' => $product_visibility_term_ids['exclude-from-search'],
			'operator' => 'NOT IN',
		);
		$query_args['post_parent'] = 0;

		return $query_args;
	}
}

/* 	Ensure cart contents update when products are added to the cart via AJAX
/* --------------------------------------------------------------------- */
function bigbazaar_header_mini_cart_fragment( $fragments ) {
	global $woocommerce;
	ob_start();	?>
	
	<div class="header-cart-content">
		<div class="heading-cart">
			<a class="cart-contents" href="<?php echo esc_url(wc_get_cart_url()); ?>">
				<h6><?php _e('Shopping Cart','bigbazaar');?></h6>
				<span><?php echo sprintf(_n('%d item', '%d item(s)', $woocommerce->cart->cart_contents_count, 'bigbazaar'), $woocommerce->cart->cart_contents_count);?> - <?php echo $woocommerce->cart->get_cart_total(); ?></span>
			</a>
		</div>
        <div class="cart-product-list woocommerce">
            <?php woocommerce_mini_cart();?>
        </div>
    </div>
	<?php
	$fragments['div.header-cart-content'] = ob_get_clean();
	return $fragments;
}
add_filter('woocommerce_add_to_cart_fragments', 'bigbazaar_header_mini_cart_fragment');

/* 	Change woocommerce breadcrumb seperator
/* --------------------------------------------------------------------- */
add_filter( 'woocommerce_breadcrumb_defaults', 'bigbazaar_change_breadcrumb_delimiter' );
function bigbazaar_change_breadcrumb_delimiter( $defaults ) {
	// Change the breadcrumb delimeter from '/' to '>'
	$defaults['delimiter'] = ' &raquo; ';
	return $defaults;
}

/* 	shop / single page colunm class
/* --------------------------------------------------------------------- */
if ( !function_exists('bigbazaar_get_woo_page_colunm_class')) {
	function bigbazaar_get_woo_page_colunm_class($page_layout){
		if(isset($page_layout) && ($page_layout=="left" || $page_layout=="right" || $page_layout=="righ")):
			if($page_layout=="left"):
				if(is_rtl()){
					$column_classs="col-xs-12 col-sm-8 col-md-9 col-sm-pull-4 col-md-pull-3";
				}else{
					$column_classs="col-xs-12 col-sm-8 col-md-9 col-sm-push-4 col-md-push-3";
				}				
			else:
				$column_classs="col-xs-12 col-sm-8 col-md-9";
			endif;
		else:
			$column_classs="col-xs-12 col-sm-12 col-md-12";
		endif;
		
		return $column_classs;
	}
}

/* 	shop / single page sidebar position
/* --------------------------------------------------------------------- */
if ( !function_exists('bigbazaar_get_woo_page_sidebar_position')) {
	function bigbazaar_get_woo_page_sidebar_position($page_layout)
	{
		$sidebar_position='';
		if(isset($page_layout) && ($page_layout=="left" || $page_layout=="right" || $page_layout=="righ")):
			if($page_layout=="left"):
				if(is_rtl()){
					$sidebar_position='col-xs-12 col-sm-4 col-md-3 col-sm-push-8 col-md-push-9';
				}else{
					$sidebar_position='col-xs-12 col-sm-4 col-md-3 col-sm-pull-8 col-md-pull-9';
				}
			else:
				$sidebar_position='col-xs-12 col-sm-4 col-md-3';
			endif;		
		endif;
		
		return $sidebar_position;
	}
}

/* 	Change number or products per row
/* --------------------------------------------------------------------- */
add_filter('loop_shop_columns', 'loop_columns');
if (!function_exists('loop_columns')) {
	function loop_columns() {
		
		return bigbazaar_get_option('products_per_row','3'); // products per row		
	}
}

/*  Get Product's ratting
/* --------------------------------------------------------------------- */
function bigbazaar_get_rating_html( $product, $rating = null ) {

    if ( ! is_numeric( $rating ) ) {
        $rating = $product->get_average_rating();
    }

    $rating_html  = '<div class="product-rating"><div class="star-rating" title="' . $rating . '">';

    $rating_html .= '<span style="width:' . ( ( $rating / 5 ) * 100 ) . '%"><strong class="rating">' . $rating . '</strong> ' . __( 'out of 5', 'woocommerce' ) . '</span>';

    $rating_html .= '</div></div>';

    return $rating_html;
}


/* 	Quick view product
/* --------------------------------------------------------------------- */
add_action('wp_ajax_bigbazaar_product_quickview', 'bigbazaar_product_quickview');
add_action('wp_ajax_nopriv_bigbazaar_product_quickview', 'bigbazaar_product_quickview');
function bigbazaar_product_quickview() {
	global $post, $product, $woocommerce;

		$id      = ( int ) $_POST['pid'];
		$post    = get_post( $id );
		$product = get_product( $id );?>
		
		<div class="woocommerce product-quickview">
			<div id="product-<?php echo esc_attr($id); ?>" class="product">
				<div class="row single-product-entry">
					<div class="col-sm-6">
						<div class="images">
							<div id="product-image" class="bigbazaar-slick-carousel" data-slick='{"slidesToShow": 1,"slidesToScroll": 1, "fade":true, <?php if ( is_rtl()) echo '"rtl": true'; ?>}'>
								<?php if ( has_post_thumbnail() ) {
									$post_thumbnail_id = get_post_thumbnail_id( $post->ID );
									$full_size_image   = wp_get_attachment_image_src( $post_thumbnail_id, 'full' );
									$thumbnail_post    = get_post( $post_thumbnail_id );
									$image_title       = $thumbnail_post->post_content;

									$attributes = array(
										'title'                   => $image_title,
										'data-src'                => $full_size_image[0],
										'data-large_image'        => $full_size_image[0],
										'data-large_image_width'  => $full_size_image[1],
										'data-large_image_height' => $full_size_image[2],
									);

									$html  = '<div>';
										$html .= get_the_post_thumbnail( $post->ID, 'shop_single', $attributes );
									$html .= '</div>';

								} else {
									$html  = '<div class="woocommerce-product-gallery__image--placeholder">';
										$html .= sprintf( '<img src="%s" alt="%s" class="wp-post-image" />', esc_url( wc_placeholder_img_src() ), esc_html__( 'Awaiting product image', 'bigbazaar' ) );
									$html .= '</div>';
								}

								echo apply_filters( 'woocommerce_single_product_image_thumbnail_html', $html, get_post_thumbnail_id( $post->ID ) );

								$attachment_ids = $product->get_gallery_image_ids(); 

								if ( $attachment_ids ) {
									foreach ( $attachment_ids as $attachment_id ) {
										$full_size_image  = wp_get_attachment_image_src( $attachment_id, 'full' );
										$thumbnail        = wp_get_attachment_image_src( $attachment_id, 'shop_thumbnail' );
										$thumbnail_post   = get_post( $attachment_id );
										$image_title      = $thumbnail_post->post_content;

										$attributes = array(
											'title'                   => $image_title,
											'data-src'                => $full_size_image[0],
											'data-large_image'        => $full_size_image[0],
											'data-large_image_width'  => $full_size_image[1],
											'data-large_image_height' => $full_size_image[2],
										);

										$html = '<div>';									
											$html .= wp_get_attachment_image( $attachment_id, 'shop_single', false, $attributes );
										$html .= '</div>';

										echo apply_filters( 'woocommerce_single_product_image_thumbnail_html', $html, $attachment_id );
									}
								} ?>
							</div>
						</div>
					</div>
					<div class="col-sm-6">
						<div class="summary entry-summary">
							<?php do_action( 'woocommerce_single_product_summary' ); ?>
						</div>
					</div><!-- .summary -->
				</div>
			</div>
		</div>
		<?php die();
}

/* 	add product detail next and prev products
/* --------------------------------------------------------------------- */
if( ! function_exists( 'addProductNextPrev' ) ) { 
	function addProductNextPrev(){
		if(!bigbazaar_get_option('show_product_navigation', 1)) return; 
	
		$next = get_next_post();
	    $prev = get_previous_post();

	    $next = ( ! empty( $next ) ) ? wc_get_product( $next->ID ) : false;
	    $prev = ( ! empty( $prev ) ) ? wc_get_product( $prev->ID ) : false;

		?>
		<div class="product-next-previous">
			<?php if ( ! empty( $prev ) ): ?>
				<div class="product-prev">
					<a href="<?php echo esc_url( $prev->get_permalink() ); ?>">					
					<span class="product-navbar">					
						<?php if(is_rtl()):?>
							<i class="fa fa-chevron-right"></i>
						<?php else:?>
							<i class="fa fa-chevron-left"></i>
						<?php endif;?>
					</span>
					<div class="product-prev-popup">
						<div class="product-thumb">
							 <?php echo wp_kses( $prev->get_image(), array( 'img' => array('class' => true,'width' => true,'height' => true,'src' => true,'alt' => true) ) );?>
						</div>
						<div class="product-title-price">
							<span class="ptitle"><?php echo esc_html( $prev->get_title() ); ?></span>
						<?php echo $prev->get_price_html(); ?>
						</div>
					</div>
					</a>
				</div>
			<?php endif ?>
			
			<?php if ( ! empty( $next ) ): ?>
			<div class="product-next">				
				<a href="<?php echo esc_url( $next->get_permalink() ); ?>">
				<span class="product-navbar">
					<?php if(is_rtl()):?>
						<i class="fa fa-chevron-left"></i>
					<?php else:?>
						<i class="fa fa-chevron-right"></i>
					<?php endif;?>					
				</span>
				<div class="product-next-popup">
					<div class="product-thumb">
						 <?php echo wp_kses( $next->get_image(), array( 'img' => array('class' => true,'width' => true,'height' => true,'src' => true,'alt' => true) ) );?>
					</div>
					<div class="product-title-price">
						<span class="ptitle"><?php echo esc_html( $next->get_title() ); ?></span>
						<?php echo $next->get_price_html(); ?>
					</div>
				</div>
				</a>
			</div>
			<?php endif ?>
		</div>
	<?php }
}

/* 	Load more product
/* --------------------------------------------------------------------- */
function load_more_products() {
	$type=bigbazaar_get_option('load_more_products','default_pagination');	
	$use_mobile=false;
	$mobile_type='more_button';
	$mobile_width=767;
	$load_more_text=bigbazaar_get_option('load_more_button_text','Load More');
	$lazy_load=(bigbazaar_get_option('enable_lazy_load', 0)==1) ? true : false ;
	$lazy_load_m=false;
	$LLanimation=bigbazaar_get_option('load_animation_style','fadeInUp');
	
	$products_selector = 'ul.products.is_shop';
	$item_selector = 'li.product';
	$pagination_selector = '.woocommerce-pagination';
	$next_page_selector = '.woocommerce-pagination a.next';
		
	$image_class = 'lmp_rotate';
	
	$image = '<div class="lmp_products_loading">';	
	$image .= '<i class="fa fa-spinner '.$image_class.'"></i>';	
	$image .= '</div>';
	
	$load_more_button = '<div class="lmp_load_more_button">';
	$load_more_button .= '<a class="lmp_button"';	
	$load_more_button .= ' href="#load_next_page">'.$load_more_text.'</a>';
	$load_more_button .= '</div>';
	
	wp_localize_script(
		'bigbazaar-script',
		'pagination_settings',
		array(
			'type'          => $type,
			'use_mobile'    => $use_mobile,
			'mobile_type'   => $mobile_type,
			'mobile_width'  => $mobile_width,
			'is_AAPF'       => '',
			'buffer'        => 50,

			'load_image'    => $image,
			'load_img_class'=> '.lmp_products_loading',

			'load_more'     => $load_more_button,

			'lazy_load'     => $lazy_load,
			'lazy_load_m'   => $lazy_load_m,
			'LLanimation'   => $LLanimation,
		
			'loading'       => __('Loading...','bigbazaar'),
			'loading_class' => '',

			'end_text'      => __('No more product','bigbazaar'),
			'end_text_class'=> '',

			//'javascript'    => $javascript_options,

			'products'      => $products_selector,
			'item'          => $item_selector,
			'pagination'    => $pagination_selector,
			'next_page'     => $next_page_selector,
		)
	);
}
add_action ( 'wp_footer', 'load_more_products' );

/* 	Get Product info added in cart
/* --------------------------------------------------------------------- */
add_action( 'wp_ajax_get_productinfo', 'get_productinfo' );
add_action( 'wp_ajax_nopriv_get_productinfo', 'get_productinfo' );

function get_productinfo() {
	global $product, $woocommerce_loop, $road_opt;
	
	$productid = intval( $_POST['data']['pid'] );
	$product = get_product( $productid );
	$quantity = intval( $_POST['data']['quantity'] );
	?>
	<h3><?php esc_html_e('Product is added to cart', 'bigbazaar');?></h3>
	<div class="product-wrapper">
		<div class="product-image">
			<?php echo wp_kses($product->get_image('shop_thumbnail'), array(
				'img'=>array(
					'src'=>array(),
					'height'=>array(),
					'width'=>array(),
					'class'=>array(),
					'alt'=>array(),
				)
			));?>
		</div>
		<div class="product-info">
			<h4><?php echo esc_html($product->get_title());?></h4>
			<p class="price"><?php echo ''.$product->get_price_html(); ?></p>
		</div>
	</div>
	<div class="buttons">
		<a class="button" href="<?php echo get_permalink( wc_get_page_id( 'cart' ) );?>"><?php esc_html_e('View Cart', 'bigbazaar');?></a>
	</div>
	<?php
	die();
}

/*  Single Product Size Guide
/* --------------------------------------------------------------------- */
if( ! function_exists( 'bigbazaar_single_product_sizeguide' ) ) {
	function bigbazaar_single_product_sizeguide() {
		$attachment_id = get_post_meta ( get_the_ID(), '_bigbazaar_product_size_guide', true );
		if(isset($attachment_id) && $attachment_id!=""):
			$sizeGuideImage=wp_get_attachment_url( $attachment_id );
		else:
			$imageurl=bigbazaar_get_option('size_guide_image', BIGBAZAAR_IMAGES.'/sizeguide.png');
			$sizeGuideImage=(!empty( $imageurl)) ? $imageurl : "";
		endif;
		
		if(bigbazaar_get_option('enable_size_guide',0) && (isset($sizeGuideImage) && $sizeGuideImage!="")):?>
			<div class="size-guide">
				<a class="zoom-gallery" href="<?php echo esc_url($sizeGuideImage);?>"><i class="fa fa-bar-chart"></i> <?php esc_html_e('Size Guide','bigbazaar');?></a>
			</div>
		<?php endif;
	}
}

/*  Define image sizes
/* --------------------------------------------------------------------- */
function bigbazaar_woocommerce_image_dimensions() {
	global $pagenow;

	if ( $pagenow != 'themes.php' || ! isset( $_GET['activated'] ) ) {
		return;
	}
	
	update_option( 'woocommerce_single_image_width', '850' ); 		// Single product image
	update_option( 'woocommerce_thumbnail_image_width', '450' ); 	// Gallery and catalog image
}
/*
 * Hook in on activation
 */
add_action( 'admin_init', 'bigbazaar_woocommerce_image_dimensions', 1 );

/*
* Woocommerce Hook Options
* @version 2.0
*/
if ( ! function_exists( 'bigbazaar_woocommerce_hook_options' )){
	function bigbazaar_woocommerce_hook_options(){
		/*Woocommerce Gallery Hook 3.0.x
		/* --------------------------------------------------------------------- */
		
		add_theme_support( 'wc-product-gallery-lightbox' );
		if(bigbazaar_get_option('enable_product_image_zoom', 1)){
			add_theme_support( 'wc-product-gallery-zoom' );
		}
		remove_theme_support( 'wc-product-gallery-slider' );
	}
}
add_action( 'init', 'bigbazaar_woocommerce_hook_options' );