<?php 

// **********************************************************************// 
// ! Register all presslayouts Widgets
// **********************************************************************// 
add_action( 'widgets_init', 'bigbazaar_register_general_widgets' );
function bigbazaar_register_general_widgets() {
	register_widget('BigBazaar_Brands_Widget');
	register_widget('BigBazaar_Brands_Slider_Widget');
	register_widget('BigBazaar_QRCode_Widget');
	register_widget('BigBazaar_Recent_Posts_Widget');
	register_widget('BigBazaar_Portfolio_Widget');
	register_widget('BigBazaar_Testimonial_Widget');
	register_widget('BigBazaar_Products_Widget');
    register_widget('BigBazaar_Twitter_Widget');
	register_widget('BigBazaar_About_Us_Widget');
	register_widget('BigBazaar_Newsletter_Widget'); 
	register_widget('BigBazaar_Stay_Connected_Widget');
}

// **********************************************************************// 
// ! Brands Filter Widget
// **********************************************************************// 
class BigBazaar_Brands_Widget extends WP_Widget {
	
	public function __construct() {
		
         $widget_ops = array('classname' => 'bigbazaar_widget_brands', 'description' => __( "Products Filter by brands", 'pl-bigbazaar-extensions') );

		$control_ops = array('id_base' => 'bigbazaar-brands');
		
        parent::__construct('bigbazaar-brands', 'BigBazaar '.__('Filter by brands', 'pl-bigbazaar-extensions'), $widget_ops, $control_ops);
	}

    function widget($args, $instance) {
        extract($args);

        $title = $instance['title'];
        echo $before_widget;
        if(!$title == '' ){
	        echo $before_title;
	        echo $title;
	        echo $after_title;
        }
        $current_term = get_queried_object();
		$args = array( 'hide_empty' => true);
		$terms = get_terms('product_brand', $args);
		$count = count($terms); $i=0;
		if ($count > 0) { ?>
			<ul>
				<?php
				foreach ($terms as $term) {
					$i++;
					$curr = false;
					$thumbnail_id 	= absint( get_woocommerce_term_meta( $term->term_id, 'thumbnail_id', true ) );
					if(isset($current_term->term_id) && $current_term->term_id == $term->term_id) {
						$curr = true;
					}?>
					<li>
						<a href="<?php echo get_term_link( $term ); ?>" title="<?php echo sprintf(__('View all products from %s', 'pl-bigbazaar-extensions'), $term->name); ?>"><?php if($curr) echo '<strong>'; ?><?php echo $term->name; ?><?php if($curr) echo '</strong>'; ?></a>
					</li>
					<?php
				}
				?>
			</ul>
			<?php
        }
        echo $after_widget;
    }

    function update( $new_instance, $old_instance ) {
        $instance = $old_instance;
        $instance['title'] = $new_instance['title'];

        return $instance;
    }

    function form( $instance ) {
        $title = isset($instance['title']) ? $instance['title'] : 'Filter by brands';
		
		bigbazaar_widget_input_text(__('Title', 'pl-bigbazaar-extensions'), $this->get_field_id('title'),$this->get_field_name('title'), $title); ?>

	<?php
    }
}

// **********************************************************************// 
// ! Brands Slider Widget
// **********************************************************************// 
class BigBazaar_Brands_Slider_Widget extends WP_Widget {
	
	public function __construct() {
		
        $widget_ops = array('classname' => 'bigbazaar_widget_brands_slider', 'description' => __( "Display product brands with slider.", 'pl-bigbazaar-extensions') );
		$control_ops = array('id_base' => 'bigbazaar-brands-slide');		
        parent::__construct('bigbazaar-brands-slide', 'BigBazaar '.__('Product Brands', 'pl-bigbazaar-extensions'), $widget_ops, $control_ops);
	}

    function widget($args, $instance) {
        extract($args);

        $title = apply_filters('widget_title', empty($instance['title']) ? false : $instance['title']);
		$orderby = (!empty($instance['orderby'])) ?  $instance['orderby'] : 'date';
		$order = (!empty($instance['order'])) ?  $instance['order'] : 'desc';
		$number = (!empty($instance['number'])) ? (int) $instance['number'] : 12;
		$number_slide = (!empty($instance['number_slide'])) ? (int) $instance['number_slide'] : 4;		

        //Get Products
        global $woocommerce_loop;		
		
		$args = array(
					'orderby' => $orderby,
					'order' => $order,
					'number' => $number,
					'hierarchical' => 1,
				    'show_option_none' => '',
				    'hide_empty' => 1,
				    'taxonomy' => 'product_brand'
				);
		$brands = get_categories($args);
		
       if ( !empty($brands) ) : ?>
        
			<?php echo $before_widget;
			if ( $title ) echo $before_title . $title . $after_title;?>			
			
			<?php $row=1;?>
			<ul class="brands-carousel owl-carousel">
			<?php foreach($brands as $brand): ?>
				<?php if($row==1){?>
					<li class="slide-row">
						<ul>
				<?php }
					$thumbnail_id = get_woocommerce_term_meta( $brand->term_id, 'thumbnail_id' ) ;
					$image_src = wp_get_attachment_image_src( $thumbnail_id, 'full' ) ;
					$brand_link = get_term_link( $brand, 'product_brand' ) ;?>
					<li class="brand-item">
						<a href="<?php echo esc_url($brand_link) ?>">									
						<?php if ( !empty($image_src) ) {?>
							<img alt="<?php echo esc_attr($brand->cat_name)?>" src="<?php echo esc_url($image_src[0])?>"/>
						<?php }?>									
						</a>
					</li>
				<?php if($row==$number_slide){ $row=0;?>
					</ul>
						</li>
				<?php } $row++;?>
			<?php endforeach; // end of the loop. ?>
			</ul>
			<script type="text/javascript">
				jQuery(document).ready(function($) {
					var chevron_left="<i class='fa fa-chevron-left'></i>";
					var chevron_right="<i class='fa fa-chevron-right'></i>";
					if($("body").hasClass("rtl")){
						chevron_left="<i class='fa fa-chevron-right'></i>";
						chevron_right="<i class='fa fa-chevron-left'></i>";
					}
					
					jQuery(".brands-carousel").owlCarousel({
						loop: true,
						rtl: ($("body").hasClass("rtl")) ? true : false,
						items:2,
						nav: true,
						navText: [chevron_left,chevron_right],
						dots:false,
						smartSpeed: 1000,
					});
				});
			</script>
		
        <?php echo $after_widget; ?>
		<?php wp_reset_query();
			wp_reset_postdata();  // Restore global post data stomped by the_post().
        endif;		
    }

    function update( $new_instance, $old_instance ) {
        $instance = $old_instance;
        $instance['title'] = strip_tags($new_instance['title']);
		$instance['orderby'] = strip_tags($new_instance['orderby']);
		$instance['order'] = strip_tags($new_instance['order']);
        $instance['number'] = (int) $new_instance['number'];

        return $instance;
    }
		
    function form( $instance ) {
        $title = isset($instance['title']) ? esc_attr($instance['title']) : __('Product Brands','pl-bigbazaar-extensions');
		$orderby = isset($instance['orderby']) ? esc_attr($instance['orderby']) : 'date';
		$order = isset($instance['order']) ? esc_attr($instance['order']) : 'desc';
		$number = isset($instance['number']) ? (int) $instance['number'] : 12;
		$number_slide = isset($instance['number_slide']) ? (int) $instance['number_slide'] : 4;
		
		bigbazaar_widget_input_text(__('Title:', 'pl-bigbazaar-extensions'), $this->get_field_id('title'),$this->get_field_name('title'), $title);
		bigbazaar_widget_input_text(__('Number of show brands:', 'pl-bigbazaar-extensions'), $this->get_field_id('number'),$this->get_field_name('number'), $number);
		$orderby_options = array('date'=>__('Date','pl-bigbazaar-extensions'), 'title'=>__('Title','pl-bigbazaar-extensions'), 'name'=>__('Name(Slug)','pl-bigbazaar-extensions'),'rand'=>__('Rand','pl-bigbazaar-extensions'),'id'=>__('ID','pl-bigbazaar-extensions'));
		bigbazaar_widget_select(__('Order By:', 'pl-bigbazaar-extensions'), $this->get_field_id('orderby'),$this->get_field_name('orderby'), $orderby,$orderby_options);
		$order_options = array('desc'=>'Descending', 'asc'=>'Ascending');
		bigbazaar_widget_select(__('Order:', 'pl-bigbazaar-extensions'), $this->get_field_id('order'),$this->get_field_name('order'), $order,$order_options);
		bigbazaar_widget_input_text(__('Display per slide brands:', 'pl-bigbazaar-extensions'), $this->get_field_id('number_slide'),$this->get_field_name('number_slide'), $number_slide);
		
		
    }
}

// **********************************************************************// 
// ! QR code Widget
// **********************************************************************// 
class BigBazaar_QRCode_Widget extends WP_Widget {
	
	public function __construct() {
		
         $widget_ops = array('classname' => 'bigbazaar_widget_qr_code', 'description' => __( "You can add a QR code image in sidebar to allow your users get quick access from their devices", 'pl-bigbazaar-extensions') );
		$control_ops = array('id_base' => 'bigbazaar-qr-code');		
        parent::__construct('bigbazaar-qr-code', 'BigBazaar '.__('QR Code', 'pl-bigbazaar-extensions'), $widget_ops, $control_ops);
	}

    function widget($args, $instance) {
        extract($args);

        $title = $instance['title'];
        $info = $instance['info'];
        $text = $instance['text'];
        $size = (int) $instance['size'];
        $lightbox = (bool) $instance['lightbox'];
        $currlink = (bool) $instance['currlink'];

        echo $before_widget;
        if ( $title ) echo $before_title . $title . $after_title;
        echo generate_qr_code($info, 'Open', $size, '', $currlink, $lightbox );
        if($text != '') 
            echo $text;
        echo $after_widget;
    }

    function update( $new_instance, $old_instance ) {
        $instance = $old_instance;
        $instance['title'] = strip_tags($new_instance['title']);
        $instance['info'] = strip_tags($new_instance['info']);
        $instance['text'] = ($new_instance['text']);
        $instance['size'] = (int) $new_instance['size'];
        $instance['lightbox'] = (bool) $new_instance['lightbox'];
        $instance['currlink'] = (bool) $new_instance['currlink'];

        return $instance;
    }

    function form( $instance ) {
        $block_id = 0;
        if(!empty($instance['block_id']))
            $block_id = esc_attr($instance['block_id']);

        $info = isset($instance['info']) ? $instance['info'] : '';
        $text = isset($instance['text']) ? $instance['text'] : '';
        $title = isset($instance['title']) ? $instance['title'] : __('QR Code','pl-bigbazaar-extensions');
        $size = isset($instance['size']) ? (int) $instance['size'] : 265;
        $lightbox = isset($instance['lightbox']) ? (bool) $instance['lightbox'] : false;
        $currlink = isset($instance['currlink']) ? (bool) $instance['currlink'] : true;?>
		
        <?php bigbazaar_widget_input_text(__('Title:', 'pl-bigbazaar-extensions'), $this->get_field_id('title'),$this->get_field_name('title'), $title); ?>

        <?php bigbazaar_widget_textarea(__('Information to encode:', 'pl-bigbazaar-extensions'), $this->get_field_id('info'),$this->get_field_name('info'), $info); ?>

        <?php bigbazaar_widget_input_text(__('Image size:', 'pl-bigbazaar-extensions'), $this->get_field_id('size'), $this->get_field_name('size'), $size); ?>

        <?php bigbazaar_widget_input_checkbox(__('Show in lightbox', 'pl-bigbazaar-extensions'), $this->get_field_id('lightbox'), $this->get_field_name('lightbox'),checked($lightbox, true, false), 1); ?>

        <?php bigbazaar_widget_input_checkbox(__('Encode link to the current page', 'pl-bigbazaar-extensions'), $this->get_field_id('currlink'), $this->get_field_name('currlink'),checked($currlink, true, false), 1); ?>

        <?php bigbazaar_widget_textarea(__('Additional information in widget', 'pl-bigbazaar-extensions'), $this->get_field_id('text'),$this->get_field_name('text'), $text); ?>

	<?php
    }
}

// **********************************************************************// 
// ! Recent posts Widget
// **********************************************************************// 
class BigBazaar_Recent_Posts_Widget extends WP_Widget {
	
	public function __construct() {
		
        $widget_ops = array('classname' => 'bigbazaar_widget_recent_entries', 'description' => __( "Your most resent post with slider.", 'pl-bigbazaar-extensions') );
		$control_ops = array('id_base' => 'bigbazaar-recent-posts');		
        parent::__construct('bigbazaar-recent-posts', 'BigBazaar '.__('Recent Posts', 'pl-bigbazaar-extensions'), $widget_ops, $control_ops);
	}

    function widget($args, $instance) {
        extract($args);

        $title = apply_filters('widget_title', empty($instance['title']) ? false : $instance['title']);
		$number = (!empty($instance['number'])) ? (int) $instance['number'] : 10;
		$number_slide = (!empty($instance['number_slide'])) ? (int) $instance['number_slide'] : 5;
		$slider = (!empty($instance['slider'])) ? (bool) $instance['slider'] : false;
		$autoplay = (!empty($instance['autoplay'])) ? (bool) $instance['autoplay'] : false;
		$navigation = (!empty($instance['navigation'])) ? (bool) $instance['navigation'] : false;

        $recent_posts = new WP_Query(array('posts_per_page' => $number, 'post_type' => 'post', 'post_status' => 'publish', 'ignore_sticky_posts' => 1));

		$id = uniqid("postCarousel-");
        if ($recent_posts->have_posts()) : ?>
        
			<?php echo $before_widget;
			if ( $title ) echo $before_title . $title . $after_title;?>
			
			<?php if($slider):
				$slider_class=" owl-carousel ".$id;
			else:
				$slider_class=""; 
			endif;?>
			
            <ul class="post-list-widget<?php echo esc_attr($slider_class); ?>">
				<?php $row=1; while ($recent_posts->have_posts()) : $recent_posts->the_post();?>
					<?php if( $slider == true && $row==1){?>
						<li class="slide-row">
							<ul>
					<?php }?>
						<li class="post-item">
							<div class="post-image">
								<a href="<?php the_permalink() ?>" title="<?php get_the_title();?>"><?php echo get_the_post_thumbnail($recent_posts->ID,'thumbnail')?></a>
							</div>
							<div class="post-widget-content">
								<a href="<?php the_permalink() ?>" title="<?php get_the_title();?>"><?php the_title(); ?></a>
								<!--<?php _e('by', 'pl-bigbazaar-extensions') ?> <strong><?php the_author(); ?></strong>--> 
								<span><?php the_time(get_option('date_format')); ?></span>
							</div>
						</li>
					<?php if( $slider == true && $row==$number_slide){ $row=0;?>
							</ul>
						</li>
					<?php } $row++;?>
				<?php endwhile;?>
			</ul>
			<?php if($slider): ?>
                <script type="text/javascript">
					
                    jQuery(document).ready(function($) {
						var chevron_left="<i class='fa fa-chevron-left'></i>";
						var chevron_right="<i class='fa fa-chevron-right'></i>";
						if($("body").hasClass("rtl")){
							chevron_left="<i class='fa fa-chevron-right'></i>";
							chevron_right="<i class='fa fa-chevron-left'></i>";
						}
						
                        jQuery(".<?php echo esc_attr($id); ?>").owlCarousel({
							autoplay:<?php echo $autoplay ? "true" : "false" ; ?>,
							rtl: ($("body").hasClass("rtl")) ? true : false,
							loop: true,
                            items:1,
                            nav: <?php echo $navigation ? "true" : "false" ; ?>,
							navText: [chevron_left,chevron_right],
							dots:false,
							smartSpeed: 1000,
                        });
                    });
                </script>
            <?php endif; ?>
		
        <?php echo $after_widget; ?>
		<?php wp_reset_query();  // Restore global post data stomped by the_post().
        endif;		
    }

    function update( $new_instance, $old_instance ) {
        $instance = $old_instance;
        $instance['title'] = strip_tags($new_instance['title']);
        $instance['number'] = (int) $new_instance['number'];
        $instance['slider'] = (bool) $new_instance['slider'];
		$instance['number_slide'] = (int) $new_instance['number_slide'];
		$instance['autoplay'] = (bool) $new_instance['autoplay'];
		$instance['navigation'] = (bool) $new_instance['navigation'];

        return $instance;
    }
		
    function form( $instance ) {
        $title = isset($instance['title']) ? esc_attr($instance['title']) : __('Recent Posts','pl-bigbazaar-extensions');
		$number = isset($instance['number']) ? (int) $instance['number'] : 10;
		$number_slide = isset($instance['number_slide']) ? (int) $instance['number_slide'] : 5;
        $slider = isset($instance['slider']) ? (bool) $instance['slider'] : false;
		$autoplay = isset($instance['autoplay']) ? (bool) $instance['autoplay'] : false;
		$navigation = isset($instance['navigation']) ? (bool) $instance['navigation'] : true;
		
		bigbazaar_widget_input_text(__('Title:', 'pl-bigbazaar-extensions'), $this->get_field_id('title'),$this->get_field_name('title'), $title);
		bigbazaar_widget_input_text(__('Number of posts to show:', 'pl-bigbazaar-extensions'), $this->get_field_id('number'),$this->get_field_name('number'), $number);
		bigbazaar_widget_input_checkbox(__('Enable slider', 'pl-bigbazaar-extensions'), $this->get_field_id('slider'), $this->get_field_name('slider'),checked($slider, true, false), 1); 
		bigbazaar_widget_input_text(__('Per slide show posts:', 'pl-bigbazaar-extensions'), $this->get_field_id('number_slide'),$this->get_field_name('number_slide'), $number_slide);
		bigbazaar_widget_input_checkbox(__('Enable Auto play slider', 'pl-bigbazaar-extensions'), $this->get_field_id('autoplay'), $this->get_field_name('autoplay'),checked($autoplay, true, false), 1);
		bigbazaar_widget_input_checkbox(__('Show slider navigation', 'pl-bigbazaar-extensions'), $this->get_field_id('navigation'), $this->get_field_name('navigation'),checked($navigation, true, false), 1);		
    }
}

// **********************************************************************// 
// ! Portfolio Widget
// **********************************************************************// 
class BigBazaar_Portfolio_Widget extends WP_Widget {
	
	public function __construct() {
		
        $widget_ops = array('classname' => 'bigbazaar_widget_portfolio', 'description' => __( "Display portfolios with slider.", 'pl-bigbazaar-extensions') );
		$control_ops = array('id_base' => 'bigbazaar-portfolio');		
        parent::__construct('bigbazaar-portfolio', 'BigBazaar '.__('Portfolio', 'pl-bigbazaar-extensions'), $widget_ops, $control_ops);
	}

    function widget($args, $instance) {
        extract($args);

        $title = apply_filters('widget_title', empty($instance['title']) ? false : $instance['title']);
		$orderby = (!empty($instance['orderby'])) ?  $instance['orderby'] : 'date';
		$order = (!empty($instance['order'])) ?  $instance['order'] : 'desc';
		$number = (!empty($instance['number'])) ? (int) $instance['number'] : 10;
		$number_slide = (!empty($instance['number_slide'])) ? (int) $instance['number_slide'] : 5;
		$slider = (!empty($instance['slider'])) ? (bool) $instance['slider'] : false;
		$autoplay = (!empty($instance['autoplay'])) ? (bool) $instance['autoplay'] : false;
		$navigation = (!empty($instance['navigation'])) ? (bool) $instance['navigation'] : false;

        $portfolios = new WP_Query(array('posts_per_page' => $number, 'post_type' => 'portfolio', 'post_status' => 'publish','orderby' => $orderby, 'order' => $order,'ignore_sticky_posts' => 1));

		$id = uniqid("portfolioCarousel-");
        if ($portfolios->have_posts()) : ?>
        
			<?php echo $before_widget;
			if ( $title ) echo $before_title . $title . $after_title;?>
			
			<?php if($slider):
				$slider_class=" owl-carousel ".$id;
			else:
				$slider_class=""; 
			endif;?>
			
            <ul class="post-list-widget<?php echo esc_attr($slider_class); ?>">
				<?php $row=1; while ($portfolios->have_posts()) : $portfolios->the_post();?>
					<?php if( $slider == true && $row==1){?>
						<li class="slide-row">
							<ul>
					<?php }?>
						<li class="post-item">
							<div class="post-image">
								<a href="<?php the_permalink() ?>" title="<?php get_the_title();?>"><?php echo get_the_post_thumbnail($portfolios->ID,'thumbnail')?></a>
							</div>
							<div class="post-widget-content">
								<a href="<?php the_permalink() ?>" title="<?php get_the_title();?>"><?php the_title(); ?></a>
								<!--<?php _e('by', 'pl-bigbazaar-extensions') ?> <strong><?php the_author(); ?></strong>--> 
								<span><?php the_time(get_option('date_format')); ?></span>
							</div>
						</li>
					<?php if( $slider == true && $row==$number_slide){ $row=0;?>
							</ul>
						</li>
					<?php } $row++;?>
				<?php endwhile;?>
			</ul>
			<?php if($slider): ?>
                <script type="text/javascript">
					
                    jQuery(document).ready(function($) {
						var chevron_left="<i class='fa fa-chevron-left'></i>";
						var chevron_right="<i class='fa fa-chevron-right'></i>";
						if($("body").hasClass("rtl")){
							chevron_left="<i class='fa fa-chevron-right'></i>";
							chevron_right="<i class='fa fa-chevron-left'></i>";
						}
						
                        jQuery(".<?php echo esc_attr($id); ?>").owlCarousel({
							autoplay:<?php echo $autoplay ? "true" : "false" ; ?>,
							rtl: ($("body").hasClass("rtl")) ? true : false,
							loop: true,
                            items:1,
                            nav: <?php echo $navigation ? "true" : "false" ; ?>,
							navText: [chevron_left,chevron_right],
							dots:false,
							smartSpeed: 1000,
                        });
                    });
                </script>
            <?php endif; ?>
		
        <?php echo $after_widget; ?>
		<?php wp_reset_query();  // Restore global post data stomped by the_post().
        endif;		
    }

    function update( $new_instance, $old_instance ) {
        $instance = $old_instance;
        $instance['title'] = strip_tags($new_instance['title']);
		$instance['orderby'] = strip_tags($new_instance['orderby']);
		$instance['order'] = strip_tags($new_instance['order']);
        $instance['number'] = (int) $new_instance['number'];
        $instance['slider'] = (bool) $new_instance['slider'];
		$instance['number_slide'] = (int) $new_instance['number_slide'];
		$instance['autoplay'] = (bool) $new_instance['autoplay'];
		$instance['navigation'] = (bool) $new_instance['navigation'];

        return $instance;
    }
		
    function form( $instance ) {
        $title = isset($instance['title']) ? esc_attr($instance['title']) : __('Portfolios','pl-bigbazaar-extensions');
		$orderby = isset($instance['orderby']) ? esc_attr($instance['orderby']) : 'date';
		$order = isset($instance['order']) ? esc_attr($instance['order']) : 'desc';
		$number = isset($instance['number']) ? (int) $instance['number'] : 10;
		$number_slide = isset($instance['number_slide']) ? (int) $instance['number_slide'] : 5;
        $slider = isset($instance['slider']) ? (bool) $instance['slider'] : false;
		$autoplay = isset($instance['autoplay']) ? (bool) $instance['autoplay'] : false;
		$navigation = isset($instance['navigation']) ? (bool) $instance['navigation'] : true;
		
		bigbazaar_widget_input_text(__('Title:', 'pl-bigbazaar-extensions'), $this->get_field_id('title'),$this->get_field_name('title'), $title);
		bigbazaar_widget_input_text(__('Number of show portfolio:', 'pl-bigbazaar-extensions'), $this->get_field_id('number'),$this->get_field_name('number'), $number);
		$orderby_options = array('date'=>__('Date','pl-bigbazaar-extensions'), 'title'=>__('Title','pl-bigbazaar-extensions'), 'name'=>__('Name(Slug)','pl-bigbazaar-extensions'),'rand'=>__('Rand','pl-bigbazaar-extensions'),'id'=>__('ID','pl-bigbazaar-extensions'));
		bigbazaar_widget_select(__('Order By:', 'pl-bigbazaar-extensions'), $this->get_field_id('orderby'),$this->get_field_name('orderby'), $orderby,$orderby_options);
		$order_options = array('desc'=>'Descending', 'asc'=>'Ascending');
		bigbazaar_widget_select(__('Order:', 'pl-bigbazaar-extensions'), $this->get_field_id('order'),$this->get_field_name('order'), $order,$order_options);
		bigbazaar_widget_input_checkbox(__('Enable slider', 'pl-bigbazaar-extensions'), $this->get_field_id('slider'), $this->get_field_name('slider'),checked($slider, true, false), 1); 
		bigbazaar_widget_input_text(__('Per slide show posts:', 'pl-bigbazaar-extensions'), $this->get_field_id('number_slide'),$this->get_field_name('number_slide'), $number_slide);
		bigbazaar_widget_input_checkbox(__('Enable Auto play slider', 'pl-bigbazaar-extensions'), $this->get_field_id('autoplay'), $this->get_field_name('autoplay'),checked($autoplay, true, false), 1);
		bigbazaar_widget_input_checkbox(__('Show slider navigation', 'pl-bigbazaar-extensions'), $this->get_field_id('navigation'), $this->get_field_name('navigation'),checked($navigation, true, false), 1);		
    }
}

// **********************************************************************// 
// ! Testimonial Widget
// **********************************************************************// 
class BigBazaar_Testimonial_Widget extends WP_Widget {
	
	public function __construct() {
		
        $widget_ops = array('classname' => 'bigbazaar_widget_testimonial', 'description' => __( "Testimonials with slider.", 'pl-bigbazaar-extensions') );
		$control_ops = array('id_base' => 'bigbazaar-testimonial');		
        parent::__construct('bigbazaar-testimonial', 'BigBazaar '.__('Testimonial', 'pl-bigbazaar-extensions'), $widget_ops, $control_ops);
	}

    function widget($args, $instance) {
        extract($args);

        $title = apply_filters('widget_title', empty($instance['title']) ? false : $instance['title']);
		$orderby = (!empty($instance['orderby'])) ?  $instance['orderby'] : 'date';
		$order = (!empty($instance['order'])) ?  $instance['order'] : 'desc';
		$number = (!empty($instance['number'])) ? (int) $instance['number'] : 10;
		$autoplay = (!empty($instance['autoplay'])) ? (bool) $instance['autoplay'] : false;
		$navigation = (!empty($instance['navigation'])) ? (bool) $instance['navigation'] : false;

        //Get Testimonials
		$args = array(
			'post_type'				=> 'testimonial',
			'post_status'			=> 'publish',
			'ignore_sticky_posts'	=> 1,
			'posts_per_page' 		=> $number,
			'orderby' 			    => $orderby,
			'order' 				=> $order,
			);
		
		$testimonials = new WP_Query( $args );

        if ($testimonials->have_posts()) : ?>
        
			<?php echo $before_widget;
			if ( $title ) echo $before_title . $title . $after_title;?>			
			
            <ul class="testimonials owl-carousel">
				<?php while( $testimonials->have_posts() ): $testimonials->the_post();
				$testimonial_meta = get_post_meta( get_the_ID());?>
					<li class="blockquote">
						<div class="quote-content">
							<?php the_content();?>
						</div>
						<div class="quote-meta">
							<div class="client-image">
								<?php echo get_the_post_thumbnail( $testimonials->ID, 'thumbnail' ); ?>
							</div>
							<div class="name-designation">
								<a href="<?php echo get_permalink();?>"> <h6 class="name"><?php the_title();?></h6></a>
								<div class="designation">
								<?php if( isset( $testimonial_meta['client_designation'] ) ):
									echo esc_attr($testimonial_meta['client_designation'][0]);
								endif;?>
								</div>								
							</div>							
						</div>
					</li>
				<?php endwhile; // end of the loop. ?>
			</ul>
			<script type="text/javascript">
				
				jQuery(document).ready(function($) {
					var chevron_left="<i class='fa fa-chevron-left'></i>";
					var chevron_right="<i class='fa fa-chevron-right'></i>";
					if($("body").hasClass("rtl")){
						chevron_left="<i class='fa fa-chevron-right'></i>";
						chevron_right="<i class='fa fa-chevron-left'></i>";
					}
					
					jQuery(".testimonials").owlCarousel({
						autoplay:<?php echo $autoplay ? "true" : "false" ; ?>,
						rtl: ($("body").hasClass("rtl")) ? true : false,
						loop: true,
						items:1,
						nav: <?php echo $navigation ? "true" : "false" ; ?>,
						navText: [chevron_left,chevron_right],
						dots:false,
						smartSpeed: 1000,
					});
				});
			</script>
		
        <?php echo $after_widget; ?>
		<?php wp_reset_postdata();  // Restore global post data stomped by the_post().
        endif;		
    }

    function update( $new_instance, $old_instance ) {
        $instance = $old_instance;
        $instance['title'] = strip_tags($new_instance['title']);
		$instance['orderby'] = strip_tags($new_instance['orderby']);
		$instance['order'] = strip_tags($new_instance['order']);
        $instance['number'] = (int) $new_instance['number'];
		$instance['autoplay'] = (bool) $new_instance['autoplay'];
		$instance['navigation'] = (bool) $new_instance['navigation'];

        return $instance;
    }
		
    function form( $instance ) {
        $title = isset($instance['title']) ? esc_attr($instance['title']) : __('Testimonial','pl-bigbazaar-extensions');
		$orderby = isset($instance['orderby']) ? esc_attr($instance['orderby']) : 'date';
		$order = isset($instance['order']) ? esc_attr($instance['order']) : 'desc';
		$number = isset($instance['number']) ? (int) $instance['number'] : 5;
		$autoplay = isset($instance['autoplay']) ? (bool) $instance['autoplay'] : false;
		$navigation = isset($instance['navigation']) ? (bool) $instance['navigation'] : true;
		
		bigbazaar_widget_input_text(__('Title:', 'pl-bigbazaar-extensions'), $this->get_field_id('title'),$this->get_field_name('title'), $title);
		$orderby_options = array('date'=>__('Date','pl-bigbazaar-extensions'), 'title'=>__('Title','pl-bigbazaar-extensions'), 'name'=>__('Name(Slug)','pl-bigbazaar-extensions'),'rand'=>__('Rand','pl-bigbazaar-extensions'),'id'=>__('ID','pl-bigbazaar-extensions'));
		bigbazaar_widget_select(__('Order By:', 'pl-bigbazaar-extensions'), $this->get_field_id('orderby'),$this->get_field_name('orderby'), $orderby,$orderby_options);
		$order_options = array('desc'=>'Descending', 'asc'=>'Ascending');
		bigbazaar_widget_select(__('Order:', 'pl-bigbazaar-extensions'), $this->get_field_id('order'),$this->get_field_name('order'), $order,$order_options);
		bigbazaar_widget_input_text(__('Number of show testimonials:', 'pl-bigbazaar-extensions'), $this->get_field_id('number'),$this->get_field_name('number'), $number);
		bigbazaar_widget_input_checkbox(__('Enable Auto play slider', 'pl-bigbazaar-extensions'), $this->get_field_id('autoplay'), $this->get_field_name('autoplay'),checked($autoplay, true, false), 1);
		bigbazaar_widget_input_checkbox(__('Show slider navigation', 'pl-bigbazaar-extensions'), $this->get_field_id('navigation'), $this->get_field_name('navigation'),checked($navigation, true, false), 1);		
    }
}

// **********************************************************************// 
// ! Products Widget
// **********************************************************************// 
class BigBazaar_Products_Widget extends WP_Widget {
	
	public function __construct() {
		
        $widget_ops = array('classname' => 'bigbazaar_widget_products', 'description' => __( "Display a list of products with slider.", 'pl-bigbazaar-extensions') );
		$control_ops = array('id_base' => 'bigbazaar-products');		
        parent::__construct('bigbazaar-products', 'BigBazaar '.__('Products', 'pl-bigbazaar-extensions'), $widget_ops, $control_ops);
	}

    function widget($args, $instance) {
        extract($args);

        $title = apply_filters('widget_title', empty($instance['title']) ? false : $instance['title']);
		$product_type = (!empty($instance['product_type'])) ?  $instance['product_type'] : 'recent-products';
		$orderby = (!empty($instance['orderby'])) ?  $instance['orderby'] : 'date';
		$order = (!empty($instance['order'])) ?  $instance['order'] : 'desc';
		$number = (!empty($instance['number'])) ? (int) $instance['number'] : 10;
		$number_slide = (!empty($instance['number_slide'])) ? (int) $instance['number_slide'] : 5;
		$slider = (!empty($instance['slider'])) ? (bool) $instance['slider'] : false;
		$autoplay = (!empty($instance['autoplay'])) ? (bool) $instance['autoplay'] : false;
		$navigation = (!empty($instance['navigation'])) ? (bool) $instance['navigation'] : false;

        //Get Products
        global $woocommerce_loop;		
				
		$args = array(
					'post_type'				=> 'product',
					'post_status'			=> 'publish',
					'ignore_sticky_posts'	=> 1,
					'posts_per_page' 		=> $number,
				);
		
		$args['meta_query'] = WC()->query->get_meta_query();
		$tax_query   		= WC()->query->get_tax_query();
		
		//recent products
		if(isset($product_type) && ( $product_type=="recent-products" )):	
			$args['orderby'] = $orderby;
			$args['order'] = $order;
			$args['tax_query']	= $tax_query;
		endif;
		
		//featured products
		if(isset($product_type) && ( $product_type=="featured-products" )):
			$f_tax_query=$tax_query;
			$f_tax_query[] = array(
				'taxonomy' => 'product_visibility',
				'field'    => 'name',
				'terms'    => 'featured',
				'operator' => 'IN',
			);
			
			$args['orderby'] 	= $orderby;
			$args['order'] 		= $order;
			$args['tax_query']	= $f_tax_query;
		endif;
		
		//best selling
		if(isset($product_type) && ( $product_type=="best-seller-products" )):
			$args['meta_key'] = 'total_sales';
			$args['orderby'] = 'meta_value_num';
			$args['tax_query']	= $tax_query;			
		endif;
		
		//top reviews
		if(isset($product_type) && ( $product_type=="top-reviews-products" )):
			$args['tax_query']	= $tax_query;
			add_filter( 'posts_clauses', array( 'WC_Shortcodes', 'order_by_rating_post_clauses' ) );
		endif;
		
		//sale products
		if(isset($product_type) && ( $product_type=="sale-products" )):
		
			$product_ids_on_sale = wc_get_product_ids_on_sale();
			$args['orderby'] = $orderby;
			$args['order'] = $order;
			$args['tax_query']	= $tax_query;
			$args['post__in'] = array_merge( array( 0 ), $product_ids_on_sale );
			
		endif;
		$products = new WP_Query( apply_filters( 'woocommerce_shortcode_products_query', $args, '' ) );
		
		if(isset($product_type) && ( $product_type=="top-reviews-products" )):
			remove_filter( 'posts_clauses', array( 'WC_Shortcodes', 'order_by_rating_post_clauses' ) );
		endif;
		
		$id = uniqid("productsCarousel-");
        if ($products->have_posts()) : ?>
        
			<?php echo $before_widget;
			if ( $title ) echo $before_title . $title . $after_title;?>
			
			<?php if($slider):
				$slider_class=" owl-carousel ".$id;
			else:
				$slider_class=""; 
			endif;?>
            <ul class="product_list_widget<?php echo esc_attr($slider_class); ?> woocommerce">
				<?php $row=1; while ($products->have_posts()) : $products->the_post();?>
					<?php if( $slider == true && $row==1){?>
						<li class="slide-row">
							<ul>
					<?php }?>
						
						<?php wc_get_template( 'bigbazaar-content-widget-product.php' );?>
						
					<?php if( $slider == true && $row==$number_slide){ $row=0;?>
							</ul>
						</li>
					<?php } $row++;?>
				<?php endwhile;?>
			</ul>
			<?php if($slider): ?>
                <script type="text/javascript">
                    jQuery(document).ready(function($) {
						var chevron_left="<i class='fa fa-chevron-left'></i>";
						var chevron_right="<i class='fa fa-chevron-right'></i>";
						if($("body").hasClass("rtl")){
							chevron_left="<i class='fa fa-chevron-right'></i>";
							chevron_right="<i class='fa fa-chevron-left'></i>";
						}
						
                        jQuery(".<?php echo esc_attr($id); ?>").owlCarousel({
							autoplay:<?php echo $autoplay ? "true" : "false" ; ?>,
							rtl: ($("body").hasClass("rtl")) ? true : false,
							loop: true,
                            items:1,
                            nav: <?php echo $navigation ? "true" : "false" ; ?>,
							navText: [chevron_left,chevron_right],
							dots:false,
							smartSpeed: 1000,
                        });
                    });
                </script>
            <?php endif; ?>
		
        <?php echo $after_widget; ?>
		<?php wp_reset_query();
			wp_reset_postdata();  // Restore global post data stomped by the_post().
        endif;		
    }

    function update( $new_instance, $old_instance ) {
        $instance = $old_instance;
        $instance['title'] = strip_tags($new_instance['title']);
		$instance['product_type'] = strip_tags($new_instance['product_type']);
		$instance['orderby'] = strip_tags($new_instance['orderby']);
		$instance['order'] = strip_tags($new_instance['order']);
        $instance['number'] = (int) $new_instance['number'];
        $instance['slider'] = (bool) $new_instance['slider'];
		$instance['number_slide'] = (int) $new_instance['number_slide'];
		$instance['autoplay'] = (bool) $new_instance['autoplay'];
		$instance['navigation'] = (bool) $new_instance['navigation'];

        return $instance;
    }
		
    function form( $instance ) {
        $title = isset($instance['title']) ? esc_attr($instance['title']) : __('Recent Products','pl-bigbazaar-extensions');
		$product_type = isset($instance['product_type']) ? esc_attr($instance['product_type']) : 'recent-products';
		$orderby = isset($instance['orderby']) ? esc_attr($instance['orderby']) : 'date';
		$order = isset($instance['order']) ? esc_attr($instance['order']) : 'desc';
		$number = isset($instance['number']) ? (int) $instance['number'] : 10;
		$number_slide = isset($instance['number_slide']) ? (int) $instance['number_slide'] : 5;
        $slider = isset($instance['slider']) ? (bool) $instance['slider'] : false;
		$autoplay = isset($instance['autoplay']) ? (bool) $instance['autoplay'] : false;
		$navigation = isset($instance['navigation']) ? (bool) $instance['navigation'] : true;
		
		bigbazaar_widget_input_text(__('Title:', 'pl-bigbazaar-extensions'), $this->get_field_id('title'),$this->get_field_name('title'), $title);
		$product_type_options = array('recent-products'=>__('Recent Products','pl-bigbazaar-extensions'), 'featured-products'=>__('Featured Products','pl-bigbazaar-extensions'), 'top-reviews-products'=>__('Top Reviews Products','pl-bigbazaar-extensions'),'sale-products'=>__('Sale Products','pl-bigbazaar-extensions'),'best-seller-products'=>__('Best Seller Products','pl-bigbazaar-extensions'));
		bigbazaar_widget_select(__('Product Type:', 'pl-bigbazaar-extensions'), $this->get_field_id('product_type'),$this->get_field_name('product_type'), $product_type,$product_type_options);
		bigbazaar_widget_input_text(__('Number of products to show:', 'pl-bigbazaar-extensions'), $this->get_field_id('number'),$this->get_field_name('number'), $number);
		$orderby_options = array('date'=>__('Date','pl-bigbazaar-extensions'), 'title'=>__('Title','pl-bigbazaar-extensions'), 'name'=>__('Name(Slug)','pl-bigbazaar-extensions'),'rand'=>__('Rand','pl-bigbazaar-extensions'),'id'=>__('ID','pl-bigbazaar-extensions'));
		bigbazaar_widget_select(__('Order By:', 'pl-bigbazaar-extensions'), $this->get_field_id('orderby'),$this->get_field_name('orderby'), $orderby,$orderby_options);
		$order_options = array('desc'=>'Descending', 'asc'=>'Ascending');
		bigbazaar_widget_select(__('Order:', 'pl-bigbazaar-extensions'), $this->get_field_id('order'),$this->get_field_name('order'), $order,$order_options);
		bigbazaar_widget_input_checkbox(__('Enable slider', 'pl-bigbazaar-extensions'), $this->get_field_id('slider'), $this->get_field_name('slider'),checked($slider, true, false), 1); 
		bigbazaar_widget_input_text(__('Per slide show products:', 'pl-bigbazaar-extensions'), $this->get_field_id('number_slide'),$this->get_field_name('number_slide'), $number_slide);
		bigbazaar_widget_input_checkbox(__('Enable Auto play slider', 'pl-bigbazaar-extensions'), $this->get_field_id('autoplay'), $this->get_field_name('autoplay'),checked($autoplay, true, false), 1);
		bigbazaar_widget_input_checkbox(__('Show slider navigation', 'pl-bigbazaar-extensions'), $this->get_field_id('navigation'), $this->get_field_name('navigation'),checked($navigation, true, false), 1);
		
    }
}

// **********************************************************************// 
// ! Twitter Widget
// **********************************************************************// 

class BigBazaar_Twitter_Widget extends WP_Widget {
	
	public function __construct() {
		
         $widget_ops = array('classname' => 'bigbazaar_twitter', 'description' => __('Display most recent Twitter feed', 'pl-bigbazaar-extensions') );
		$control_ops = array('id_base' => 'bigbazaar-twitte');		
        parent::__construct('bigbazaar-twitte', 'BigBazaar '.__('Twitter Feed', 'pl-bigbazaar-extensions'), $widget_ops, $control_ops);
	}
 
    function widget( $args, $instance ) {
        extract( $args );
        $title = apply_filters('widget_title', $instance['title'] );
        echo $before_widget;
        if ( $title ) echo $before_title . $title . $after_title;
        $attr = array( 'usernames' => $instance['usernames'], 'limit' => $instance['limit'], 'interval' => $instance['interval'] );
        $attr['interval'] = $attr['interval'] * 10;
        //echo bigbazaar_get_twitter( $attr );
        //echo bigbazaar_print_tweets($instance['consumer_key'],$instance['consumer_secret'],$instance['user_token'],$instance['user_secret'],$attr['usernames'], $attr['limit'], 50);
		
		include_once(BB_EXTENSIONS_PATH.'/inc/twitteroauth/twitteroauth.php');

		/*$screen_name					= 'saaraan';
		$twitter_customer_key           = 'JdmrAiQk2mx8v3tvhDEA';
		$twitter_customer_secret        = 'uQ7imQSv6hirqQr9Nt5mksCdUCVAfk5srF0Mk3vo';
		$twitter_access_token           = '17587879-mftRUoqaPQj2OLZdu2Y08qY9vHRJfM7hE2yo87Y3d';
		$twitter_access_token_secret    = 'jFQyQ64PAEnyBVCWYPgJdVEGr3X0RpoCldgkyLUW5A';*/
		
		$screen_name					= $attr['usernames'];
		$twitter_customer_key           = $instance['consumer_key'];
		$twitter_customer_secret        = $instance['consumer_secret'];
		$twitter_access_token           = $instance['user_token'];
		$twitter_access_token_secret    = $instance['user_secret'];
		$count							= $attr['limit'];

		$connection = new TwitterOAuth($twitter_customer_key, $twitter_customer_secret, $twitter_access_token, $twitter_access_token_secret);

		$my_tweets = $connection->get('statuses/user_timeline', array('screen_name' => $attr['usernames'], 'count' => $count));

		echo '<div class="twitter-bubble">';
		if(isset($my_tweets->errors))
		{           
			echo 'Error :'. $my_tweets->errors[0]->code. ' - '. $my_tweets->errors[0]->message;
		}else{
			$html = '<ul class="twitter-list">';
			if(!empty($my_tweets)):
				foreach ($my_tweets as $tweet) {
					if(!isset($tweet->message)) :
						$html .= '<li class="lastItem firstItem"><div class="media"><i class="pull-left fa fa-twitter"></i><div class="media-body">' . makeClickableLinks($tweet->text) . '</div></div></li>';
					else :
						$html .= '<li class="lastItem firstItem"><div class="media tweet-error"><div class="media-body">' . $tweet->message . '</div></div></li>';
					endif;	
				}
			else:
				$html .= '<li class="lastItem firstItem"><div class="media"><div class="media-body">' ._e('Connection or authontication problem.','pl-bigbazaar-extensions'). '</div></div></li>';
			endif;
			$html .= '</ul>';
			echo $html;
		}
		echo '</div>';
		
        echo $after_widget;
    }
	
    function update( $new_instance, $old_instance ) {
        $instance = $old_instance;
        $instance['title'] = strip_tags( $new_instance['title'] );
        $instance['usernames'] = strip_tags( $new_instance['usernames'] );
        $instance['consumer_key'] = strip_tags( $new_instance['consumer_key'] );
        $instance['consumer_secret'] = strip_tags( $new_instance['consumer_secret'] );
        $instance['user_token'] = strip_tags( $new_instance['user_token'] );
        $instance['user_secret'] = strip_tags( $new_instance['user_secret'] );
        $instance['limit'] = strip_tags( $new_instance['limit'] );
        $instance['interval'] = strip_tags( $new_instance['interval'] );
        return $instance;
    }
    function form( $instance ) {
        $defaults = array( 'title' => __('Twitter Feed','pl-bigbazaar-extensions'), 'usernames' => '', 'consumer_key'=>'', 'consumer_secret'=>'', 'user_token'=>'', 'user_secret'=>'', 'limit' => '2', 'interval' => '5' );
        $instance = wp_parse_args( (array) $instance, $defaults );
        bigbazaar_widget_input_text( __('Title:', 'pl-bigbazaar-extensions'), $this->get_field_id( 'title' ), $this->get_field_name( 'title' ), $instance['title'] );
        bigbazaar_widget_input_text( __('Username:', 'pl-bigbazaar-extensions'), $this->get_field_id( 'usernames' ), $this->get_field_name( 'usernames' ), $instance['usernames'] );
        bigbazaar_widget_input_text( __('Customer Key:', 'pl-bigbazaar-extensions'), $this->get_field_id( 'consumer_key' ), $this->get_field_name( 'consumer_key' ), $instance['consumer_key'] );
        bigbazaar_widget_input_text( __('Customer Secret:', 'pl-bigbazaar-extensions'), $this->get_field_id( 'consumer_secret' ), $this->get_field_name( 'consumer_secret' ), $instance['consumer_secret'] );
        bigbazaar_widget_input_text( __('Access Token:', 'pl-bigbazaar-extensions'), $this->get_field_id( 'user_token' ), $this->get_field_name( 'user_token' ), $instance['user_token'] );
        bigbazaar_widget_input_text( __('Access Token Secret:', 'pl-bigbazaar-extensions'), $this->get_field_id( 'user_secret' ), $this->get_field_name( 'user_secret' ), $instance['user_secret'] );
        bigbazaar_widget_input_text( __('Number of tweets:', 'pl-bigbazaar-extensions'), $this->get_field_id( 'limit' ), $this->get_field_name( 'limit' ), $instance['limit'] );
    }
}

// **********************************************************************// 
// ! About Us Widget
// **********************************************************************// 
class BigBazaar_About_Us_Widget extends WP_Widget {
	
	public function __construct() {
		
         $widget_ops = array('classname' => 'bigbazaar_about_us', 'description' => esc_html__('Display about us', 'pl-bigbazaar-extensions') );
		$control_ops = array('id_base' => 'bigbazaar-about-us');		
        parent::__construct('bigbazaar-about-us', 'BigBazaar '.esc_html__('About Us', 'pl-bigbazaar-extensions'), $widget_ops, $control_ops);
	}

    function widget($args, $instance) {
        extract($args);

        $title = apply_filters('widget_title', empty($instance['title']) ? false : $instance['title']);
		$hide_title = (!empty($instance['hide_title'])) ? (bool) $instance['hide_title'] : false;
		$logo_url = (!empty($instance['logo_url'])) ?  $instance['logo_url'] : '';
		$our_site_url = (!empty($instance['our_site_url'])) ?  $instance['our_site_url'] : '#';
		$about_tagline = apply_filters('about_tagline', empty($instance['about_tagline']) ? false : $instance['about_tagline']);
		$address = (!empty($instance['address'])) ?  $instance['address'] : '';
		$phone_number = (!empty($instance['phone_number'])) ?  $instance['phone_number'] : '';
		$fax_number = (!empty($instance['fax_number'])) ?  $instance['fax_number'] : '';
		$email_address = (!empty($instance['email_address'])) ?  $instance['email_address'] : '';
		$website = (!empty($instance['website'])) ?  $instance['website'] : '';
		$days_hours = (!empty($instance['days_hours'])) ?  $instance['days_hours'] : '';

        // About Us        
		echo $before_widget;
		if ( $title && !$hide_title) echo $before_title . $title . $after_title;		
			
		$html='<div class="about-us-widget">';
		
		if($logo_url != '')
			$html.='<p class="about-logo"><a href="'.esc_url($our_site_url) .'"><img src="'. esc_url($logo_url) .'" alt="pl-bigbazaar-extensions" /></a></p>';			
		
		if($about_tagline != '')
			$html.='<p>'. esc_attr($about_tagline) .'</p>';			
		
		$html.='<ul class="about-us">';
			if($address != '')
				$html.='<li><i class="fa fa-map-marker"></i><span>'. esc_attr($address) .'</span></li>';				
			
			if($phone_number != '')
				$html.='<li><i class="fa fa-phone"></i><span>'. esc_attr($phone_number) .'</span></li>';
			
			if($fax_number != '')
				$html.='<li><i class="fa fa-print"></i><span>'. esc_attr($fax_number) .'</span></li>';
			
			if($email_address != ''):
				$html.='<li><i class="fa fa-envelope-o"></i><span>';
				if(is_email($email_address)){
					$html.='<a href="mailto:'. esc_attr($email_address).' ">'.esc_attr($email_address) .'</a>';
				}else{
					esc_html_e("Invalid Email Address","pl-bigbazaar-extensions");
				}
				$html.='</span>';
				$html.='</li>';
			endif;
			
			if($website != '')
				$html.='<li><i class="fa fa-globe"></i><span><a href="'.esc_url($website) .'">'.  $website .'</a></span></li>';
			
			if($days_hours != '')
				$html.='<li><i class="fa fa-clock-o"></i><span>'. esc_attr($days_hours) .'</span></li>';

		$html.='</ul>';
		$html.='</div>';
		
		echo $html;
        echo $after_widget;
    }

    function update( $new_instance, $old_instance ) {
        $instance = $old_instance;
        $instance['title'] = strip_tags( $new_instance['title'] );
		$instance['hide_title'] = (bool) $new_instance['hide_title'] ;
        $instance['logo_url'] = strip_tags( $new_instance['logo_url'] );
		$instance['our_site_url'] = strip_tags( $new_instance['our_site_url'] );
        $instance['about_tagline'] = strip_tags( $new_instance['about_tagline'] );
        $instance['address'] = strip_tags( $new_instance['address'] );
        $instance['phone_number'] = strip_tags( $new_instance['phone_number'] );
        $instance['fax_number'] = strip_tags( $new_instance['fax_number'] );
        $instance['email_address'] = strip_tags( $new_instance['email_address'] );
        $instance['website'] = strip_tags( $new_instance['website'] );
		$instance['days_hours'] = strip_tags( $new_instance['days_hours'] );
        return $instance;
    }
		
    function form( $instance ) {
        $title = isset($instance['title']) ? esc_attr($instance['title']) : esc_html__('About Us','pl-bigbazaar-extensions');
		$hide_title = isset($instance['hide_title']) ? (bool) $instance['hide_title'] : false;
		$logo_url = isset($instance['logo_url']) ? esc_attr($instance['logo_url']) : '';
		$our_site_url = isset($instance['our_site_url']) ? esc_attr($instance['our_site_url']) : '';
		$about_tagline = isset($instance['about_tagline']) ? esc_attr($instance['about_tagline']) : '';
		$address = isset($instance['address']) ? $instance['address'] : '';
		$phone_number = isset($instance['phone_number']) ? $instance['phone_number'] : '';
		$fax_number = isset($instance['fax_number']) ? $instance['fax_number'] : '';
		$email_address = isset($instance['email_address']) ? $instance['email_address'] : '';
		$website = isset($instance['website']) ? $instance['website'] : '';
		$days_hours = isset($instance['days_hours']) ? $instance['days_hours'] : '';
		
        bigbazaar_widget_input_text( esc_html__('Title:', 'pl-bigbazaar-extensions'), $this->get_field_id( 'title' ), $this->get_field_name( 'title' ), $title );
		bigbazaar_widget_input_checkbox(esc_html__('Hide Widget Title', 'pl-bigbazaar-extensions'), $this->get_field_id('hide_title'), $this->get_field_name('hide_title'),checked($hide_title, true, false), 1);
        bigbazaar_widget_input_text( esc_html__('Logo URL:', 'pl-bigbazaar-extensions'), $this->get_field_id( 'logo_url' ), $this->get_field_name( 'logo_url' ), $logo_url );
		bigbazaar_widget_input_text( esc_html__('Our Site URL:', 'pl-bigbazaar-extensions'), $this->get_field_id( 'our_site_url' ), $this->get_field_name( 'our_site_url' ), $our_site_url );
		bigbazaar_widget_textarea(esc_html__('About Tagline:', 'pl-bigbazaar-extensions'), $this->get_field_id('about_tagline'),$this->get_field_name('about_tagline'), $about_tagline);
        bigbazaar_widget_input_text( esc_html__('Address:', 'pl-bigbazaar-extensions'), $this->get_field_id( 'address' ), $this->get_field_name( 'address' ), $address );
        bigbazaar_widget_input_text( esc_html__('Phone Number:', 'pl-bigbazaar-extensions'), $this->get_field_id( 'phone_number' ), $this->get_field_name( 'phone_number' ), $phone_number );
		bigbazaar_widget_input_text( esc_html__('Fax Number:', 'pl-bigbazaar-extensions'), $this->get_field_id( 'fax_number' ), $this->get_field_name( 'fax_number' ), $fax_number );
        bigbazaar_widget_input_text( esc_html__('Email Address:', 'pl-bigbazaar-extensions'), $this->get_field_id( 'email_address' ), $this->get_field_name( 'email_address' ), $email_address );
		bigbazaar_widget_input_text( esc_html__('Website:', 'pl-bigbazaar-extensions'), $this->get_field_id( 'website' ), $this->get_field_name( 'website' ), $website );
        bigbazaar_widget_input_text( esc_html__('Working Days/Hours:', 'pl-bigbazaar-extensions'), $this->get_field_id( 'days_hours' ), $this->get_field_name( 'days_hours' ), $days_hours );		
    }
}

// **********************************************************************// 
// ! Newsletter Widget
// **********************************************************************// 
class BigBazaar_Newsletter_Widget extends WP_Widget {
	
	public function __construct() {
		
         $widget_ops = array('classname' => 'bigbazaar_newsletter', 'description' => esc_html__('Display newsletter', 'pl-bigbazaar-extensions') );
		$control_ops = array('id_base' => 'bigbazaar-newsletter');		
        parent::__construct('bigbazaar-newsletter', 'BigBazaar '.esc_html__('Newsletter', 'pl-bigbazaar-extensions'), $widget_ops, $control_ops);
	}

    function widget($args, $instance) {
        extract($args);

        $title = apply_filters('widget_title', empty($instance['title']) ? false : $instance['title']);
		$newsletter_tagline = apply_filters('newsletter_tagline', empty($instance['newsletter_tagline']) ? false : $instance['newsletter_tagline']);
		
        // About Us        
		echo $before_widget;
		if ( $title ) echo $before_title . $title . $after_title;?>	
			
		<div class="newsletter-widget">
		
			<?php if($newsletter_tagline != '')?>
				<p><?php echo esc_attr($newsletter_tagline);?></p>						
			
			<?php if( function_exists( 'mc4wp_show_form' ) ) {
				mc4wp_show_form();
			}?>
		</div>
			
		<?php echo $after_widget;
    }

    function update( $new_instance, $old_instance ) {
        $instance = $old_instance;
        $instance['title'] = strip_tags( $new_instance['title'] );		
        $instance['newsletter_tagline'] = strip_tags( $new_instance['newsletter_tagline'] );       
        return $instance;
    }
		
    function form( $instance ) {
        $title = isset($instance['title']) ? esc_attr($instance['title']) : esc_html__('Newsletter','pl-bigbazaar-extensions');		
		$newsletter_tagline = isset($instance['newsletter_tagline']) ? esc_attr($instance['newsletter_tagline']) : '';		
		
        bigbazaar_widget_input_text( esc_html__('Title:', 'pl-bigbazaar-extensions'), $this->get_field_id( 'title' ), $this->get_field_name( 'title' ), $title );
		bigbazaar_widget_textarea(esc_html__('Newsletter Tagline:', 'pl-bigbazaar-extensions'), $this->get_field_id('newsletter_tagline'),$this->get_field_name('newsletter_tagline'), $newsletter_tagline);     	
    }
}

// **********************************************************************// 
// ! Stay Connected Widget
// **********************************************************************// 
class BigBazaar_Stay_Connected_Widget extends WP_Widget {
	
	public function __construct() {
		
         $widget_ops = array('classname' => 'bigbazaar_stay_connected', 'description' => esc_html__('Display social link.', 'pl-bigbazaar-extensions') );
		$control_ops = array('id_base' => 'bigbazaar-stay-connected');		
        parent::__construct('bigbazaar-stay-connected', 'BigBazaar '.esc_html__('Stay Connected', 'pl-bigbazaar-extensions'), $widget_ops, $control_ops);
	}

    function widget($args, $instance) {
        extract($args);

        $title = apply_filters('widget_title', empty($instance['title']) ? false : $instance['title']);
		$hide_title = (!empty($instance['hide_title'])) ? (bool) $instance['hide_title'] : false;
		$social_style = (!empty($instance['social_style'])) ?  $instance['social_style'] : 'style-1';
		
        // About Us        
		echo $before_widget;
		if ( $title && !$hide_title) echo $before_title . $title . $after_title;?>	
		
		<div class="stay-connected-widget <?php echo esc_attr($social_style);?>">
			<?php //Get Social link
			if ( function_exists( 'bigbazaar_social_link' ) ){
				bigbazaar_social_link();
			}?>
		</div>
			
		<?php echo $after_widget;
    }

    function update( $new_instance, $old_instance ) {
        $instance = $old_instance;
        $instance['title'] = strip_tags( $new_instance['title'] );
		$instance['hide_title'] = (bool) $new_instance['hide_title'] ;
		$instance['social_style'] = strip_tags( $new_instance['social_style'] );
		
        return $instance;
    }
		
    function form( $instance ) {
        $title = isset($instance['title']) ? esc_attr($instance['title']) : esc_html__('Stay Connected','pl-bigbazaar-extensions');
		$hide_title = isset($instance['hide_title']) ? (bool) $instance['hide_title'] : false;
		$social_style = isset($instance['social_style']) ? esc_attr($instance['social_style']) : 'style-1';
		
        bigbazaar_widget_input_text( esc_html__('Title:', 'pl-bigbazaar-extensions'), $this->get_field_id( 'title' ), $this->get_field_name( 'title' ), $title ); 
		bigbazaar_widget_input_checkbox(esc_html__('Hide Widget Title', 'pl-bigbazaar-extensions'), $this->get_field_id('hide_title'), $this->get_field_name('hide_title'),checked($hide_title, true, false), 1);
		$social_style_option = array('style-1'=>esc_html__('Style 1','pl-bigbazaar-extensions'), 'style-2'=>esc_html__('Style 2','pl-bigbazaar-extensions'));
		bigbazaar_widget_select(esc_html__('Social Style:', 'pl-bigbazaar-extensions'), $this->get_field_id('social_style'),$this->get_field_name('social_style'), $social_style,$social_style_option);
    }
}

//function to convert text url into links.
function makeClickableLinks($s) {
  return preg_replace('@(https?://([-\w\.]+[-\w])+(:\d+)?(/([\w/_\.#-]*(\?\S+)?[^\.\s])?)?)@', '<a target="blank" rel="nofollow" href="$1" target="_blank">$1</a>', $s);
}
	
/* Forms
-------------------------------------------------------------- */
function bigbazaar_widget_label( $label, $id ) {
    echo "<label for='{$id}'>{$label}</label>";
}
function bigbazaar_widget_input_checkbox( $label, $id, $name, $checked, $value = 1 ) {
    echo "\n\t\t\t<p>";
    echo "<label for='{$id}'>";
    echo "<input type='checkbox' id='{$id}' value='{$value}' name='{$name}' {$checked} /> ";
    echo "{$label}</label>";
    echo '</p>';
}
function bigbazaar_widget_textarea( $label, $id, $name, $value ) {
    echo "\n\t\t\t<p>";
    bigbazaar_widget_label( $label, $id );
    echo "<textarea id='{$id}' name='{$name}' rows='3' cols='10' class='widefat'>" . strip_tags( $value ) . "</textarea>";
    echo '</p>';
}
function bigbazaar_widget_input_text( $label, $id, $name, $value ) {
    echo "\n\t\t\t<p>";
    bigbazaar_widget_label( $label, $id );
    echo "<input type='text' id='{$id}' name='{$name}' value='" . strip_tags( $value ) . "' class='widefat' />";
    echo '</p>';
}
function bigbazaar_widget_select( $label, $id, $name, $value, $options ) {
	echo "\n\t\t\t<p>";
	bigbazaar_widget_label( $label, $id );
	echo "<select name='{$name}' id='{$id}' class='widefat'>";
	foreach ($options as $key=>$option) { 
		echo "<option value=$key". selected($value,$key).">$option</option>";
	}
	echo '</select>';
	echo '</p>';
}