<?php 
class BigBazaar_Post_Content{
	
	function __construct() {

		add_action('init', array( $this, 'addTestimonialContentType' ) );
		add_action('init', array( $this, 'addServicesContentType' ) );
        add_action('init', array( $this, 'addPortfolioContentType' ) );
		add_action('init', array( $this, 'addProductBrand' ) );
		
		add_action('admin_enqueue_scripts', array( $this,'bigbazaar_admin_scripts' ) );
		
		//add_action( 'admin_head', array( $this, 'bigbazaar_admin_head_style') );
		//add_action( 'admin_footer', array( $this, 'bigbazaar_admin_footer_script') );
		
		// Add form
		add_action( 'product_brand_add_form_fields', array( $this, 'add_brand_fields' ) );
		add_action( 'product_brand_edit_form_fields', array( $this, 'edit_brand_fields' ), 10, 2 );
		add_action( 'created_term', array( $this, 'save_brand_fields' ), 10, 3 );
		add_action( 'edit_term', array( $this, 'save_brand_fields' ), 10, 3 );
		
		// Add columns
		add_filter( 'manage_edit-product_brand_columns', array( $this, 'product_brand_columns' ) );
		add_filter( 'manage_product_brand_custom_column', array( $this, 'product_brand_column' ), 10, 3 );
    }
	
	// add css
	function bigbazaar_admin_head_style(){
		
	}
	
	// add js
	function bigbazaar_admin_scripts(){		
		wp_enqueue_media();
	}
	
	// Register testimonial content type
    function addTestimonialContentType() {
        register_post_type(
            'testimonial',
            array(
                'labels' => $this->getLabels(__('Testimonials', 'pl-bigbazaar-extensions'), __('Testimonials', 'pl-bigbazaar-extensions')),
                'exclude_from_search' => true,
                'has_archive' => true,
                'public' => true,
                'rewrite' => array('slug' => 'testimonial'),
                'supports' => array('title', 'editor', 'thumbnail'),
                'can_export' => true,
            )
        );
    }
	
	// Register services content type
    function addServicesContentType() {
        register_post_type(
            'service',
            array(
                'labels' => $this->getLabels(__('Services', 'pl-bigbazaar-extensions'), __('Services', 'pl-bigbazaar-extensions')),
                'exclude_from_search' => true,
                'has_archive' => true,
                'public' => true,
                'rewrite' => array('slug' => 'service'),
                'supports' => array('title', 'editor', 'service'),
                'can_export' => true,
            )
        );
    }

    // Register portfolio content type
    function addPortfolioContentType() {
        register_post_type(
            'portfolio',
            array(
                'labels' => $this->getLabels(__('Portfolio', 'pl-bigbazaar-extensions'), __('Portfolios', 'pl-bigbazaar-extensions')),
                'exclude_from_search' => false,
                'has_archive' => true,
                'public' => true,
                //'rewrite' => array('slug' => 'portfolio', 'with_front' => true),
				'rewrite' => array('slug' => 'portfolio'),
                'supports' => array('title', 'editor', 'thumbnail'),
                'can_export' => true
            )
        );
		flush_rewrite_rules( false );

        register_taxonomy(
            'portfolio_cat',
            'portfolio',
            array(
                'hierarchical' => true,
                'show_in_nav_menus' => true,
                'labels' => $this->getTaxonomyLabels(__('Portfolio Category', 'pl-bigbazaar-extensions'), __('Portfolio Categories', 'pl-bigbazaar-extensions')),
                'query_var' => true,
                'rewrite' => true
            )
        );

        register_taxonomy(
            'portfolio_skills',
            'portfolio',
            array(
                'hierarchical' => true,
                'show_in_nav_menus' => true,
                'labels' => $this->getTaxonomyLabels(__('Portfolio Skill', 'pl-bigbazaar-extensions'), __('Portfolio Skills', 'pl-bigbazaar-extensions')),
                'query_var' => true,
                'rewrite' => true
            )
        );
		
		register_taxonomy(
            'service_cat',
            'service',
            array(
                'hierarchical' => true,
                'show_in_nav_menus' => true,
                'labels' => $this->getTaxonomyLabels(__('Service Category', 'pl-bigbazaar-extensions'), __('Service Categories', 'pl-bigbazaar-extensions')),
                'query_var' => true,
                'rewrite' => true
            )
        );
    }

	// Register brand content type
    function addProductBrand() {

        register_taxonomy(
            'product_brand',
            'product',
            array(
                'hierarchical' => true,
                'show_in_nav_menus' => true,
                'labels' => $this->getTaxonomyLabels(__('Brands', 'pl-bigbazaar-extensions'), __('Brands', 'pl-bigbazaar-extensions')),
				'show_admin_column'     => true,
				'update_count_callback' => '_update_post_term_count',
                'query_var' => true,
                'rewrite' => true
            )
        );
    }
	
    // load plugin text domain
    function loadTextDomain() {
        load_plugin_textdomain( 'pl-bigbazaar-extensions', false, dirname( __FILE__ ) . '/languages/' );
    }

    // Get content type labels
    function getLabels($singular_name, $name, $title = FALSE) {
        if( !$title )
            $title = $name;

        return array(
            "name" => $title,
            "singular_name" => $singular_name,
            "add_new" => __("Add New", 'pl-bigbazaar-extensions'),
            "add_new_item" => sprintf( __("Add New %s", 'pl-bigbazaar-extensions'), $singular_name),
            "edit_item" => sprintf( __("Edit %s", 'pl-bigbazaar-extensions'), $singular_name),
            "new_item" => sprintf( __("New %s", 'pl-bigbazaar-extensions'), $singular_name),
            "view_item" => sprintf( __("View %s", 'pl-bigbazaar-extensions'), $singular_name),
            "search_items" => sprintf( __("Search %s", 'pl-bigbazaar-extensions'), $name),
            "not_found" => sprintf( __("No %s found", 'pl-bigbazaar-extensions'), $name),
            "not_found_in_trash" => sprintf( __("No %s found in Trash", 'pl-bigbazaar-extensions'), $name),
            "parent_item_colon" => ""
        );
    }

    // Get content type taxonomy labels
    function getTaxonomyLabels($singular_name, $name) {
        return array(
            "name" => $name,
            "singular_name" => $singular_name,
            "search_items" => sprintf( __("Search %s", 'pl-bigbazaar-extensions'), $name),
            "all_items" => sprintf( __("All %s", 'pl-bigbazaar-extensions'), $name),
            "parent_item" => sprintf( __("Parent %s", 'pl-bigbazaar-extensions'), $singular_name),
            "parent_item_colon" => sprintf( __("Parent %s:", 'pl-bigbazaar-extensions'), $singular_name),
            "edit_item" => sprintf( __("Edit %", 'pl-bigbazaar-extensions'), $singular_name),
            "update_item" => sprintf( __("Update %s", 'pl-bigbazaar-extensions'), $singular_name),
            "add_new_item" => sprintf( __("Add New %s", 'pl-bigbazaar-extensions'), $singular_name),
            "new_item_name" => sprintf( __("New %s Name", 'pl-bigbazaar-extensions'), $singular_name),
            "menu_name" => $name,
        );
    }
	
	/**
	 * Brand thumbnail fields.
	 *
	 * @access public
	 * @return void
	 */
	function add_brand_fields() {
		?>
		<div class="form-field">
			<label><?php _e( 'Thumbnail', 'pl-bigbazaar-extensions' ); ?></label>
			<div id="product_brand_thumbnail" style="float:left;margin-right:10px;"><img src="<?php echo wc_placeholder_img_src(); ?>" width="60px" height="60px" /></div>
			<div style="line-height:60px;">
				<input type="hidden" id="product_brand_thumbnail_id" name="product_brand_thumbnail_id" />
				<button type="button" class="upload_image_button button"><?php _e( 'Upload/Add image', 'pl-bigbazaar-extensions' ); ?></button>
				<button type="button" class="remove_image_button button"><?php _e( 'Remove image', 'pl-bigbazaar-extensions' ); ?></button>
			</div>
			<script type="text/javascript">

				 // Only show the "remove image" button when needed
				 if ( ! jQuery('#product_brand_thumbnail_id').val() )
					 jQuery('.remove_image_button').hide();

				// Uploading files
				var file_frame;

				jQuery(document).on( 'click', '.upload_image_button', function( event ){

					event.preventDefault();

					// If the media frame already exists, reopen it.
					if ( file_frame ) {
						file_frame.open();
						return;
					}

					// Create the media frame.
					file_frame = wp.media.frames.downloadable_file = wp.media({
						title: '<?php _e( 'Choose an image', 'pl-bigbazaar-extensions' ); ?>',
						button: {
							text: '<?php _e( 'Use image', 'pl-bigbazaar-extensions' ); ?>',
						},
						multiple: false
					});

					// When an image is selected, run a callback.
					file_frame.on( 'select', function() {
						attachment = file_frame.state().get('selection').first().toJSON();

						jQuery('#product_brand_thumbnail_id').val( attachment.id );
						jQuery('#product_brand_thumbnail img').attr('src', attachment.url );
						jQuery('.remove_image_button').show();
					});

					// Finally, open the modal.
					file_frame.open();
				});

				jQuery(document).on( 'click', '.remove_image_button', function( event ){
					jQuery('#product_brand_thumbnail img').attr('src', '<?php echo wc_placeholder_img_src(); ?>');
					jQuery('#product_brand_thumbnail_id').val('');
					jQuery('.remove_image_button').hide();
					return false;
				});

			</script>
			<div class="clear"></div>
		</div>
		<?php
	}

	/**
	 * Edit brand thumbnail field.
	 *
	 * @access public
	 * @param mixed $term Term (brand) being edited
	 * @param mixed $taxonomy Taxonomy of the term being edited
	 */
	function edit_brand_fields( $term, $taxonomy ) {

		$image 			= '';
		$thumbnail_id 	= absint( get_woocommerce_term_meta( $term->term_id, 'thumbnail_id', true ) );
		if ( $thumbnail_id )
			$image = wp_get_attachment_thumb_url( $thumbnail_id );
		else
			$image = wc_placeholder_img_src();
		?>
		<tr class="form-field">
			<th scope="row" valign="top"><label><?php _e( 'Thumbnail', 'pl-bigbazaar-extensions' ); ?></label></th>
			<td>
				<div id="product_brand_thumbnail" style="float:left;margin-right:10px;"><img src="<?php echo $image; ?>" style="max-width: 150px; height: auto;" /></div>
				<div style="line-height:60px;">
					<input type="hidden" id="product_brand_thumbnail_id" name="product_brand_thumbnail_id" value="<?php echo $thumbnail_id; ?>" />
					<button type="submit" class="upload_image_button button"><?php _e( 'Upload/Add image', 'pl-bigbazaar-extensions' ); ?></button>
					<button type="submit" class="remove_image_button button"><?php _e( 'Remove image', 'pl-bigbazaar-extensions' ); ?></button>
				</div>
				<script type="text/javascript">

					// Uploading files
					var file_frame;

					jQuery(document).on( 'click', '.upload_image_button', function( event ){

						event.preventDefault();

						// If the media frame already exists, reopen it.
						if ( file_frame ) {
							file_frame.open();
							return;
						}

						// Create the media frame.
						file_frame = wp.media.frames.downloadable_file = wp.media({
							title: '<?php _e( 'Choose an image', 'pl-bigbazaar-extensions' ); ?>',
							button: {
								text: '<?php _e( 'Use image', 'pl-bigbazaar-extensions' ); ?>',
							},
							multiple: false
						});

						// When an image is selected, run a callback.
						file_frame.on( 'select', function() {
							attachment = file_frame.state().get('selection').first().toJSON();

							jQuery('#product_brand_thumbnail_id').val( attachment.id );
							jQuery('#product_brand_thumbnail img').attr('src', attachment.url );
							jQuery('.remove_image_button').show();
						});

						// Finally, open the modal.
						file_frame.open();
					});

					jQuery(document).on( 'click', '.remove_image_button', function( event ){
						jQuery('#product_brand_thumbnail img').attr('src', '<?php echo wc_placeholder_img_src(); ?>');
						jQuery('#product_brand_thumbnail_id').val('');
						jQuery('.remove_image_button').hide();
						return false;
					});

				</script>
				<div class="clear"></div>
			</td>
		</tr>
		<?php
	}

	/**
	 * save_brand_fields function.
	 *
	 * @access public
	 * @param mixed $term_id Term ID being saved
	 * @param mixed $tt_id
	 * @param mixed $taxonomy Taxonomy of the term being saved
	 * @return void
	 */
	function save_brand_fields( $term_id, $tt_id, $taxonomy ) {

		if ( isset( $_POST['product_brand_thumbnail_id'] ) )
			update_woocommerce_term_meta( $term_id, 'thumbnail_id', absint( $_POST['product_brand_thumbnail_id'] ) );

		delete_transient( 'wc_term_counts' );
	}

	/**
	 * Thumbnail column added to brand admin.
	 *
	 * @access public
	 * @param mixed $columns
	 * @return array
	 */
	function product_brand_columns( $columns ) {
		$new_columns          = array();
		$new_columns['cb']    = $columns['cb'];
		$new_columns['thumb'] = __( 'Image', 'pl-bigbazaar-extensions' );

		unset( $columns['cb'] );

		unset( $columns['description'] );

		return array_merge( $new_columns, $columns );
	}

	/**
	 * Thumbnail column value added to brand admin.
	 *
	 * @access public
	 * @param mixed $columns
	 * @param mixed $column
	 * @param mixed $id
	 * @return array
	 */
	function product_brand_column( $columns, $column, $id ) {

		if ( $column == 'thumb' ) {

			$image 			= '';
			$thumbnail_id 	= get_woocommerce_term_meta( $id, 'thumbnail_id', true );

			if ($thumbnail_id)
				$image = wp_get_attachment_thumb_url( $thumbnail_id );
			else
				$image = wc_placeholder_img_src();

			// Prevent esc_url from breaking spaces in urls for image embeds
			// Ref: http://core.trac.wordpress.org/ticket/23605
			$image = str_replace( ' ', '%10', $image );

			$columns .= '<img src="' . esc_url( $image ) . '" alt="Thumbnail" class="wp-post-image" style="max-width: 150px; max-height: 65px;" />';

		}

		return $columns;
	}
}
new BigBazaar_Post_Content();
?>