<?php
/**
 * @author  PressLayouts
 * @package BigBazaar
 * @version 1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

vc_map( array(
    "name"                  => __( "Testimonials", "pl-bigbazaar-extensions"),
    "base"                  => "testimonials",
	"description"           => __( "Display your testimonials.", "pl-bigbazaar-extensions"),
    "category"              => __("BigBazaar Theme", "pl-bigbazaar-extensions" ),
    "params"                => array(
		array(
			"type" 			=> "textfield",
			"heading" 		=> __( "Title", "pl-bigbazaar-extensions" ),
			"param_name" 	=> "title",
			"description"   => __( "Enter title", "pl-bigbazaar-extensions" ),
			"admin_label"   => true,
		),
		array(
			"type" 			=> "dropdown",
			"heading" 		=> __( "Order By", "pl-bigbazaar-extensions" ),
			"param_name" 	=> "orderby",
			"admin_label" 	=> true,
			"std"           => "date",
			"value" 		=> array(
				__( "Date", "pl-bigbazaar-extensions" )   => "date",
				__( "Title", "pl-bigbazaar-extensions" )   => "title",
				__( "Name(Slug)", "pl-bigbazaar-extensions" ) => "name",
				__( "Random", "pl-bigbazaar-extensions" )   => "rand",
				__( "ID", "pl-bigbazaar-extensions" )   => "id",
			),
			"description" 	=> __( "Select to sort testimonials", "pl-bigbazaar-extensions")
		),
		array(
			"type" 			=> "dropdown",
			"heading" 		=> __( "Order Direction", "pl-bigbazaar-extensions" ),
			"param_name" 	=> "order",
			"std"           => "desc",
			"value" 		=> array(
				__( "Descending", "pl-bigbazaar-extensions" ) => "desc",
				__( "Ascending", "pl-bigbazaar-extensions" )   => "asc",
			),
			"description" 	=> __( "Select to sort testimonials", "pl-bigbazaar-extensions")
		),
		array(
			"type" 			=> "textfield",
			"heading" 		=> __( "Show No. Of Testimonials", "pl-bigbazaar-extensions" ),
			"param_name" 	=> "per_page",
			"value" 		=> "10",
			"description" 	=> __( "Show number of testimonials", "pl-bigbazaar-extensions" ),
		),
		array(
            "type"        	=> "css_editor",
            "heading"     	=> __( "Css", "pl-bigbazaar-extensions" ),
            "param_name"  	=> "css",
            "group"       	=> __( "Design options", "pl-bigbazaar-extensions" ),
            "admin_label" 	=> false,
		),
		array(
            "type"        	=> "textfield",
            "heading"     	=> __( "Extra class name", "pl-bigbazaar-extensions" ),
            "param_name"  	=> "el_class",
            "description" 	=> __( "If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "pl-bigbazaar-extensions" ),
            "admin_label" 	=> false,
        ),     
    ),
));

class WPBakeryShortCode_Testimonials extends WPBakeryShortCode {	
    protected function content($atts, $content = null) {
        $atts = function_exists( 'vc_map_get_attributes' ) ? vc_map_get_attributes( 'testimonials', $atts ) : $atts;
        extract( shortcode_atts( array(
			"title"          => "title",
			"orderby"		 => "date",
			"order"          => "desc",
			"per_page"       => 10,         
            "css"            => "",       
            "el_class"       => "",        
           
        ), $atts ) );
        
		$shortcode_class = array(
        	'base' => apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, 'testimonials', $this->settings['base'], $atts ),
        	'extra' => $this->getExtraClass( $el_class ),
            'shortcode_custom' => vc_shortcode_custom_css_class( $css, ' ' )
        );        
        $shortcode_class = preg_replace( array( '/\s+/', '/^\s|\s$/' ), array( ' ', '' ), implode( ' ', $shortcode_class ) );
		
		//Get Testimonials
		$args = array(
			'post_type'				=> 'testimonial',
			'post_status'			=> 'publish',
			'ignore_sticky_posts'	=> 1,
			'posts_per_page' 		=> $atts['per_page'],
			'orderby' 			    => $atts['orderby'],
			'order' 				=> $atts['order'],
			);
		
		$testimonials = new WP_Query( $args );
		
        $id = uniqid();
		ob_start();	?>		
		<div id="section-<?php echo esc_attr($id);?>" class="testimonials-section <?php echo esc_attr($shortcode_class);?>">
			<div class="section-header">
				<div class="section-title">
					<h3><?php echo esc_html($title);?></h3>
				</div>
			</div>
			<div class="section-content">
				<?php if ( $testimonials->have_posts() ) : ?>
					<ul class="testimonials testimonial-carousel owl-carousel">
						<?php while( $testimonials->have_posts() ): $testimonials->the_post();
						$testimonial_meta = get_post_meta( get_the_ID());?>
							<li class="blockquote">
								<div class="quote-content">
									<?php the_content();?>
								</div>
								<div class="quote-meta">
									<div class="name-designation">
										<a href="<?php echo esc_url(get_permalink());?>"><?php the_title()?></a>,<?php
										if( isset( $testimonial_meta['client_designation'] ) ):
											echo esc_attr($testimonial_meta['client_designation'][0]);
										endif;?><br>
										<span class="client-company">
										<?php
										if( isset( $testimonial_meta['client_company'] ) ):
											echo esc_attr($testimonial_meta['client_company'][0]);
										endif;?>
										</span>
									</div>
									<div class="client-image">
										<?php echo get_the_post_thumbnail( $testimonials->ID, 'thumbnail' ); ?>
									</div>
								</div>
							</li>
						<?php endwhile; // end of the loop. ?>
					</ul>
				<?php endif;
				wp_reset_postdata();?>
			</div>
		</div>
		<?php
		$result = ob_get_clean();
        return $result;
    }
}