<?php
/**
 * @author  PressLayouts
 * @package BigBazaar
 * @version 1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

vc_map( array(
    "name"                  => __( "Products Brands", "pl-bigbazaar-extensions"),
    "base"                  => "products_brands",
	"description"           => __( "Display products brands with carousel slider.", "pl-bigbazaar-extensions"),
    "category"              => __("BigBazaar Theme", "pl-bigbazaar-extensions" ),
    "params"                => array(
		array(
			"type" 			=> "textfield",
			"heading" 		=> __( "Title", "pl-bigbazaar-extensions" ),
			"param_name" 	=> "title",
			"description"   => __( "Enter title", "pl-bigbazaar-extensions" ),
			"admin_label"   => true,
		),	
		array(
            "type"        	=> "bigbazaar_brands",
            "heading"     	=> __("Select Brands", "pl-bigbazaar-extensions"),
            "param_name"  	=> "brand",
            "admin_label" 	=> true,
			"description" 	=> __( "If you want to display brands of specific brand then select parent brand otherwise skip it.", "pl-bigbazaar-extensions" ),
        ),
		array(
			"type" 			=> "dropdown",
			"heading" 		=> __( "Order By", "pl-bigbazaar-extensions" ),
			"param_name" 	=> "orderby",
			"std"           => "name",
			"value" 		=> array(
				__( "ID", "pl-bigbazaar-extensions" )   => "id",
				__( "Name", "pl-bigbazaar-extensions" )   => "name",
				__( "Slug", "pl-bigbazaar-extensions" )   => "slug",
			),
			"description" 	=> __( "Select to sort brands", "pl-bigbazaar-extensions")
		),
		array(
			"type" 			=> "dropdown",
			"heading" 		=> __( "Order Direction", "pl-bigbazaar-extensions" ),
			"param_name" 	=> "order",
			"std"           => "asc",
			"value" 		=> array(
				__( "Descending", "pl-bigbazaar-extensions" ) => "desc",
				__( "Ascending", "pl-bigbazaar-extensions" )   => "asc",
			),
			"description" 	=> __( "Select to sort brands", "pl-bigbazaar-extensions")
		),
		array(
			"type" 			=> "textfield",
			"heading" 		=> __( "Show No. Of Brands", "pl-bigbazaar-extensions" ),
			"param_name" 	=> "per_page",
			"value" 		=> "12",
			"description" 	=> __( "Show number of brands per page", "pl-bigbazaar-extensions" ),
		),
		array(
			"type" 			=> "dropdown",
			"heading" 		=> __( "Show No. Of Brands rows", "pl-bigbazaar-extensions" ),
			"param_name" 	=> "brands_row",
			"std"           => "1",
			"value" 		=> array(
				__( "1 Row", "pl-bigbazaar-extensions" ) => "1",
				__( "2 Row", "pl-bigbazaar-extensions" ) => "2",
				__( "3 Row", "pl-bigbazaar-extensions" ) => "3",
			),
			"description" 	=> __( "Show number of Brands row", "pl-bigbazaar-extensions" ),
		),
		array(
			"type"        	=> "textfield",
			"heading"     	=> __( "Show No. Of Brands Columns", "pl-bigbazaar-extensions" ),
			"param_name"  	=> "brands_columns",
			"group"       	=> __( "Carousel options", "pl-bigbazaar-extensions" ),
			"value"       	=> 6,
			"description" 	=> __( "Show numbers of brands columns you want to display.", "pl-bigbazaar-extensions" ),
		),
		array(
			"type"        	=> "checkbox",
			"heading"     	=> __( "Autoplay", "pl-bigbazaar-extensions" ),
			"param_name"  	=> "auto_play",
			"group"       	=> __( "Carousel options", "pl-bigbazaar-extensions" ),
			"value"       	=> array( __( "Yes", "pl-bigbazaar-extensions" ) => "true" ),
			"description" 	=> __( "Enables autoplay mode", "pl-bigbazaar-extensions" ),
		),
		array(
			"type"        	=> "checkbox",
			"heading"     	=> __( "Navigation", "pl-bigbazaar-extensions" ),
			"param_name"  	=> "navigation",
			"group"       	=> __( "Carousel options", "pl-bigbazaar-extensions" ),
			"value"       	=> array( __( "No", "pl-bigbazaar-extensions" ) => "false" ),
			"description" 	=> __( "Show next/prev buttons", "pl-bigbazaar-extensions" ),
		),
		array(
			"type"        	=> "checkbox",
			"heading"     	=> __( "Loop", "pl-bigbazaar-extensions" ),
			"param_name"  	=> "loop",
			"group"       	=> __( "Carousel options", "pl-bigbazaar-extensions" ),
			"value"       	=> array( __( "Yes", "pl-bigbazaar-extensions" ) => "true" ),
			"description" 	=> __( "Inifnity loop. Duplicate last and first items to get loop illusion", "pl-bigbazaar-extensions" ),
		),
		array(
            "type"        	=> "css_editor",
            "heading"     	=> __( "Css", "pl-bigbazaar-extensions" ),
            "param_name"  	=> "css",
            "group"       	=> __( "Design options", "pl-bigbazaar-extensions" ),
            "admin_label" 	=> false,
		),
		array(
            "type"        	=> "textfield",
            "heading"     	=> __( "Extra class name", "pl-bigbazaar-extensions" ),
            "param_name"  	=> "el_class",
            "description" 	=> __( "If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "pl-bigbazaar-extensions" ),
            "admin_label" 	=> false,
        ),     
    ),
));

class WPBakeryShortCode_Products_Brands extends WPBakeryShortCode {	
    protected function content($atts, $content = null) {
        $atts = function_exists( 'vc_map_get_attributes' ) ? vc_map_get_attributes( 'products_brands', $atts ) : $atts;
        extract( shortcode_atts( array(
		
            "title"          => "Brands Title",
			"brand"          => -1,
			"orderby"		 => "date",
			"order"          => "desc",
			"per_page"       => 12,
			"brands_row"   => 1,
			"brands_columns"=> 5,
            "auto_play"      => "false",
            "navigation"     => "true",
            "loop"    		 => "false",          
            "css"            => "",       
            "el_class"       => "",        
           
        ), $atts ) );
        
		$shortcode_class = array(
        	'base' => apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, 'products_brands', $this->settings['base'], $atts ),
        	'extra' => $this->getExtraClass( $el_class ),
            'shortcode_custom' => vc_shortcode_custom_css_class( $css, ' ' )
        );        
        $shortcode_class = preg_replace( array( '/\s+/', '/^\s|\s$/' ), array( ' ', '' ), implode( ' ', $shortcode_class ) );
		
		//Get Brands		
		$args = array(
					'orderby' => 'ID',
					'order' => 'DESC',
					'number' => $atts['per_page'],
					'hierarchical' => 1,
				    'show_option_none' => '',
				    'hide_empty' => 1,
				    'taxonomy' => 'product_brand'
				);
		
		$term = get_term_by( 'slug', $brand, 'product_brand' );
		if(!empty($term)):
			$args['parent']=$term->term_id;
		endif;
		
		$brands = get_categories($args);
		
        $id = uniqid();
		global $owlparam;
		$owlparam['productsBrands']['section-'.$id] = array(
			'item_columns'     => $brands_columns,
			'autoplay'    => $auto_play ? $auto_play : 'false',
			'navigation'  => $navigation ? $navigation : 'true',
			'loop'        => $loop ? $loop : 'false'
		);
		
		ob_start();?>		
		<div id="section-<?php echo esc_attr($id);?>" class="product-section <?php echo esc_attr($shortcode_class);?>">
			<div class="section-header">
				<div class="section-title">
					<h3><?php echo esc_attr($title);?></h3>
				</div>
			</div>
			<div class="section-content woocommerce">
				<?php if ( !empty($brands) ) :?>
					<?php $row=1;?>
					<div class="product-items row">
						<ul class="products brands-carousel owl-carousel">
						<?php foreach($brands as $brand): ?>
							<?php if($row==1){?>
								<li class="slide-row">
									<ul>
							<?php }
								$thumbnail_id = get_woocommerce_term_meta( $brand->term_id, 'thumbnail_id' ) ;
								$image_src = wp_get_attachment_image_src( $thumbnail_id, 'full' ) ;
								$brand_link = get_term_link( $brand, 'product_brand' ) ;?>
								<li class="brand-item">
									<a href="<?php echo esc_url($brand_link) ?>">									
									<?php if ( !empty($image_src) ) {?>
										<img class="lazyOwl" alt="<?php echo esc_attr($brand->cat_name)?>" src="<?php echo esc_url($image_src[0])?>"/>
									<?php }else{?>
										<img src="<?php echo esc_url(BB_EXTENSIONS_URL.'assets/img/brand-placeholder.jpg');?>"/>
									<?php }?>									
									</a>
								</li>
							<?php if($row==$brands_row){ $row=0;?>
								</ul>
									</li>
							<?php } $row++;?>
						<?php endforeach; // end of the loop. ?>
						</ul>
					</div>
				<?php endif;
				wp_reset_query();?>
			</div>
		</div>
		<?php
		$result = ob_get_clean();
        return $result;
    }
}