<?php
/**
 * @author  PressLayouts
 * @package BigBazaar
 * @version 1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

vc_map( array(
    "name"                  => __( "Product Tabs", "pl-bigbazaar-extensions"),
    "base"                  => "product_tab",
	"description"           => __( "Display products with tabs", "pl-bigbazaar-extensions"),
    "category"              => __("BigBazaar Theme", "pl-bigbazaar-extensions" ),
    "params"                => array(	
		array(
            "type"        	=> "bigbazaar_product_cates_with_none",
            "heading"     	=> __("Select Category", "pl-bigbazaar-extensions"),
            "param_name"  	=> "category",
            "admin_label" 	=> true,
			"description" 	=> __( "Choose any one parent category", "pl-bigbazaar-extensions" ),
        ),
		array(
			"type" 			=> "dropdown",
			"heading" 		=> __( "Order By", "pl-bigbazaar-extensions" ),
			"param_name" 	=> "orderby",
			"std"           => "date",
			"value" 		=> array(
				__( "Date", "pl-bigbazaar-extensions" )   => "date",
				__( "Title", "pl-bigbazaar-extensions" )   => "title",
				__( "Name(Slug)", "pl-bigbazaar-extensions" ) => "name",
				__( "Random", "pl-bigbazaar-extensions" )   => "rand",
				__( "ID", "pl-bigbazaar-extensions" )   => "id",
			),
			"dependency"  	=> array("element" => "section_style","value" => array("banner-products","only-products")),
			"description" 	=> __( "Select to sort products", "pl-bigbazaar-extensions")
		),
		array(
			"type" 			=> "dropdown",
			"heading" 		=> __( "Order Direction", "pl-bigbazaar-extensions" ),
			"param_name" 	=> "order",
			"std"           => "desc",
			"value" 		=> array(
				__( "Descending", "pl-bigbazaar-extensions" ) => "desc",
				__( "Ascending", "pl-bigbazaar-extensions" )   => "asc",
			),
			"dependency"  	=> array("element" => "section_style","value" => array("banner-products","only-products")),
			"description" 	=> __( "Select to sort products", "pl-bigbazaar-extensions")
		),
		array(
			"type" 			=> "textfield",
			"heading" 		=> __( "Show No. Of Products Per Page", "pl-bigbazaar-extensions" ),
			"param_name" 	=> "per_page",
			"value" 		=> "12",
			"description" 	=> __( "Show number of product per page", "pl-bigbazaar-extensions" ),
		),
		array(
			"type" 			=> "dropdown",
			"heading" 		=> __( "Show No. Of Products row", "pl-bigbazaar-extensions" ),
			"param_name" 	=> "products_row",
			"std"           => "1",
			"value" 		=> array(
				__( "1 Row", "pl-bigbazaar-extensions" ) => "1",
				__( "2 Row", "pl-bigbazaar-extensions" ) => "2",
				__( "3 Row", "pl-bigbazaar-extensions" ) => "3",
			),
			"description" 	=> __( "Show number of products row", "pl-bigbazaar-extensions" ),
		),
		array(
			"type"        	=> "textfield",
			"heading"     	=> __( "Show Product Columns", "pl-bigbazaar-extensions" ),
			"param_name"  	=> "product_columns",
			"group"       	=> __( "Carousel options", "pl-bigbazaar-extensions" ),
			"value"       	=> 5,
			"description" 	=> __( "Show numbers of product columns you want to display.", "pl-bigbazaar-extensions" ),
		),
		array(
			"type"        	=> "checkbox",
			"heading"     	=> __( "Autoplay", "pl-bigbazaar-extensions" ),
			"param_name"  	=> "auto_play",
			"group"       	=> __( "Carousel options", "pl-bigbazaar-extensions" ),
			"value"       	=> array( __( "Yes", "pl-bigbazaar-extensions" ) => "true" ),
			"description" 	=> __( "Enables autoplay mode", "pl-bigbazaar-extensions" ),
		),
		array(
			"type"        	=> "checkbox",
			"heading"     	=> __( "Navigation", "pl-bigbazaar-extensions" ),
			"param_name"  	=> "navigation",
			"group"       	=> __( "Carousel options", "pl-bigbazaar-extensions" ),
			"value"       	=> array( __( "No", "pl-bigbazaar-extensions" ) => "false" ),
			"description" 	=> __( "Show next/prev buttons", "pl-bigbazaar-extensions" ),
		),
		array(
			"type"        	=> "checkbox",
			"heading"     	=> __( "Loop", "pl-bigbazaar-extensions" ),
			"param_name"  	=> "loop",
			"group"       	=> __( "Carousel options", "pl-bigbazaar-extensions" ),
			"value"       	=> array( __( "Yes", "pl-bigbazaar-extensions" ) => "true" ),
			"description" 	=> __( "Inifnity loop. Duplicate last and first items to get loop illusion", "pl-bigbazaar-extensions" ),
		),
		array(
            "type"        	=> "css_editor",
            "heading"     	=> __( "Css", "pl-bigbazaar-extensions" ),
            "param_name"  	=> "css",
            "group"       	=> __( "Design options", "pl-bigbazaar-extensions" ),
            "admin_label" 	=> false,
		),
		array(
            "type"        	=> "textfield",
            "heading"     	=> __( "Extra class name", "pl-bigbazaar-extensions" ),
            "param_name"  	=> "el_class",
            "description" 	=> __( "If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "pl-bigbazaar-extensions" ),
            "admin_label" 	=> false,
        ),     
    ),
));

class WPBakeryShortCode_Product_Tab extends WPBakeryShortCode {
    protected function content($atts, $content = null) {
        $atts = function_exists( 'vc_map_get_attributes' ) ? vc_map_get_attributes( 'product_tab', $atts ) : $atts;
        extract( shortcode_atts( array(
		
            "category"       => -1,
			"orderby"		 => "date",
			"order"          => "desc",
			"per_page"       => "12",
			"products_row"   => 1,
			"product_columns" => 5,
            "auto_play"      => "false",
            "navigation"     => "true",
            "loop"    		 => "false",          
            "css"            => "",       
            "el_class"       => "",        
           
        ), $atts ) );
        
		$shortcode_class = array(
        	'base' => apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, 'products_carousel', $this->settings['base'], $atts ),
        	'extra' => $this->getExtraClass( $el_class ),
            'shortcode_custom' => vc_shortcode_custom_css_class( $css, ' ' )
        );        
        $shortcode_class = preg_replace( array( '/\s+/', '/^\s|\s$/' ), array( ' ', '' ), implode( ' ', $shortcode_class ) );
		
		//Get Products
		global $woocommerce_loop;		
		
		// Global Query
		$args = array(
				'post_type'				=> 'product',
				'post_status'			=> 'publish',
				'ignore_sticky_posts'	=> 1,
				'posts_per_page' 		=> $atts['per_page'],
			);
		$args['meta_query'] = WC()->query->get_meta_query();
		$tax_query   		= WC()->query->get_tax_query();
		
		//Get Categories
		$term = get_term_by( 'slug', $category, 'product_cat' );
		if(!empty($term)):
			$tax_query[]=array(
							array(
								'taxonomy' => 'product_cat',
								'field'    => 'id',
								'terms'    => $term->term_id,
								'operator' => 'IN'
							)
						);
		endif;
		
		//recent products		
		$recent_args				= $args;
		$recent_args['orderby'] 	= $atts['orderby'];
		$recent_args['order'] 		= $atts['order'];
		$recent_args['tax_query']	= $tax_query;
		
		$recent_products = new WP_Query( apply_filters( 'woocommerce_shortcode_products_query', $recent_args, $atts ) );
			
		//featured products
		$f_tax_query   =$tax_query;
		$f_tax_query[] = array(
			'taxonomy' => 'product_visibility',
			'field'    => 'name',
			'terms'    => 'featured',
			'operator' => 'IN',
		);
		
		$featured_args				= $args;
		$featured_args['orderby'] 	= $atts['orderby'];
		$featured_args['order'] 	= $atts['order'];
		$featured_args['tax_query']	= $f_tax_query;
		
		$featured_products = new WP_Query( apply_filters( 'woocommerce_shortcode_products_query', $featured_args, $atts ) );
		
		//best selling
		$best_selling_args				= $args;
		$best_selling_args['meta_key'] 	= 'total_sales';
		$best_selling_args['orderby'] 	= 'meta_value_num';
		$best_selling_args['tax_query']	= $tax_query;
		
		$best_selling_products = new WP_Query( apply_filters( 'woocommerce_shortcode_products_query', $best_selling_args, $atts ) );
		
		//top reviews
		$top_reviews_args				= $args;
		$top_reviews_args['orderby'] 	= $atts['orderby'];
		$top_reviews_args['order'] 		= $atts['order'];
		$top_reviews_args['tax_query']	=$tax_query;
		
		add_filter( 'posts_clauses', array( 'WC_Shortcodes', 'order_by_rating_post_clauses' ) );
		$top_reviews_products = new WP_Query( apply_filters( 'woocommerce_shortcode_products_query', $top_reviews_args, $atts ) );
		remove_filter( 'posts_clauses', array( 'WC_Shortcodes', 'order_by_rating_post_clauses' ) );
		
		//sale products
		$product_ids_on_sale = wc_get_product_ids_on_sale();			
		$sale_args				= $args;
		$sale_args['orderby'] 	= $atts['orderby'];
		$sale_args['order'] 	= $atts['order'];
		$sale_args['tax_query']	=$tax_query;
		$sale_args['post__in'] 	= array_merge( array( 0 ), $product_ids_on_sale );
		
		$sale_products = new WP_Query( apply_filters( 'woocommerce_shortcode_products_query', $sale_args, $atts ) );
		
		
        $id = uniqid();
		global $owlparam;
		$owlparam['productsCarousel']['section-'.$id] = array(
			'item_columns'     => $product_columns,
			'autoplay'    => $auto_play ? $auto_play : 'false',
			'navigation'  => $navigation ? $navigation : 'true',
			'loop'        => $loop ? $loop : 'false'
		);
		
		ob_start();	?>		
		<div id="section-<?php echo esc_attr($id);?>" class="product-section <?php echo esc_attr($shortcode_class);?>">
			<div class="section-header">
				<div class="section-tab">
				<?php $t=0;?>
					<ul class="nav nav-tabs"><?php 
					if ( $recent_products->have_posts() ) :?>
						<li <?php echo  $t == 0 ? 'class="active"': '' ?>>
							<a href="#recent-<?php echo esc_attr($id);?>" data-toggle="tab"><?php _e('Recent Products','pl-bigbazaar-extensions');?></a>
						</li><?php $t++;						
					endif;
					if ( $best_selling_products->have_posts() ) :?>
						<li <?php echo  $t == 0 ? 'class="active"': '' ?>>
							<a href="#seller-<?php echo esc_attr($id);?>" data-toggle="tab"><?php _e('Best Seller','pl-bigbazaar-extensions');?></a>
						</li><?php $t++;						
					endif;						
					if ( $featured_products->have_posts() ) :?>
						<li <?php echo  $t == 0 ? 'class="active"': '' ?>>
							<a href="#featured-<?php echo esc_attr($id);?>" data-toggle="tab"><?php _e('Featured Products','pl-bigbazaar-extensions');?></a>
						</li><?php $t++;						
					endif;
					
					if ( $top_reviews_products->have_posts() ) :?>
						<li <?php echo  $t == 0 ? 'class="active"': '' ?>>
							<a href="#reviews-<?php echo esc_attr($id);?>" data-toggle="tab"><?php _e('Top Reviews','pl-bigbazaar-extensions');?></a>
						</li><?php $t++;						
					endif;
					
					if ( $sale_products->have_posts() ) :?>
						<li <?php echo  $t == 0 ? 'class="active"': '' ?>>
							<a href="#sale-<?php echo esc_attr($id);?>" data-toggle="tab"><?php _e('Sale Products','pl-bigbazaar-extensions');?></a>
						</li><?php $t++;						
					endif;?>
					</ul>						
				</div>
			</div>
			<div class="section-content woocommerce">
				<div class="tab-content">
				<?php $p=0;
				if ( $recent_products->have_posts() ) :?>
					<div class="tab-pane fade<?php echo  $p == 0 ? ' in active': '' ?>" id="recent-<?php echo esc_attr($id);?>">
						<?php $row=1;?>
						<div class="product-items row">
							<ul class="products product-carousel owl-carousel">
							<?php while ( $recent_products->have_posts() ) : $recent_products->the_post(); ?>
								<?php if($row==1){?>
									<li class="slide-row">
										<ul>
								<?php }?>
											<?php wc_get_template_part( 'content', 'product' ); ?>
								<?php if($row==$products_row || $recent_products->current_post+1==$recent_products->post_count){ $row=0;?>
										</ul>
									</li>
								<?php } $row++;?>
							<?php endwhile; // end of the loop. ?>
							</ul>
						</div>
					</div>
					<?php $p++;						
				endif;
				
				if ( $best_selling_products->have_posts() ) :?>
					<div class="tab-pane fade<?php echo  $p == 0 ? ' in active': '' ?>" id="seller-<?php echo esc_attr($id);?>">
						<?php $row=1;?>
						<div class="product-items row">
							<ul class="products product-carousel owl-carousel">
							<?php while ( $best_selling_products->have_posts() ) : $best_selling_products->the_post(); ?>
								<?php if($row==1){?>
									<li class="slide-row">
										<ul>
								<?php }?>
											<?php wc_get_template_part( 'content', 'product' ); ?>
								<?php if($row==$products_row || $best_selling_products->current_post+1==$best_selling_products->post_count){ $row=0;?>
										</ul>
									</li>
								<?php } $row++;?>
							<?php endwhile; // end of the loop. ?>
							</ul>
						</div>
					</div>
					<?php $p++;						
				endif;
				
				if ( $featured_products->have_posts() ) :?>
					<div class="tab-pane fade<?php echo  $p == 0 ? ' in active': '' ?>" id="featured-<?php echo esc_attr($id);?>">
						<?php $row=1;?>
						<div class="product-items row">
							<ul class="products product-carousel owl-carousel">
							<?php while ( $featured_products->have_posts() ) : $featured_products->the_post(); ?>
								<?php if($row==1){?>
									<li class="slide-row">
										<ul>
								<?php }?>
											<?php wc_get_template_part( 'content', 'product' ); ?>
								<?php if($row==$products_row || $featured_products->current_post+1==$featured_products->post_count){ $row=0;?>
										</ul>
									</li>
								<?php } $row++;?>
							<?php endwhile; // end of the loop. ?>
							</ul>
						</div>
					</div>
					<?php $p++;						
				endif;
				
				if ( $top_reviews_products->have_posts() ) :?>
					<div class="tab-pane fade<?php echo  $p == 0 ? ' in active': '' ?>" id="reviews-<?php echo esc_attr($id);?>">
						<?php $row=1;?>
						<div class="product-items row">
							<ul class="products product-carousel owl-carousel">
							<?php while ( $top_reviews_products->have_posts() ) : $top_reviews_products->the_post(); ?>
								<?php if($row==1){?>
									<li class="slide-row">
										<ul>
								<?php }?>
											<?php wc_get_template_part( 'content', 'product' ); ?>
								<?php if($row==$products_row || $top_reviews_products->current_post+1==$top_reviews_products->post_count){ $row=0;?>
										</ul>
									</li>
								<?php } $row++;?>
							<?php endwhile; // end of the loop. ?>
							</ul>
						</div>
					</div>
					<?php $p++;					
				endif;
				
				if ( $sale_products->have_posts() ) :?>
					<div class="tab-pane fade<?php echo  $p == 0 ? ' in active': '' ?>" id="sale-<?php echo esc_attr($id);?>">
						<?php $row=1;?>
						<div class="product-items row">
							<ul class="products product-carousel owl-carousel">
							<?php while ( $sale_products->have_posts() ) : $sale_products->the_post(); ?>
								<?php if($row==1){?>
									<li class="slide-row">
										<ul>
								<?php }?>
											<?php wc_get_template_part( 'content', 'product' ); ?>
								<?php if($row==$products_row || $sale_products->current_post+1==$sale_products->post_count){ $row=0;?>
										</ul>
									</li>
								<?php } $row++;?>
							<?php endwhile; // end of the loop. ?>
							</ul>
						</div>
					</div>
					<?php $p++;					
				endif;
				wp_reset_postdata();?>
				</div>
			</div>
		</div>
		<?php
		$result = ob_get_clean();
        return $result;
    }

}