<?php
/**
 * @author  PressLayouts
 * @package BigBazaar
 * @version 1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

vc_map( array(
    "name"                  => __( "Newsletter", "pl-bigbazaar-extensions"),
    "base"                  => "newsletter",
	"description"           => __( "Display newsletter.", "pl-bigbazaar-extensions"),
    "category"              => __("BigBazaar Theme", "pl-bigbazaar-extensions" ),
    "params"                => array(
		array(
			"type" 			=> "textfield",
			"heading" 		=> __( "Title", "pl-bigbazaar-extensions" ),
			"param_name" 	=> "title",
			"description"   => __( "Enter title", "pl-bigbazaar-extensions" ),
			"admin_label"   => true,
		),
		array(
			"type" 			=> "textfield",
			"heading" 		=> __( "Newsletter Tag line.", "pl-bigbazaar-extensions" ),
			"param_name" 	=> "newsletter_tagline",
			"description" 	=> __( "Enter newsletter tag line.", "pl-bigbazaar-extensions" ),
		),
		array(
            "type"        	=> "css_editor",
            "heading"     	=> __( "Css", "pl-bigbazaar-extensions" ),
            "param_name"  	=> "css",
            "group"       	=> __( "Design options", "pl-bigbazaar-extensions" ),
            "admin_label" 	=> false,
		),
		array(
            "type"        	=> "textfield",
            "heading"     	=> __( "Extra class name", "pl-bigbazaar-extensions" ),
            "param_name"  	=> "el_class",
            "description" 	=> __( "If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "pl-bigbazaar-extensions" ),
            "admin_label" 	=> false,
        ),     
    ),
));

class WPBakeryShortCode_Newsletter extends WPBakeryShortCode {	
    protected function content($atts, $content = null) {
        $atts = function_exists( 'vc_map_get_attributes' ) ? vc_map_get_attributes( 'newsletter', $atts ) : $atts;
        extract( shortcode_atts( array(
			"title"          => "title",
			"newsletter_tagline"  => "",      
            "css"            => "",       
            "el_class"       => "",           
        ), $atts ) );
        
		$shortcode_class = array(
        	'base' => apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, 'newsletter', $this->settings['base'], $atts ),
        	'extra' => $this->getExtraClass( $el_class ),
            'shortcode_custom' => vc_shortcode_custom_css_class( $css, ' ' )
        );        
        $shortcode_class = preg_replace( array( '/\s+/', '/^\s|\s$/' ), array( ' ', '' ), implode( ' ', $shortcode_class ) );

        $id = uniqid();
		ob_start();	?>	
		<div id="section-<?php echo esc_attr($id);?>" class="newsletter-section <?php echo esc_attr($shortcode_class);?>">
			<div class="section-header">
				<div class="section-title">
					<h3><?php echo esc_html($title);?></h3>
				</div>
			</div>
			<div class="section-content">
				<p><?php echo esc_html($newsletter_tagline);?></p>
				<?php if( function_exists( 'mc4wp_show_form' ) ) {
					mc4wp_show_form();
				}?>
			</div>
		</div>
		<?php
		$result = ob_get_clean();
        return $result;
    }
}