<?php
/**
 * @author  PressLayouts
 * @package BigBazaar
 * @version 1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

vc_map( array(
    "name"                  => __( "Hot Deal Products", "pl-bigbazaar-extensions"),
    "base"                  => "hot_deal_products",
	"description"           => __( "Display hot deal products with carousel.", "pl-bigbazaar-extensions"),
    "category"              => __("BigBazaar Theme", "pl-bigbazaar-extensions" ),
    "params"                => array(
		array(
			"type" 			=> "textfield",
			"heading" 		=> __( "Title", "pl-bigbazaar-extensions" ),
			"param_name" 	=> "title",
			"description"   => __( "Enter title", "pl-bigbazaar-extensions" ),
			"admin_label"   => true,
		),	
		array(
            "type"        	=> "bigbazaar_product_cates_with_none",
            "heading"     	=> __("Select Category", "pl-bigbazaar-extensions"),
            "param_name"  	=> "category",
            "admin_label" 	=> true,
			"description" 	=> __( "If you want to display hot deal products of specific category then select category otherwise skip it.", "pl-bigbazaar-extensions" ),
        ),
		array(
			"type" 			=> "dropdown",
			"heading" 		=> __( "Order By", "pl-bigbazaar-extensions" ),
			"param_name" 	=> "orderby",
			"std"           => "date",
			"value" 		=> array(
				__( "Date", "pl-bigbazaar-extensions" )   => "date",
				__( "Title", "pl-bigbazaar-extensions" )   => "title",
				__( "Name(Slug)", "pl-bigbazaar-extensions" ) => "name",
				__( "Random", "pl-bigbazaar-extensions" )   => "rand",
				__( "ID", "pl-bigbazaar-extensions" )   => "id",
			),
			"description" 	=> __( "Select to sort products", "pl-bigbazaar-extensions")
		),
		array(
			"type" 			=> "dropdown",
			"heading" 		=> __( "Order Direction", "pl-bigbazaar-extensions" ),
			"param_name" 	=> "order",
			"std"           => "desc",
			"value" 		=> array(
				__( "Descending", "pl-bigbazaar-extensions" ) => "desc",
				__( "Ascending", "pl-bigbazaar-extensions" )   => "asc",
			),
			"description" 	=> __( "Select to sort products", "pl-bigbazaar-extensions")
		),
		array(
			"type" 			=> "textfield",
			"heading" 		=> __( "Show No. Of Products", "pl-bigbazaar-extensions" ),
			"param_name" 	=> "per_page",
			"value" 		=> "12",
			"description" 	=> __( "Show number of display product", "pl-bigbazaar-extensions" ),
		),
		array(
			"type" 			=> "dropdown",
			"heading" 		=> __( "Show No. Of Products row", "pl-bigbazaar-extensions" ),
			"param_name" 	=> "products_row",
			"std"           => "1",
			"value" 		=> array(
				__( "1 Row", "pl-bigbazaar-extensions" ) => "1",
				__( "2 Row", "pl-bigbazaar-extensions" ) => "2",
				__( "3 Row", "pl-bigbazaar-extensions" ) => "3",
			),
			"description" 	=> __( "Show number of products row", "pl-bigbazaar-extensions" ),
		),
		array(
			"type"        	=> "textfield",
			"heading"     	=> __( "Show No. Of Product Columns", "pl-bigbazaar-extensions" ),
			"param_name"  	=> "product_columns",
			"group"       	=> __( "Carousel options", "pl-bigbazaar-extensions" ),
			"value"       	=> 5,
			"description" 	=> __( "Show numbers of product columns you want to display.", "pl-bigbazaar-extensions" ),
		),
		array(
			"type"        	=> "checkbox",
			"heading"     	=> __( "Autoplay", "pl-bigbazaar-extensions" ),
			"param_name"  	=> "auto_play",
			"group"       	=> __( "Carousel options", "pl-bigbazaar-extensions" ),
			"value"       	=> array( __( "Yes", "pl-bigbazaar-extensions" ) => "true" ),
			"description" 	=> __( "Enables autoplay mode", "pl-bigbazaar-extensions" ),
		),
		array(
			"type"        	=> "checkbox",
			"heading"     	=> __( "Navigation", "pl-bigbazaar-extensions" ),
			"param_name"  	=> "navigation",
			"group"       	=> __( "Carousel options", "pl-bigbazaar-extensions" ),
			"value"       	=> array( __( "No", "pl-bigbazaar-extensions" ) => "false" ),
			"description" 	=> __( "Show next/prev buttons", "pl-bigbazaar-extensions" ),
		),
		array(
			"type"        	=> "checkbox",
			"heading"     	=> __( "Loop", "pl-bigbazaar-extensions" ),
			"param_name"  	=> "loop",
			"group"       	=> __( "Carousel options", "pl-bigbazaar-extensions" ),
			"value"       	=> array( __( "Yes", "pl-bigbazaar-extensions" ) => "true" ),
			"description" 	=> __( "Inifnity loop. Duplicate last and first items to get loop illusion", "pl-bigbazaar-extensions" ),
		),
		array(
            "type"        	=> "css_editor",
            "heading"     	=> __( "Css", "pl-bigbazaar-extensions" ),
            "param_name"  	=> "css",
            "group"       	=> __( "Design options", "pl-bigbazaar-extensions" ),
            "admin_label" 	=> false,
		),
		array(
            "type"        	=> "textfield",
            "heading"     	=> __( "Extra class name", "pl-bigbazaar-extensions" ),
            "param_name"  	=> "el_class",
            "description" 	=> __( "If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "pl-bigbazaar-extensions" ),
            "admin_label" 	=> false,
        ),     
    ),
));

class WPBakeryShortCode_Hot_Deal_Products extends WPBakeryShortCode {	
    protected function content($atts, $content = null) {
        $atts = function_exists( 'vc_map_get_attributes' ) ? vc_map_get_attributes( 'hot_deal_products', $atts ) : $atts;
        extract( shortcode_atts( array(
		
            "title"          => "Products Title",
			"category"       => -1,
			"orderby"		 => "date",
			"order"          => "desc",
			"per_page"       => 12,
			"products_row"   => 1,
			"product_columns"=> 5,
            "auto_play"      => "false",
            "navigation"     => "true",
            "loop"    		 => "false",          
            "css"            => "",       
            "el_class"       => "",        
           
        ), $atts ) );
        
		$shortcode_class = array(
        	'base' => apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, 'hot_deal_products', $this->settings['base'], $atts ),
        	'extra' => $this->getExtraClass( $el_class ),
            'shortcode_custom' => vc_shortcode_custom_css_class( $css, ' ' )
        );        
        $shortcode_class = preg_replace( array( '/\s+/', '/^\s|\s$/' ), array( ' ', '' ), implode( ' ', $shortcode_class ) );
		
		//Get Categories
		$term = get_term_by( 'slug', $category, 'product_cat' );
		if(!empty($term)):
			$tax_query=array(
							array(
								'taxonomy' => 'product_cat',
								'field'    => 'id',
								'terms'    => $term->term_id,
								'operator' => 'IN'
							)
						);
		endif;
		
		//Get Products
        global $woocommerce_loop;		
		$meta_query = WC()->query->get_meta_query();
		
		//Hot Deal products
		
		// Get products on sale
		$product_ids_on_sale = wc_get_product_ids_on_sale();
		$meta_query = WC()->query->get_meta_query();
		$meta_query[] = array(
			'key'     => '_sale_price_dates_to',
			'value'   => strtotime( 'now' ),
			'compare' => '>'
		);
		$args = array(
			'post_type'				=> 'product',
			'post_status'			=> 'publish',
			'ignore_sticky_posts'	=> 1,
			'posts_per_page' 		=> $atts['per_page'],
			'orderby' 			    => $atts['orderby'],
			'order' 				=> $atts['order'],
			'post__in'			    => array_merge( array( 0 ), $product_ids_on_sale ),
			'meta_query' 			=> $meta_query,
			);
			
		if(!empty($term)):
			$args['tax_query']=$tax_query;
		endif;
		
		$products = new WP_Query( apply_filters( 'woocommerce_shortcode_products_query', $args, $atts ) );
		
        $id = uniqid();
		global $owlparam;
		$owlparam['productsCarousel']['section-'.$id] = array(
			'item_columns'     => $product_columns,
			'autoplay'    => $auto_play ? $auto_play : 'false',
			'navigation'  => $navigation ? $navigation : 'true',
			'loop'        => $loop ? $loop : 'false'
		);
		
		ob_start();	?>			
		<div id="section-<?php echo esc_attr($id);?>" class="product-section <?php echo esc_attr($shortcode_class);?>">
			<div class="section-header">
				<div class="section-title">
					<h3><?php echo esc_attr($title);?></h3>
				</div>
			</div>
			<div class="section-content woocommerce">
				<?php if ( $products->have_posts() ) :?>
					<?php $row=1;?>
					<div class="product-items row">
						<ul class="products product-carousel owl-carousel">
						<?php while ( $products->have_posts() ) : $products->the_post(); ?>
							<?php if($row==1){?>
								<li class="slide-row">
									<ul>
							<?php }?>
								<?php wc_get_template_part( 'content', 'product' ); ?>
							<?php if($row==$products_row || $products->current_post+1==$products->post_count){ $row=0;?>
									</ul>
								</li>
							<?php } $row++;?>
						<?php endwhile; // end of the loop. ?>
						</ul>
					</div>
				<?php endif;
				wp_reset_postdata();?>
			</div>
		</div>
		<?php
		$result = ob_get_clean();
        return $result;
    }

}