<?php
/**
 * @author  PressLayouts
 * @package BigBazaar
 * @version 1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

vc_map( array(
    "name"                  => __( "Product Categories", "pl-bigbazaar-extensions"),
    "base"                  => "categories_carousel",
	"description"           => __( "Display product categories with carousel slider.", "pl-bigbazaar-extensions"),
    "category"              => __("BigBazaar Theme", "pl-bigbazaar-extensions" ),
    "params"                => array(
		array(
			"type" 			=> "textfield",
			"heading" 		=> __( "Title", "pl-bigbazaar-extensions" ),
			"param_name" 	=> "title",
			"description"   => __( "Enter title", "pl-bigbazaar-extensions" ),
			"admin_label"   => true,
		),	
		array(
            "type"        	=> "bigbazaar_product_cates_with_none",
            "heading"     	=> __("Select Category", "pl-bigbazaar-extensions"),
            "param_name"  	=> "category",
            "admin_label" 	=> true,
			"description" 	=> __( "If you want to display categories of specific category then select category otherwise skip it.", "pl-bigbazaar-extensions" ),
        ),
		array(
			"type" 			=> "dropdown",
			"heading" 		=> __( "Order By", "pl-bigbazaar-extensions" ),
			"param_name" 	=> "orderby",
			"std"           => "name",
			"value" 		=> array(
				__( "ID", "pl-bigbazaar-extensions" )   => "id",
				__( "Name", "pl-bigbazaar-extensions" )   => "name",
				__( "Slug", "pl-bigbazaar-extensions" )   => "slug",
			),
			"description" 	=> __( "Select to sort categories", "pl-bigbazaar-extensions")
		),
		array(
			"type" 			=> "dropdown",
			"heading" 		=> __( "Order Direction", "pl-bigbazaar-extensions" ),
			"param_name" 	=> "order",
			"std"           => "desc",
			"value" 		=> array(
				__( "Descending", "pl-bigbazaar-extensions" ) => "desc",
				__( "Ascending", "pl-bigbazaar-extensions" )   => "asc",
			),
			"description" 	=> __( "Select to sort categories", "pl-bigbazaar-extensions")
		),
		array(
			"type" 			=> "textfield",
			"heading" 		=> __( "Show No. Of Categories", "pl-bigbazaar-extensions" ),
			"param_name" 	=> "per_page",
			"value" 		=> "12",
			"description" 	=> __( "Show number of display categories", "pl-bigbazaar-extensions" ),
		),
		array(
			"type" 			=> "dropdown",
			"heading" 		=> __( "Show No. Of Categories row", "pl-bigbazaar-extensions" ),
			"param_name" 	=> "categories_row",
			"std"           => "1",
			"value" 		=> array(
				__( "1 Row", "pl-bigbazaar-extensions" ) => "1",
				__( "2 Row", "pl-bigbazaar-extensions" ) => "2",
				__( "3 Row", "pl-bigbazaar-extensions" ) => "3",
			),
			"description" 	=> __( "Show number of categories row", "pl-bigbazaar-extensions" ),
		),
		array(
			"type"        	=> "textfield",
			"heading"     	=> __( "Show No. Of Categories Columns", "pl-bigbazaar-extensions" ),
			"param_name"  	=> "category_columns",
			"group"       	=> __( "Carousel options", "pl-bigbazaar-extensions" ),
			"value"       	=> 5,
			"description" 	=> __( "Show numbers of category columns you want to display.", "pl-bigbazaar-extensions" ),
		),
		array(
			"type"        	=> "checkbox",
			"heading"     	=> __( "Autoplay", "pl-bigbazaar-extensions" ),
			"param_name"  	=> "auto_play",
			"group"       	=> __( "Carousel options", "pl-bigbazaar-extensions" ),
			"value"       	=> array( __( "Yes", "pl-bigbazaar-extensions" ) => "true" ),
			"description" 	=> __( "Enables autoplay mode", "pl-bigbazaar-extensions" ),
		),
		array(
			"type"        	=> "checkbox",
			"heading"     	=> __( "Navigation", "pl-bigbazaar-extensions" ),
			"param_name"  	=> "navigation",
			"group"       	=> __( "Carousel options", "pl-bigbazaar-extensions" ),
			"value"       	=> array( __( "No", "pl-bigbazaar-extensions" ) => "false" ),
			"description" 	=> __( "Show next/prev buttons", "pl-bigbazaar-extensions" ),
		),
		array(
			"type"        	=> "checkbox",
			"heading"     	=> __( "Loop", "pl-bigbazaar-extensions" ),
			"param_name"  	=> "loop",
			"group"       	=> __( "Carousel options", "pl-bigbazaar-extensions" ),
			"value"       	=> array( __( "Yes", "pl-bigbazaar-extensions" ) => "true" ),
			"description" 	=> __( "Inifnity loop. Duplicate last and first items to get loop illusion", "pl-bigbazaar-extensions" ),
		),
		array(
            "type"        	=> "css_editor",
            "heading"     	=> __( "Css", "pl-bigbazaar-extensions" ),
            "param_name"  	=> "css",
            "group"       	=> __( "Design options", "pl-bigbazaar-extensions" ),
            "admin_label" 	=> false,
		),
		array(
            "type"        	=> "textfield",
            "heading"     	=> __( "Extra class name", "pl-bigbazaar-extensions" ),
            "param_name"  	=> "el_class",
            "description" 	=> __( "If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "pl-bigbazaar-extensions" ),
            "admin_label" 	=> false,
        ),     
    ),
));

class WPBakeryShortCode_Categories_Carousel extends WPBakeryShortCode {	
    protected function content($atts, $content = null) {
        $atts = function_exists( 'vc_map_get_attributes' ) ? vc_map_get_attributes( 'categories_carousel', $atts ) : $atts;
        extract( shortcode_atts( array(
		
            "title"          => "Categories Title",
			"category"       => -1,
			"orderby"		 => "date",
			"order"          => "desc",
			"per_page"       => 12,
			"categories_row"   => 1,
			"category_columns"=> 5,
            "auto_play"      => "false",
            "navigation"     => "true",
            "loop"    		 => "false",          
            "css"            => "",       
            "el_class"       => "",        
           
        ), $atts ) );
        
		$shortcode_class = array(
        	'base' => apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, 'categories_carousel', $this->settings['base'], $atts ),
        	'extra' => $this->getExtraClass( $el_class ),
            'shortcode_custom' => vc_shortcode_custom_css_class( $css, ' ' )
        );        
        $shortcode_class = preg_replace( array( '/\s+/', '/^\s|\s$/' ), array( ' ', '' ), implode( ' ', $shortcode_class ) );
		
		//Get Categories		
		$args = array(
					'orderby' => $atts['orderby'],
					'order' => $atts['order'],
					'number' => $atts['per_page'],
					'hierarchical' => 1,
				    'show_option_none' => '',
				    'hide_empty' => 1,
				    'taxonomy' => 'product_cat'
				);
		
		$term = get_term_by( 'slug', $category, 'product_cat' );
		if(!empty($term)):
			$args['parent']=$term->term_id;
		endif;
		
		$subcats = get_categories($args);
		
        $id = uniqid();
		global $owlparam;
		$owlparam['productsCarousel']['section-'.$id] = array(
			'item_columns'     => $category_columns,
			'autoplay'    => $auto_play ? $auto_play : 'false',
			'navigation'  => $navigation ? $navigation : 'true',
			'loop'        => $loop ? $loop : 'false'
		);
		
		ob_start();	?>		
		<div id="section-<?php echo esc_attr($id);?>" class="product-section <?php echo esc_attr($shortcode_class);?>">
			<div class="section-header">
				<div class="section-title">
					<h3><?php echo esc_attr($title);?></h3>
				</div>
			</div>
			<div class="section-content woocommerce">
				<?php if ( !empty($subcats) ) : $lastElement = end($subcats);?>
					<?php $row=1;?>
					<div class="product-items row">
						<ul class="products product-carousel owl-carousel">
						<?php foreach($subcats as $cate): ?>
							<?php if($row==1){?>
								<li class="slide-row">
									<ul>
							<?php }?>
							<?php $cate_link = get_term_link( $cate ); ?>
								<li class="category-entry">
									<div class="category-image">
										<?php $thumbnail_id = get_woocommerce_term_meta( $cate->term_id, 'thumbnail_id', true );
										$catalog_img = wp_get_attachment_image_src( $thumbnail_id, 'shop_catalog' );
										if ( !empty($catalog_img) ) {?>
											<a href="<?php echo esc_url($cate_link);?>">										
											<img src="<?php echo esc_url($catalog_img[0]);?>" alt="<?php echo esc_html($cate->name);?>" />
											</a>
										<?php }else{?>
											<img src="<?php echo esc_url(BB_EXTENSIONS_URL.'assets/img/product-listing-placeholder.jpg');?>"/>
										<?php }?>											
									</div>
									<div class="category-content">
										<a href="<?php echo esc_url($cate_link);?>">
											<div class="category-title">
												<h3><?php echo esc_html($cate->name);?></h3>
											</div>
											<div class="cate-explore"><?php _e('Explore Now','pl-bigbazaar-extensions');?><i class="fa fa-angle-right"></i></div>
										</a>
									</div>
								</li>
							<?php if($row==$categories_row || $cate==$lastElement){ $row=0;?>
									</ul>
								</li>
							<?php } $row++;?>
						<?php endforeach; // end of the loop. ?>
						</ul>
					</div>
				<?php endif;
				wp_reset_query();?>
			</div>
		</div>
		<?php
		$result = ob_get_clean();
        return $result;		
    }

}