<?php
/**
 * @author  PressLayouts
 * @package BigBazaar
 * @version 1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

vc_map( array(
    "name"                  => __( "Categories And Products", "pl-bigbazaar-extensions"),
    "base"                  => "categories_and_products",
	"description"           => __( "Display categories and products", "pl-bigbazaar-extensions"),
    "category"              => __("BigBazaar Theme", "pl-bigbazaar-extensions" ),
    "params"                => array(
		array(
			"type" 			=> "textfield",
			"heading" 		=> __( "Title", "pl-bigbazaar-extensions" ),
			"param_name" 	=> "title",
			"description"   => __( "Enter category/section title.", "pl-bigbazaar-extensions" ),
			"admin_label"   => true,
		),	
		array(
            "type"        	=> "bigbazaar_product_categories",
            "heading"     	=> __("Select Category", "pl-bigbazaar-extensions"),
            "param_name"  	=> "category",
            "admin_label" 	=> true,
			"description" 	=> __( "Choose any one parent category then display it's sub categories and products.", "pl-bigbazaar-extensions" ),
        ),
		array(
            "type"        	=> "dropdown",
            "heading"     	=> __("Section Style", "pl-bigbazaar-extensions"),
            "param_name"  	=> "section_style",
            "admin_label" 	=> true,
            "std"         	=> "banner-products",
            "value"       	=> array(
				__( "Banner With Products Of Category", "pl-bigbazaar-extensions" ) => "banner-products",
        		__( "Banner With Sub Categories Of Category", "pl-bigbazaar-extensions" ) => "banner-categories",
				__( "Brands With Products Of Category", "pl-bigbazaar-extensions" ) => "brands-products",
                __( "Brands With Sub Categories Of Category", "pl-bigbazaar-extensions" ) => "brands-categories",
				__( "Only Products Of Category", "pl-bigbazaar-extensions" ) => "only-products",
				__( "Only Sub Categories Of Category", "pl-bigbazaar-extensions" ) => "only-categories",
        	),
			"description" 	=> __( "Choose main section style. (ex. If you choose 'Banner With Products Of Category' then display left side banner images and right side display products slider).", "pl-bigbazaar-extensions" ),
        ),
		array(
			"type" 			=> "dropdown",
			"heading" 		=> __( "Order By", "pl-bigbazaar-extensions" ),
			"param_name" 	=> "orderby",
			"std"           => "date",
			"value" 		=> array(
				__( "Date", "pl-bigbazaar-extensions" )   => "date",
				__( "Title", "pl-bigbazaar-extensions" )   => "title",
				__( "Name(Slug)", "pl-bigbazaar-extensions" ) => "name",
				__( "Random", "pl-bigbazaar-extensions" )   => "rand",
				__( "ID", "pl-bigbazaar-extensions" )   => "id",
			),
			"dependency"  	=> array("element" => "section_style","value" => array("banner-products","only-products")),
			"description" 	=> __( "Select to sort products", "pl-bigbazaar-extensions")
		),
		array(
			"type" 			=> "dropdown",
			"heading" 		=> __( "Order Direction", "pl-bigbazaar-extensions" ),
			"param_name" 	=> "order",
			"std"           => "desc",
			"value" 		=> array(
				__( "Descending", "pl-bigbazaar-extensions" ) => "desc",
				__( "Ascending", "pl-bigbazaar-extensions" )   => "asc",
			),
			"dependency"  	=> array("element" => "section_style","value" => array("banner-products","only-products")),
			"description" 	=> __( "Select to sort products", "pl-bigbazaar-extensions")
		),
		array(
			"type" 			=> "textfield",
			"heading" 		=> __( "Show No. Of Products Per Page", "pl-bigbazaar-extensions" ),
			"param_name" 	=> "per_page",
			"value" 		=> "12",
			"description" 	=> __( "Show number of product per page", "pl-bigbazaar-extensions" ),
		),
		array(
            "type"        	=> "colorpicker",
            "heading"     	=> __("Section Color", "pl-bigbazaar-extensions"),
            "param_name"  	=> "section_color",
			"value"       	=> "#E62E04",
			"description" 	=> __( "Set unique color of this section", "pl-bigbazaar-extensions" ),
        ),
		array(
			"type" 			=> "dropdown",
			"heading" 		=> __( "Banner Style", "pl-bigbazaar-extensions" ),
			"param_name" 	=> "banner_style",
			"std"			=> "banner_single_image",
			"value" 		=> array(
				__( "Banner Single Image", "pl-bigbazaar-extensions" ) => "banner_single_image",
				__( "Banner Mutliple Images With Slider", "pl-bigbazaar-extensions" )   => "banner_with_slider",
			),
			"dependency"  	=> array("element" => "section_style","value" => array("banner-products","banner-categories")),
			"description" 	=> __( "Select banner style. Only single image banner or multiple images banner with slider", "pl-bigbazaar-extensions")
		),
		array(
            "type"        	=> "attach_image",
            "heading"     	=> __( "Banner Single Image", "pl-bigbazaar-extensions" ),
            "param_name"  	=> "banner_image",
            "dependency"  	=> array("element" => "section_style","value" => array("banner-categories","banner-products")),
            "description" 	=> __( "Single image banner", "pl-bigbazaar-extensions" )
    	),
		array(
            "type"        	=> "attach_images",
            "heading"     	=> __( "Banner Mutliple Images", "pl-bigbazaar-extensions" ),
            "param_name"  	=> "banner_images",
            "dependency"  	=> array("element" => "section_style","value" => array("banner-categories","banner-products")),
            "description" 	=> __( "Multiple images banner with slider", "pl-bigbazaar-extensions" )
    	),
		array(
			"type"        	=> "textfield",
			"heading"     	=> __( "Show Product Columns", "pl-bigbazaar-extensions" ),
			"param_name"  	=> "product_columns",
			"group"       	=> __( "Carousel options", "pl-bigbazaar-extensions" ),
			"value"       	=> 3,
			"description" 	=> __( "Show numbers of product columns you want to display.", "pl-bigbazaar-extensions" ),
		),
		array(
			"type"        	=> "checkbox",
			"heading"     	=> __( "Autoplay", "pl-bigbazaar-extensions" ),
			"param_name"  	=> "auto_play",
			"group"       	=> __( "Carousel options", "pl-bigbazaar-extensions" ),
			"value"       	=> array( __( "Yes", "pl-bigbazaar-extensions" ) => "true" ),
			"description" 	=> __( "Enables autoplay mode", "pl-bigbazaar-extensions" ),
		),
		array(
			"type"        	=> "checkbox",
			"heading"     	=> __( "Navigation", "pl-bigbazaar-extensions" ),
			"param_name"  	=> "navigation",
			"group"       	=> __( "Carousel options", "pl-bigbazaar-extensions" ),
			"value"       	=> array( __( "No", "pl-bigbazaar-extensions" ) => "false" ),
			"description" 	=> __( "Show next/prev buttons", "pl-bigbazaar-extensions" ),
		),
		array(
			"type"        	=> "checkbox",
			"heading"     	=> __( "Loop", "pl-bigbazaar-extensions" ),
			"param_name"  	=> "loop",
			"group"       	=> __( "Carousel options", "pl-bigbazaar-extensions" ),
			"value"       	=> array( __( "Yes", "pl-bigbazaar-extensions" ) => "true" ),
			"description" 	=> __( "Inifnity loop. Duplicate last and first items to get loop illusion", "pl-bigbazaar-extensions" ),
		),
		array(
            "type"        	=> "css_editor",
            "heading"     	=> __( "Css", "pl-bigbazaar-extensions" ),
            "param_name"  	=> "css",
            "group"       	=> __( "Design options", "pl-bigbazaar-extensions" ),
            "admin_label" 	=> false,
		),
		array(
            "type"        	=> "textfield",
            "heading"     	=> __( "Extra class name", "pl-bigbazaar-extensions" ),
            "param_name"  	=> "el_class",
            "description" 	=> __( "If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "pl-bigbazaar-extensions" ),
            "admin_label" 	=> false,
        ),     
    ),
));

class WPBakeryShortCode_Categories_And_Products extends WPBakeryShortCode {
    protected function content($atts, $content = null) {
        $atts = function_exists( 'vc_map_get_attributes' ) ? vc_map_get_attributes( 'categories_and_products', $atts ) : $atts;
        extract( shortcode_atts( array(
		
            "title"          => "Category Title",
            "category"       => 0,
            "section_style"  => "banner-products",
			"orderby"		 => "date",
			"order"          => "desc",
			"per_page"       => "12",
            "section_color"  => "#e62e04",
            "banner_style"   => "banner_single_image",
			"banner_image"	 => "",
			"banner_images"  => "",
			"product_columns" => 3,
            "auto_play"      => "false",
            "navigation"     => "true",
            "loop"    		 => "false",          
            "css"            => "",       
            "el_class"       => "",        
           
        ), $atts ) );
        
		$shortcode_class = array(
        	'base' => apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, 'categories_and_products '.$section_style, $this->settings['base'], $atts ),
        	'extra' => $this->getExtraClass( $el_class ),
            'shortcode_custom' => vc_shortcode_custom_css_class( $css, ' ' )
        );        
        $shortcode_class = preg_replace( array( '/\s+/', '/^\s|\s$/' ), array( ' ', '' ), implode( ' ', $shortcode_class ) );
		
		//Get Categories
		$term = get_term_by( 'slug', $category, 'product_cat' );
		if(empty ($term)){
			ob_start();	?>		
				<h4><?php esc_html_e('Choose proper any one parent category','pl-bigbazaar-extensions');?></h4>
			<?php $result = ob_get_clean();		
			return $result;
		}else{
			$term_link = get_term_link($term);
			$cat_args = array(
						'orderby'      	=> 'name',
						'order'        	=> 'asc',
						'number' 		=> 15,
						'hierarchical' 	=> 1,
						'show_option_none' => '',
						'hide_empty'	=> 1,
						'parent'		=> $term->term_id,
						'taxonomy' 		=> 'product_cat'
					);
			$subcats = get_categories($cat_args);
			
			//Get Products
			global $woocommerce_loop;		
			if(isset($section_style) && ($section_style=="banner-products" || $section_style=="only-products" || $section_style=="brands-products")):
				
				//Global Query
				$args = array(
						'post_type'				=> 'product',
						'post_status'			=> 'publish',
						'ignore_sticky_posts'	=> 1,
						'posts_per_page' 		=> $atts['per_page'],
					);
				$args['meta_query'] = WC()->query->get_meta_query();
				$tax_query   		= WC()->query->get_tax_query();
					
				$tax_query[] =array(
								array(
									'taxonomy' => 'product_cat',
									'field'    => 'id',
									'terms'    => $term->term_id,
									'operator' => 'IN'
								)
							);
						
				//recent products		
				$recent_args				= $args;
				$recent_args['orderby'] 	= $atts['orderby'];
				$recent_args['order'] 		= $atts['order'];
				$recent_args['tax_query']	= $tax_query;
				
				$recent_products = new WP_Query( apply_filters( 'woocommerce_shortcode_products_query', $recent_args, $atts ) );		
			
				//featured products 
				$f_tax_query   =$tax_query;
				$f_tax_query[] = array(
					'taxonomy' => 'product_visibility',
					'field'    => 'name',
					'terms'    => 'featured',
					'operator' => 'IN',
				); 
				
				$featured_args				= $args;
				$featured_args['orderby'] 	= $atts['orderby'];
				$featured_args['order'] 	= $atts['order'];
				$featured_args['tax_query']	= $f_tax_query;
				
				$featured_products = new WP_Query( apply_filters( 'woocommerce_shortcode_products_query', $featured_args, $atts ) );
				
				//best selling
				$best_selling_args				= $args;
				$best_selling_args['meta_key'] 	= 'total_sales';
				$best_selling_args['orderby'] 	= 'meta_value_num';
				$best_selling_args['tax_query']	= $tax_query;
				
				$best_selling_products = new WP_Query( apply_filters( 'woocommerce_shortcode_products_query', $best_selling_args, $atts ) );
				
				//top reviews
				$top_reviews_args				= $args;
				$top_reviews_args['orderby'] 	= $atts['orderby'];
				$top_reviews_args['order'] 		= $atts['order'];
				$top_reviews_args['tax_query']	= $tax_query;
				
				add_filter( 'posts_clauses', array( 'WC_Shortcodes', 'order_by_rating_post_clauses' ) );
				$top_reviews_products = new WP_Query( apply_filters( 'woocommerce_shortcode_products_query', $top_reviews_args, $atts ) );
				remove_filter( 'posts_clauses', array( 'WC_Shortcodes', 'order_by_rating_post_clauses' ) );
				
				//sale products
				$product_ids_on_sale = wc_get_product_ids_on_sale();			
				$sale_args				= $args;
				$sale_args['orderby'] 	= $atts['orderby'];
				$sale_args['order'] 	= $atts['order'];
				$sale_args['tax_query']	= $tax_query;
				$sale_args['post__in'] 	= array_merge( array( 0 ), $product_ids_on_sale );
				
				$sale_products = new WP_Query( apply_filters( 'woocommerce_shortcode_products_query', $sale_args, $atts ) );
	
			endif;
			
			$id = uniqid();
			global $owlparam;
			$owlparam['productsCarousel']['section-'.$id] = array(
				'item_columns'     => $product_columns,
				'autoplay'    => $auto_play ? $auto_play : 'false',
				'navigation'  => $navigation ? $navigation : 'true',
				'loop'        => $loop ? $loop : 'false'
			);
			
			$owlparam['sectionColor']['section-'.$id]=array(
				'color_code'     => $section_color
			);
			//$section_id='section-'.$id;
			
			ob_start();	
			if(empty($subcats)){?>
			
				<h4><?php esc_html_e('Child (subcategories) are not available for this selected parent category.','pl-bigbazaar-extensions');?></h4>

			<?php }else{?>
			
				<div id="section-<?php echo esc_attr($id);?>" class="product-section <?php echo esc_attr($shortcode_class);?>">
					<?php include( BB_EXTENSIONS_PATH . 'js_composer/includes/'.$section_style.'.php' );?>	
				</div>	
			
			<?php } 
			wp_reset_postdata();
			
			$result = ob_get_clean();		
			return $result;
		}
    }

}