<?php
/**
 * @author  PressLayouts
 * @package BigBazaar
 * @version 1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

vc_map( array(
    "name"                  => __( "Blogs Carousel", "pl-bigbazaar-extensions"),
    "base"                  => "blogs_carousel",
	"description"           => __( "Display blogs with carousel slider.", "pl-bigbazaar-extensions"),
    "category"              => __("BigBazaar Theme", "pl-bigbazaar-extensions" ),
    "params"                => array(
		array(
			"type" 			=> "textfield",
			"heading" 		=> __( "Title", "pl-bigbazaar-extensions" ),
			"param_name" 	=> "title",
			"description"   => __( "Enter title", "pl-bigbazaar-extensions" ),
			"admin_label"   => true,
		),	
		array(
            "type"        	=> "bigbazaar_categories_with_none",
            "heading"     	=> __("Select Category", "pl-bigbazaar-extensions"),
            "param_name"  	=> "category",
            "admin_label" 	=> true,
			"description" 	=> __( "If you want to display  blogs of specific category then select category otherwise skip it.", "pl-bigbazaar-extensions" ),
        ),
		array(
			"type" 			=> "dropdown",
			"heading" 		=> __( "Order By", "pl-bigbazaar-extensions" ),
			"param_name" 	=> "orderby",
			"std"           => "date",
			"value" 		=> array(
				__( "Date", "pl-bigbazaar-extensions" )   => "date",
				__( "Title", "pl-bigbazaar-extensions" )   => "title",
				__( "Name(Slug)", "pl-bigbazaar-extensions" ) => "name",
				__( "Random", "pl-bigbazaar-extensions" )   => "rand",
				__( "ID", "pl-bigbazaar-extensions" )   => "id",
			),
			"description" 	=> __( "Select to sort blogs", "pl-bigbazaar-extensions")
		),
		array(
			"type" 			=> "dropdown",
			"heading" 		=> __( "Order Direction", "pl-bigbazaar-extensions" ),
			"param_name" 	=> "order",
			"std"           => "desc",
			"value" 		=> array(
				__( "Descending", "pl-bigbazaar-extensions" ) => "desc",
				__( "Ascending", "pl-bigbazaar-extensions" )   => "asc",
			),
			"description" 	=> __( "Select to sort blogs", "pl-bigbazaar-extensions")
		),
		array(
			"type" 			=> "textfield",
			"heading" 		=> __( "Show No. Of Blogs", "pl-bigbazaar-extensions" ),
			"param_name" 	=> "per_page",
			"value" 		=> "12",
			"description" 	=> __( "Show number of blogs", "pl-bigbazaar-extensions" ),
		),
		array(
			"type" 			=> "dropdown",
			"heading" 		=> __( "Show No. Of Blogs rows", "pl-bigbazaar-extensions" ),
			"param_name" 	=> "blogs_rows",
			"std"           => "1",
			"value" 		=> array(
				__( "1 Row", "pl-bigbazaar-extensions" ) => "1",
				__( "2 Row", "pl-bigbazaar-extensions" ) => "2",
				__( "3 Row", "pl-bigbazaar-extensions" ) => "3",
			),
			"description" 	=> __( "Show number of blogs row", "pl-bigbazaar-extensions" ),
		),
		array(
			"type"        	=> "textfield",
			"heading"     	=> __( "Show No. Of blogs Columns", "pl-bigbazaar-extensions" ),
			"param_name"  	=> "blogs_columns",
			"group"       	=> __( "Carousel options", "pl-bigbazaar-extensions" ),
			"value"       	=> 4,
			"description" 	=> __( "Show numbers of blogs columns you want to display.", "pl-bigbazaar-extensions" ),
		),
		array(
			"type"        	=> "checkbox",
			"heading"     	=> __( "Autoplay", "pl-bigbazaar-extensions" ),
			"param_name"  	=> "auto_play",
			"group"       	=> __( "Carousel options", "pl-bigbazaar-extensions" ),
			"value"       	=> array( __( "Yes", "pl-bigbazaar-extensions" ) => "true" ),
			"description" 	=> __( "Enables autoplay mode", "pl-bigbazaar-extensions" ),
		),
		array(
			"type"        	=> "checkbox",
			"heading"     	=> __( "Navigation", "pl-bigbazaar-extensions" ),
			"param_name"  	=> "navigation",
			"group"       	=> __( "Carousel options", "pl-bigbazaar-extensions" ),
			"value"       	=> array( __( "No", "pl-bigbazaar-extensions" ) => "false" ),
			"description" 	=> __( "Show next/prev buttons", "pl-bigbazaar-extensions" ),
		),
		array(
			"type"        	=> "checkbox",
			"heading"     	=> __( "Loop", "pl-bigbazaar-extensions" ),
			"param_name"  	=> "loop",
			"group"       	=> __( "Carousel options", "pl-bigbazaar-extensions" ),
			"value"       	=> array( __( "Yes", "pl-bigbazaar-extensions" ) => "true" ),
			"description" 	=> __( "Inifnity loop. Duplicate last and first items to get loop illusion", "pl-bigbazaar-extensions" ),
		),
		array(
            "type"        	=> "css_editor",
            "heading"     	=> __( "Css", "pl-bigbazaar-extensions" ),
            "param_name"  	=> "css",
            "group"       	=> __( "Design options", "pl-bigbazaar-extensions" ),
            "admin_label" 	=> false,
		),
		array(
            "type"        	=> "textfield",
            "heading"     	=> __( "Extra class name", "pl-bigbazaar-extensions" ),
            "param_name"  	=> "el_class",
            "description" 	=> __( "If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "pl-bigbazaar-extensions" ),
            "admin_label" 	=> false,
        ),     
    ),
));

class WPBakeryShortCode_Blogs_Carousel extends WPBakeryShortCode {	
    protected function content($atts, $content = null) {
        $atts = function_exists( 'vc_map_get_attributes' ) ? vc_map_get_attributes( 'blogs_carousel', $atts ) : $atts;
        extract( shortcode_atts( array(
		
            "title"          => "Blogs Title",
			"category"       => -1,
			"orderby"		 => "date",
			"order"          => "desc",
			"per_page"       => 12,
			"blogs_rows"     => 1,
			"blogs_columns"  => 4,
            "auto_play"      => "false",
            "navigation"     => "true",
            "loop"    		 => "false",          
            "css"            => "",       
            "el_class"       => "",        
           
        ), $atts ) );
        
		$shortcode_class = array(
        	'base' => apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, 'blogs_carousel', $this->settings['base'], $atts ),
        	'extra' => $this->getExtraClass( $el_class ),
            'shortcode_custom' => vc_shortcode_custom_css_class( $css, ' ' )
        );        
        $shortcode_class = preg_replace( array( '/\s+/', '/^\s|\s$/' ), array( ' ', '' ), implode( ' ', $shortcode_class ) );
		
		//Get Categories
		$term = get_term_by( 'slug', $category, 'category' );
		if(!empty($term)):
			$tax_query=array(
							array(
								'taxonomy' => 'category',
								'field'    => 'id',
								'terms'    => $term->term_id,
								'operator' => 'IN'
							)
						);
		endif;
		
		//Get Blogs
		$args = array(
			'post_type'				=> 'post',
			'post_status'			=> 'publish',
			'ignore_sticky_posts'	=> 1,
			'posts_per_page' 		=> $atts['per_page'],
			'orderby' 			    => $atts['orderby'],
			'order' 				=> $atts['order'],
			);
		if(!empty($term)):
			$args['tax_query']=$tax_query;
		endif;
		
		$blogs = new WP_Query( $args );
		
        $id = uniqid();
		global $owlparam;
		$owlparam['productsCarousel']['section-'.$id] = array(
			'item_columns'     => $blogs_columns,
			'autoplay'    => $auto_play ? $auto_play : 'false',
			'navigation'  => $navigation ? $navigation : 'true',
			'loop'        => $loop ? $loop : 'false'
		);
		
		ob_start();?>
		<div id="section-<?php echo esc_attr($id);?>" class="product-section <?php echo esc_attr($shortcode_class);?>">
			<div class="section-header">
				<div class="section-title">
					<h3><?php echo esc_attr($title);?></h3>
				</div>
			</div>
			<div class="section-content">
				<?php if ( $blogs->have_posts() ) : ?>
					<?php $row=1;?>
					<div class="product-items row">
						<ul class="products product-carousel owl-carousel">
						<?php function new_excerpt_length($length) {
								return 20;
							}
							add_filter('excerpt_length', 'new_excerpt_length');	?>
						<?php while( $blogs->have_posts() ): $blogs->the_post();?>
							<?php if($row==1){?>
								<li class="slide-row">
									<ul>
							<?php }?>
								<li class="blog-entry">
									<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
										<div class="entry-thumbnail">
											<?php bigbazaar_post_thumbnail();?>
										</div>
										<div class="blog-entry-content">
											<header class="entry-header">
												<?php the_title( sprintf( '<h2 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' );?>
											</header><!-- .entry-header -->
											
											<footer class="entry-footer">
												<?php bigbazaar_entry_meta(); ?>
											</footer><!-- .entry-footer -->
											
											<div class="entry-content">
												<?php the_excerpt(); ?>												
											</div><!-- .entry-content -->
										</div>

									</article><!-- #post-## -->
								</li>
							<?php if($row==$blogs_rows || $blogs->current_post+1==$blogs->post_count){ $row=0;?>
									</ul>
								</li>
							<?php } $row++;?>
						<?php endwhile; // end of the loop. ?>
						</ul>
					</div>
				<?php endif;
				wp_reset_postdata();?>
			</div>
		</div>
		<?php
		$result = ob_get_clean();
        return $result;
    }
}