<?php
/*
* @author  PressLayouts
* @package BigBazaar
* @version 1.0
*/
 
if ( ! defined( 'ABSPATH' ) ):
	exit; // Exit if accessed directly
endif;
?>
<div class="section-inner">
	<div class="section-categories col-md-2">
		<div class="section-title">
			<a href="<?php echo esc_url($term_link);?>"><h3><?php echo esc_attr($title);?></h3></a>
		</div>
		<ul class="sub-categories">
			<?php foreach($subcats as $cate):?>
				<?php $cate_link = get_term_link( $cate ); ?>
				<li><a href="<?php echo esc_url($cate_link);?>"><?php echo esc_html($cate->name);?></a></li>
			<?php endforeach;?>
		</ul>
	</div>
	<div class="section-content col-md-10 col-lg-8 woocommerce">
		<div class="section-tab row">
		<?php if(isset($section_style) && ($section_style=="banner-products" || $section_style=="only-products" || $section_style=="brands-products")):
			$t=0;?>
			<ul class="nav nav-tabs"><?php 
			if ( $recent_products->have_posts() ) :?>
				<li <?php echo  $t == 0 ? 'class="active"': '' ?>>
					<a href="#recent-<?php echo esc_attr($id);?>" data-toggle="tab"><?php _e('Recent Products','pl-bigbazaar-extensions');?></a>
				</li><?php $t++;						
			endif;
			if ( $best_selling_products->have_posts() ) :?>
				<li <?php echo  $t == 0 ? 'class="active"': '' ?>>
					<a href="#seller-<?php echo esc_attr($id);?>" data-toggle="tab"><?php _e('Best Seller','pl-bigbazaar-extensions');?></a>
				</li><?php $t++;						
			endif;						
			if ( $featured_products->have_posts() ) :?>
				<li <?php echo  $t == 0 ? 'class="active"': '' ?>>
					<a href="#featured-<?php echo esc_attr($id);?>" data-toggle="tab"><?php _e('Featured Products','pl-bigbazaar-extensions');?></a>
				</li><?php $t++;						
			endif;
			
			if ( $top_reviews_products->have_posts() ) :?>
				<li <?php echo  $t == 0 ? 'class="active"': '' ?>>
					<a href="#reviews-<?php echo esc_attr($id);?>" data-toggle="tab"><?php _e('Top Reviews','pl-bigbazaar-extensions');?></a>
				</li><?php $t++;						
			endif;
			
			if ( $sale_products->have_posts() ) :?>
				<li <?php echo  $t == 0 ? 'class="active"': '' ?>>
					<a href="#sale-<?php echo esc_attr($id);?>" data-toggle="tab"><?php _e('Sale Products','pl-bigbazaar-extensions');?></a>
				</li><?php $t++;						
			endif;?>
			</ul>						
		<?php endif; ?>
		</div>
		<div class="tab-content row">
		<?php $p=0;
		if ( $recent_products->have_posts() ) :?>
			<div class="tab-pane fade<?php echo  $p == 0 ? ' in active': '' ?>" id="recent-<?php echo esc_attr($id);?>">
				<?php $row=1; //woocommerce_product_loop_start(); ?>
					<div class="product-items">
					<ul class="products product-carousel owl-carousel">
					<?php while ( $recent_products->have_posts() ) : $recent_products->the_post(); ?>
						<?php if($row==1){?>
							<li class="slide-row">
								<ul>
						<?php }?>
									<?php wc_get_template_part( 'content', 'product' ); ?>
						<?php if($row==2){ $row=0;?>
								</ul>
							</li>
						<?php } $row++;?>
					<?php endwhile; // end of the loop. ?>
					</ul>
					</div>
				<?php //woocommerce_product_loop_end(); ?>
			</div>
			<?php $p++;						
		endif;
		wp_reset_postdata();
		
		if ( $best_selling_products->have_posts() ) :?>
			<div class="tab-pane fade<?php echo  $p == 0 ? ' in active': '' ?>" id="seller-<?php echo esc_attr($id);?>">
				<?php $row=1; //woocommerce_product_loop_start(); ?>
					<div class="product-items">
					<ul class="products product-carousel owl-carousel">
					<?php while ( $best_selling_products->have_posts() ) : $best_selling_products->the_post(); ?>
						<?php if($row==1){?>
							<li class="slide-row">
								<ul>
						<?php }?>
									<?php wc_get_template_part( 'content', 'product' ); ?>
						<?php if($row==2 || $best_selling_products->current_post+1==$best_selling_products->post_count){ $row=0;?>
								</ul>
							</li>
						<?php } $row++;?>
					<?php endwhile; // end of the loop. ?>
					</ul>
					</div>
				<?php //woocommerce_product_loop_end(); ?>
			</div>
			<?php $p++;						
		endif;
		wp_reset_postdata();
		
		if ( $featured_products->have_posts() ) :?>
			<div class="tab-pane fade<?php echo  $p == 0 ? ' in active': '' ?>" id="featured-<?php echo esc_attr($id);?>">
				<?php $row=1; //woocommerce_product_loop_start(); ?>
					<div class="product-items">
					<ul class="products product-carousel owl-carousel">
					<?php while ( $featured_products->have_posts() ) : $featured_products->the_post(); ?>
						<?php if($row==1){?>
							<li class="slide-row">
								<ul>
						<?php }?>
									<?php wc_get_template_part( 'content', 'product' ); ?>
						<?php if($row==2 || $featured_products->current_post+1==$featured_products->post_count){ $row=0;?>
								</ul>
							</li>
						<?php } $row++;?>
					<?php endwhile; // end of the loop. ?>
					</ul>
					</div>
				<?php //woocommerce_product_loop_end(); ?>
			</div>
			<?php $p++;						
		endif;
		wp_reset_postdata();
		
		if ( $top_reviews_products->have_posts() ) :?>
			<div class="tab-pane fade<?php echo  $p == 0 ? ' in active': '' ?>" id="reviews-<?php echo esc_attr($id);?>">
				<?php $row=1; //woocommerce_product_loop_start(); ?>
					<div class="product-items">
					<ul class="products product-carousel owl-carousel">
					<?php while ( $top_reviews_products->have_posts() ) : $top_reviews_products->the_post(); ?>
						<?php if($row==1){?>
							<li class="slide-row">
								<ul>
						<?php }?>
									<?php wc_get_template_part( 'content', 'product' ); ?>
						<?php if($row==2 || $top_reviews_products->current_post+1==$top_reviews_products->post_count){ $row=0;?>
								</ul>
							</li>
						<?php } $row++;?>
					<?php endwhile; // end of the loop. ?>
					</ul>
					</div>
				<?php //woocommerce_product_loop_end(); ?>
			</div>
			<?php $p++;					
		endif;
		wp_reset_postdata();
		
		if ( $sale_products->have_posts() ) :?>
			<div class="tab-pane fade<?php echo  $p == 0 ? ' in active': '' ?>" id="sale-<?php echo esc_attr($id);?>">
				<?php $row=1; //woocommerce_product_loop_start(); ?>
					<div class="product-items">
					<ul class="products product-carousel owl-carousel">
					<?php while ( $sale_products->have_posts() ) : $sale_products->the_post(); ?>
						<?php if($row==1){?>
							<li class="slide-row">
								<ul>
						<?php }?>
									<?php wc_get_template_part( 'content', 'product' ); ?>
						<?php if($row==2 || $sale_products->current_post+1==$sale_products->post_count){ $row=0;?>
								</ul>
							</li>
						<?php } $row++;?>
					<?php endwhile; // end of the loop. ?>
					</ul>
					</div>
				<?php //woocommerce_product_loop_end(); ?>
			</div>
			<?php $p++;					
		endif;
		//wp_reset_postdata();?>
		</div>
	</div>
	<div class="section-brands col-lg-2 col-md-2 hidden-xs hidden-sm">
		<ul class="brands-vertical-carousel" data-slick='{"arrows":true, "infinite": true, "slidesToShow": 6, 	"slidesToScroll": 3, "vertical":true, "center":true, "margin":10}'>
			<?php $brands = get_categories( array( 'hide_empty' => 1, 'taxonomy' => 'product_brand', 'orderby' => 'date', 'order' => 'desc' ) );
			foreach ( $brands as $brand ) { $lastElement = end($brands);
				$thumbnail_id = get_woocommerce_term_meta( $brand->term_id, 'thumbnail_id' ) ;
				$image_src = wp_get_attachment_image_src( $thumbnail_id, 'large' ) ;
				$brand_link = get_term_link( $brand, 'product_brand' ) ;?>
				
				<li class="brand-item">
					<a href="<?php echo esc_url($brand_link) ?>">
						<?php if ( !empty($image_src) ) {?>
							<img alt="<?php echo esc_attr($brand->cat_name)?>" src="<?php echo esc_url($image_src[0])?>"/>
						<?php }else{?>
							<img src="<?php echo esc_url(BB_EXTENSIONS_URL.'assets/img/brand-placeholder.jpg');?>"/>
						<?php }?>
					</a>
				</li>
			<?php }?>
		</ul>
	</div>
</div>