<?php
/*
* @author  PressLayouts
* @package BigBazaar
* @version 1.0
*/
 
if ( ! defined( 'ABSPATH' ) ):
	exit; // Exit if accessed directly
endif;
?>
<div class="section-inner">
	<div class="section-categories col-md-2">
		<div class="section-title">
			<a href="<?php echo esc_url($term_link);?>"><h3><?php echo esc_attr($title);?></h3></a>
		</div>
		<ul class="sub-categories">
			<?php foreach($subcats as $cate):?>
				<?php $cate_link = get_term_link( $cate ); ?>
				<li><a href="<?php echo esc_url($cate_link);?>"><?php echo esc_html($cate->name);?></a></li>
			<?php endforeach;?>
		</ul>
	</div>
	<div class="section-content col-md-8 col-lg-8 woocommerce">
		<div class="row">
		<?php if ( !empty($subcats) ) :	$lastElement = end($subcats);?>
			<?php $row=1;?>
			<div class="product-items">
				<ul class="products product-carousel owl-carousel">
				<?php foreach($subcats as $cate): ?>
					<?php if($row==1){?>
						<li class="slide-row">
							<ul>
					<?php }?>
					<?php $cate_link = get_term_link( $cate ); ?>
						<li class="category-entry">
							<div class="category-image">
								<?php $thumbnail_id = get_woocommerce_term_meta( $cate->term_id, 'thumbnail_id', true );
								$catalog_img = wp_get_attachment_image_src( $thumbnail_id, 'shop_catalog' );
								if ( !empty($catalog_img) ) {?>
									<a href="<?php echo esc_url($cate_link);?>">										
									<img src="<?php echo esc_url($catalog_img[0]);?>" alt="<?php echo esc_html($cate->name);?>" />
									</a>
								<?php }else{?>
									<img src="<?php echo esc_url(BB_EXTENSIONS_URL.'assets/img/product-listing-placeholder.jpg');?>"/>
								<?php }?>									
							</div>
							<div class="category-content">
								<a href="<?php echo esc_url($cate_link);?>">
									<div class="category-title">
										<h3><?php echo esc_html($cate->name);?></h3>
									</div>
									<div class="cate-explore"><?php _e('Explore Now','pl-bigbazaar-extensions');?><i class="fa fa-angle-right"></i></div>
								</a>
							</div>
						</li>
					<?php if($row==2 || $cate==$lastElement){ $row=0;?>
							</ul>
						</li>
					<?php } $row++;?>
				<?php endforeach; // end of the loop. ?>
				</ul>
			</div>
		<?php endif; ?>
		</div>
	</div>
	<div class="section-brands col-lg-2 col-md-2 hidden-xs hidden-sm">
		<ul class="brands-vertical-carousel" data-slick='{"arrows":true, "infinite": true, "slidesToShow": 7, 	"slidesToScroll": 3, "vertical":true, "center":true, "margin":10}'>
			<?php $brands = get_categories( array( 'hide_empty' => 1, 'taxonomy' => 'product_brand', 'orderby' => 'date', 'order' => 'desc' ) );
			foreach ( $brands as $brand ) { $lastElement = end($brands);
				$thumbnail_id = get_woocommerce_term_meta( $brand->term_id, 'thumbnail_id' ) ;
				$image_src = wp_get_attachment_image_src( $thumbnail_id, 'large' ) ;
				$brand_link = get_term_link( $brand, 'product_brand' ) ;?>
				
				<li class="brand-item">
					<a href="<?php echo esc_url($brand_link) ?>">
						<?php if ( !empty($image_src) ) {?>
							<img alt="<?php echo esc_attr($brand->cat_name)?>" src="<?php echo esc_url($image_src[0])?>"/>
						<?php }else{?>
							<img src="<?php echo esc_url(BB_EXTENSIONS_URL.'assets/img/brand-placeholder.jpg');?>"/>
						<?php }?>
					</a>
				</li>
			<?php }?>
		</ul>
	</div>
</div>