<?php
/*
* @author  PressLayouts
* @package BigBazaar
* @version 1.0
*/
 
if ( ! defined( 'ABSPATH' ) ):
	exit; // Exit if accessed directly
endif;
?>
<div class="section-inner">
	<div class="section-categories col-md-2">
		<div class="section-title">
			<a href="<?php echo esc_url($term_link);?>"><h3><?php echo esc_attr($title);?></h3></a>
		</div>
		<ul class="sub-categories">
			<?php foreach($subcats as $cate):?>
				<?php $cate_link = get_term_link( $cate ); ?>
				<li><a href="<?php echo esc_url($cate_link);?>"><?php echo esc_html($cate->name);?></a></li>
			<?php endforeach;?>
		</ul>
	</div>
	<div class="section-banner-content col-md-10">
		<div class="row">
			<div class="section-tab">
			<?php if(isset($section_style) && ($section_style=="banner-products" || $section_style=="only-products" || $section_style=="brands-products")):
				$t=0;?>
				<ul class="nav nav-tabs"><?php 
				if ( $recent_products->have_posts() ) :?>
					<li <?php echo  $t == 0 ? 'class="active"': '' ?>>
						<a href="#recent-<?php echo esc_attr($id);?>" data-toggle="tab"><?php esc_html_e('Recent Products','pl-bigbazaar-extensions');?></a>
					</li><?php $t++;						
				endif;
				if ( $best_selling_products->have_posts() ) :?>
					<li <?php echo  $t == 0 ? 'class="active"': '' ?>>
						<a href="#seller-<?php echo esc_attr($id);?>" data-toggle="tab"><?php esc_html_e('Best Seller','pl-bigbazaar-extensions');?></a>
					</li><?php $t++;						
				endif;						
				if ( $featured_products->have_posts() ) :?>
					<li <?php echo  $t == 0 ? 'class="active"': '' ?>>
						<a href="#featured-<?php echo esc_attr($id);?>" data-toggle="tab"><?php esc_html_e('Featured Products','pl-bigbazaar-extensions');?></a>
					</li><?php $t++;						
				endif;
				
				if ( $top_reviews_products->have_posts() ) :?>
					<li <?php echo  $t == 0 ? 'class="active"': '' ?>>
						<a href="#reviews-<?php echo esc_attr($id);?>" data-toggle="tab"><?php esc_html_e('Top Reviews','pl-bigbazaar-extensions');?></a>
					</li><?php $t++;						
				endif;
				
				if ( $sale_products->have_posts() ) :?>
					<li <?php echo  $t == 0 ? 'class="active"': '' ?>>
						<a href="#sale-<?php echo esc_attr($id);?>" data-toggle="tab"><?php esc_html_e('Sale Products','pl-bigbazaar-extensions');?></a>
					</li><?php $t++;						
				endif;?>
				</ul>						
			<?php endif; ?>
			</div>
			<div class="section-banner col-md-5 hidden-xs hidden-sm">
				<div class="banner-img">
					<?php if(isset($banner_style) && $banner_style=="banner_with_slider"):?>
						<ul class="banner-carousel owl-carousel">
							<?php foreach(explode(",",$banner_images) as $attchID):?>
								<?php $cate_link = get_term_link( $cate ); ?>
								<li>
									<a href="<?php echo  $term_link ? esc_url( $term_link ) : ''; ?>">
									<?php if(wp_get_attachment_url( $attchID )) :
										echo wp_get_attachment_image($attchID,'full');
									else:?>
										<img src="<?php echo esc_url(BB_EXTENSIONS_URL.'assets/img/product-banner-placeholder.jpg');?>"/>
									<?php endif;?>
									</a>
								</li>
							<?php endforeach;
							?>
						</ul>
					<?php else:?>
						<a href="<?php echo  $term_link ? esc_url( $term_link ) : ''; ?>">
							<?php if(wp_get_attachment_url( $banner_image )) :
								echo wp_get_attachment_image($banner_image,'full');
							else:?>
								<img src="<?php echo esc_url(BB_EXTENSIONS_URL.'assets/img/product-banner-placeholder.jpg');?>"/>
							<?php endif;?>
						</a>
					<?php endif;?>
				</div>
			</div>
			<div class="section-content col-sm-12 col-md-7 woocommerce">
				<div class="tab-content row">
				<?php $p=0;
				if ( $recent_products->have_posts() ) :?>
					<div class="tab-pane fade<?php echo  $p == 0 ? ' in active': '' ?>" id="recent-<?php echo esc_attr($id);?>">
						<?php $row=1; //woocommerce_product_loop_start(); ?>
							<div class="product-items">
								<ul class="products product-carousel owl-carousel">
								<?php while ( $recent_products->have_posts() ) : $recent_products->the_post(); ?>
									<?php if($row==1){?>
										<li class="slide-row">
											<ul>
									<?php }?>
												<?php wc_get_template_part( 'content', 'product' ); ?>
									<?php if($row==2 || $recent_products->current_post+1==$recent_products->post_count){ $row=0;?>
											</ul>
										</li>
									<?php } $row++;?>
								<?php endwhile; // end of the loop. ?>
								</ul>
							</div>
						<?php //woocommerce_product_loop_end(); ?>
					</div>
					<?php $p++;
					wp_reset_postdata();
				endif;
				
				if ( $best_selling_products->have_posts() ) :?>
					<div class="tab-pane fade<?php echo  $p == 0 ? ' in active': '' ?>" id="seller-<?php echo esc_attr($id);?>">
						<?php $row=1; //woocommerce_product_loop_start(); ?>
							<div class="product-items">
								<ul class="products product-carousel owl-carousel">
								<?php while ( $best_selling_products->have_posts() ) : $best_selling_products->the_post(); ?>
									<?php if($row==1){?>
										<li class="slide-row">
											<ul>
									<?php }?>
												<?php wc_get_template_part( 'content', 'product' ); ?>
									<?php if($row==2 || $best_selling_products->current_post+1==$best_selling_products->post_count){ $row=0;?>
											</ul>
										</li>
									<?php } $row++;?>
								<?php endwhile; // end of the loop. ?>
								</ul>
							</div>
						<?php //woocommerce_product_loop_end(); ?>
					</div>
					<?php $p++;						
					wp_reset_postdata();
				endif;
				
				if ( $featured_products->have_posts() ) :?>
					<div class="tab-pane fade<?php echo  $p == 0 ? ' in active': '' ?>" id="featured-<?php echo esc_attr($id);?>">
						<?php $row=1; //woocommerce_product_loop_start(); ?>
							<div class="product-items">
								<ul class="products product-carousel owl-carousel">
								<?php while ( $featured_products->have_posts() ) : $featured_products->the_post(); ?>
									<?php if($row==1){?>
										<li class="slide-row">
											<ul>
									<?php }?>
												<?php wc_get_template_part( 'content', 'product' ); ?>
									<?php if($row==2 || $featured_products->current_post+1==$featured_products->post_count){ $row=0;?>
											</ul>
										</li>
									<?php } $row++;?>
								<?php endwhile; // end of the loop. ?>
								</ul>
							</div>
						<?php //woocommerce_product_loop_end(); ?>
					</div>
					<?php $p++;
					wp_reset_postdata();
				endif;
				
				if ( $top_reviews_products->have_posts() ) :?>
					<div class="tab-pane fade<?php echo  $p == 0 ? ' in active': '' ?>" id="reviews-<?php echo esc_attr($id);?>">
						<?php $row=1; //woocommerce_product_loop_start(); ?>
							<div class="product-items">
								<ul class="products product-carousel owl-carousel">
								<?php while ( $top_reviews_products->have_posts() ) : $top_reviews_products->the_post(); ?>
									<?php if($row==1){?>
										<li class="slide-row">
											<ul>
											<?php }?>
												<?php wc_get_template_part( 'content', 'product' ); ?>
											<?php if($row==2 || $top_reviews_products->current_post+1==$top_reviews_products->post_count){ $row=0;?>
											</ul>
										</li>
									<?php } $row++;?>
								<?php endwhile; // end of the loop. ?>
								</ul>
							</div>
						<?php //woocommerce_product_loop_end(); ?>
					</div>
					<?php $p++;	
					wp_reset_postdata();
				endif;
				
				if ( $sale_products->have_posts() ) :?>
					<div class="tab-pane fade<?php echo  $p == 0 ? ' in active': '' ?>" id="sale-<?php echo esc_attr($id);?>">
						<?php $row=1; //woocommerce_product_loop_start(); ?>
							<div class="product-items">
							<ul class="products product-carousel owl-carousel">
							<?php while ( $sale_products->have_posts() ) : $sale_products->the_post(); ?>
								<?php if($row==1){?>
									<li class="slide-row">
										<ul>
								<?php }?>
											<?php wc_get_template_part( 'content', 'product' ); ?>
								<?php if($row==2 || $sale_products->current_post+1==$sale_products->post_count){ $row=0;?>
										</ul>
									</li>
								<?php } $row++;?>
							<?php endwhile; // end of the loop. ?>
							</ul>
							</div>
						<?php //woocommerce_product_loop_end(); ?>
					</div>
					<?php $p++;						
					wp_reset_postdata();
				endif;?>
				</div>
			</div>
		</div>
	</div>
</div>