<?php
/*
* @author  PressLayouts
* @package BigBazaar
* @version 1.0
*/
 
if ( ! defined( 'ABSPATH' ) ):
	exit; // Exit if accessed directly
endif;
?>
<div class="section-inner">
	<div class="section-categories col-md-2">
		<div class="section-title">
			<a href="<?php echo esc_url($term_link);?>"><h3><?php echo esc_attr($title);?></h3></a>
		</div>
		<ul class="sub-categories">
			<?php if ( !empty($subcats) ) : 
					foreach($subcats as $cate):?>
					<?php $cate_link = get_term_link( $cate ); ?>
					<li><a href="<?php echo esc_url($cate_link);?>"><?php echo esc_html($cate->name);?></a></li>
				<?php endforeach; 
			endif;?>
		</ul>
	</div>
	<div class="section-banner-content col-md-10">
		<div class="row">
			<div class="section-banner col-md-5 hidden-xs hidden-sm">
				<div class="banner-img">
					<?php if(isset($banner_style) && $banner_style=="banner_with_slider"):?>
						<ul class="banner-carousel owl-carousel">
							<?php foreach(explode(",",$banner_images) as $attchID):?>
								<?php if(!empty($cate)) { $cate_link = get_term_link( $cate ); }else{ $cate_link ='#';} ?>
								<li>
									<a href="<?php echo  $term_link ? esc_url( $term_link ) : ''; ?>">
									<?php if(wp_get_attachment_url( $attchID )) :
										echo wp_get_attachment_image($attchID,'full');
									else:?>
										<img src="<?php echo esc_url(BB_EXTENSIONS_URL.'assets/img/product-banner-placeholder.jpg');?>"/>
									<?php endif;?>
									</a>
								</li>
							<?php endforeach;
							?>
						</ul>
					<?php else:?>
						<a href="<?php echo  $term_link ? esc_url( $term_link ) : ''; ?>">
							<?php if(wp_get_attachment_url( $banner_image )) :
								echo wp_get_attachment_image($banner_image,'full');
							else:?>
								<img src="<?php echo esc_url(BB_EXTENSIONS_URL.'assets/img/product-banner-placeholder.jpg');?>"/>
							<?php endif;?>
						</a>
					<?php endif;?>
				</div>
			</div>
			<div class="section-content col-sm-12 col-md-7 woocommerce">
				<div class="row">
				<?php if ( !empty($subcats) ) :	$lastElement = end($subcats);	?>
					<?php $row=1;?>
					<div class="product-items">
						<ul class="products product-carousel owl-carousel">
						<?php foreach($subcats as $cate): ?>
							<?php if($row==1){?>
								<li class="slide-row">
									<ul>
							<?php }?>
							<?php $cate_link = get_term_link( $cate ); ?>
								<li class="category-entry">
									<div class="category-image">
										<?php $thumbnail_id = get_woocommerce_term_meta( $cate->term_id, 'thumbnail_id', true );
										$catalog_img = wp_get_attachment_image_src( $thumbnail_id, 'shop_catalog' );
										if ( !empty($catalog_img) ) {?>
											<a href="<?php echo esc_url($cate_link);?>">										
												<img src="<?php echo esc_url($catalog_img[0]);?>" alt="<?php echo esc_html($cate->name);?>" />
											</a>
										<?php }else{?>
											<img src="<?php echo esc_url(BB_EXTENSIONS_URL.'assets/img/product-listing-placeholder.jpg');?>"/>
										<?php }?>
									</div>
									<div class="category-content">
										<a href="<?php echo esc_url($cate_link);?>">
											<div class="category-title">
												<h3><?php echo esc_html($cate->name);?></h3>
											</div>
											<div class="cate-explore"><?php _e('Explore Now','pl-bigbazaar-extensions');?><?php if(is_rtl()):?> <i class="fa fa-angle-left"></i> <?php else:?> <i class="fa fa-angle-right"></i><?php endif;?></div>
										</a>
									</div>
								</li>
							<?php if($row==2 || $cate==$lastElement){ $row=0;?>
									</ul>
								</li>
							<?php } $row++;?>
						<?php endforeach; // end of the loop. ?>
						</ul>
					</div>
				<?php endif; ?>
				</div>
			</div>
		</div>
	</div>
</div>