<?php
if ( ! lsvr_shortcode_exists( 'lsvr_gmap' ) && ! function_exists( 'lsvr_gmap_shortcode' ) ) {

    function lsvr_gmap_shortcode( $atts, $content = null, $generator = false, $check_if_inline = false ) {

        /* ---------------------------------------------------------------------
            Output shortcode info for shortcode generator
        --------------------------------------------------------------------- */

        if ( $generator === true ) {

            return array(
                'lsvr_gmap' => array(
                    'name' => __( 'Google Map', 'lsvr-toolkit' ),
					'description' => __( 'You can define either just <strong>Address</strong> field or <strong>Latitude</strong> and <strong>Longitude</strong> fields. Don\'t forget to <strong>insert your Gooogle Maps API key</strong> under Theme Options / General Settings into Google Maps API Key field', 'lsvr-toolkit' ),
                    'paired' => false,
                    'inline' => false,
                    'atts' => array(
						'address' => array(
                            'label' => __( 'Address', 'lsvr-toolkit' ),
							'description' => __( 'For example: <em>8833 Sunset Blvd, West Hollywood, CA 90069, USA</em>.', 'lsvr-toolkit' ),
                            'type' => 'text'
                        ),
						'latitude' => array(
                            'label' => __( 'Latitude', 'lsvr-toolkit' ),
							'description' => __( 'Optional, it can be more precise than using just the address. For example: <em>48.634340</em>.', 'lsvr-toolkit' ),
                            'type' => 'text'
                        ),
						'longitude' => array(
                            'label' => __( 'Longitude', 'lsvr-toolkit' ),
							'description' => __( 'Optional, it can be more precise than using just the address. For example: <em>21.929627</em>.', 'lsvr-toolkit' ),
                            'type' => 'text'
                        ),
						'type' => array(
							'label' => __( 'Map Type', 'lsvr-toolkit' ),
							'values' => array( 'roadmap' => __( 'Roadmap', 'lsvr-toolkit' ), 'satellite' => __( 'Satellite', 'lsvr-toolkit' ), 'terrain' => __( 'Terrain', 'lsvr-toolkit' ), 'hybrid' => __( 'Hybrid', 'lsvr-toolkit' ) ),
                            'type' => 'select',
							'default' => 'satellite'
                        ),
						'zoom' => array(
							'label' => __( 'Zoom Level', 'lsvr-toolkit' ),
							'values' => array( '16' => __( 'Far', 'lsvr-toolkit' ), '17' => __( 'Medium', 'lsvr-toolkit' ), '18' => __( 'Default', 'lsvr-toolkit' ), '19' => __( 'Very Close', 'lsvr-toolkit' ) ),
                            'type' => 'select',
							'default' => '18'
                        ),
						'height' => array(
                            'label' => __( 'Height', 'lsvr-toolkit' ),
							'description' => __( 'In pixels.', 'lsvr-toolkit' ),
                            'type' => 'text',
							'default' => '400'
                        ),
                        'custom_class' => array(
                            'label' => __( 'Custom Class', 'lsvr-toolkit' ),
                            'description' => __( 'It can be used for applying custom CSS.', 'lsvr-toolkit' ),
                            'type' => 'text'
                        ),
                    )
                )
            );

        }

        /* ---------------------------------------------------------------------
            Check if shortcode is inline
        --------------------------------------------------------------------- */

        if ( $check_if_inline === true ) {
            return false;
        }

        /* ---------------------------------------------------------------------
            Prepare arguments
        --------------------------------------------------------------------- */

        $args = shortcode_atts(
            array(
				'address' => '',
				'latitude' => '',
				'longitude' => '',
				'type' => 'roadmap',
				'zoom' => '18',
                'height' => '400',
                'custom_class' => '',
            ),
            $atts
        );

		$address = esc_attr( $args['address'] );
		$latitude = esc_attr( $args['latitude'] );
		$longitude = esc_attr( $args['longitude'] );
		$type = esc_attr( $args['type'] );
		$zoom = esc_attr( $args['zoom'] );
        $height = (int) esc_attr( $args['height'] );
        $custom_class = esc_attr( $args['custom_class'] );

        /* ---------------------------------------------------------------------
            Generate HTML
        --------------------------------------------------------------------- */

        $class = $custom_class;
		$class = $class !== '' ? ' ' . $class : '';

		$output = '<div class="c-gmap' . $class . '"';
		$output .= $height > 0 ? ' style="height: ' . $height . 'px;"' : '';
		$output .= $address !== '' ? ' data-address="' . $address . '"' : '';
		$output .= $latitude !== '' ? ' data-latitude="' . $latitude . '"' : '';
		$output .= $longitude !== '' ? ' data-longitude="' . $longitude . '"' : '';
		$output .= $zoom !== '' ? ' data-zoom="' . $zoom . '"' : '';
		$output .= $type !== '' ? ' data-maptype="' . $type . '"' : '';
		$output .= ' data-enable-mousewheel="false"></div>';

		return $output;

    }
    add_shortcode( 'lsvr_gmap', 'lsvr_gmap_shortcode' );

}
?>