<?php
function bauen_removeDemoModeLink() { 
    if ( class_exists('ReduxFrameworkPlugin') ) {
        remove_filter( 'plugin_row_meta', array( ReduxFrameworkPlugin::get_instance(), 'plugin_metalinks'), null, 2 );
    }
    if ( class_exists('ReduxFrameworkPlugin') ) {
        remove_action('admin_notices', array( ReduxFrameworkPlugin::get_instance(), 'admin_notices' ) );    
    }
}


class Bauen_Classic_Walker extends Walker_Nav_Menu {
    var $number = 1;
    function start_el( &$output, $item, $depth = 0, $args = array(), $id = 0 ) {
        $indent = ( $depth ) ? str_repeat( "\t", $depth ) : '';
        $class_names = $value = '';
        $classes = empty( $item->classes ) ? array() : (array) $item->classes;
        $icon_class = $classes[0];
        $class_names = join( ' ', apply_filters( 'nav_menu_css_class', array_filter( $classes ), $item, $args ) );
		//1st lvl sub menu li class
		if( $depth == 1 ){
			if ( $args->has_children ) {
				$class_names = $class_names ? ' class="dropdown-item ' . esc_attr( $class_names ) . '"' : '';
			}
			else {
				$class_names = $class_names ? ' class="dropdown-item ' . esc_attr( $class_names ) . '"' : '';
			}
		}
		//2nd lvl sub menu li class
		else if( $depth == 2 ){
			$class_names = $class_names ? ' class="dropdown-item ' . esc_attr( $class_names ) . '"' : '';
		}
		//default li class
		else {
			if ( $args->has_children ) {
				// if menu item has sub menu
				$class_names = $class_names ? ' class="nav-item dropdown  ' . esc_attr( $class_names ) . '"' : '';
			}
			else{
				$class_names = $class_names ? ' class="nav-item ' . esc_attr( $class_names ) . '"' : '';
			}
		}
        $id = apply_filters( 'nav_menu_item_id', 'menu-item-'. $item->ID, $item, $args );
        $id = $id ? ' id="' . esc_attr( $id ) . '"' : '';
		
        $output .= $indent . '<li' . $id . $value . $class_names .'>';
        // add span with number here
        if ( $depth == 0 ) { // remove if statement if depth check is not required
            $output .= sprintf( '', $this->number++ );
        }
		
        $atts = array();        
        $atts['target'] = ! empty( $item->target )     ? $item->target     : '';
        $atts['rel']    = ! empty( $item->xfn )        ? $item->xfn        : '';
        $atts['href']   = ! empty( $item->url )        ? $item->url        : '';
        $atts = apply_filters( 'nav_menu_link_attributes', $atts, $item, $args );
        $attributes = '';
		$varpost = get_post($item->object_id);   
        foreach ( $atts as $attr => $value ) {
		//1st lvl sub menu a class and attr
		if( $depth == 1 ){
		if ( ! empty( $value ) ) {
					$value = ( 'href' === $attr ) ? esc_url( $value ) : esc_attr( $value );
					$attributes .= ' ' . $attr . '="'. $value .'"';
					$attributes .= ' class=" menu-' . $varpost->post_name . '"';
			}
		}
		//2nd lvl sub menu a class and attr
		else if( $depth == 2 ){
		if ( ! empty( $value ) ) {
					$value = ( 'href' === $attr ) ? esc_url( $value ) : esc_attr( $value );
					$attributes .= ' ' . $attr . '="'. $value .'"';
					$attributes .= ' class=" menu-' . $varpost->post_name . '"';
			}
		}
		//default a class and attr
		else { 
			if ( ! empty( $value ) ) {
					$value = ( 'href' === $attr ) ? esc_url( $value ) : esc_attr( $value );
					$attributes .= ' ' . $attr . '="'. $value .'"';
					$attributes .= ' class="nav-link nav-color menu-' . $varpost->post_name . '"';
			}
		}
        }
        $item_output = $args->before;
		$item_output .= '';
		if ( $args->has_children ) {
			//2nd lvl sub menu holder a markup
			if( $depth == 1 ){
				$item_output .= '<span class="nav-color">';
				$item_output .= $args->link_before . apply_filters( 'the_title', $item->title, $item->ID ) . $args->link_after;
				$item_output .= '<i class="ti-angle-right"></i></span>';
			}
			else {
			//1st lvl sub menu holder a markup
			$item_output .= '<span class="nav-link nav-color">';
			$item_output .= $args->link_before . apply_filters( 'the_title', $item->title, $item->ID ) . $args->link_after;
			$item_output .= '<i class="ti-angle-down"></i></span>';
			}
		}
		else {
			//default a markup
			$item_output .= '<a'. $attributes .' >';
			$item_output .= $args->link_before . apply_filters( 'the_title', $item->title, $item->ID ) . $args->link_after;
			$item_output .= '</a>';
		}
		$item_output .= '';
        $item_output .= $args->after;
        $output .= apply_filters( 'walker_nav_menu_start_el', $item_output, $item, $depth, $args );
		
    }
	function display_element( $element, &$children_elements, $max_depth, $depth=0, $args, &$output ) {
		$id_field = $this->db_fields['id'];
		if ( is_object( $args[0] ) ) {
		  $args[0]->has_children = ! empty( $children_elements[$element->$id_field] );
		}
		return parent::display_element( $element, $children_elements, $max_depth, $depth, $args, $output );
	}
	function start_lvl( &$output, $depth = 0, $args = array() ) {
		//2nd lvl sub menu ul markup
		if($depth >= 1) {
			$indent = str_repeat("\t", $depth);
			$output .= "\n$indent<ul class='sub-menu'>\n";
		}
		else {
			// 1st lvl sub menu ul markup
			$indent = str_repeat("\t", $depth);
			$output .= "\n$indent<ul class='dropdown-menu'>\n";
		}
    }
    function end_lvl( &$output, $depth = 0, $args = array() ) {
        $indent = str_repeat("\t", $depth);
        $output .= "$indent</ul>\n";
    }
}


class Bauen_Click_Walker extends Walker_Nav_Menu {
    var $number = 1;
    function start_el( &$output, $item, $depth = 0, $args = array(), $id = 0 ) {
        $indent = ( $depth ) ? str_repeat( "\t", $depth ) : '';
        $class_names = $value = '';
        $classes = empty( $item->classes ) ? array() : (array) $item->classes;
        $icon_class = $classes[0];
        $class_names = join( ' ', apply_filters( 'nav_menu_css_class', array_filter( $classes ), $item, $args ) );
		if ( $args->has_children ) {
			// if menu item has sub menu
			$class_names = $class_names ? ' class="bauen-sub  ' . esc_attr( $class_names ) . '"' : '';
		}
		else{
			$class_names = $class_names ? ' class=" ' . esc_attr( $class_names ) . '"' : '';
		}
		
        $id = apply_filters( 'nav_menu_item_id', 'menu-item-'. $item->ID, $item, $args );
        $id = $id ? ' id="' . esc_attr( $id ) . '"' : '';
		
        $output .= $indent . '<li' . $id . $value . $class_names .'>';
        // add span with number here
        if ( $depth == 0 ) { // remove if statement if depth check is not required
            $output .= sprintf( '', $this->number++ );
        }
		
        $atts = array();        
        $atts['target'] = ! empty( $item->target )     ? $item->target     : '';
        $atts['rel']    = ! empty( $item->xfn )        ? $item->xfn        : '';
        $atts['href']   = ! empty( $item->url )        ? $item->url        : '';
        $atts = apply_filters( 'nav_menu_link_attributes', $atts, $item, $args );
        $attributes = '';
		$varpost = get_post($item->object_id);   
        foreach ( $atts as $attr => $value ) {
		
			if ( ! empty( $value ) ) {
					$value = ( 'href' === $attr ) ? esc_url( $value ) : esc_attr( $value );
					$attributes .= ' ' . $attr . '="'. $value .'"';
					$attributes .= ' class="nav-link nav-color menu-' . $varpost->post_name . '"';
			}
		
        }
        $item_output = $args->before;
		$item_output .= '';
		if ( $args->has_children ) {
			//default a markup
			$item_output .= '<a href="#" >';
			$item_output .= $args->link_before . apply_filters( 'the_title', $item->title, $item->ID ) . $args->link_after;
			$item_output .= '</a>';
		}
		else {
			//default a markup
			$item_output .= '<a'. $attributes .' >';
			$item_output .= $args->link_before . apply_filters( 'the_title', $item->title, $item->ID ) . $args->link_after;
			$item_output .= '</a>';
		}
		$item_output .= '';
        $item_output .= $args->after;
        $output .= apply_filters( 'walker_nav_menu_start_el', $item_output, $item, $depth, $args );
		
    }
	function display_element( $element, &$children_elements, $max_depth, $depth=0, $args, &$output ) {
		$id_field = $this->db_fields['id'];
		if ( is_object( $args[0] ) ) {
		  $args[0]->has_children = ! empty( $children_elements[$element->$id_field] );
		}
		return parent::display_element( $element, $children_elements, $max_depth, $depth, $args, $output );
	}
	function start_lvl( &$output, $depth = 0, $args = array() ) {
		// 1st lvl sub menu ul markup
		$indent = str_repeat("\t", $depth);
		$output .= "\n$indent<ul>\n";
    }
    function end_lvl( &$output, $depth = 0, $args = array() ) {
        $indent = str_repeat("\t", $depth);
        $output .= "$indent</ul>\n";
    }
}

/**
 * Include the TGM_Plugin_Activation class.
 */
require_once (BAUEN_THEME_PATH .'/framework/class-tgm-plugin-activation.php');

/**
 * Register the required plugins for this theme.
 */
function bauen_register_required_plugins() {

$bauen_plugins = array(
// This is an example of how to include a plugin from the WordPress Plugin Repository.
        array(
            'name'      => esc_html__( 'Redux Framework', 'bauen' ),
            'slug'      => 'redux-framework',
            'required'  => true,
			'force_activation'   => false,
            'force_deactivation' => false,
        ),		
		array(
            'name'      => esc_html__( 'WPBakery Page Builder', 'bauen' ),
            'slug'      => 'js_composer',
			'source'    => 'http://webredox.net/plugins/js_composer.zip',
            'required'  => true,
        ),	
		
		array(
            'name'      => esc_attr__( 'Revolution Slider', 'bauen' ),
            'slug'      => 'revslider',
            'source'    => esc_url('http://webredox.net/plugins/revslider.zip','bauen' ),
            'required'  => true,  
        ),
				
		array(
            'name'      => esc_html__( 'Bauen Plugin', 'bauen' ),
            'slug'      => 'bauen-plugin',
			'source'    => 'http://webredox.net/demo/wp/plugins/bauen-plugin.zip',
			'required'  => true,
        ),
		array(
            'name'      => esc_html__( 'Contact Form 7', 'bauen' ),
            'slug'      => 'contact-form-7',
            'required'  => true,
        ),
		
		array(
            'name'      => esc_html__( 'Meta Box', 'bauen' ),
            'slug'      => 'meta-box',
            'required'  => true,
        ),
		
		array(
            'name'      => esc_html__( 'Bauen Demo Importer', 'bauen' ),
            'slug'      => 'one-click-demo-import',
            'required'  => true,
        ),
		array(
            'name'      => esc_html__( 'MailChimp for WordPress', 'bauen' ),
            'slug'      => 'mailchimp-for-wp',
            'required'  => true,
        ),		
		
    );


    /**
     * Array of configuration settings. Amend each line as needed.
     */
    $bauen_config = array(
        'default_path' => '',                      
        'menu'         => 'tgmpa-install-plugins',
        'has_notices'  => true,
        'dismissable'  => true,
        'dismiss_msg'  => '',                      
        'is_automatic' => false,                   
        'message'      => '',                      
        
    );
tgmpa( $bauen_plugins, $bauen_config );

}

if ( is_admin() ) {

	function bauen_remove_revolution_slider_meta_boxes() {
		remove_meta_box( 'mymetabox_revslider_0', 'page', 'normal' );
		remove_meta_box( 'mymetabox_revslider_0', 'post', 'normal' );
		remove_meta_box( 'mymetabox_revslider_0', 'gallery', 'normal' );
		remove_meta_box( 'slugdiv', 'gallery', 'normal' );
	}

	add_action( 'do_meta_boxes', 'bauen_remove_revolution_slider_meta_boxes' );
	
}
