<?php
    /**
     * ReduxFramework Sample Config File
     * For full documentation, please visit: http://docs.reduxframework.com/
     */

    if ( ! class_exists( 'Redux' ) ) {
        return;
    }


    // This is your option name where all the Redux data is stored.
    $opt_name = "bauen";

    // This line is only for altering the demo. Can be easily removed.
    $opt_name = apply_filters( 'bauen/opt_name', $opt_name );

    /*
     *
     * --> Used within different fields. Simply examples. Search for ACTUAL DECLARATION for field examples
     *
     */

    /**
     * ---> SET ARGUMENTS
     * All the possible arguments for Redux.
     * For full documentation on arguments, please refer to: https://github.com/ReduxFramework/ReduxFramework/wiki/Arguments
     * */

    $theme = wp_get_theme(); // For use with some settings. Not necessary.

    $args = array(
        // TYPICAL -> Change these values as you need/desire
        'opt_name'             => $opt_name,
		'class'                => 'admin-color-pimax',
        // This is where your data is stored in the database and also becomes your global variable name.
        'display_name'         => $theme->get( 'Name' ),
        // Name that appears at the top of your panel
        'display_version'      => $theme->get( 'Version' ),
        // Version that appears at the top of your panel
        'menu_type'            => 'menu',
        //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
        'allow_sub_menu'       => true,
        // Show the sections below the admin menu item or not
        'menu_title'           => esc_html__( 'Bauen Options', 'bauen' ),
        'page_title'           => esc_html__( 'Bauen Options', 'bauen' ),
        // You will need to generate a Google API key to use this feature.
        // Please visit: https://developers.google.com/fonts/docs/developer_api#Auth
        'google_api_key'       => 'AIzaSyCN8bSGZHdbSOXu0HbhXf8j0SnswTmbCNw',
        // Set it you want google fonts to update weekly. A google_api_key value is required.
        'google_update_weekly' => true,
        // Must be defined to add google fonts to the typography module
        'async_typography'     => false,
        // Use a asynchronous font on the front end or font string
        //'disable_google_fonts_link' => true,                    // Disable this in case you want to create your own google fonts loader
        'admin_bar'            => true,
        // Show the panel pages on the admin bar
        'admin_bar_icon'       => 'dashicons-portfolio',
        // Choose an icon for the admin bar menu
        'admin_bar_priority'   => 50,
        // Choose an priority for the admin bar menu
        'global_variable'      => '',
        // Set a different name for your global variable other than the opt_name
        'dev_mode'             => false,
        // Show the time the page took to load, etc
        'update_notice'        => false,
        // If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo
        'customizer'           => true,
        // Enable basic customizer support
        //'open_expanded'     => true,                    // Allow you to start the panel in an expanded way initially.
        //'disable_save_warn' => true,                    // Disable the save warning when a user changes a field

        // OPTIONAL -> Give you extra features
        'page_priority'        => null,
        // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
        'page_parent'          => 'themes.php',
        // For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
        'page_permissions'     => 'manage_options',
        // Permissions needed to access the options panel.
        'menu_icon'            => '',
        // Specify a custom URL to an icon
        'last_tab'             => '',
        // Force your panel to always open to a specific tab (by id)
        'page_icon'            => 'icon-themes',
        // Icon displayed in the admin panel next to your menu_title
        'page_slug'            => '',
        // Page slug used to denote the panel, will be based off page title then menu title then opt_name if not provided
        'save_defaults'        => true,
        // On load save the defaults to DB before user clicks save or not
        'default_show'         => false,
        // If true, shows the default value next to each field that is not the default value.
        'default_mark'         => '',
        // What to print by the field's title if the value shown is default. Suggested: *
        'show_import_export'   => true,
        // Shows the Import/Export panel when not used as a field.

        // CAREFUL -> These options are for advanced use only
        'transient_time'       => 60 * MINUTE_IN_SECONDS,
        'output'               => true,
        // Global shut-off for dynamic CSS output by the bauen. Will also disable google fonts output
        'output_tag'           => true,
        // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head
        // 'footer_credit'     => '',                   // Disable the footer credit of Redux. Please leave if you can help it.

        // FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
        'database'             => '',
        // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!
        'use_cdn'              => true,
        // If you prefer not to use the CDN for Select2, Ace Editor, and others, you may download the Redux Vendor Support plugin yourself and run locally or embed it in your code.

        // HINTS
        'hints'                => array(
            'icon'          => 'el el-question-sign',
            'icon_position' => 'right',
            'icon_color'    => 'lightgray',
            'icon_size'     => 'normal',
            'tip_style'     => array(
                'color'   => 'red',
                'shadow'  => true,
                'rounded' => false,
                'style'   => '',
            ),
            'tip_position'  => array(
                'my' => 'top left',
                'at' => 'bottom right',
            ),
            'tip_effect'    => array(
                'show' => array(
                    'bauen'   => 'slide',
                    'duration' => '500',
                    'event'    => 'mouseover',
                ),
                'hide' => array(
                    'bauen'   => 'slide',
                    'duration' => '500',
                    'event'    => 'click mouseleave',
                ),
            ),
        )
    );

    
    // Panel Intro text -> before the form
    if ( ! isset( $args['global_variable'] ) || $args['global_variable'] !== false ) {
        if ( ! empty( $args['global_variable'] ) ) {
            $v = $args['global_variable'];
        } else {
            $v = str_replace( '-', '_', $args['opt_name'] );
        }
        $args['intro_text'] = sprintf( esc_html__( '', 'bauen' ), $v );
    } else {
        $args['intro_text'] = esc_html__( '', 'bauen' );
    }

    // Add content after the form.
    $args['footer_text'] = esc_html__( '', 'bauen' );

    Redux::setArgs( $opt_name, $args );

    /*
     * ---> END ARGUMENTS
     */


    /*
     * ---> START HELP TABS
     */

    $tabs = array(
        array(
            'id'      => 'redux-help-tab-1',
            'title'   => esc_html__( 'Support', 'bauen' ),
            'content' => esc_html__( 'Send us a mail by using our item support form.', 'bauen' )
        ),
        
    );
    Redux::setHelpTab( $opt_name, $tabs );

    // Set the help sidebar
    $content = esc_html__( 'Send us a mail by using our item support form.', 'bauen' );
    Redux::setHelpSidebar( $opt_name, $content );


    /*
     * <--- END HELP TABS
     */


    /*
     *
     * ---> START SECTIONS
     *
     */

    /*

        As of Redux 3.5+, there is an extensive API. This API can be used in a mix/match mode allowing for


     */

    // ACTUAL DECLARATION OF SECTIONS
                Redux::setSection( $opt_name, array(
                    'title'  => esc_html__( 'General Settings', 'bauen' ),
                    'desc'   => esc_html__( '', 'bauen' ),
                    'icon'   => 'el-icon-home-alt',
                    // 'submenu' => false, // Setting submenu to false on a given section will hide it from the WordPress sidebar menu!
                    'fields' => array(
					
						array(
								'id' => 'notice_header_logo',
								'type' => 'info',
								'notice' => true,
								'style' => 'success',
								'title' => esc_html__('Logo Options', 'bauen'),
								'desc' => esc_html__('Logo options of your site header.', 'bauen')
						),						
						array(
								'id' => 'image_logo',
								'type' => 'button_set',
								'title' => esc_html__('Image Logo', 'bauen'),
								'subtitle' => esc_html__('', 'bauen'),
								'desc' => '',
								'options' => array(
										'st1'=> esc_html__('Disable', 'bauen'),
										'st2' => esc_html__('Enable', 'bauen'),
								),
								'default'  => 'st1'
						),					
						array(
								'id' => 'logopic',
								'type' => 'media',
								'compiler' => 'true',
								'title' => esc_html__('Upload Logo', 'bauen'),
								'subtitle' => esc_html__('', 'bauen'),
								'required' => array('image_logo', '=' , 'st2')
						),
						
						array(
								'id' => 'nav_scroll_logo',
								'type' => 'button_set',
								'title' => esc_html__('Sticky Logo Selection', 'bauen'),
								'subtitle' => esc_html__('Working only for Classic and Click  menu style.', 'bauen'),
								'desc' => '',
								'options' => array(
										'st1'=> esc_html__('Disable', 'bauen'),
										'st2' => esc_html__('Enable', 'bauen'),
								),
								'default'  => 'st1'
						),	
						
						array(
								'id' => 'nav_scroll_logo_visiabilty',
								'type' => 'button_set',
								'title' => esc_html__('Show Sticky Logo Image', 'bauen'),
								'subtitle' => esc_html__('Working only for Classic and Click menu style.', 'bauen'),
								'desc' => '',
								'options' => array(
										'st1'=> esc_html__('On Scroll', 'bauen'),
										'st2' => esc_html__('Always', 'bauen'),
								),
								'default'  => 'st1',
								'required' => array('nav_scroll_logo', '=' , 'st2')
						),

						array(
								'id' => 'logopic_dark',
								'type' => 'media',
								'compiler' => 'true',
								'title' => esc_html__('Upload Sticky Navigation Logo', 'bauen'),
								'subtitle' => esc_html__('', 'bauen'),
								'required' => array('nav_scroll_logo', '=' , 'st2')
						),						

						$fields = array(
						'id'       => 'opt_logo_dimensions',
						'type'     => 'dimensions',
						'units'    => array('em','px','%'),
						'output' => array('img.logo-img, .bauen-header .bauen-logo img.logo-img, #bauen-aside .bauen-logo img.logo-img, div.logo'),
						'title'    => __('Logo Size', 'bauen'),
						'subtitle' => __('.', 'bauen'),
						'desc'     => __('Optional', 'bauen'),
						'default'  => array(
							'Width'   => '75', 
							'Height'  => '53'
						),
						'required' => array('image_logo', '=' , 'st2')
						),
                        /*
	                    $fields = array(
							'id'             => 'opt_logo_spacing_mrg',
							'type'           => 'spacing',
							'output' => array('img.logo-img, .bauen-header .bauen-logo img.logo-img, #bauen-aside .bauen-logo img.logo-img'),
							'mode'           => 'margin',
							'units'          => array('em', 'px'),
							'units_extended' => 'false',
							'title'          => __('Logo Margin', 'bauen'),
							'subtitle'       => __('Allow your users to choose the spacing or margin they want.', 'bauen'),
							'desc'           => __('You can enable or disable any piece of this field. Top, Right, Bottom, Left, or Units.', 'bauen'),
							'default'            => array(
								//'margin-top'     => '1px', 
								//'margin-right'   => '2px', 
								//'margin-bottom'  => '3px', 
								//'margin-left'    => '4px',
								'units'          => 'px', 
							),
						'required' => array('image_logo', '=' , 'st2')	
						),	
	                    $fields = array(
							'id'             => 'opt_logo_spacing_pad',
							'type'           => 'spacing',
							'output' => array('img.logo-img, .bauen-header .bauen-logo img.logo-img, #bauen-aside .bauen-logo img.logo-img'),
							'mode'           => 'padding',
							'units'          => array('em', 'px'),
							'units_extended' => 'false',
							'title'          => __('Logo Padding', 'bauen'),
							'subtitle'       => __('Allow your users to choose the spacing or padding they want.', 'bauen'),
							'desc'           => __('You can enable or disable any piece of this field. Top, Right, Bottom, Left, or Units.', 'bauen'),
							'default'            => array(
								//'padding-top'     => '1px', 
								//'padding-right'   => '2px', 
								//'padding-bottom'  => '3px', 
								//'padding-left'    => '4px',
								'units'          => 'px', 
							),
						'required' => array('image_logo', '=' , 'st2')	
						),	*/					
						array(
								'id' => 'text_logo',
								'type' => 'button_set',
								'title' => esc_html__('Text Logo', 'bauen'),
								'subtitle' => esc_html__('', 'bauen'),
								'desc' => '',
								'options' => array(
										'st1'=> esc_html__('Disable', 'bauen'),
										'st2' => esc_html__('Enable', 'bauen'),
								),
								'default'  => 'st2'
						),						
						array(
								'id' => 'logo_text_title',
								'type' => 'text',
								'title' => esc_html__('Logo Text', 'bauen'),
								'subtitle' => esc_html__('Ex: BAUEN', 'bauen'),
								'required' => array('text_logo', '=' , 'st2')								
							
						),
						array(
								'id' => 'logo_text_sub',
								'type' => 'text',
								'title' => esc_html__('Logo Tagline Text', 'bauen'),
								'subtitle' => esc_html__('Ex: INNOVATE DESIGN', 'bauen'),
							    'required' => array('text_logo', '=' , 'st2')	
						),										
						array(
									'id' => 'notice_site_nav_menu',
									'type' => 'info',
									'notice' => true,
									'style' => 'success',
									'title' => esc_html__('Nav Menu Options.', 'bauen'),
									'desc' => esc_html__('Select Nav Menu Style.', 'bauen'),
									
							),						
							
						array(
								'id' => 'nav_menu_style',
								'type' => 'select',
								'title' => esc_html__('Nav Menu Style', 'bauen'),
								'subtitle' => esc_html__('', 'bauen'),
								'desc' => '',
								'options' => array(
										'st1'=> esc_html__('Classic', 'bauen'),
										'st2' => esc_html__('Click', 'bauen'),
										'st3'=> esc_html__('Classic Fullscreen', 'bauen'),
										'st4'=> esc_html__('Click Fullscreen', 'bauen'),
										'st5' => esc_html__('Sidebar', 'bauen'),
										
								),
								'default'  => 'st1'
							),	
						array(
								'id' => 'header_color_style',
								'type' => 'button_set',
								'title' => esc_html__('Nav Menu Color Style', 'bauen'),
								'subtitle' => esc_html__('', 'bauen'),
								'desc' => '',
								'options' => array(
										'no'=> esc_html__('Black', 'bauen'),
										'yes' => esc_html__('White', 'bauen'),
										
								),
								'default'  => 'no',
						),	
						array(
								'id' => 'header_logo_sub_color_style',
								'type' => 'button_set',
								'title' => esc_html__('Logo Tag Line Color Style', 'bauen'),
								'subtitle' => esc_html__('', 'bauen'),
								'desc' => '',
								'options' => array(
										'no'=> esc_html__('Gray', 'bauen'),
										'yes' => esc_html__('White', 'bauen'),
										
								),
								'default'  => 'no',
						),		
						array(
								'id' => 'notice_header_contact_info_social',
								'type' => 'info',
								'notice' => true,
								'style' => 'success',
								'title' => esc_html__('Social Icon Options', 'bauen'),
								'desc' => esc_html__('', 'bauen'),
								'required' => array('nav_menu_style', '=' , 'st5')
						),
							
						array(
								'id' => 'en_header_social_opt',
								'type' => 'button_set',
								'title' => esc_html__('Social Icon', 'bauen'),
								'subtitle' => esc_html__('', 'bauen'),
								'desc' => '',
								'options' => array(
										'st1'=> esc_html__('Disable', 'bauen'),
										'st2' => esc_html__('Enable', 'bauen'),
								),
								'default'  => 'st1',
								'required' => array('nav_menu_style', '=' , 'st5')
						),	

						
						array(
									'id' => 'notice_header_contact_info',
									'type' => 'info',
									'notice' => true,
									'style' => 'success',
									'title' => esc_html__('Click Nav Menu Info Options', 'bauen'),
									'desc' => esc_html__('', 'bauen'),
						),
						array(
								'id' => 'menu_contact_info',
								'type' => 'button_set',
								'title' => esc_html__('Menu Info', 'bauen'),
								'subtitle' => esc_html__('', 'bauen'),
								'desc' => '',
								'options' => array(
										'no'=> esc_html__('Disable', 'bauen'),
										'yes' => esc_html__('Enable', 'bauen'),
										
								),
								'default'  => 'yes',
						),						
					    array(
								'id' => 'notice_header_contact_info_email',
								'type' => 'info',
								'notice' => true,
								'style' => 'success',
								'title' => esc_html__('Contact Info', 'bauen'),
								'desc' => esc_html__('', 'bauen'),
								'required' => array('menu_contact_info', '=' , 'yes')
						),
						array(
								'id' => 'hd_email_address1',
								'type' => 'text',
								'compiler' => 'true',
								'title' => esc_html__('Email Address 1', 'bauen'),
								'subtitle' => esc_html__('', 'bauen'),
								'required' => array('menu_contact_info', '=' , 'yes')
						),
						
						array(
								'id' => 'hd_email_address2',
								'type' => 'text',
								'compiler' => 'true',
								'title' => esc_html__('Email Address 2', 'bauen'),
								'subtitle' => esc_html__('', 'bauen'),
								'required' => array('menu_contact_info', '=' , 'yes')
						),
																								
						array(
								'id' => 'hd_phn_number1',
								'type' => 'text',
								'compiler' => 'true',
								'title' => esc_html__('Phone Number 1', 'bauen'),
								'subtitle' => esc_html__('', 'bauen'),
								'required' => array('menu_contact_info', '=' , 'yes')								
						),
						
						array(
								'id' => 'hd_phn_number2',
								'type' => 'text',
								'compiler' => 'true',
								'title' => esc_html__('Phone Number 2', 'bauen'),
								'subtitle' => esc_html__('', 'bauen'),
								'required' => array('menu_contact_info', '=' , 'yes')
						),
						
					
						array(
									'id' => 'notice_site_preloader',
									'type' => 'info',
									'notice' => true,
									'style' => 'success',
									'title' => esc_html__('Preloader Options.', 'bauen'),
									'desc' => esc_html__('', 'bauen'),
									
							),
						
						array(
								'id' => 'enable_preloader',
								'type' => 'button_set',
								'title' => esc_html__('Preloader', 'bauen'),
								'subtitle' => esc_html__('', 'bauen'),
								'desc' => '',
								'options' => array(
										'no'=> esc_html__('Disable', 'bauen'),
										'yes' => esc_html__('Enable', 'bauen'),
								),
								'default'  => 'yes'
						),																				
						
						array(
									'id' => 'notice_site_lines',
									'type' => 'info',
									'notice' => true,
									'style' => 'success',
									'title' => esc_html__('Content Lines Option', 'bauen'),
									'desc' => esc_html__('', 'bauen'),
									
						),								
						array(
									'id' => 'content_lines',
									'type' => 'button_set',
									'title' => esc_attr__('Content Lines', 'bauen'),
									'subtitle' => esc_attr__('', 'bauen'),
									'desc' => '',
									'options' => array(
											'st1'=> esc_html__('Disable', 'bauen'),
											'st2' => esc_html__('Enable', 'bauen'),
									),
									'default'  => 'st1'
						),	
						array(
									'id' => 'notice_site_scrollbar',
									'type' => 'info',
									'notice' => true,
									'style' => 'success',
									'title' => esc_html__('Scrollbar Option', 'bauen'),
									'desc' => esc_html__('', 'bauen'),
									
						),						
						array(
								'id' => 'scrollbar',
								'type' => 'button_set',
								'title' => esc_attr__('Scrollbar Style', 'bauen'),
								'subtitle' => esc_attr__('Choose theme scrollbar style.', 'bauen'),
								'options' => array(
										'st1'=> esc_html__('Disable', 'bauen'),
										'st2' => esc_html__('Enable', 'bauen'),
								),
								'default'  => 'st1'						
						),											
						array(
									'id' => 'notice_site_aniamte',
									'type' => 'info',
									'notice' => true,
									'style' => 'success',
									'title' => esc_html__('Animate Effect Option', 'bauen'),
									'desc' => esc_html__('', 'bauen'),
									
							),
								
						array(
									'id' => 'animate_style',
									'type' => 'button_set',
									'title' => esc_attr__('Animate Effect', 'bauen'),
									'subtitle' => esc_attr__('', 'bauen'),
									'desc' => '',
									'options' => array(
											'st1'=> esc_html__('Disable', 'bauen'),
											'st2' => esc_html__('Enable', 'bauen'),										
									),
									'default'  => 'st1'
						),											
					
				  )
               ) );
			   
				Redux::setSection( $opt_name, array(
                    'icon'   => 'el-icon-brush',
                    'title'  => esc_html__( 'Styling', 'bauen' ),
                    'fields' => array(
						array(
									'id' => 'notice_site_theme_color',
									'type' => 'info',
									'notice' => true,
									'style' => 'success',
									'title' => esc_html__('Theme Color Scheme Options.', 'bauen'),
									'desc' => esc_html__('Select Theme Color Scheme Style.', 'bauen'),
									
						),						
						array(
								'id' => 'theme_color_style',
								'type' => 'button_set',
								'title' => esc_html__('Theme Color Scheme Style', 'bauen'),
								'subtitle' => esc_html__('', 'bauen'),
								'desc' => '',
								'options' => array(
										'st1' => esc_html__('Light Version', 'bauen'),
										'st2' => esc_html__('Dark Version', 'bauen'),
										
								),
								'default'  => 'st1'
							),	
						array(
								'id'       => 'opt_theme_style',
								'type'     => 'color',
								'title'    => esc_html__( 'Theme Color Option', 'bauen' ),
								'subtitle' => esc_html__( 'Only color validation can be done on this field type', 'bauen' ),
								'desc'     => esc_html__( 'Change all global color.', 'bauen' ),
								//'regular'   => false, // Disable Regular Color
								//'hover'     => false, // Disable Hover Color
								//'active'    => false, // Disable Active Color
								//'visited'   => true,  // Enable Visited Color
								
						),
					)
                ) );			  
			   
				Redux::setSection( $opt_name, array(
                    'icon'   => 'el-icon-cogs',
                    'title'  => esc_html__( 'Page Settings', 'bauen' ),
                    'fields' => array(
					array(
							'id' => 'header-error',
							'type' => 'info',
		                    'notice' => true,
		                    'style' => 'info',
							'title' => esc_attr__('404 Error Page Option', 'bauen'),
							
					),		
					array(
							'id' => '404_page_img_opt',
							'type' => 'button_set',
							'title' => esc_html__('404 Page Image', 'bauen'),
							'subtitle' => esc_html__('', 'bauen'),
							'desc' => '',
							'options' => array(
									'st1'=> esc_html__('Disable', 'bauen'),
									'st2' => esc_html__('Enable', 'bauen'),
									
							),
							'default'  => 'st1',
					),						
					array(
							'id' => '404_page_img',
							'type' => 'media',
							'compiler' => 'true',
							'title' => esc_html__('Upload 404 Image', 'bauen'),
							'subtitle' => esc_html__('', 'bauen'),
							'default' => array('url' => get_template_directory_uri().'/includes/images/404-image.png'),'required' => array('404_page_img_opt', '=' , 'st2')								
					),
					array(
							'id' => '404_banner_img',
							'type' => 'media',
							'compiler' => 'true',
							'title' => esc_html__('Upload 404 Banner Background', 'bauen'),
							'subtitle' => esc_html__('', 'bauen'),
					),											
					array(
			                'id' => 'notice_404page_translation',
			                'type' => 'info',
			                'notice' => true,
			                'style' => 'success',
			                'title' => esc_html__('404 Page Translate Options', 'bauen'),
			                'desc' => esc_html__('404 Page Text Translate Options', 'bauen'),
							
			        ),						
					array(
							'id' => '404_page_title_2',
							'type' => 'text',
							'compiler' => 'true',
							'title' => esc_html__('Text 1', 'bauen'),
							'subtitle' => esc_html__('Translate Options. Ex:  Page not found. ', 'bauen'),
							
					),
					array(
							'id' => '404_page_title_4',
							'type' => 'text',
							'compiler' => 'true',
							'title' => esc_html__('Text 2', 'bauen'),
							'subtitle' => esc_html__('Translate Options. Ex:  The page you were looking for does not exist. ', 'bauen'),
							
					),					
					array(
							'id' => '404_page_title_3',
							'type' => 'text',
							'compiler' => 'true',
							'title' => esc_html__('Text 3', 'bauen'),
							'subtitle' => esc_html__('Translate Options. Ex:  Back To Home', 'bauen'),
							
					),
					array(
							'id' => '404_serach',
							'type' => 'button_set',
							'title' => esc_html__('404 Page Search Box', 'bauen'),
							'subtitle' => esc_html__('', 'bauen'),
							'desc' => '',
							'options' => array(
									'st1'=> esc_html__('Disable', 'bauen'),
									'st2' => esc_html__('Enable', 'bauen'),
									
							),
							'default'  => 'st1',
					),	
						array(
							'id' => '404_serach_title',
							'type' => 'text',
							'compiler' => 'true',
							'title' => esc_html__('Text 4', 'bauen'),
							'subtitle' => esc_html__('Translate Options. Ex: Search here', 'bauen'),
							'required' => array('404_serach', '=' , 'st2')
					),				
					array(
			                'id' => 'notice_portfoliopage_translation',
			                'type' => 'info',
			                'notice' => true,
			                'style' => 'success',
			                'title' => esc_html__('Portfolio Post Page Options', 'bauen'),
			                'desc' => esc_html__('', 'bauen'),
							
			            ),					
					array(
							'id' => 'port_page_url',
							'type' => 'text',
							'compiler' => 'true',
							'title' => esc_html__('Portfolio Page URL', 'bauen'),
							'subtitle' => esc_html__('Insert portfolio page url here.', 'bauen'),
							
					),	
					array(
			                'id' => 'notice_portfolio_translation',
			                'type' => 'info',
			                'notice' => true,
			                'style' => 'success',
			                'title' => esc_html__('Translation Options', 'bauen'),
			                'desc' => esc_html__('Default Text Translate Here.', 'bauen'),
			        ),
					array(
							'id' => 'back_port',
							'type' => 'text',
							'title' => esc_html__('Back To Portfolio', 'bauen'),
							'subtitle' => esc_html__('Portfolio Pagination.', 'bauen'),
					),
					array(
							'id' => 'back_home',
							'type' => 'text',
							'title' => esc_html__('Back To Home', 'bauen'),
							'subtitle' => esc_html__('Portfolio Pagination.', 'bauen'),
					),					
					array(
							'id' => 'translet_opt_5',
							'type' => 'text',
							'title' => esc_html__('Prev', 'bauen'),
							'subtitle' => esc_html__('Portfolio Pagination.', 'bauen'),
					),
					
					array(
							'id' => 'translet_opt_6',
							'type' => 'text',
							'title' => esc_html__('Next', 'bauen'),
							'subtitle' => esc_html__('Portfolio Pagination.', 'bauen'),
					),
										
					
                    )
                ) );
				
			
				
				Redux::setSection( $opt_name, array(
                    'icon'   => 'el-icon-bullhorn',
                    'title'  => esc_html__( 'Blog Settings', 'bauen' ),
                    'fields' => array(
					
					array(
			                'id' => 'notice_index_details_main_page_opt',
			                'type' => 'info',
			                'notice' => true,
			                'style' => 'success',
			                'title' => esc_html__('Blog Details Page Style', 'bauen'),
			                'desc' => esc_html__('Select blog details page style of your site. You can select details style from post also.', 'bauen')
			        ),
					
					array(
							'id' => 'blogdetailstyle',
							'type' => 'button_set',
							'title' => esc_html__('Select Blog Details Layout', 'bauen'),
							'subtitle' => esc_html__('', 'bauen'),
							'desc' => '',
							'options' => array(
									'st1'=> esc_html__('Right Sidebar', 'bauen'),
									'st2' => esc_html__('Full Width', 'bauen'),
									
							),
							'default'  => 'st1'
					),

					
			        array(
							'id' => 'index_header_show',
							'type' => 'button_set',
							'title' => esc_html__('Blog Header Section', 'bauen'),
							'subtitle' => esc_html__('Enable/Disable header section for blog single, archives, category, tag & search page.', 'bauen'),
							'default'  => 'yes',
							'options' => array(
									'yes'=> esc_html__('Enable', 'bauen'),
									'no'=> esc_html__('Disable', 'bauen'),
							),
							
					),						
					array(
							'id' => 'index_header_banner_img',
							'type' => 'media',
							'compiler' => 'true',
							'title' => esc_html__('Upload Index Header Image', 'bauen'),
							'subtitle' => esc_html__('', 'bauen'),
							'required' => array('index_header_show', '=' , 'yes')
					),							
					array(
							'id' => 'blog_page_title',
							'type' => 'text',
							'title' => esc_html__('Blog Title Text', 'bauen'),
							'subtitle' => esc_html__('Insert blog page header title text here.', 'bauen'),
							'required' => array('index_header_show', '=' , 'yes')
							
					),									
					array(
			                'id' => 'notice_blog_translation',
			                'type' => 'info',
			                'notice' => true,
			                'style' => 'success',
			                'title' => esc_html__('Translation Options', 'bauen'),
			                'desc' => esc_html__('Default Text Translate Here.', 'bauen'),
			        ),	
					array(
							'id' => 'blog_read_more',
							'type' => 'text',
							'title' => __('Read More', 'bauen'),
							'subtitle' => __('Change/Repalce blog post "Read More" text here.', 'bauen'),
							'default' => '',
							
					),					  					
					array(
							'id' => 'arch_page_title',
							'type' => 'text',
							'title' => esc_html__('Archive Page Title', 'bauen'),
							'subtitle' => esc_html__('Insert header title for blog archive page here. Ex: Archive : ', 'bauen'),
							'default' => '',
					),	
					array(
							'id' => 'cat_page_title',
							'type' => 'text',
							'title' => esc_html__('Category Page Title', 'bauen'),
							'subtitle' => esc_html__('Insert header title for blog category page here. Ex: Category : ', 'bauen'),
							'default' => '',
					),	
	
					array(
							'id' => 'tag_page_title',
							'type' => 'text',
							'title' => esc_html__('Tag Page Title', 'bauen'),
							'subtitle' => esc_html__('Insert header title for blog tag page here. Ex: Tag : ', 'bauen'),
							'default' => '',
					),						

					array(
							'id' => 'src_page_title',
							'type' => 'text',
							'title' => esc_html__('Search Page Title', 'bauen'),
							'subtitle' => esc_html__('Insert header title for blog search page title here. Ex: Search Results for :', 'bauen'),
							'default' => '',
					),
					array(
							'id' => 'blog_page_nopost',
							'type' => 'text',
							'title' => esc_html__('Search Page No Post Title', 'bauen'),
							'subtitle' => esc_html__('Insert header title for blog search page no post title here. Ex: No Post Found', 'bauen'),
							'default' => '',
					),	
					array(
							'id' => 'blog_page_search_again',
							'type' => 'text',
							'title' => esc_html__('Search Page Search Again Title', 'bauen'),
							'subtitle' => esc_html__('Insert header title for blog search page no post title here. Ex: Please Search Again.', 'bauen'),
							'default' => '',
					),	
					array(
							'id' => 'translet_opt_9',
							'type' => 'text',
							'title' => esc_html__('No Results Found', 'bauen'),
							'subtitle' => esc_html__('Search Page.', 'bauen'),
					),				
					array(
							'id' => 'translet_opt_3',
							'type' => 'text',
							'title' => esc_html__('Search..', 'bauen'),
							'subtitle' => esc_html__('Search Widget.', 'bauen'),
					),
					
                    )
                ) );								
				
				Redux::setSection( $opt_name, array(
                    'icon'   => 'el-icon-leaf',
                    'title'  => esc_html__( 'Social Options', 'bauen' ),
                    'fields' => array(
					
					
					array(
							'id' => 'facebook',
							'type' => 'text',
							'title' => esc_html__('Facebook ', 'bauen'),
							'subtitle' => esc_html__('Insert Social URL Here.', 'bauen'),
							
					),
					
					array(
							'id' => 'twitter',
							'type' => 'text',
							'title' => esc_html__('Twitter ', 'bauen'),
							'subtitle' => esc_html__('Insert Social URL Here.', 'bauen'),
							
					),
					
					array(
							'id' => 'pinterest',
							'type' => 'text',
							'title' => esc_html__('Pinterest ', 'bauen'),
							'subtitle' => esc_html__('Insert Social URL Here.', 'bauen'),
							
					),
					
					array(
							'id' => 'instagram',
							'type' => 'text',
							'title' => esc_html__('Instagram ', 'bauen'),
							'subtitle' => esc_html__('Insert Social URL Here.', 'bauen'),
							
							
					),					
					
					array(
							'id' => 'behance',
							'type' => 'text',
							'title' => esc_html__('Behance ', 'bauen'),
							'subtitle' => esc_html__('Insert Social URL Here.', 'bauen'),
							
					),
					
					array(
							'id' => 'dribbble',
							'type' => 'text',
							'title' => esc_html__('Dribbble', 'bauen'),
							'subtitle' => esc_html__('Insert Social URL Here.', 'bauen'),
							
					),
					
					array(
							'id' => 'gplus',
							'type' => 'text',
							'title' => esc_html__('Google+ ', 'bauen'),
							'subtitle' => esc_html__('Insert Social URL Here.', 'bauen'),
							
					),
					
					array(
							'id' => 'linkedin',
							'type' => 'text',
							'title' => esc_html__('LinkedIn ', 'bauen'),
							'subtitle' => esc_html__('Insert Social URL Here.', 'bauen'),
							
					),
					
					array(
							'id' => 'youtube',
							'type' => 'text',
							'title' => esc_html__('YouTube ', 'bauen'),
							'subtitle' => esc_html__('Insert Social URL Here.', 'bauen'),
							
						
					),
					
					array(
							'id' => 'vimeo',
							'type' => 'text',
							'title' => esc_html__('Vimeo ', 'bauen'),
							'subtitle' => esc_html__('Insert Social URL Here.', 'bauen'),
							
							
					),
					
					array(
							'id' => 'slack',
							'type' => 'text',
							'title' => esc_html__('Slack ', 'bauen'),
							'subtitle' => esc_html__('Insert Social URL Here.', 'bauen'),
							
							
					),
					
					array(
							'id' => 'github',
							'type' => 'text',
							'title' => esc_html__('GitHub ', 'bauen'),
							'subtitle' => esc_html__('Insert Social URL Here.', 'bauen'),
							
							
					),
					
					array(
							'id' => 'tumblr',
							'type' => 'text',
							'title' => esc_html__('Tumblr ', 'bauen'),
							'subtitle' => esc_html__('Insert Social URL Here.', 'bauen'),
							
							
					),
					array(
							'id'       => 'opt_add_more_social',
							'type'     => 'multi_text',
							'title'    => esc_html__( 'Add More Social Icons (Footer)', 'bauen' ),
							'subtitle' => esc_html__( '', 'bauen' ),
							'desc'     => __( 'Ex: &lt;a target="_blank" href="#"&gt;&lt;i class="fab fa-facebook-f"&gt;&lt;/i&gt;&lt;/a&gt;<br>Use <a href="https://fontawesome.com/icons?d=listing" target="_blank">Fontawesome</a> Icon Class', 'bauen' ),
					),									
					
					array(
							'id'       => 'opt_add_more_text_social',
							'type'     => 'multi_text',
							'title'    => esc_html__( 'Add More Social Icons (Sidebar Nav)', 'bauen' ),
							'subtitle' => esc_html__( '', 'bauen' ),
							'desc'     => __( 'Ex: &lt;li&gt;&lt;a target="_blank" href="#"&gt;&lt;i class="fab fa-facebook-f"&gt;&lt;/i&gt;&lt;/a&gt;&lt;/li&gt;<br>Use <a href="https://fontawesome.com/icons?d=listing" target="_blank">Fontawesome</a> Icon Class', 'bauen' ),							
					),	
					
                    )
                ) );
				Redux::setSection( $opt_name, array(
                    'icon'   => 'el-icon-text-width',
                    'title'  => esc_attr__( 'Typography', 'bauen' ),
                    'fields' => array(  


						array(
                            'id'          => 'typo_body',
                            'type'        => 'typography', 
                            'title'       => esc_html__('Body', 'bauen'),
                            'google'      => true, 
                            'font-backup' => false,
                            'output'      => array('body'),
                            'units'       =>'px',
                            'line-height'       =>true,
							'font-size'   => true,
                            'text-align'       =>false,
                            'subtitle'    => esc_html__('Specify the Body Text font properties.', 'bauen'),
                            'default'     => array(
                            'color'       => false,
                            'font-style'  => false,
                            'font-family' => false,
                            'google'      => true,
                            'font-size'   => false,
                            'line-height' => false,
                            'text-align' => false,
                            ),
						),
				
						array(
			                'id' => 'notice_t_global',
			                'type' => 'info',
			                'notice' => true,
			                'style' => 'success',
			                'title' => esc_html__('All The Title Tag Font Properties.', 'bauen'),
			                'desc' => esc_html__('Specify the all title tag font properties.', 'bauen')
			            ),
						
						array(
                            'id'          => 'typo_t_h1',
                            'type'        => 'typography', 
                            'title'       => esc_html__('H1', 'bauen'),
                            'google'      => true, 
                            'font-backup' => false,
                            'output'      => array('body h1'),
                            'units'       =>'px',
                            'line-height'       =>true,
							'font-size'   => true,
                            'text-align'       =>false,
                            'subtitle'    => esc_html__('Specify the h1 font properties.', 'bauen'),
                            'default'     => array(
                            'color'       => false,
                            'font-style'  => false,
                            'font-family' => false,
                            'google'      => true,
                            'font-size'   => false,
                            'line-height' => false,
                            'text-align' => false,
                            ),
						),
						
						array(
                            'id'          => 'typo_t_h2',
                            'type'        => 'typography', 
                            'title'       => esc_html__('H2', 'bauen'),
                            'google'      => true, 
                            'font-backup' => false,
                            'output'      => array('body h2'),
                            'units'       =>'px',
                            'line-height'       =>true,
							'font-size'   => true,
                            'text-align'       =>false,
                            'subtitle'    => esc_html__('Specify the h2 font properties.', 'bauen'),
                            'default'     => array(
                            'color'       => false,
                            'font-style'  => false,
                            'font-family' => false,
                            'google'      => true,
                            'font-size'   => false,
                            'line-height' => false,
                            'text-align' => false,
                            ),
						),
						
						array(
                            'id'          => 'typo_t_h3',
                            'type'        => 'typography', 
                            'title'       => esc_html__('H3', 'bauen'),
                            'google'      => true, 
                            'font-backup' => false,
                            'output'      => array('body h3'),
                            'units'       =>'px',
                            'line-height'       =>true,
							'font-size'   => true,
                            'text-align'       =>false,
                            'subtitle'    => esc_html__('Specify the h3 font properties.', 'bauen'),
                            'default'     => array(
                            'color'       => false,
                            'font-style'  => false,
                            'font-family' => false,
                            'google'      => true,
                            'font-size'   => false,
                            'line-height' => false,
                            'text-align' => false,
                            ),
						),
						
						array(
                            'id'          => 'typo_t_h4',
                            'type'        => 'typography', 
                            'title'       => esc_html__('H4', 'bauen'),
                            'google'      => true, 
                            'font-backup' => false,
                            'output'      => array('body h4'),
                            'units'       =>'px',
                            'line-height'       =>true,
							'font-size'   => true,
                            'text-align'       =>false,
                            'subtitle'    => esc_html__('Specify the h4 font properties.', 'bauen'),
                            'default'     => array(
                            'color'       => false,
                            'font-style'  => false,
                            'font-family' => false,
                            'google'      => true,
                            'font-size'   => false,
                            'line-height' => false,
                            'text-align' => false,
                            ),
						),
						
						array(
                            'id'          => 'typo_t_h5',
                            'type'        => 'typography', 
                            'title'       => esc_html__('H5', 'bauen'),
                            'google'      => true, 
                            'font-backup' => false,
                            'output'      => array('body h5'),
                            'units'       =>'px',
                            'line-height'       =>true,
							'font-size'   => true,
                            'text-align'       =>false,
                            'subtitle'    => esc_html__('Specify the h5 font properties.', 'bauen'),
                            'default'     => array(
                            'color'       => false,
                            'font-style'  => false,
                            'font-family' => false,
                            'google'      => true,
                            'font-size'   => false,
                            'line-height' => false,
                            'text-align' => false,
                            ),
						),
						
						array(
                            'id'          => 'typo_t_h6',
                            'type'        => 'typography', 
                            'title'       => esc_html__('H6', 'bauen'),
                            'google'      => true, 
                            'font-backup' => false,
                            'output'      => array('body h6'),
                            'units'       =>'px',
                            'line-height'       =>true,
							'font-size'   => true,
                            'text-align'       =>false,
                            'subtitle'    => esc_html__('Specify the h6 font properties.', 'bauen'),
                            'default'     => array(
                            'color'       => false,
                            'font-style'  => false,
                            'font-family' => false,
                            'google'      => true,
                            'font-size'   => false,
                            'line-height' => false,
                            'text-align' => false,
                            ),
						),												
						array(
                            'id'          => 'typo_t_t',
                            'type'        => 'typography', 
                            'title'       => esc_html__('Section Title', 'bauen'),
                            'google'      => true, 
                            'font-backup' => false,
                            'output'      => array('body .section-title'),
                            'units'       =>'px',
                            'line-height'       =>true,
							'font-size'   => true,
                            'text-align'       =>false,
                            'subtitle'    => esc_html__('Specify the title font properties.', 'bauen'),
                            'default'     => array(
                            'color'       => false,
                            'font-style'  => false,
                            'font-family' => false,
                            'google'      => true,
                            'font-size'   => false,
                            'line-height' => false,
                            'text-align' => false,
                            ),
						),	
						array(
                            'id'          => 'typo_t_t_s',
                            'type'        => 'typography', 
                            'title'       => esc_html__('Section Title Span', 'bauen'),
                            'google'      => true, 
                            'font-backup' => false,
                            'output'      => array('body .section-title span'),
                            'units'       =>'px',
                            'line-height'       =>true,
							'font-size'   => true,
                            'text-align'       =>false,
                            'subtitle'    => esc_html__('Specify the title font properties.', 'bauen'),
                            'default'     => array(
                            'color'       => false,
                            'font-style'  => false,
                            'font-family' => false,
                            'google'      => true,
                            'font-size'   => false,
                            'line-height' => false,
                            'text-align' => false,
                            ),
						),							
						array(
			                'id' => 'notice_p_1',
			                'type' => 'info',
			                'notice' => true,
			                'style' => 'success',
			                'title' => esc_html__('P Tag Font Properties.', 'bauen'),
			                'desc' => esc_html__('Specify the p tag font properties.', 'bauen')
			            ),
						
						array(
                            'id'          => 'typo_p_s_d',
                            'type'        => 'typography', 
                            'title'       => esc_html__('P', 'bauen'),
                            'google'      => true, 
                            'font-backup' => false,
                            'output'      => array('body p'),
                            'units'       =>'px',
                            'line-height'       =>true,
							'font-size'   => true,
                            'text-align'       =>false,
                            'subtitle'    => esc_html__('Specify the p font properties.', 'bauen'),
                            'default'     => array(
                            'color'       => false,
                            'font-style'  => false,
                            'font-family' => false,
                            'google'      => true,
                            'font-size'   => false,
                            'line-height' => false,
                            'text-align' => false,
                            ),
						),
						array(
			                'id' => 'notice_critical1_permalink1',
			                'type' => 'info',
			                'notice' => true,
			                'style' => 'success',
			                'title' => __('Permalink', 'bauen'),
			                'desc' => __('', 'bauen')
			            ),	
                        array(
                            'id'          => 'typography-lnurl',
                            'type'        => 'typography', 
                            'title'       => __('URL', 'bauen'),
                            'google'      => true, 
                            'font-backup' => false,
                            'output'      => array('body a'),
                            'units'       =>'px',
                            'subtitle'    => __('Specify the permalink URL font properties.', 'bauen'),
                            'default'     => array(
                            'color'       => false,
                            'font-style'  => false,
                            'font-family' => false,
                            'google'      => true,
                            'font-size'   => false,
                            'line-height' => false,
                            ),							
						),		
						array(
                            'id'          => 'typography-a-hover',
                            'type'        => 'typography', 
                            'title'       => esc_attr__('URL Hover', 'bauen'),
                            'google'      => true, 
                            'font-backup' => false,
                            'output'      => array('body a:focus, body a:hover'),
                            'units'       =>'px',
                            'subtitle'    => esc_attr__('Specify the permalink font properties.', 'bauen'),
                            'default'     => array(
                            'color'       => false,
                            'font-style'  => false,
                            'font-family' => false,
                            'google'      => true,
                            'font-size'   => false,
                            'line-height' => false,
                            ),
						),	
                        array(
                            'id'          => 'typography-lnurl-btn',
                            'type'        => 'typography', 
                            'title'       => __('Button URL (Light)', 'bauen'),
                            'google'      => true, 
                            'font-backup' => false,
                            'output'      => array('body .butn-light a'),
                            'units'       =>'px',
                            'subtitle'    => __('Specify the permalink URL font properties.', 'bauen'),
                            'default'     => array(
                            'color'       => false,
                            'font-style'  => false,
                            'font-family' => false,
                            'google'      => true,
                            'font-size'   => false,
                            'line-height' => false,
                            ),							
						),	
						array(
                            'id'          => 'typography-a-hover-btn',
                            'type'        => 'typography', 
                            'title'       => esc_attr__('Button URL Hover  (Light)', 'bauen'),
                            'google'      => true, 
                            'font-backup' => false,
                            'output'      => array('body .butn-light a:focus, body .butn-light a:hover'),
                            'units'       =>'px',
                            'subtitle'    => esc_attr__('Specify the permalink font properties.', 'bauen'),
                            'default'     => array(
                            'color'       => false,
                            'font-style'  => false,
                            'font-family' => false,
                            'google'      => true,
                            'font-size'   => false,
                            'line-height' => false,
                            ),
						),							
                        array(
                            'id'          => 'typography-lnurl-btn-drk',
                            'type'        => 'typography', 
                            'title'       => __('Button URL (Dark)', 'bauen'),
                            'google'      => true, 
                            'font-backup' => false,
                            'output'      => array('body .butn-dark a'),
                            'units'       =>'px',
                            'subtitle'    => __('Specify the permalink URL font properties.', 'bauen'),
                            'default'     => array(
                            'color'       => false,
                            'font-style'  => false,
                            'font-family' => false,
                            'google'      => true,
                            'font-size'   => false,
                            'line-height' => false,
                            ),							
						),						

						array(
                            'id'          => 'typography-a-hover-btn-dark',
                            'type'        => 'typography', 
                            'title'       => esc_attr__('Button URL Hover (Dark)', 'bauen'),
                            'google'      => true, 
                            'font-backup' => false,
                            'output'      => array('body .butn-dark a:focus, body .butn-dark a:hover'),
                            'units'       =>'px',
                            'subtitle'    => esc_attr__('Specify the permalink font properties.', 'bauen'),
                            'default'     => array(
                            'color'       => false,
                            'font-style'  => false,
                            'font-family' => false,
                            'google'      => true,
                            'font-size'   => false,
                            'line-height' => false,
                            ),
						),				
												
						array(
			                'id' => 'notice_critical13',
			                'type' => 'info',
			                'notice' => true,
			                'style' => 'success',
			                'title' => __('Page', 'bauen'),
			                'desc' => __('', 'bauen')
			            ),					
                        array(
                            'id'          => 'typography-pgcontentl',
                            'type'        => 'typography', 
                            'title'       => __('Content', 'bauen'),
                            'google'      => true, 
                            'font-backup' => false,
                            'output'      => array('body .page-content p'),
                            'units'       =>'px',
                            'subtitle'    => __('Specify the page content text font properties.', 'bauen'),
                            'default'     => array(
                            'color'       => false,
                            'font-style'  => false,
                            'font-family' => false,
                            'google'      => true,
                            'font-size'   => false,
                            'line-height' => false,
                            ),							
						),						
                        array(
                            'id'          => 'typography-pgsecwdtl',
                            'type'        => 'typography', 
                            'title'       => __('Sidebar Widget Title', 'bauen'),
                            'google'      => true, 
                            'font-backup' => false,
                            'output'      => array('body .blog-sidebar .widget-title h6'),
                            'units'       =>'px',
                            'subtitle'    => __('Specify the page section title font properties.', 'bauen'),
                            'default'     => array(
                            'color'       => false,
                            'font-style'  => false,
                            'font-family' => false,
                            'google'      => true,
                            'font-size'   => false,
                            'line-height' => false,
                            ),							
						), 	
                        array(
                            'id'          => 'typography-pgsecwdcont',
                            'type'        => 'typography', 
                            'title'       => __('Sidebar Widget Content', 'bauen'),
                            'google'      => true, 
                            'font-backup' => false,
                            'output'      => array('body .widget.widget-block, body .textwidget'),
                            'units'       =>'px',
                            'subtitle'    => __('Specify the page section title font properties.', 'bauen'),
                            'default'     => array(
                            'color'       => false,
                            'font-style'  => false,
                            'font-family' => false,
                            'google'      => true,
                            'font-size'   => false,
                            'line-height' => false,
                            ),							
						), 		
                        array(
                            'id'          => 'typography-lnurl_sidebar',
                            'type'        => 'typography', 
                            'title'       => __('Sidebar URL', 'bauen'),
                            'google'      => true, 
                            'font-backup' => false,
                            'output'      => array('body .blog-sidebar a, body .blog-sidebar .widget ul li a'),
                            'units'       =>'px',
                            'subtitle'    => __('Specify the permalink URL font properties.', 'bauen'),
                            'default'     => array(
                            'color'       => false,
                            'font-style'  => false,
                            'font-family' => false,
                            'google'      => true,
                            'font-size'   => false,
                            'line-height' => false,
                            ),							
						),		
						array(
                            'id'          => 'typography-a-hover_sidebar',
                            'type'        => 'typography', 
                            'title'       => esc_attr__('Sidebar URL Hover', 'bauen'),
                            'google'      => true, 
                            'font-backup' => false,
                            'output'      => array('body .blog-sidebar a:focus, body .blog-sidebar a:hover, body .blog-sidebar .widget ul li a:focus, body .blog-sidebar .widget ul li a:hover'),
                            'units'       =>'px',
                            'subtitle'    => esc_attr__('Specify the permalink font properties.', 'bauen'),
                            'default'     => array(
                            'color'       => false,
                            'font-style'  => false,
                            'font-family' => false,
                            'google'      => true,
                            'font-size'   => false,
                            'line-height' => false,
                            ),
						),						
						array(
			                'id' => 'notice_critical14',
			                'type' => 'info',
			                'notice' => true,
			                'style' => 'success',
			                'title' => __('Post', 'bauen'),
			                'desc' => __('', 'bauen')
			            ),	
                        array(
                            'id'          => 'typography-bltl',
                            'type'        => 'typography', 
                            'title'       => __('Blog Page Title (List Style)', 'bauen'),
                            'google'      => true, 
                            'font-backup' => false,
                            'output'      => array('body .bauen-blog3 .post-cont h5 a'),
                            'units'       =>'px',
                            'subtitle'    => __('Specify the blog post title font properties.', 'bauen'),
                            'default'     => array(
                            'color'       => false,
                            'font-style'  => false,
                            'font-family' => false,
                            'google'      => true,
                            'font-size'   => false,
                            'line-height' => false,
                            ),							
						),	
	                        array(
                            'id'          => 'typography-bltl-hover',
                            'type'        => 'typography', 
                            'title'       => __('Blog Page Title Hover (List Style)', 'bauen'),
                            'google'      => true, 
                            'font-backup' => false,
                            'output'      => array('body .bauen-blog3 .post-cont h5 a:hover'),
                            'units'       =>'px',
                            'subtitle'    => __('Specify the blog post title font properties.', 'bauen'),
                            'default'     => array(
                            'color'       => false,
                            'font-style'  => false,
                            'font-family' => false,
                            'google'      => true,
                            'font-size'   => false,
                            'line-height' => false,
                            ),							
						),	
                        array(
                            'id'          => 'typography-bltl-col',
                            'type'        => 'typography', 
                            'title'       => __('Blog Page Title (Column Style)', 'bauen'),
                            'google'      => true, 
                            'font-backup' => false,
                            'output'      => array('body .bauen-blog .item .con h5, body .bauen-blog .item .con h5 a'),
                            'units'       =>'px',
                            'subtitle'    => __('Specify the blog post title font properties.', 'bauen'),
                            'default'     => array(
                            'color'       => false,
                            'font-style'  => false,
                            'font-family' => false,
                            'google'      => true,
                            'font-size'   => false,
                            'line-height' => false,
                            ),							
						),	
	                        array(
                            'id'          => 'typography-bltl-hover-col',
                            'type'        => 'typography', 
                            'title'       => __('Blog Page Title Hover (Column Style)', 'bauen'),
                            'google'      => true, 
                            'font-backup' => false,
                            'output'      => array('body .bauen-blog .item .con h5:hover, body .bauen-blog .item .con h5 a:hover'),
                            'units'       =>'px',
                            'subtitle'    => __('Specify the blog post title font properties.', 'bauen'),
                            'default'     => array(
                            'color'       => false,
                            'font-style'  => false,
                            'font-family' => false,
                            'google'      => true,
                            'font-size'   => false,
                            'line-height' => false,
                            ),							
						),
                        array(
                            'id'          => 'typography-bltl-hor',
                            'type'        => 'typography', 
                            'title'       => __('Blog Page Title (Horizontal Style)', 'bauen'),
                            'google'      => true, 
                            'font-backup' => false,
                            'output'      => array('body .bauen-blog2 .content .cont h4'),
                            'units'       =>'px',
                            'subtitle'    => __('Specify the blog post title font properties.', 'bauen'),
                            'default'     => array(
                            'color'       => false,
                            'font-style'  => false,
                            'font-family' => false,
                            'google'      => true,
                            'font-size'   => false,
                            'line-height' => false,
                            ),							
						),	
	                        array(
                            'id'          => 'typography-bltl-hover-hor',
                            'type'        => 'typography', 
                            'title'       => __('Blog Page Title Hover (Horizontal Style)', 'bauen'),
                            'google'      => true, 
                            'font-backup' => false,
                            'output'      => array('body .bauen-blog2 .content .cont h4:hover'),
                            'units'       =>'px',
                            'subtitle'    => __('Specify the blog post title font properties.', 'bauen'),
                            'default'     => array(
                            'color'       => false,
                            'font-style'  => false,
                            'font-family' => false,
                            'google'      => true,
                            'font-size'   => false,
                            'line-height' => false,
                            ),							
						),								
                        array(
                            'id'          => 'typography-bltlindx',
                            'type'        => 'typography', 
                            'title'       => __('Post Page Title', 'bauen'),
                            'google'      => true, 
                            'font-backup' => false,
                            'output'      => array('body .section-title2'),
                            'units'       =>'px',
                            'subtitle'    => __('Specify the blog post title font properties.', 'bauen'),
                            'default'     => array(
                            'color'       => false,
                            'font-style'  => false,
                            'font-family' => false,
                            'google'      => true,
                            'font-size'   => false,
                            'line-height' => false,
                            ),							
						),						
                        array(
                            'id'          => 'typography-blcon',
                            'type'        => 'typography', 
                            'title'       => __('Post Content', 'bauen'),
                            'google'      => true, 
                            'font-backup' => false,
                            'output'      => array('body .post-content p, body .comment-text p'),
                            'units'       =>'px',
                            'subtitle'    => __('Specify the blog post content font properties.', 'bauen'),
                            'default'     => array(
                            'color'       => false,
                            'font-style'  => false,
                            'font-family' => false,
                            'google'      => true,
                            'font-size'   => false,
                            'line-height' => false,
                            ),							
						),	
                        array(
                            'id'          => 'typography-blcon',
                            'type'        => 'typography', 
                            'title'       => __('Post Meta', 'bauen'),
                            'google'      => true, 
                            'font-backup' => false,
                            'output'      => array('body .blogPost__info.leading-md'),
                            'units'       =>'px',
                            'subtitle'    => __('Specify the blog post content font properties.', 'bauen'),
                            'default'     => array(
                            'color'       => false,
                            'font-style'  => false,
                            'font-family' => false,
                            'google'      => true,
                            'font-size'   => false,
                            'line-height' => false,
                            ),							
						),							
						array(
			                'id' => 'notice_critical1_permalink1_post',
			                'type' => 'info',
			                'notice' => true,
			                'style' => 'success',
			                'title' => __('Permalink', 'bauen'),
			                'desc' => __('', 'bauen')
			            ),	
                        array(
                            'id'          => 'typography-lnurl_post',
                            'type'        => 'typography', 
                            'title'       => __('URL', 'bauen'),
                            'google'      => true, 
                            'font-backup' => false,
                            'output'      => array('body .post-content a'),
                            'units'       =>'px',
                            'subtitle'    => __('Specify the permalink URL font properties.', 'bauen'),
                            'default'     => array(
                            'color'       => false,
                            'font-style'  => false,
                            'font-family' => false,
                            'google'      => true,
                            'font-size'   => false,
                            'line-height' => false,
                            ),							
						),		
						array(
                            'id'          => 'typography-a-hover_post',
                            'type'        => 'typography', 
                            'title'       => esc_attr__('URL Hover', 'bauen'),
                            'google'      => true, 
                            'font-backup' => false,
                            'output'      => array('body .post-content a:focus, body .post-content a:hover'),
                            'units'       =>'px',
                            'subtitle'    => esc_attr__('Specify the permalink font properties.', 'bauen'),
                            'default'     => array(
                            'color'       => false,
                            'font-style'  => false,
                            'font-family' => false,
                            'google'      => true,
                            'font-size'   => false,
                            'line-height' => false,
                            ),
						),	
                        array(
                            'id'          => 'typography-readlnurl',
                            'type'        => 'typography', 
                            'title'       => __('Read More', 'bauen'),
                            'google'      => true, 
                            'font-backup' => false,
                            'output'      => array('body .bauen-blog2 .content .cont .more'),
                            'units'       =>'px',
                            'subtitle'    => __('Specify the permalink URL font properties.', 'bauen'),
                            'default'     => array(
                            'color'       => false,
                            'font-style'  => false,
                            'font-family' => false,
                            'google'      => true,
                            'font-size'   => false,
                            'line-height' => false,
                            ),							
						),
                        array(
                            'id'          => 'typography-readlnurlhover',
                            'type'        => 'typography', 
                            'title'       => __('Read More Hover', 'bauen'),
                            'google'      => true, 
                            'font-backup' => false,
                            'output'      => array('body .bauen-blog2 .content .cont .more:hover'),
                            'units'       =>'px',
                            'subtitle'    => __('Specify the permalink URL font properties.', 'bauen'),
                            'default'     => array(
                            'color'       => false,
                            'font-style'  => false,
                            'font-family' => false,
                            'google'      => true,
                            'font-size'   => false,
                            'line-height' => false,
                            ),							
						),	
						array(
			                'id' => 'notice_critical1_navmenu_classic',
			                'type' => 'info',
			                'notice' => true,
			                'style' => 'success',
			                'title' => __('Navigation Menu (Classic)', 'bauen'),
			                'desc' => __('', 'bauen')
			            ),		
						array(
                            'id'          => 'typography-a-navmenu-classic',
                            'type'        => 'typography', 
                            'title'       => esc_attr__('Menu Item', 'bauen'),
                            'google'      => true, 
                            'font-backup' => false,
                            'output'      => array('body .navbar .navbar-nav .nav-link, body .navbar .navbar-nav.-white .nav-link.nav-color, body .navbar .navbar-nav .nav-link.nav-color'),
                            'units'       =>'px',
                            'subtitle'    => esc_attr__('Specify the permalink font properties.', 'bauen'),
                            'default'     => array(
                            'color'       => false,
                            'font-style'  => false,
                            'font-family' => false,
                            'google'      => true,
                            'font-size'   => false,
                            'line-height' => false,
                            ),
						),	
						array(
                            'id'          => 'typography-a-hover-navmenu-classic',
                            'type'        => 'typography', 
                            'title'       => esc_attr__('Menu Item Hover', 'bauen'),
                            'google'      => true, 
                            'font-backup' => false,
                            'output'      => array('body .navbar .navbar-nav .nav-link:hover, body .navbar .navbar-nav.-white .nav-link.nav-color:hover, body .navbar .navbar-nav .nav-link.nav-color:hover'),
                            'units'       =>'px',
                            'subtitle'    => esc_attr__('Specify the permalink font properties.', 'bauen'),
                            'default'     => array(
                            'color'       => false,
                            'font-style'  => false,
                            'font-family' => false,
                            'google'      => true,
                            'font-size'   => false,
                            'line-height' => false,
                            ),
						),
						array(
			                'id' => 'notice_critical1_navmenu_click',
			                'type' => 'info',
			                'notice' => true,
			                'style' => 'success',
			                'title' => __('Navigation Menu (Click)', 'bauen'),
			                'desc' => __('', 'bauen')
			            ),		
						array(
                            'id'          => 'typography-a-navmenu-click',
                            'type'        => 'typography', 
                            'title'       => esc_attr__('Menu Item', 'bauen'),
                            'google'      => true, 
                            'font-backup' => false,
                            'output'      => array('body .bauen-menu>ul>li>a'),
                            'units'       =>'px',
                            'subtitle'    => esc_attr__('Specify the permalink font properties.', 'bauen'),
                            'default'     => array(
                            'color'       => false,
                            'font-style'  => false,
                            'font-family' => false,
                            'google'      => true,
                            'font-size'   => false,
                            'line-height' => false,
                            ),
						),	
						array(
                            'id'          => 'typography-a-hover-navmenu-click',
                            'type'        => 'typography', 
                            'title'       => esc_attr__('Menu Item Hover', 'bauen'),
                            'google'      => true, 
                            'font-backup' => false,
                            'output'      => array('body .bauen-menu ul li:hover > a, body .bauen-menu ul li.open > a, body .bauen-menu ul li.active > a, body .bauen-menu ul ul li:hover > a, body .bauen-menu ul ul li.open > a, body .bauen-menu ul ul li.active>a'),
                            'units'       =>'px',
                            'subtitle'    => esc_attr__('Specify the permalink font properties.', 'bauen'),
                            'default'     => array(
                            'color'       => false,
                            'font-style'  => false,
                            'font-family' => false,
                            'google'      => true,
                            'font-size'   => false,
                            'line-height' => false,
                            ),
						),	
						array(
			                'id' => 'notice_critical1_navmenu_sidebar',
			                'type' => 'info',
			                'notice' => true,
			                'style' => 'success',
			                'title' => __('Navigation Menu (Sidebar)', 'bauen'),
			                'desc' => __('', 'bauen')
			            ),		
						array(
                            'id'          => 'typography-a-navmenu-sidebar',
                            'type'        => 'typography', 
                            'title'       => esc_attr__('Menu Item', 'bauen'),
                            'google'      => true, 
                            'font-backup' => false,
                            'output'      => array('body #bauen-aside .bauen-main-menu>ul>li>a'),
                            'units'       =>'px',
                            'subtitle'    => esc_attr__('Specify the permalink font properties.', 'bauen'),
                            'default'     => array(
                            'color'       => false,
                            'font-style'  => false,
                            'font-family' => false,
                            'google'      => true,
                            'font-size'   => false,
                            'line-height' => false,
                            ),
						),	

						array(
                            'id'          => 'typography-a-hover-navmenu-sidebar',
                            'type'        => 'typography', 
                            'title'       => esc_attr__('Menu Item Hover', 'bauen'),
                            'google'      => true, 
                            'font-backup' => false,
                            'output'      => array('body #bauen-aside .bauen-main-menu > ul > li > a:hover, body #bauen-aside .bauen-main-menu > ul > li.active > a, body #bauen-aside .bauen-main-menu>ul>li.open>a'),
                            'units'       =>'px',
                            'subtitle'    => esc_attr__('Specify the permalink font properties.', 'bauen'),
                            'default'     => array(
                            'color'       => false,
                            'font-style'  => false,
                            'font-family' => false,
                            'google'      => true,
                            'font-size'   => false,
                            'line-height' => false,
                            ),
						),						
						array(
			                'id' => 'notice_critical1_navmenu_overall',
			                'type' => 'info',
			                'notice' => true,
			                'style' => 'success',
			                'title' => __('Navigation Menu Sub/Dropdown', 'bauen'),
			                'desc' => __('', 'bauen')
			            ),	
						array(
                            'id'          => 'typography-a-sub-navmenu',
                            'type'        => 'typography', 
                            'title'       => esc_attr__('Sub Menu Item', 'bauen'),
                            'google'      => true, 
                            'font-backup' => false,
                            'output'      => array('body .dropdown-menu .dropdown-item, body .sub-menu .dropdown-item'),
                            'units'       =>'px',
                            'subtitle'    => esc_attr__('Specify the permalink font properties.', 'bauen'),
                            'default'     => array(
                            'color'       => false,
                            'font-style'  => false,
                            'font-family' => false,
                            'google'      => true,
                            'font-size'   => false,
                            'line-height' => false,
                            ),
						),										
						array(
                            'id'          => 'typography-a-hover-navmenu-sub',
                            'type'        => 'typography', 
                            'title'       => esc_attr__('Sub Menu Item Hover', 'bauen'),
                            'google'      => true, 
                            'font-backup' => false,
                            'output'      => array('body .dropdown-menu .dropdown-item:hover, body .sub-menu .dropdown-item:hover'),
                            'units'       =>'px',
                            'subtitle'    => esc_attr__('Specify the permalink font properties.', 'bauen'),
                            'default'     => array(
                            'color'       => false,
                            'font-style'  => false,
                            'font-family' => false,
                            'google'      => true,
                            'font-size'   => false,
                            'line-height' => false,
                            ),
						),							
						array(
			                'id' => 'notice_critical1_intro',
			                'type' => 'info',
			                'notice' => true,
			                'style' => 'success',
			                'title' => __('Intro Slider', 'bauen'),
			                'desc' => __('', 'bauen')
			            ),
						array(
                            'id'          => 'typography-intro-slider-title',
                            'type'        => 'typography', 
                            'title'       => esc_attr__('Intro Slider Title', 'bauen'),
                            'google'      => true, 
                            'font-backup' => false,
                            'output'      => array('body .header .caption h1'),
                            'units'       =>'px',
                            'subtitle'    => esc_attr__('Specify the permalink font properties.', 'bauen'),
                            'default'     => array(
                            'color'       => false,
                            'font-style'  => false,
                            'font-family' => false,
                            'google'      => true,
                            'font-size'   => false,
                            'line-height' => false,
                            ),
						),
						array(
                            'id'          => 'typography-intro-slider-subtitle',
                            'type'        => 'typography', 
                            'title'       => esc_attr__('Intro Slider Subtitle', 'bauen'),
                            'google'      => true, 
                            'font-backup' => false,
                            'output'      => array('body .header .caption p'),
                            'units'       =>'px',
                            'subtitle'    => esc_attr__('Specify the permalink font properties.', 'bauen'),
                            'default'     => array(
                            'color'       => false,
                            'font-style'  => false,
                            'font-family' => false,
                            'google'      => true,
                            'font-size'   => false,
                            'line-height' => false,
                            ),
						),						
						array(
                            'id'          => 'typography-intro-slider-button',
                            'type'        => 'typography', 
                            'title'       => esc_attr__('Intro Slider Button', 'bauen'),
                            'google'      => true, 
                            'font-backup' => false,
                            'output'      => array('body .butn-light a'),
                            'units'       =>'px',
                            'subtitle'    => esc_attr__('Specify the permalink font properties.', 'bauen'),
                            'default'     => array(
                            'color'       => false,
                            'font-style'  => false,
                            'font-family' => false,
                            'google'      => true,
                            'font-size'   => false,
                            'line-height' => false,
                            ),
						),
						array(
                            'id'          => 'typography-intro-slider-button',
                            'type'        => 'typography', 
                            'title'       => esc_attr__('Intro Slider Button Hover', 'bauen'),
                            'google'      => true, 
                            'font-backup' => false,
                            'output'      => array('body .butn-light a:hover span'),
                            'units'       =>'px',
                            'subtitle'    => esc_attr__('Specify the permalink font properties.', 'bauen'),
                            'default'     => array(
                            'color'       => false,
                            'font-style'  => false,
                            'font-family' => false,
                            'google'      => true,
                            'font-size'   => false,
                            'line-height' => false,
                            ),
						),					
						
					    array(
			                'id' => 'notice_contact_form',
			                'type' => 'info',
			                'notice' => true,
			                'style' => 'success',
			                'title' => esc_html__('Contact form font properties.', 'bauen'),
			                'desc' => esc_html__('Specify the Contact form font properties.', 'bauen')
			            ),
						array(
                            'id'          => 'typopagi_form_1',
                            'type'        => 'typography', 
                            'title'       => esc_html__('Contact Form Placeholder', 'bauen'),
                            'google'      => true, 
                            'font-backup' => false,
                            'output'      => array('::placeholder'),
                            'units'       =>'px',
                            'line-height'       =>true,
							'font-size'   => true,
                            'text-align'       =>false,
                            'subtitle'    => esc_html__('', 'bauen'),
                            'default'     => array(
                            'color'       => false,
                            'font-style'  => false,
                            'font-family' => false,
                            'google'      => true,
                            'font-size'   => false,
                            'line-height' => false,
                            'text-align' => false,
                            ),
						),	
						
						array(
                            'id'          => 'typopagi_form_2',
                            'type'        => 'typography', 
                            'title'       => esc_html__('Label', 'bauen'),
                            'google'      => true, 
                            'font-backup' => false,
                            'output'      => array('body form label'),
                            'units'       =>'px',
                            'line-height'       =>true,
							'font-size'   => true,
                            'text-align'       =>false,
                            'subtitle'    => esc_html__('', 'bauen'),
                            'default'     => array(
                            'color'       => false,
                            'font-style'  => false,
                            'font-family' => false,
                            'google'      => true,
                            'font-size'   => false,
                            'line-height' => false,
                            'text-align' => false,
                            ),
						),	
						
						array(
			                'id' => 'notice_critical1_footer',
			                'type' => 'info',
			                'notice' => true,
			                'style' => 'success',
			                'title' => __('Copyright', 'bauen'),
			                'desc' => __('', 'bauen')
			            ),
						array(
                            'id'          => 'typography-footer-copy',
                            'type'        => 'typography', 
                            'title'       => esc_attr__('Footer Copyright', 'bauen'),
                            'google'      => true, 
                            'font-backup' => false,
                            'output'      => array('body .main-footer .sub-footer p'),
                            'units'       =>'px',
                            'subtitle'    => esc_attr__('Specify the permalink font properties.', 'bauen'),
                            'default'     => array(
                            'color'       => false,
                            'font-style'  => false,
                            'font-family' => false,
                            'google'      => true,
                            'font-size'   => false,
                            'line-height' => false,
                            ),
						),		
						array(
                            'id'          => 'typography-footer-url',
                            'type'        => 'typography', 
                            'title'       => esc_attr__('Footer URL Text', 'bauen'),
                            'google'      => true, 
                            'font-backup' => false,
                            'output'      => array('body .main-footer .sub-footer p'),
                            'units'       =>'px',
                            'subtitle'    => esc_attr__('Specify the permalink font properties.', 'bauen'),
                            'default'     => array(
                            'color'       => false,
                            'font-style'  => false,
                            'font-family' => false,
                            'google'      => true,
                            'font-size'   => false,
                            'line-height' => false,
                            ),
						),
						array(
                            'id'          => 'typography-footer-url-hover',
                            'type'        => 'typography', 
                            'title'       => esc_attr__('Footer URL Text Hover', 'bauen'),
                            'google'      => true, 
                            'font-backup' => false,
                            'output'      => array('body .main-footer .sub-footer p a:hover'),
                            'units'       =>'px',
                            'subtitle'    => esc_attr__('Specify the permalink font properties.', 'bauen'),
                            'default'     => array(
                            'color'       => false,
                            'font-style'  => false,
                            'font-family' => false,
                            'google'      => true,
                            'font-size'   => false,
                            'line-height' => false,
                            ),
						),						
                        
                    )
                ) );

				 Redux::setSection( $opt_name, array(
                    'icon'   => 'el-icon-th-large',
                    'title'  => esc_html__( 'Footer Settings', 'bauen' ),
                    'fields' => array(					
					array(
			                'id' => 'notice_footer_contact',
			                'type' => 'info',
			                'notice' => true,
			                'style' => 'success',
			                'title' => esc_html__('Footer Contact Options', 'bauen'),
			                'desc' => esc_html__('', 'bauen'),
			        ),						
					array(
							'id' => 'en_footer_contact_opt',
							'type' => 'button_set',
							'title' => esc_html__('Footer Contact', 'bauen'),
							'subtitle' => esc_html__('', 'bauen'),
							'desc' => '',
							'options' => array(
									'st1'=> esc_html__('Disable', 'bauen'),
									'st2' => esc_html__('Enable', 'bauen'),
							),
							'default'  => 'st1',
					),					
					array(
							'id' => 'footer_address_title',
							'type' => 'text',
							'compiler' => 'true',
							'title' => esc_html__('Address Text', 'bauen'),
							'subtitle' => esc_html__('Ex:  Our Address ', 'bauen'),
							'required' => array('en_footer_contact_opt', '=' , 'st2'),
					),	
					array(
							'id' => 'ft_address1',
							'type' => 'text',
							'compiler' => 'true',
							'title' => esc_html__('Address Line 1', 'bauen'),
							'subtitle' => esc_html__('', 'bauen'),
							'required' => array('en_footer_contact_opt', '=' , 'st2')
					),	
					array(
							'id' => 'ft_address1_link_url',
							'type' => 'text',
							'compiler' => 'true',
							'title' => esc_html__('Address Line 1 URL', 'bauen'),
							'subtitle' => esc_html__('', 'bauen'),
							'required' => array('en_footer_contact_opt', '=' , 'st2')
					),						
					array(
							'id' => 'ft_address2',
							'type' => 'text',
							'compiler' => 'true',
							'title' => esc_html__('Address Line 2', 'bauen'),
							'subtitle' => esc_html__('(Optional)', 'bauen'),
							'required' => array('en_footer_contact_opt', '=' , 'st2')
					),
					array(
							'id' => 'ft_address2_link_url',
							'type' => 'text',
							'compiler' => 'true',
							'title' => esc_html__('Address Line 2 URL', 'bauen'),
							'subtitle' => esc_html__('', 'bauen'),
							'required' => array('en_footer_contact_opt', '=' , 'st2')
					),						
					array(
							'id' => 'ft_address_link_target',
							'type' => 'button_set',
							'title' => esc_html__('Address URL Open In', 'bauen'),
							'subtitle' => esc_html__('', 'bauen'),
							'desc' => '',
							'options' => array(
									'st1'=> esc_html__('Same Window', 'bauen'),
									'st2' => esc_html__('New Window', 'bauen'),
							),
							'default'  => 'st1',
							'required' => array('en_footer_contact_opt', '=' , 'st2')
					),	
					array(
							'id' => 'footer_email_title',
							'type' => 'text',
							'compiler' => 'true',
							'title' => esc_html__('Email Text', 'bauen'),
							'subtitle' => esc_html__('Ex: Email', 'bauen'),
							'required' => array('en_footer_contact_opt', '=' , 'st2'),
					),
					array(
							'id' => 'ft_email_address1',
							'type' => 'text',
							'compiler' => 'true',
							'title' => esc_html__('Email Address 1', 'bauen'),
							'subtitle' => esc_html__('', 'bauen'),
							'required' => array('en_footer_contact_opt', '=' , 'st2')
					),
					
					array(
							'id' => 'ft_email_address2',
							'type' => 'text',
							'compiler' => 'true',
							'title' => esc_html__('Email Address 2', 'bauen'),
							'subtitle' => esc_html__('(Optional)', 'bauen'),
							'required' => array('en_footer_contact_opt', '=' , 'st2')
					),
					array(
							'id' => 'footer_phone_title',
							'type' => 'text',
							'compiler' => 'true',
							'title' => esc_html__('Phone Text', 'bauen'),
							'subtitle' => esc_html__('Ex: Phone', 'bauen'),
							'required' => array('en_footer_contact_opt', '=' , 'st2'),
					),																							
					array(
							'id' => 'ft_phn_number1',
							'type' => 'text',
							'compiler' => 'true',
							'title' => esc_html__('Phone Number 1', 'bauen'),
							'subtitle' => esc_html__('', 'bauen'),
							'required' => array('en_footer_contact_opt', '=' , 'st2')								
					),					
					array(
							'id' => 'ft_phn_number2',
							'type' => 'text',
							'compiler' => 'true',
							'title' => esc_html__('Phone Number 2', 'bauen'),
							'subtitle' => esc_html__('(Optional)', 'bauen'),
							'required' => array('en_footer_contact_opt', '=' , 'st2')
					),					
				    array(
							'id' => 'theme-cus-copy',
							'type' => 'info',
		                    'notice' => true,
		                    'style' => 'info',
							'title' => esc_html__('Footer Copyright Text Options', 'bauen'),
							'desc' => esc_html__('Copyright text of your webSite.', 'bauen'),
							'required' => array('en_footer_content_opt', '=' , 'st2')
							
					  ),					
					array(
							'id' => 'copyright',
							'type' => 'editor',
							'wpautop'=>true,
							'compiler' => 'true',
							'title' => esc_html__('Copyright Text', 'bauen'),
							'subtitle' => esc_html__('Insert copyright text here.', 'bauen'),
							'default'          => '&copy; Copyright 2022 Bauen. Developed By <a href="https://themeforest.net/user/webredox/portfolio">webRedox</a>',
							'args'   => array(
								'teeny'            => true,
								'textarea_rows'    => 10
							),
					),				
					array(
			                'id' => 'notice_footer_social',
			                'type' => 'info',
			                'notice' => true,
			                'style' => 'success',
			                'title' => esc_html__('Footer Social Icon Options', 'bauen'),
			                'desc' => esc_html__('', 'bauen'),
			        ),						
					array(
							'id' => 'en_footer_social_opt',
							'type' => 'button_set',
							'title' => esc_html__('Footer Social Icon', 'bauen'),
							'subtitle' => esc_html__('', 'bauen'),
							'desc' => '',
							'options' => array(
									'st1'=> esc_html__('Disable', 'bauen'),
									'st2' => esc_html__('Enable', 'bauen'),
							),
							'default'  => 'st1',
					),			
					array(
			                'id' => 'notice_footer_nav',
			                'type' => 'info',
			                'notice' => true,
			                'style' => 'success',
			                'title' => esc_html__('Footer Rightside Options', 'bauen'),
			                'desc' => esc_html__('Footer rightside botttom section page url option.', 'bauen'),
			        ),						
					array(
							'id' => 'footer_menu_title',
							'type' => 'text',
							'compiler' => 'true',
							'title' => esc_html__('Rightside Text', 'bauen'),
							'subtitle' => esc_html__('Ex: Terms &amp; Conditions', 'bauen'),
					),	
					array(
							'id' => 'ft_menu_link_url',
							'type' => 'text',
							'compiler' => 'true',
							'title' => esc_html__('Rightside Text URL', 'bauen'),
							'subtitle' => esc_html__('', 'bauen'),
					),						
					array(
							'id' => 'ft_menu_link_target',
							'type' => 'button_set',
							'title' => esc_html__('Rightside Text URL Open In', 'bauen'),
							'subtitle' => esc_html__('', 'bauen'),
							'desc' => '',
							'options' => array(
									'st1'=> esc_html__('Same Window', 'bauen'),
									'st2' => esc_html__('New Window', 'bauen'),
							),
							'default'  => 'st1',
					),									

					array(
								'id' => 'notice_site_to_top',
								'type' => 'info',
								'notice' => true,
								'style' => 'success',
								'title' => esc_html__('Scroll To Top Button Option', 'bauen'),
								'desc' => esc_html__('Enable/Disable to top button.', 'bauen'),
						
						),
							
					array(
								'id' => 'enable_scroll_top',
								'type' => 'button_set',
								'title' => esc_attr__('Scroll To Top Button', 'bauen'),
								'subtitle' => esc_attr__('', 'bauen'),
								'desc' => '',
								'options' => array(
										'no'=> esc_html__('Disable', 'bauen'),
										'yes' => esc_html__('Enable', 'bauen'),
										
								),
								'default'  => 'yes'
					),					
					
					)
                ) );
				
				Redux::setSection( $opt_name, array(
                    'icon'   => 'el-icon-key',
                    'title'  => esc_html__( 'Documentation', 'bauen' ),
                    'fields' => array(					
					
					array(
							'id' => 'docs',
							'type' => 'info',
		                    'notice' => true,
		                    'style' => 'info',
							'title' => esc_html__('Bauen Theme Documentation', 'bauen'),
							'desc' => __('<a href="http://webredox.net/demo/wp/bauen/doc/documentation.html" target="_blank">Click Here</a> To get the theme documentation.', 'bauen')
							
					),	

			
			
					)
                ));
				
				
    /*
     * <--- END SECTIONS
     */


    /*
     *
     * YOU MUST PREFIX THE FUNCTIONS BELOW AND ACTION FUNCTION CALLS OR ANY OTHER CONFIG MAY OVERRIDE YOUR CODE.
     *
     */

    /*
    *
    * --> Action hook examples
    *
    */

    // If Redux is running as a plugin, this will remove the demo notice and links
    //add_action( 'redux/loaded', 'remove_demo' );

    // Function to test the compiler hook and demo CSS output.
    // Above 10 is a priority, but 2 in necessary to include the dynamically generated CSS to be sent to the function.
    //add_filter('redux/options/' . $opt_name . '/compiler', 'compiler_action', 10, 3);

    // Change the arguments after they've been declared, but before the panel is created
    //add_filter('redux/options/' . $opt_name . '/args', 'change_arguments' );

    // Change the default value of a field after it's been set, but before it's been useds
    //add_filter('redux/options/' . $opt_name . '/defaults', 'change_defaults' );

    // Dynamically add a section. Can be also used to modify sections/fields
    //add_filter('redux/options/' . $opt_name . '/sections', 'dynamic_section');

    /**
     * This is a test function that will let you see when the compiler hook occurs.
     * It only runs if a field    set with compiler=>true is changed.
     * */
    if ( ! function_exists( 'compiler_action' ) ) {
        function compiler_action( $options, $css, $changed_values ) {
            echo '<h1>The compiler hook has run!</h1>';
            echo "<pre>";
            print_r( $changed_values ); // Values that have changed since the last save
            echo "</pre>";
            //print_r($options); //Option values
            //print_r($css); // Compiler selector CSS values  compiler => array( CSS SELECTORS )
        }
    }

    /**
     * Custom function for the callback validation referenced above
     * */
    if ( ! function_exists( 'redux_validate_callback_function' ) ) {
        function redux_validate_callback_function( $field, $value, $existing_value ) {
            $error   = false;
            $warning = false;

            //do your validation
            if ( $value == 1 ) {
                $error = true;
                $value = $existing_value;
            } elseif ( $value == 2 ) {
                $warning = true;
                $value   = $existing_value;
            }

            $return['value'] = $value;

            if ( $error == true ) {
                $return['error'] = $field;
                $field['msg']    = 'your custom error message';
            }

            if ( $warning == true ) {
                $return['warning'] = $field;
                $field['msg']      = 'your custom warning message';
            }

            return $return;
        }
    }

    /**
     * Custom function for the callback referenced above
     */
    if ( ! function_exists( 'redux_my_custom_field' ) ) {
        function redux_my_custom_field( $field, $value ) {
            print_r( $field );
            echo '<br/>';
            print_r( $value );
        }
    }

    /**
     * Custom function for filtering the sections array. Good for child themes to override or add to the sections.
     * Simply include this function in the child themes functions.php file.
     * NOTE: the defined constants for URLs, and directories will NOT be available at this point in a child theme,
     * so you must use get_template_directory_uri() if you want to use any of the built in icons
     * */
    if ( ! function_exists( 'dynamic_section' ) ) {
        function dynamic_section( $sections ) {
            //$sections = array();
            $sections[] = array(
                'title'  => esc_html__( 'Section via hook', 'bauen' ),
                'desc'   => esc_html__( '<p class="description">This is a section created by adding a filter to the sections array. Can be used by child themes to add/remove sections from the options.</p>', 'bauen' ),
                'icon'   => 'el el-paper-clip',
                // Leave this as a blank section, no options just some intro text set above.
                'fields' => array()
            );

            return $sections;
        }
    }

    /**
     * Filter hook for filtering the args. Good for child themes to override or add to the args array. Can also be used in other functions.
     * */
    if ( ! function_exists( 'change_arguments' ) ) {
        function change_arguments( $args ) {
            //$args['dev_mode'] = true;

            return $args;
        }
    }

    /**
     * Filter hook for filtering the default value of any given field. Very useful in development mode.
     * */
    if ( ! function_exists( 'change_defaults' ) ) {
        function change_defaults( $defaults ) {
            $defaults['str_replace'] = 'Testing filter hook!';

            return $defaults;
        }
    }

    /**
     * Removes the demo link and the notice of integrated demo from the redux-bauen plugin
     */
    if ( ! function_exists( 'remove_demo' ) ) {
        function remove_demo() {
            // Used to hide the demo mode link from the plugin page. Only used when Redux is a plugin.
            if ( class_exists( 'ReduxFrameworkPlugin' ) ) {
                remove_filter( 'plugin_row_meta', array(
                    ReduxFrameworkPlugin::instance(),
                    'plugin_metalinks'
                ), null, 2 );

                // Used to hide the activation notice informing users of the demo panel. Only used when Redux is a plugin.
                remove_action( 'admin_notices', array( ReduxFrameworkPlugin::instance(), 'admin_notices' ) );
            }
        }
    }

