<?php
define('BAUEN_THEME_PATH',	get_template_directory());
define('BAUEN_THEME_URL',		get_template_directory_uri());
require (BAUEN_THEME_PATH . '/includes/style.php');
require (BAUEN_THEME_PATH . '/includes/js.php');
require (BAUEN_THEME_PATH . '/includes/color.php');
require (BAUEN_THEME_PATH . '/includes/AfterSetupTheme.php');
require (BAUEN_THEME_PATH . '/includes/functions.php');
require (BAUEN_THEME_PATH . '/bauen-widget/bauen-widget.php');
require (BAUEN_THEME_PATH . '/pagination.php');
require (BAUEN_THEME_PATH . '/includes/ini/bauen-base.php');

if ( ! isset( $content_width ) ) $content_width = 900;	

$bauen_options = get_option('bauen');

// register nav menu
function bauen_register_menus() {
	register_nav_menus( array( 
	'top-menu' => esc_html__( 'Primary menu','bauen' ),
	'main-menu' => esc_attr__('One Page Menu (Sub menu item not allaowed)','bauen'),	
	)
	);
}
add_action( 'after_setup_theme', 'bauen_setup' );

function bauen_setup() {
	// Add support for Block Styles.
	add_theme_support( 'wp-block-styles' );

	// Add support for full and wide align images.
	add_theme_support( 'align-wide' );

	// Add support for editor styles.
	add_theme_support( 'editor-styles' );
	// Enqueue editor styles.
	add_editor_style( 'style-editor.css' );
	
	// Add custom editor font sizes.
	add_theme_support(
			'editor-font-sizes',
			array(
				array(
					'name'      => esc_html__( 'Small', 'bauen' ),
					'shortName' => 'S',
					'size'      => 11,
					'slug'      => 'small',
				),
				array(
					'name'      => esc_html__( 'Normal', 'bauen' ),
					'shortName' => 'M',
					'size'      => 12,
					'slug'      => 'normal',
				),
				array(
					'name'      => esc_html__( 'Large', 'bauen' ),
					'shortName' => 'L',
					'size'      => 36,
					'slug'      => 'large',
				),
				array(
					'name'      => esc_html__( 'Huge', 'bauen' ),
					'shortName' => 'XL',
					'size'      => 49,
					'slug'      => 'huge',
				),
			)
		);
	
	add_theme_support( 'editor-color-palette', array(
        array(
            'name' => esc_html__( 'Light Grey', 'bauen' ),
            'slug' => 'color-grey',
            'color' => '#fafafa',
        ),
        array(
            'name' => esc_html__( 'Black', 'bauen' ),
            'slug' => 'color-black',
            'color' => '#000',
        ),
        
    ) );
	// Add support for responsive embedded content.
	add_theme_support( 'responsive-embeds' );
	
	add_action( 'after_setup_theme', 'bauen_lang_setup' );
	function bauen_lang_setup(){
    load_theme_textdomain('bauen', get_template_directory() . '/languages');
    }
	add_theme_support( 'automatic-feed-links' );
	add_theme_support( "title-tag" );
	add_post_type_support( 'portgallery', 'post-formats' );
	remove_theme_support( 'widgets-block-editor' );
}
// Word Limit 
	function bauen_string_limit_words($string, $word_limit)
	{
	$words = explode(' ', $string, ($word_limit + 1));
	if(count($words) > $word_limit)
	array_pop($words);
	return implode(' ', $words);
	}
// Add post thumbnail functionality
	add_theme_support( 'post-thumbnails' );
	set_post_thumbnail_size( 559, 220, true ); // Normal post thumbnails
	add_image_size( 'bauen_blog_image', 540, 317, true ); // Blog Thumbnail
	add_image_size( 'bauen_portfolio_image', 540, 380, true ); // Portfolio Thumbnail	
	
function bauen_move_comment_field_to_bottom( $fields ) {
$comment_field = $fields['comment'];
unset( $fields['comment'] );
$fields['comment'] = $comment_field;
return $fields;
}
 
add_filter( 'comment_form_fields', 'bauen_move_comment_field_to_bottom' );

// How comments are displayed
function bauen_comment($comment, $args, $depth) {
    $GLOBALS['comment'] = $comment;
    extract($args, EXTR_SKIP);
if ( 'div' == $args['style'] ) {
      $tag = 'div';
      $add_below = 'comment';
    } else {
      $tag = 'li';
      $add_below = 'div-comment';
    }
?>
    <<?php echo esc_attr($tag); ?> <?php comment_class(empty( $args['has_children'] ) ? '' : 'parent') ?>>
    <?php if ( 'div' != $args['style'] ) : ?>
	<?php endif; ?>
	<div class="bauen-post-comment-wrap">
		<div class="bauen-user-comment">
		<?php if ($args['avatar_size'] != 0) echo get_avatar( $comment, '100' ); ?>
		</div>
	    <div class="comments__body bauen-user-content">
            <div class="comments__header"> 
			<h3><?php printf(__('%s','bauen'), get_comment_author_link()) ?> <br><span> <?php comment_date(get_option( 'date_format')); ?></span></h3> 
            </div>    
			<div class="comments__text comment-text">
			    <?php comment_text() ?>
		    </div>
			<div class="comments__reply">
				<?php comment_reply_link(array_merge( $args, array('add_below' => $add_below, 'depth' => $depth, 'max_depth' => $args['max_depth']))) ?>
			</div>			
		</div>
	</div>
		
	<div class="clearfix"></div>
          <?php if ($comment->comment_approved == '0') : ?>
    <em class="comment-awaiting-moderation"><?php esc_html_e('Your comment is awaiting moderation.','bauen') ?></em>
    <br />
	<?php endif; ?>   
<?php if ( 'div' != $args['style'] ) : ?>
    
    <?php endif; ?>
<?php
        }
// create sidebar & widget area
if(function_exists('register_sidebar')) {
function bauen_theme_slug_widgets_init() {
    register_sidebar( array(
        'name' => esc_html__( 'Blog Sidebar', 'bauen' ),
        'id' => 'sidebar-1',
        'description' => esc_html__( 'This area is for blog widgets.', 'bauen' ),
        'before_widget' => '<div id="%1$s" class="widget widget-block %2$s">',
		'after_widget'  => '</div>', 
		'before_title'  => '<div class="widget-title"><h6>', 
		'after_title'   => '</h6></div>'
    ) );
}
add_action( 'widgets_init', 'bauen_theme_slug_widgets_init' );

function bauen_widgets_init() {
    register_sidebar( array(
        'name' => esc_html__( 'Page Sidebar', 'bauen' ),
        'id' => 'sidebar-2',
        'description' => esc_html__( 'This area is for page widgets.', 'bauen' ),
        'before_widget' => '<div id="%1$s" class="widget widget-block %2$s">',
		'after_widget'  => '</div>', 
		'before_title'  => '<div class="widget-title"><h6>', 
		'after_title'   => '</h6></div>'
    ) );
}
add_action( 'widgets_init', 'bauen_widgets_init' );


}

if(function_exists('vc_set_as_theme')) vc_set_as_theme();
// Initialising Shortcodes
if (class_exists('WPBakeryVisualComposerAbstract')) {
  function requireVcExtend(){
    require_once (BAUEN_THEME_PATH . '/extendvc/extend-vc.php');
  }

}

function bauen_my_search_form( $form ) {
$bauen_options = get_option('bauen');
if(!empty($bauen_options['translet_opt_3'])) {
$bauen_search_text = esc_html(Bauen_AfterSetupTheme::return_thme_option('translet_opt_3',''));
}
else {
$bauen_search_text ='Search...';
}
    $bauen_form = '<div class="search"><form role="search" method="get" id="blog-search-form" class="form-search" action="' . esc_url(home_url( '/' )) . '" >
    <label class="screen-reader-text" for="s">' . esc_html__( 'Search for:','bauen' ) . '</label>
    <input type="text" value="' . get_search_query() . '" name="s" id="s" class="form-input black js-pointer-small" placeholder="'. esc_attr($bauen_search_text).'" />
   <button type="submit"><i class="ti-search" aria-hidden="true"></i></button>
   </form></div>';
 
    return $bauen_form;
}
add_filter( 'get_search_form', 'bauen_my_search_form' );

function bauen_excerpt_more( $more ) {
    return '...';
}
add_filter('excerpt_more', 'bauen_excerpt_more');
function bauen_excerpt_length( $length ) {
    return 60;
}
add_filter( 'excerpt_length', 'bauen_excerpt_length', 999 );

/*removing default submit tag*/
remove_action('wpcf7_init', 'wpcf7_add_form_tag_submit');
/*adding action with function which handles our button markup*/
add_action('wpcf7_init', 'bauen_child_cf7_button');
/*adding out submit button tag*/
if (!function_exists('bauen_child_cf7_button')) {
function bauen_child_cf7_button() {
wpcf7_add_form_tag('submit', 'bauen_child_cf7_button_handler');
}
}

/*out button markup inside handler*/
if (!function_exists('bauen_child_cf7_button_handler')) {
function bauen_child_cf7_button_handler($tag) {
$tag = new WPCF7_FormTag($tag);
$class = wpcf7_form_controls_class($tag->type);
$atts = array();
$atts['class'] = $tag->get_class_option($class);
$atts['class'] .= ' bauen-child-custom-btn';
$atts['id'] = $tag->get_id_option();
$atts['tabindex'] = $tag->get_option('tabindex', 'int', true);
$value = isset($tag->values[0]) ? $tag->values[0] : '';
if (empty($value)) {
$value = esc_html__('Submit', 'bauen');
}
$atts['type'] = 'submit';
$atts = wpcf7_format_atts($atts);
$html = sprintf('<div class="wpcf7-form-control wpcf7-submit"><button class="butn-dark mt-15"><a ><span>%2$s</span></a></button></div>', $atts, $value);
return $html;
}
}

function bauen_body_classes( $classes ) {
	if (Bauen_AfterSetupTheme::return_thme_option('theme_color_style')=='st2'){ 
    $classes[] = 'dark-version';
    } else {
	$classes[] = 'light-version';	
	}	
    return $classes;
}
add_filter( 'body_class','bauen_body_classes' );


if (is_admin() && isset($_GET['activated'])){
	wp_redirect(admin_url("themes.php?page=bauen"));
}