<?php

/*
**	Rockthemes Default WooCommerce Setting
**
**	
*/

//Activate WooCommerce Settings for WooCommerce Notification
add_theme_support( 'woocommerce' );
add_theme_support( 'wc-product-gallery-zoom' );
add_theme_support( 'wc-product-gallery-lightbox' );
add_theme_support( 'wc-product-gallery-slider' );


/*
**	Deregister default WooCommerce Styles
**
*/
if ( version_compare( WOOCOMMERCE_VERSION, "2.1" ) >= 0 ) {
	add_filter( 'woocommerce_enqueue_styles', '__return_false' );
} else {
	define( 'WOOCOMMERCE_USE_CSS', false );
}


/*
**	Enqueue theme style for WooCommerce
**
*/
function rockthemes_enqueue_woocommerce_css(){
	wp_register_style( 'woocommerce', get_template_directory_uri() . '/css/woocommerce.css' );
	if ( class_exists( 'woocommerce' ) ) {
		wp_enqueue_style( 'woocommerce' );
	}
}
add_action( 'wp_enqueue_scripts', 'rockthemes_enqueue_woocommerce_css',1);

/*
**	A widely used plugin named "Product Archive Customizer", deregister it's style
**
*/
function rockthemes_woo_remove_queue(){
	//Deregister Product Arhieve Customizer (pac) style 
	wp_deregister_style('pac-layout-styles');
}
add_action( 'wp_enqueue_scripts', 'rockthemes_woo_remove_queue',99);



//Get Main Font Details
$site_default_font_details = xr_get_option('site_default_font_details',array());
$main_font = 'font-family: "Open Sans", sans-serif;';
if(!empty($site_default_font_details)){
	$main_font = sanitize_text_field($site_default_font_details['font_family']);
}
$shop_header_font = $main_font;

//Get Main Colors
$main_color = xr_get_option('site_general_color','#00aae8');
$main_font_color = xr_get_option('general_font_color', '#666666');

$rockthemes_woocommerce_settings = array(
	'style'		=>	array(
		'shop_columns'				=>	intval(xr_get_option('woo_shop_product_blocks',2)),
		
		'cross_up_sells_total_cart'		=>	((int)xr_get_option('cross_up_sells_total_cart',2)),
		'cross_up_sells_blocks_cart'	=>	((int)xr_get_option('cross_up_sells_blocks_cart',2)),
		
		'cross_up_sells_total_item'		=>	((int)xr_get_option('cross_up_sells_total_item',4)),
		'cross_up_sells_blocks_item'	=>	((int)xr_get_option('cross_up_sells_blocks_item',4)),
		
		'shop_header_font'			=>	$shop_header_font,
		'main_color'				=>	$main_color,
		'main_default_font'			=>	$main_font,
		'main_font_color'			=>	$main_font_color,
		'search_box_color'			=>	xr_get_option('search_box_color', '#FAFAFA'),
		'cart_icon_margin_top'		=>	xr_get_option('cart_icon_margin_top','13px'),
		'cart_icon_margin_bottom'	=>	xr_get_option('cart_icon_margin_bottom','13px'),
		'woo_shop_product_blocks_ipad_portrait' => xr_get_option('woo_shop_product_blocks_ipad_portrait', 2),
		'disable_responsivity'		=> xr_get_option('disable_responsivity',false),

	)

);




function rockthemes_woocommerce_get_columns(){
	global $post, $rockthemes_woocommerce_settings;
	if(!isset($post) || !isset($post->post_content)) return;
	$content = $post->post_content;
	
	if(strpos($content, "recent_products") !== false){
		$dump_content = preg_match("/\[recent_products\s*.*?\]/",$content, $match);
		
		if($match && !empty($match)){
			extract(shortcode_parse_atts($match[0]));
			
			$rockthemes_woocommerce_settings['style']['shop_columns'] = $columns;
		}
	}
	
	if(strpos($content, "featured_products") !== false){
		$dump_content = preg_match("/\[featured_products\s*.*?\]/",$content, $match);
		
		if($match && !empty($match)){
			extract(shortcode_parse_atts($match[0]));
			
			$rockthemes_woocommerce_settings['style']['shop_columns'] = $columns;
		}
	}
	
	return $rockthemes_woocommerce_settings['style']['shop_columns'];
}



//Remove default WooCommerce Hooks
remove_action( 'woocommerce_before_main_content', 'woocommerce_output_content_wrapper', 10);
remove_action( 'woocommerce_after_main_content', 'woocommerce_output_content_wrapper_end', 10);



function rockthemes_woocommerce_page_wrapper_before() {

	do_action('rockthemes_pb_frontend_before_page');
	if(defined('RPB_FULL_SHORTCODE')){ echo '<!-- Regular Content Area --><div class="row">';}
	if(function_exists('rockthemes_pb_frontend_sidebar_before_content')) rockthemes_pb_frontend_sidebar_before_content();
	echo '<div id="primary" class="content-area large-'.rockthemes_pb_frontend_get_content_columns_after_sidebars().' column">';

}

function rockthemes_woocommerce_page_wrapper_after() { 
	echo '</div>';//#primary
	
	if(function_exists('rockthemes_pb_frontend_sidebar_after_content')){
		rockthemes_pb_frontend_sidebar_after_content();
	}else{
		get_sidebar();
	}
	
	if(defined('RPB_FULL_SHORTCODE')){ echo '</div><!-- /End of Regular Content Area -->';}
	do_action('rockthemes_pb_frontend_after_page');
	if(!defined('RPB_FULL_SHORTCODE')){ echo '<div class="vertical-space"></div>'; }
}


add_action('woocommerce_before_main_content', 'rockthemes_woocommerce_page_wrapper_before', 10);
add_action('woocommerce_after_main_content', 'rockthemes_woocommerce_page_wrapper_after', 10);


//WooCommerce Breadcrumb

function rockthemes_woocommerce_breadcrumb($args){
	$args['delimiter']		=	'<li> | </li>';
	$args['wrap_before']	=	'<ul class="azoom-breadcrumbs">';
	$args['wrap_after']		=	'</ul><div class="clear"></div>';
	$args['before']			=	'<li>';
	$args['after']			=	'</li>';
	
	return $args;
	
}
add_filter('woocommerce_breadcrumb_defaults', 'rockthemes_woocommerce_breadcrumb', 1);






function rockthemes_woo_style_buttons(){
	$woo_buttons = '';
	$add_to_cart = '';
	ob_start();
	rockthemes_woocommerce_add_to_cart();
	$add_to_cart = ob_get_contents();
	ob_get_clean();
	
	if($add_to_cart !== ''){
		$total_woo_btns = substr_count($add_to_cart, 'rockthemes-woo-shop-buttons');
		
		if($total_woo_btns == 2){
			$add_to_cart = str_replace('rockthemes-woo-shop-buttons', 'large-6 medium-6 small-6 columns rockthemes-woo-shop-buttons',$add_to_cart);
		}elseif($total_woo_btns === 1){
			$add_to_cart = str_replace('rockthemes-woo-shop-buttons', 'large-12 medium-12 small-12 columns rockthemes-woo-shop-buttons',$add_to_cart);
		}
		
		$add_to_cart = str_replace('rockthemes-woo-buttons-container', 'rockthemes-woo-buttons-container row collapse', $add_to_cart);
		$woo_buttons = '<div class="azoom-woo-grid-buttons">'.$add_to_cart.'</div>';
	}

	return $woo_buttons;
}







/*
**	Remove the default WooCommerce Tabs Callback
**	Restyle and change the structure of the regular WooCommerce Tabs.
**	
**	Uses woocommerce_product_tabs hook to get the WooCommerce Tabs Data
**
**	@return	:	Echo Rockthemes Tabs element with WooCommerce Tabs Content
*/
function rockthemes_woocommerce_tabs(){
	$tabs = apply_filters( 'woocommerce_product_tabs', array() );
	
	$shortcode = '';
	$single_tab = '';
	
	if ( ! empty( $tabs ) ) :
		$shortcode = '[rockthemes_tabs tab_type="tab-top" use_shadow="true" tab_use_hash="yes"]';
		foreach ( $tabs as $key => $tab ) :
				
			$content = '';
			ob_start();
			call_user_func( $tab['callback'], $key, $tab);
			$content = ob_get_contents();
			ob_get_clean();
		
			$single_tab .= '[rockthemes_tabs_single
				title="'.esc_attr(apply_filters( 'woocommerce_product_' . $key . '_tab_title', $tab['title'], $key )).'" tab_hash="'.esc_attr($key).'" use_hash="true"]
				'.$content.'
				[/rockthemes_tabs_single]
			';
			
		endforeach;
		$shortcode .= $single_tab.'[/rockthemes_tabs]';
	endif;
	

	echo '<div class="clear"></div>';
	echo '<div class="vertical-space"></div>';

	if($shortcode !== ''){
		echo do_shortcode($shortcode).'<div class="vertical-space"></div>';	
	}
	
	return;
}
remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_product_data_tabs', 10 );
add_action( 'woocommerce_after_single_product_summary', 'rockthemes_woocommerce_tabs', 10 );


if(!function_exists('rockthemes_woocommerce_add_to_cart')):
/*
**	WooCommerce loop only shows Add to Cart Button. We will add "read more" button
**
**
*/
function rockthemes_woocommerce_add_to_cart(){
	global $product;

	if ($product->is_type('bundle') ){
		$product = new WC_Product_Bundle($product->get_id());
	}
	
	$icons = array(
		'icon_variable'	=>	'icomoon icomoon-icon-settings',
		'icon_cart'		=>	'icomoon icomoon-icon-shopping114',
		'icon_details'	=>	'icomoon icomoon-icon-attachment',
		'icon_link'		=>	'icomoon icomoon-icon-next15',
	);
	
	$loader_motion = function_exists('rockthemes_loader_motion') ? rockthemes_loader_motion('woocommerce-loader') : '';
	
	extract($icons);

	$return = '';


	ob_start();
	woocommerce_template_loop_add_to_cart();
	$return = ob_get_clean();
	
	$is_there_fee = $product->get_price_html();

	if(!empty($return)){
		$find_close = strpos($return, '>');

		if ($find_close !== false) {
			if($product->is_type('grouped')){
				$return = substr_replace($return,'><i class="'.$icon_variable.'"></i> ', $find_close , strlen(1));
				$return = '<span class="rockthemes-woo-shop-buttons-full center-text centered-text-responsive">'.$return.'</span>';
				
			}elseif($product->is_type('simple')){
				$return = substr_replace($return,'><i class="'.$icon_cart.'"></i> ', $find_close , strlen(1));
				$return = '<span class="rockthemes-woo-shop-buttons left-text centered-text-responsive">'.$return.'</span>';
				
			}elseif($product->is_type('external')){
				$return = substr_replace($return,'><i class="'.$icon_link.'"></i> ', $find_close , strlen(1));
				$return = '<span class="rockthemes-woo-shop-buttons-full left-text centered-text-responsive">'.$return.'</span>';
			}
		}
		
		//Start to check button classes. To make it safe first check with double space and so on
		if(strpos($return, ' button ') > -1){
			$return = str_replace(' button ', ' button escape_button_style escapea ', $return);
		}elseif(strpos($return, ' button') > -1){
			$return = str_replace(' button', ' button escape_button_style escapea', $return);
		}elseif(strpos($return, 'button ') > -1){
			$return = str_replace('button ', 'button escape_button_style escapea ', $return);
		}elseif(strpos($return, 'button') > -1){
			$return = str_replace('button', 'button escape_button_style escapea', $return);
		}
	
		$return = str_replace('</i>','</i> <span class="text">',$return);
		if(!$product->is_type('external') && $is_there_fee != ''){
			$return = str_replace('</a>','</span>'.$loader_motion.'</a>',$return);
		}
	}


	if($product->is_type('variable')){
		$return = '
		<span class="center-text rockthemes-woo-shop-buttons-full">
			<a class="escapea add_to_cart_button escape_button_style product_type_variable center-text" href="'.get_permalink($product->get_id()).'"><i class="'.$icon_variable.'"></i> <span class="text">'.esc_html__('Options','azoom').'</span></a>
		</span>
		';
	}

	if($product->is_type('simple')){
		if( $is_there_fee != ''){
			$return .= '
			<span class="rockthemes-woo-shop-buttons right-text centered-text-responsive">	
				<a class="show_details_button escape_button_style escapea" href="'.get_permalink($product->get_id()).'"><i class="'.$icon_details.'"></i> <span class="text">'.esc_html__('Details','azoom').'</span></a>
			</span>	
			';
		}else{
			$return = '
			<span class="rockthemes-woo-shop-buttons right-text centered-text-responsive">	
				<a class="show_details_button escape_button_style escapea" href="'.get_permalink($product->get_id()).'"><i class="'.$icon_details.'"></i> <span class="text">'.esc_html__('Details','azoom').'</span></a>
			</span>	
			';
		}
	}
	
	if($product->is_type('external')){
		$return .= '
		<span class="rockthemes-woo-shop-buttons right-text centered-text-responsive">	
			<a class="show_details_button escape_button_style escapea" href="'.get_permalink($product->get_id()).'"><i class="'.$icon_details.'"></i> <span class="text">'.esc_html__('Details','azoom').'</span></a>
		</span>	
		';
	}
	
	$return = '<div class="rockthemes-woo-buttons-container">'.$return.'</div>';

	echo rockthemes_escaped_out_render($return);
}
endif;

remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10);
add_action( 'woocommerce_after_shop_loop_item', 'rockthemes_woo_style_buttons_echo', 99);
function rockthemes_woo_style_buttons_echo(){
	echo rockthemes_woo_style_buttons();	
}

add_filter('add_to_cart_text', 'woo_custom_cart_button_text_single');
add_filter( 'woocommerce_product_add_to_cart_text', 'woo_custom_cart_button_text_single' );
add_filter( 'woocommerce_product_single_add_to_cart_text', 'woo_custom_cart_button_text_single' );

function woo_custom_cart_button_text_single($text) {
	global $product;
	if(isset($product) && isset($product->product_type) && $product->product_type == 'external'){
		return $text;
	}
	return esc_html__('Add', 'azoom');
}


if(!function_exists('rockthemes_woocommerce_alter_thumbnail')):
function rockthemes_woocommerce_alter_thumbnail()
{
	global $product, $post;
	$rating = wc_get_rating_html( $product->get_average_rating() ); //get rating
	$price_html = $product->get_price_html();//get price
	$use_swiper = true;
	$flip_image = false;

	$id = get_the_ID();
	$featured_image_size = 'shop_catalog';
	
	//For swiper shortcode
	$images_string = '';
	
	$start_tag = '<div class="relative-container rockthemes-woocommerce-thumbnail '.($flip_image && !$use_swiper ? 'woo-image-change azoom-transition-fast' : '').'">';
	$end_tag = '</div>';
	
	$return = $start_tag;
	
		$thumb_image = get_the_post_thumbnail($id,$featured_image_size);
		
		if($thumb_image == ''){
			$thumb_image = rockthemes_demo_image($featured_image_size);	
		}
		
		$return .= $thumb_image;
		
		$attachment_ids = $product->get_gallery_image_ids();
		

		if ( $attachment_ids && count($attachment_ids) > 0 && $flip_image) {
			$secondary_image_id = $attachment_ids['0'];
			$attachment = wp_get_attachment_image( $secondary_image_id, 'shop_catalog', '', $attr = array( 'class' => 'woo-hover-image attachment-shop-catalog' ) );
			if($attachment == ''){
				$attachment = rockthemes_demo_image('shop_catalog');	
			}
			$return .= $attachment;
		}
				
		if($use_swiper && $attachment_ids && is_array($attachment_ids) && count($attachment_ids) > 0 && !$flip_image){
			$main_thumb = wp_get_attachment_image_src(get_post_thumbnail_id($id), '');
			if($main_thumb){
				$images_string .= $main_thumb[0].'rockthemes_image_ids'.get_post_thumbnail_id($id).', ';
			}else{
				$main_thumb = rockthemes_demo_image('',true);
				$images_string .= $main_thumb.', ';
			}

			$total_aid = count($attachment_ids);
			$i = 0;
			$swipe_images = '';
			foreach($attachment_ids as $aid){
				//Image details array
				$ia = wp_get_attachment_image_src($aid, '');
				$i++;
				if($ia){
					$swipe_images .= $ia[0].'rockthemes_image_ids'.$aid;
					
					if($i < $total_aid){
						$swipe_images .= ', ';
					}
				}else{
					$ia = rockthemes_demo_image('',true);
					$swipe_images .= $ia;
					
					if($i < $total_aid){
						$swipe_images .= ', ';
					}
				}
				
			}
			
			if($swipe_images !== ''){
				$images_string .= $swipe_images;	
			}else{
				//Images either not exists or can not be retreived from the server. Disable Swiper
				$use_swiper = false;	
			}
		}
				
		
		if($use_swiper && !$flip_image && count($attachment_ids) > 0 ){
			$shortcode = '[rockthemes_swiperslider images="'.$images_string.'" size="'.$featured_image_size.'" max_width="400px"]';
			
			$return = $start_tag.do_shortcode($shortcode);//Will use the same end tag
		}
				
		
		if($rating){
			$return .= '<div class="woocommerce-rating-overlay boxed-layout">'.$rating.'</div>';
		}
		
		if($price_html){
			$return .= '<div class="rockthemes-woo-loop-price price">'.$price_html.'</div>';	
		}
		

		
	$return .= $end_tag;
	
			
	echo rockthemes_escaped_out_render($return);
}
endif;
add_action( 'woocommerce_before_shop_loop_item_title', 'rockthemes_woocommerce_alter_thumbnail', 10);
remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_thumbnail', 10);





function rockthemes_woocommerce_sum_before(){
	echo '<div class="relative-container rockthemes-woo-single-image">';	
}
function rockthemes_woocommerce_sum_after(){
	echo '</div>';	
}
add_action('woocommerce_before_single_product_summary', 'rockthemes_woocommerce_sum_before',1);
add_action('woocommerce_before_single_product_summary', 'rockthemes_woocommerce_sum_after',30);



/*
**	Wrap the description area with boxed layout
*/
add_action( 'woocommerce_before_shop_loop_item', 'rockthemes_woocommerce_shop_before_description', 16);
function rockthemes_woocommerce_shop_before_description(){
	echo '<div class="rockthemes-woo-shop-loop-wrapper boxed-layout boxed-colors padding relative-container no-top-border-radius">';
}

add_action( 'woocommerce_after_shop_loop_item',  'rockthemes_woocommerce_shop_after_description', 100);
function rockthemes_woocommerce_shop_after_description(){
	echo '</div>';
}

//remove woo rating from shop loop
remove_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating', 5 ); //remove rating
remove_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_price', 10 ); //remove price

remove_action( 'woocommerce_before_shop_loop_item', 'woocommerce_template_loop_product_link_open', 10 ); //remove rating
remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_product_link_close', 5 ); //remove price



/*
**	Adds WooCommerce Cart Icon to menu. This function will be called from "header-models.php" file
**
**	@params	:	Filter Params
*/

if(!function_exists('rockthemes_add_cart_icon_to_menu')){
	function rockthemes_add_cart_icon_to_menu($items, $args) {
  		if( $args->theme_location !== 'primary' ) return $items;
		global $woocommerce;
		
		$cart_icon = '
			<a href="#" class="special-cart-container '.(is_cart() || is_checkout() ? 'disabled' : '').'">
				<span class="special-cart-icon">
					<i class="icomoon icomoon-icon-shopping114"></i>
					<span class="display-cart-count">
						<span class="cart-current-count">
							<span class="cart-count-number">'.intval($woocommerce->cart->cart_contents_count).'</span> '.esc_html__('Item','azoom').'
						</span>
					</span>
					<span class="hide new_value"></span>
				</span>
			</a>		
		';
		
  
        $cart_menu_item =
                '<li class="menu-item dismiss-mobile azoom-woocommerce-cart-menu-item">' .
                $args->before .
				$cart_icon.
                $args->after .
                '</li>';
  
        $items = $items.$cart_menu_item;
  
		return $items;
	}
}

//Woocommerce dynamic cart 
function woocommerce_header_add_to_cart_fragment( $fragments ) {

	global $woocommerce;
	ob_start();
	?>
    <span class="hide new_value">
    	<span class="cart-current-count">
			<span class="cart-count-number">
            	<?php echo intval($woocommerce->cart->cart_contents_count); ?>
			</span> 
            <?php echo ' '.esc_html__('Item','azoom'); ?>
		</span>
	</span>
	<?php
	$fragments['.special-cart-icon span.new_value'] = ob_get_clean();
	return $fragments;
}
if(version_compare(WOOCOMMERCE_VERSION, "3.0") >= 0){
	add_filter( 'woocommerce_add_to_cart_fragments', 'woocommerce_header_add_to_cart_fragment' );
}elseif ( version_compare( WOOCOMMERCE_VERSION, "2.3" ) >= 0 ) {
	add_filter('woocommerce_add_to_cart_fragments', 'woocommerce_header_add_to_cart_fragment');
}else{
	add_filter('add_to_cart_fragments', 'woocommerce_header_add_to_cart_fragment');
}

function rockthemes_get_woocommerce_cart_widget(){
	global $woocommerce, $wp_widget_factory;
	$wooCommerceWidget;
	
	if ( version_compare( WOOCOMMERCE_VERSION, "2.0.0" ) >= 0 ) {
		$wooCommerceWidget = 'WC_Widget_Cart';
	} else {
		$wooCommerceWidget = 'WooCommerce_Widget_Cart';
	}
	
	if(!empty($wp_widget_factory) && isset($wp_widget_factory->widgets) && isset($wp_widget_factory->widgets[$wooCommerceWidget])){
		the_widget( $wooCommerceWidget, 'title=' );
	}

}


function rockthemes_get_woocommerce_cart_fragments($fragments){
	global $woocommerce;
	ob_start();

	rockthemes_get_woocommerce_cart_widget();

	$woo_cart_contents = ob_get_clean();
	
	$fragments['.azoom-woocommerce-box-fragments'] = $woo_cart_contents;

	return $fragments;
}
if(version_compare(WOOCOMMERCE_VERSION, "3.0") >= 0){
	add_filter( 'woocommerce_add_to_cart_fragments', 'rockthemes_get_woocommerce_cart_fragments' );
}elseif ( version_compare( WOOCOMMERCE_VERSION, "2.3" ) >= 0 ) {
	add_filter('woocommerce_add_to_cart_fragments', 'rockthemes_get_woocommerce_cart_fragments');
}else{
	add_filter( 'add_to_cart_fragments', 'rockthemes_get_woocommerce_cart_fragments' ); // The cart fragment
}

function rockthemes_woocommerce_ajax_added_to_cart($atts){
	return '';
}
add_filter('woocommerce_ajax_added_to_cart', 'rockthemes_woocommerce_ajax_added_to_cart',1);



/*
**	Related Products and Upsells
*/


// Change number or products per row to 3
if (!function_exists('rockthemes_woocommerce_loop_columns')) {
	function rockthemes_woocommerce_loop_columns() {
		return function_exists('xr_get_option') ? xr_get_option('woo_shop_blocks_large','3') : 3;
		// 3 products per row
	}
}
add_filter('loop_shop_columns', 'rockthemes_woocommerce_loop_columns');



remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_related_products',20);
remove_action( 'woocommerce_after_single_product', 'woocommerce_output_related_products',10);
add_action( 'woocommerce_after_single_product_summary', 'rockthemes_woocommerce_related', 20);

function rockthemes_woocommerce_related(){
	global $rockthemes_woocommerce_settings;
	
	$total = (int)$rockthemes_woocommerce_settings['style']['cross_up_sells_total_cart'];;
	$blocks = (int)$rockthemes_woocommerce_settings['style']['cross_up_sells_blocks_cart'];
	if(is_product()){
		$total = (int)$rockthemes_woocommerce_settings['style']['cross_up_sells_total_item'];;
		$blocks = (int)$rockthemes_woocommerce_settings['style']['cross_up_sells_blocks_item'];
	}
	
	if ( version_compare( WOOCOMMERCE_VERSION, "2.1" ) >= 0 ) {
		$args = array(
			'posts_per_page'	=>	intval($total),
			'columns'			=>	intval($blocks),
			'orderby'			=>	'rand'
		);
		woocommerce_related_products($args); 
	} else {
		woocommerce_related_products($total, $blocks); 
	}
}


remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_upsell_display', 15 );
remove_action( 'woocommerce_after_single_product', 'woocommerce_upsell_display',10);
add_action( 'woocommerce_after_single_product_summary', 'rockthemes_woocommerce_upsells', 21);

function rockthemes_woocommerce_upsells(){
	global $rockthemes_woocommerce_settings;

	$total = (int)$rockthemes_woocommerce_settings['style']['cross_up_sells_total_cart'];;
	$blocks = (int)$rockthemes_woocommerce_settings['style']['cross_up_sells_blocks_cart'];

	if(is_product()){
		$total = (int)$rockthemes_woocommerce_settings['style']['cross_up_sells_total_item'];;
		$blocks = (int)$rockthemes_woocommerce_settings['style']['cross_up_sells_blocks_item'];
	}

	woocommerce_upsell_display($total, $blocks); 
}



add_filter('woocommerce_cross_sells_total', 'rockthemes_woocommerce_cross_total');
function rockthemes_woocommerce_cross_total($count)
{
	global $rockthemes_woocommerce_settings;
	
	$total = (int)$rockthemes_woocommerce_settings['style']['cross_up_sells_total_cart'];
	if(is_product()){
		$total = (int)$rockthemes_woocommerce_settings['style']['cross_up_sells_total_item'];
	}

	return $total;
}

add_filter('woocommerce_cross_sells_columns', 'rockthemes_woocommerce_cross_columns');
function rockthemes_woocommerce_cross_columns($count)
{
	global $rockthemes_woocommerce_settings;
	
	$blocks = (int)$rockthemes_woocommerce_settings['style']['cross_up_sells_blocks_cart'];
	if(is_product()){
		$blocks = (int)$rockthemes_woocommerce_settings['style']['cross_up_sells_blocks_item'];
	}

	return $blocks;
}



/*
**	We use WooCommerce template file to add our shop columns templates/loop/loop-start.php
**
*/
function rockthemes_woo_shop_columns_class(){
	global $woocommerce_loop, $rockthemes_woocommerce_settings;
	
	
	$return = '';
	
	if(is_product()){
		$woocommerce_loop['columns'] = (int)$rockthemes_woocommerce_settings['style']['cross_up_sells_blocks_item'];
	}
		
	if(isset($woocommerce_loop['columns']) && $woocommerce_loop['columns'] !== '' && function_exists('xr_get_option')){
		//For cross-sells, up-sell, related
		$return = 'large-block-grid-'.$woocommerce_loop['columns'].' ';
		$return .= 'medium-block-grid-'.intval(xr_get_option('woo_shop_blocks_medium', '3')).' ';
		$return .= 'small-block-grid-'.intval(xr_get_option('woo_shop_blocks_small', '1')).' ';
	}elseif(function_exists('xr_get_option')){
		$return = 'large-block-grid-'.intval(xr_get_option('woo_shop_blocks_large','4')).' ';
		$return .= 'medium-block-grid-'.intval(xr_get_option('woo_shop_blocks_medium', '3')).' ';
		$return .= 'small-block-grid-'.intval(xr_get_option('woo_shop_blocks_small', '1')).' ';
	}else{
		$return = 'large-block-grid-4 medium-block-grid-3 small-block-grid-1';	
	}
	
	if(xr_get_option('woo_wall_mode', true)){
		$return .= 'block-collapse ';
	}
	
	$return .= 'woo-remove-ul-space';
	
	return $return;
}







/*
**	Azoom Undermenu Content Filter
**
*/
function undermenu_contents_woo_filter($default){
	$woocommerce_box_model = 'full';

	ob_start();
	rockthemes_get_woocommerce_cart_widget();
	$woo_widget_content = ob_get_clean();

	$null = '';
	$return = '<div class="azoom-woocommerce-cart-wrapper azoom-woocommerce-box '.$woocommerce_box_model.'">
					<div class="azoom-woocommerce-box-content">
						'.$woo_widget_content.'
					</div>
					<div class="clear"></div>
				</div>					
				';
	
	return $default.$return;
}

add_filter('azoom_undermenu_contents', 'undermenu_contents_woo_filter',10, 1);


function undermenu_buttons_woo_filter($default){
	global $woocommerce;

	$wc_checkout_url;
	$wc_cart_url;
	if(version_compare(WOOCOMMERCE_VERSION, "2.5") >= 0){
		$wc_checkout_url=wc_get_checkout_url();
		$wc_cart_url=wc_get_cart_url();
	}else{
		$wc_checkout_url=$woocommerce->cart->get_checkout_url();
		$wc_cart_url=$woocommerce->cart->get_cart_url();
	}

	$return = '<a href="'.esc_url($wc_cart_url).'" class="azoom-woo-cart-buttons cart-widget-view-cart undermenu-box-button border-radius-class azoom-transition">
					'.esc_html__('View Cart','azoom').' 
				</a>
				<a href="'.esc_url($wc_checkout_url).'" class="azoom-woo-cart-buttons cart-widget-checkout undermenu-box-button border-radius-class azoom-transition">
					'.esc_html__('Checkout','azoom').' 
				</a>';
				
	return $default.$return;
}
add_filter('azoom_undermenu_buttons', 'undermenu_buttons_woo_filter', 10, 1);






/**
 * woo_custom_product_searchform
 *
 * @access      public
 * @since       1.0 
 * @return      void
*/
function azoom_woo_search_form( $form ) {
	
	$form = '<form role="search" method="get" id="searchform" action="' . esc_url( home_url( '/'  ) ) . '">
		<div>
			<input type="text" value="' . get_search_query() . '" name="s" id="s" placeholder="' . esc_html__( 'Search For Products', 'azoom' ) . '" />
			<button type="submit" id="searchsubmit" value="'. esc_attr__( 'Search', 'azoom' ) .'"></button>
			<input type="hidden" name="post_type" value="product" />
		</div>
	</form>';
	
	return $form;
	
}
add_filter( 'get_product_search_form' , 'azoom_woo_search_form' );



?>