<?php
/**
 * The default template for displaying title and breadcrumbs
 *
 * @package WordPress
 * @subpackage Azoom
 * @since Azoom 1.0
 */
?>
<?php
$full_width_title = esc_attr(xr_get_option('title_breadcrumbs_area_model','full')) === 'full' ? true : false;
?>

<?php if($full_width_title): ?>
<!--Close the row-->
<?php endif; ?>

<div class="azoom-title-breadcrumbs azoom-transition 
	<?php echo (xr_get_option('font_loading_active', true) === true ? 'not-visible' : '') ?>
	<?php echo (xr_get_option('deactivate_breadcrumbs', false) === true || is_home() || is_front_page()) ? 'breadcrumbs-disabled' : ''; ?>
	<?php echo rockthemes_escaped_out_render($full_width_title ? 'full-width-title-breadcrumbs' : 'half-width-title-breadcrumbs'); ?>
	<?php 
	$title_area_data_prefix = '';//Use this prefix for WooCommerce datas
	if(rockthemes_woocommerce_active() && (is_woocommerce() || is_cart() || is_account_page() || is_checkout())){
		$title_area_data_prefix	= 'woo_';
	}elseif(is_page()){
		$title_area_data_prefix = 'page_';	
	}
	

	$transparent_header = rad_get_option('transparent_header');
	$transparent_header = !$transparent_header || $transparent_header === '' || $transparent_header === 'false' ? false : true;
	
		
	$title_area_background_image_repeat = xr_get_option($title_area_data_prefix.'title_area_background_image_repeat', '');
	$title_area_background_image_width = xr_get_option($title_area_data_prefix.'title_area_background_image_width', '');
	$title_area_background_image_height = xr_get_option($title_area_data_prefix.'title_area_background_image_height', '');
	
	//Javascript value infinity fix
	$title_area_background_image_width = (int)$title_area_background_image_width === 0 ? 16 : $title_area_background_image_width;
	$title_area_background_image_height = (int)$title_area_background_image_height === 0 ? 9 : $title_area_background_image_height;

	if($title_area_background_image_repeat === 'parallax' && !$transparent_header){
		echo ' rockthemes-parallax rockthemes-unique-grid';
	}
	?>
    "
    <?php
	if($title_area_background_image_repeat === 'parallax' && !$transparent_header){
		$bg_parallax_image = '';
		
		$rad_header_bg_image = rad_get_option('header_bg_image');
		if($rad_header_bg_image !== '' && is_string($rad_header_bg_image) && (is_page() || is_single())){
			$bg_parallax_image = $rad_header_bg_image;
		}else{
			$bg_parallax_image = xr_get_option($title_area_data_prefix.'title_area_background_image', '');
		}
				
		echo '
			data-parallax-model="height_specific" 
			data-parallax-bg-image="'.esc_url($bg_parallax_image).'" 
			data-image-ratio="'.rockthemes_fn_px_em_return_num($title_area_background_image_width).'_'.rockthemes_fn_px_em_return_num($title_area_background_image_height).'"';
	
		$bg_parallax_image_retina = '';
		$rad_header_bg_image_retina = rad_get_option('header_bg_image_retina');
		if($rad_header_bg_image_retina !== '' && is_string($rad_header_bg_image_retina) && (is_page() || is_single())){
			$bg_parallax_image_retina = $rad_header_bg_image_retina;
		}else{
			$bg_parallax_image_retina = xr_get_option($title_area_data_prefix.'title_area_background_image_retina', '');
		}
		
		if($bg_parallax_image_retina != ''){
			echo ' data-parallax-bg-image-retina="'.esc_url($bg_parallax_image).'" ';
		}

	}
	?>
	>
	<?php 
	if(xr_get_option('title_area_top_shadow', true)):
    echo azoom_image_shadow_down(); 
	endif;
	?>
	<div class="row">
    	<?php if(xr_get_option('deactivate_breadcrumbs', false)): ?>
            <div class="large-12 medium-12 columns">
        <?php else: ?>
        	<?php if(!is_rtl() || $full_width_title): ?>
                <div class="<?php echo rockthemes_escaped_out_render($full_width_title ? 'center-text' : 'large-7 medium-7 columns'); ?>">
            <?php else: ?>
                <div class="<?php echo rockthemes_escaped_out_render($full_width_title ? 'center-text' : 'large-7 medium-7 columns'); ?> breadcrumbs-container left-text centered-text-responsive-small">
                    <p><br /></p>
                    <?php 
                    if(rockthemes_woocommerce_active() && is_woocommerce()):
                        woocommerce_breadcrumb();
                        //Remove WooCommerce Breadcrumb
                        remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20, 0);
                    else:
                    ?>
                    <?php azoom_breadcrumb(); ?>
                    <?php endif; ?>
                    <div class="clear"></div>
                </div>
            
	            <div class="<?php echo rockthemes_escaped_out_render($full_width_title ? 'center-text' : 'large-5 medium-5 columns'); ?>">
            <?php endif; ?>
        <?php endif; ?>
                    <<?php echo (is_single()) ? 'h2' : 'h1'; ?> class="page-title post-title <?php if(is_single()){echo 'entry-title'; } ?> centered-text-responsive-small" itemprop="headline">
                    <?php 
                    azoom_get_main_title();
                    ?> 
                    </<?php echo (is_single()) ? 'h2' : 'h1'; ?>>
                </div>
        <?php if(!xr_get_option('deactivate_breadcrumbs', false) && (!is_rtl() || $full_width_title)): ?>
            <div class="<?php echo rockthemes_escaped_out_render($full_width_title ? '' : 'large-5 medium-5 columns right-text'); ?> breadcrumbs-container centered-text-responsive-small">
        	<?php if(!$full_width_title): ?>
            <?php endif; ?>
            <?php 
			if(rockthemes_woocommerce_active() && is_woocommerce()):
				woocommerce_breadcrumb();
				//Remove WooCommerce Breadcrumb
				remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20, 0);
			else:
			?>
            <?php azoom_breadcrumb(); ?>
            <?php endif; ?>
            <div class="clear"></div>
        </div>
        <?php endif; ?>
    </div>
	<?php 
	if(xr_get_option('title_area_bottom_shadow', true)):
    echo azoom_image_shadow_up();	
	endif
	?>
</div>
<?php 


?>


<?php if($full_width_title): ?>
<?php do_action('azoom_after_header_title'); ?>
<!--Reopen the closed row-->
<?php endif; ?>