<?php
/**
 * The default template for displaying content. Used for both single and index/archive/search.
 *
 * @package WordPress
 * @subpackage Azoom
 * @since Azoom 1.0
 */
?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?> rel="<?php if(is_single()): echo 'single-post'; else: echo 'loop-post'; endif; ?>">
	
    <?php echo azoom_get_boxed_date(); ?>
    
    <div class="article-details <?php echo azoom_article_details_class(); ?>">
        <header class="entry-header">
            <?php echo azoom_get_entry_header(); ?>
        </header><!-- .entry-header -->
    
        <div class="entry-summary">
            <?php echo rock_check_p(get_the_excerpt()); ?>
        </div><!-- .entry-summary -->


        <footer class="entry-meta">
            <div class="entry-footer-details">
            	<?php azoom_entry_footer_meta(); ?>
            </div>            
            <?php do_action('rockthemes_single_post_footer'); ?>
        </footer><!-- .entry-meta -->
        <?php do_action('rockthemes_single_post_after_footer'); ?>
            
	</div><!-- .article-details -->
</article><!-- #post -->